/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.AbstractShortArrayList;

public class UnsignedByteArrayList
extends AbstractShortArrayList
implements Serializable {
    private transient byte[] _data = null;
    private int _size = 0;
    public static final short MAX_VALUE = 255;
    public static final short MIN_VALUE = 0;

    public UnsignedByteArrayList() {
        this(8);
    }

    public UnsignedByteArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity=" + capacity);
        }
        this._data = new byte[capacity];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public short getShort(int index) {
        this.checkRange(index);
        return this.toShort(this._data[index]);
    }

    public boolean containsShort(short value) {
        this.assertValidUnsignedByte(value);
        return -1 != this.indexOfShort(value);
    }

    public int indexOfShort(short value) {
        this.assertValidUnsignedByte(value);
        byte ivalue = this.fromShort(value);
        int i = 0;
        while (i < this._size) {
            if (ivalue == this._data[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOfShort(short value) {
        this.assertValidUnsignedByte(value);
        byte ivalue = this.fromShort(value);
        int i = this._size - 1;
        while (i >= 0) {
            if (ivalue == this._data[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public short setShort(int index, short value) {
        this.assertValidUnsignedByte(value);
        this.checkRange(index);
        short old = this.toShort(this._data[index]);
        this._data[index] = this.fromShort(value);
        return old;
    }

    public boolean addShort(short value) {
        this.assertValidUnsignedByte(value);
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = this.fromShort(value);
        return true;
    }

    public void addShort(int index, short value) {
        this.assertValidUnsignedByte(value);
        this.checkRangeIncludingEndpoint(index);
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = this.fromShort(value);
        ++this._size;
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public short removeShortAt(int index) {
        this.checkRange(index);
        ++this.modCount;
        short oldval = this.toShort(this._data[index]);
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public boolean removeShort(short value) {
        this.assertValidUnsignedByte(value);
        int index = this.indexOfShort(value);
        if (-1 == index) {
            return false;
        }
        this.removeShortAt(index);
        return true;
    }

    public void ensureCapacity(int mincap) {
        ++this.modCount;
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            byte[] olddata = this._data;
            this._data = new byte[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            byte[] olddata = this._data;
            this._data = new byte[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private final short toShort(byte value) {
        return (short)((short)value & 0xFF);
    }

    private final byte fromShort(short value) {
        return (byte)(value & 0xFF);
    }

    private final void assertValidUnsignedByte(short value) throws IllegalArgumentException {
        if (value > 255) {
            throw new IllegalArgumentException(value + " > " + 255);
        }
        if (value < 0) {
            throw new IllegalArgumentException(value + " < " + 0);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeByte(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new byte[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readByte();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

