/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.ArrayBuilder;
import flex2.compiler.mxml.builder.Builder;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.HTTPServiceBuilder;
import flex2.compiler.mxml.builder.InlineComponentBuilder;
import flex2.compiler.mxml.builder.ModelBuilder;
import flex2.compiler.mxml.builder.PrimitiveBuilder;
import flex2.compiler.mxml.builder.RemoteObjectBuilder;
import flex2.compiler.mxml.builder.WebServiceBuilder;
import flex2.compiler.mxml.builder.XMLBuilder;
import flex2.compiler.mxml.builder.XMLListBuilder;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BindingNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.HTTPServiceNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.MetaDataNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.RemoteObjectNode;
import flex2.compiler.mxml.dom.StyleNode;
import flex2.compiler.mxml.dom.WebServiceNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.lang.ValueNodeHandler;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.QName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ApplicationBuilder
extends ComponentBuilder {
    private static final String rootAttrBackgroundColor = "backgroundColor";
    private static final String rootAttrHeight = "height";
    private static final String rootAttrWidth = "width";
    private static final String specialAttrFrameRate = "frameRate";
    private static final String specialAttrImplements = "implements";
    private static final String specialAttrLib = "lib";
    private static final String specialAttrPageTitle = "pageTitle";
    private static final String specialAttrPreloader = "preloader";
    private static final String specialAttrRsl = "rsl";
    private static final String specialAttrScriptRecursionLimit = "scriptRecursionLimit";
    private static final String specialAttrScriptTimeLimit = "scriptTimeLimit";
    private static final String specialAttrTheme = "theme";
    private static final String specialAttrUsePreloader = "usePreloader";
    private static Set specialAttributes;
    protected RootAttributeParser rootAttributeParser;
    protected NestedDeclarationNodeHandler nestedDeclarationNodeHandler;
    protected ComponentDeclarationBindingHandler componentDeclarationBindingHandler;
    protected PrimitiveDeclarationBindingHandler primitiveDeclarationBindingHandler;
    private boolean generateLoader = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ApplicationBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        super(unit, typeTable, configuration, document, null, false, null);
        this.childNodeHandler = new ApplicationChildNodeHandler(typeTable);
        this.rootAttributeParser = new RootAttributeParser(typeTable);
        this.nestedDeclarationNodeHandler = new NestedDeclarationNodeHandler();
        this.componentDeclarationBindingHandler = new ComponentDeclarationBindingHandler();
        this.primitiveDeclarationBindingHandler = new PrimitiveDeclarationBindingHandler();
    }

    public void analyze(Node node) {
        if (node.getAttribute("id") != null) {
            this.log(node, (CompilerMessage)new IdNotAllowedOnRoot());
        }
        Type type = this.nodeTypeResolver.resolveType(node);
        this.constructComponent(type, node.beginLine);
        this.document.setRoot(this.component);
        this.processAttributes(node, type);
        this.processChildren(node, type);
        this.document.resolveTwoWayBindings();
        if (this.unit.isRoot()) {
            this.rootPostProcess(node);
            Iterator iter = this.document.getBindingExpressions().iterator();
            while (iter.hasNext()) {
                BindingExpression bexpr = (BindingExpression)iter.next();
                this.document.addImport(bexpr.getDestinationTypeName(), bexpr.getXmlLineNumber());
            }
        }
    }

    public void analyze(MetaDataNode node) {
        CDATANode cdata = (CDATANode)node.getChildAt(0);
        if (cdata != null && cdata.image != null && node.getText().toString().indexOf("[Frame") != -1) {
            if (!$assertionsDisabled && !this.unit.isRoot()) {
                throw new AssertionError();
            }
            this.generateLoader = false;
        }
    }

    public void analyze(StyleNode node) {
        if (node.getStyleSheet() != null) {
            try {
                this.document.getStylesContainer().extractStyles(node.getStyleSheet(), true);
            }
            catch (Exception exception) {
                String message = exception.getLocalizedMessage();
                if (message == null) {
                    message = exception.getClass().getName();
                }
                this.logError(node, message);
            }
        }
    }

    public void analyze(WebServiceNode node) {
        WebServiceBuilder builder = new WebServiceBuilder(this.unit, this.typeTable, this.configuration, this.document);
        node.analyze(builder);
    }

    public void analyze(HTTPServiceNode node) {
        HTTPServiceBuilder builder = new HTTPServiceBuilder(this.unit, this.typeTable, this.configuration, this.document);
        node.analyze(builder);
    }

    public void analyze(RemoteObjectNode node) {
        RemoteObjectBuilder builder = new RemoteObjectBuilder(this.unit, this.typeTable, this.configuration, this.document);
        node.analyze(builder);
    }

    public void analyze(BindingNode node) {
        String source = (String)node.getAttribute("source");
        if (source == null) {
            this.log(node, (CompilerMessage)new MissingAttribute("source"));
            return;
        }
        String destination = (String)node.getAttribute("destination");
        if (destination == null) {
            this.log(node, (CompilerMessage)new MissingAttribute("destination"));
            return;
        }
        Object value = this.textParser.parseValue(source, this.typeTable.stringType, 0, node.beginLine, "source");
        BindingExpression bindingExpression = value instanceof BindingExpression ? (BindingExpression)value : new BindingExpression((String)value, node.beginLine, this.document);
        bindingExpression.setDestinationProperty(destination);
        bindingExpression.setDestinationLValue(destination);
        this.component.setProperty(destination, (Object)bindingExpression, bindingExpression.getXmlLineNumber());
    }

    protected boolean isLegalLanguageNode(Node node) {
        Class<?> nodeClass = node.getClass();
        return super.isLegalLanguageNode(node) || nodeClass == MetaDataNode.class || nodeClass == StyleNode.class || nodeClass == RemoteObjectNode.class || nodeClass == HTTPServiceNode.class || nodeClass == WebServiceNode.class || nodeClass == BindingNode.class;
    }

    protected boolean isAllowedProperty(Property property) {
        return true;
    }

    protected boolean isSpecialAttribute(String namespaceURI, String localPart) {
        return namespaceURI.length() == 0 && specialAttributes.contains(localPart);
    }

    protected void processSpecialAttributes(Node node) {
        if (this.unit.getSource().isRoot()) {
            this.parseRootAttributes(node);
        }
    }

    private static String buildSwfMetadata(Map varmap) {
        if (varmap == null || varmap.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(50);
        buf.append("[SWF( ");
        boolean more = false;
        Iterator it = varmap.keySet().iterator();
        while (it.hasNext()) {
            String var = (String)it.next();
            Object val = varmap.get(var);
            if (more) {
                buf.append(", ");
            } else {
                more = true;
            }
            buf.append(var);
            buf.append("='");
            buf.append(val);
            buf.append("'");
        }
        buf.append(")]");
        return buf.toString();
    }

    private void parseRootAttributes(Node node) {
        String lib;
        String rsl;
        String theme;
        String preloader;
        Object value;
        String usePreloader;
        Object value2;
        String height;
        Object value3;
        String title;
        Object value4;
        String bgcolor;
        Object value5;
        String scriptTimeLimit;
        Object value6;
        String scriptRecursionLimit;
        Object value7;
        TreeMap<String, Object> swfvarmap = new TreeMap<String, Object>();
        String frameRate = (String)node.getAttribute(specialAttrFrameRate);
        if (frameRate != null && (value7 = this.rootAttributeParser.parseUInt(frameRate, node.getLineNumber(specialAttrFrameRate), specialAttrFrameRate)) != null) {
            swfvarmap.put(specialAttrFrameRate, value7.toString());
        }
        if ((scriptRecursionLimit = (String)node.getAttribute(specialAttrScriptRecursionLimit)) != null && (value6 = this.rootAttributeParser.parseUInt(scriptRecursionLimit, node.getLineNumber(specialAttrScriptRecursionLimit), specialAttrScriptRecursionLimit)) != null) {
            swfvarmap.put(specialAttrScriptRecursionLimit, value6.toString());
        }
        if ((scriptTimeLimit = (String)node.getAttribute(specialAttrScriptTimeLimit)) != null && (value5 = this.rootAttributeParser.parseUInt(scriptTimeLimit, node.getLineNumber(specialAttrScriptTimeLimit), specialAttrScriptTimeLimit)) != null) {
            swfvarmap.put(specialAttrScriptTimeLimit, value5.toString());
        }
        if ((bgcolor = (String)node.getAttribute(rootAttrBackgroundColor)) != null && (value4 = this.rootAttributeParser.parseColor(bgcolor, node.getLineNumber(rootAttrBackgroundColor), rootAttrBackgroundColor)) != null) {
            swfvarmap.put(rootAttrBackgroundColor, value4.toString());
        }
        if ((title = (String)node.getAttribute(specialAttrPageTitle)) != null) {
            swfvarmap.put(specialAttrPageTitle, title);
        }
        boolean isApplication = "Application".equals(node.getLocalPart()) && "http://www.adobe.com/2006/mxml".equals(node.getNamespace());
        String width = (String)node.getAttribute(rootAttrWidth);
        if (width != null && isApplication && (value3 = this.rootAttributeParser.parseNumberOrPercentage(width, node.getLineNumber(rootAttrWidth), rootAttrWidth)) != null) {
            if (this.rootAttributeParser.wasPercentage()) {
                if (width.toString().endsWith("%")) {
                    swfvarmap.put("widthPercent", width.toString());
                } else {
                    swfvarmap.put("widthPercent", width.toString() + '%');
                }
                node.removeAttribute(new QName("", rootAttrWidth));
            } else {
                if (value3 instanceof Double) {
                    value3 = new Integer(((Double)value3).intValue());
                }
                swfvarmap.put(rootAttrWidth, value3);
            }
        }
        if ((height = (String)node.getAttribute(rootAttrHeight)) != null && isApplication && (value2 = this.rootAttributeParser.parseNumberOrPercentage(height, node.getLineNumber(rootAttrHeight), rootAttrHeight)) != null) {
            if (this.rootAttributeParser.wasPercentage()) {
                if (height.toString().endsWith("%")) {
                    swfvarmap.put("heightPercent", height.toString());
                } else {
                    swfvarmap.put("heightPercent", height.toString() + '%');
                }
                node.removeAttribute(new QName("", rootAttrHeight));
            } else {
                if (value2 instanceof Double) {
                    value2 = new Integer(((Double)value2).intValue());
                }
                swfvarmap.put(rootAttrHeight, value2);
            }
        }
        if ((usePreloader = (String)node.getAttribute(specialAttrUsePreloader)) != null && (value = this.rootAttributeParser.parseBoolean(usePreloader, node.getLineNumber(specialAttrUsePreloader), specialAttrUsePreloader)) != null) {
            this.document.setUsePreloader((Boolean)value);
        }
        if ((preloader = (String)node.getAttribute(specialAttrPreloader)) != null) {
            String preloaderClassName = TextParser.parseClassName(preloader);
            if (preloaderClassName != null) {
                this.document.setPreloader(preloader);
            } else {
                this.log(node, (CompilerMessage)new InvalidPreLoaderClassName(preloader));
            }
        }
        if (swfvarmap.size() > 0) {
            String metadata = ApplicationBuilder.buildSwfMetadata(swfvarmap);
            Script script = new Script(metadata);
            this.document.addMetadata(script);
        }
        if ((theme = (String)node.getAttribute(specialAttrTheme)) != null) {
            this.log(new ThemeAttributeError());
        }
        if ((rsl = (String)node.getAttribute(specialAttrRsl)) != null) {
            this.log(new RslAttributeError());
        }
        if ((lib = (String)node.getAttribute(specialAttrLib)) != null) {
            this.log(new LibAttributeError());
        }
    }

    private void rootPostProcess(Node node) {
        if (this.generateLoader) {
            this.generateLoaderInfo(node);
        } else {
            this.document.addMetadata(new Script("[Frame(extraClass=\"FlexInit\")]\n"));
        }
    }

    private void generateLoaderInfo(Node node) {
        String baseLoaderClass = this.document.getSuperClass().getLoaderClass();
        if (baseLoaderClass == null) {
            return;
        }
        this.unit.auxGenerateInfo = new HashMap();
        String generateInitClass = "_" + this.document.getClassName() + "_FlexInit";
        generateInitClass = generateInitClass.replaceAll("[^A-Za-z0-9]", "_");
        this.document.addMetadata(new Script("[Frame(extraClass=\"" + generateInitClass + "\")]\n"));
        baseLoaderClass = baseLoaderClass.replace(':', '.');
        String generateLoaderClass = "_" + this.document.getClassName() + "_" + baseLoaderClass;
        generateLoaderClass = generateLoaderClass.replaceAll("[^A-Za-z0-9]", "_");
        this.document.addMetadata(new Script("[Frame(factoryClass=\"" + generateLoaderClass + "\")]\n"));
        HashMap<String, Object> rootAttributeMap = new HashMap<String, Object>();
        Iterator it = node.getAttributeNames();
        while (it != null && it.hasNext()) {
            QName qname = (QName)it.next();
            String localPart = qname.getLocalPart();
            String value = (String)node.getAttribute(qname);
            value = value.replaceAll("\"", "\\\"");
            rootAttributeMap.put(localPart, node.getAttribute(qname));
        }
        String windowClass = this.document.getClassName();
        if (this.document.getPackageName() != null && this.document.getPackageName().length() != 0) {
            windowClass = this.document.getPackageName() + "." + this.document.getClassName();
        }
        this.unit.auxGenerateInfo.put("baseLoaderClass", baseLoaderClass);
        this.unit.auxGenerateInfo.put("generateLoaderClass", generateLoaderClass);
        this.unit.auxGenerateInfo.put("windowClass", windowClass);
        this.unit.auxGenerateInfo.put("preloaderClass", this.document.getPreloader());
        this.unit.auxGenerateInfo.put(specialAttrUsePreloader, new Boolean(this.document.getUsePreloader()));
        this.unit.auxGenerateInfo.put("rootAttributes", rootAttributeMap);
    }

    static {
        $assertionsDisabled = !ApplicationBuilder.class.desiredAssertionStatus();
        specialAttributes = new HashSet(32);
        specialAttributes.add(specialAttrFrameRate);
        specialAttributes.add(specialAttrImplements);
        specialAttributes.add(specialAttrLib);
        specialAttributes.add(specialAttrPageTitle);
        specialAttributes.add(specialAttrPreloader);
        specialAttributes.add(specialAttrRsl);
        specialAttributes.add(specialAttrScriptRecursionLimit);
        specialAttributes.add(specialAttrScriptTimeLimit);
        specialAttributes.add(specialAttrTheme);
        specialAttributes.add(specialAttrUsePreloader);
    }

    public static class InvalidPreLoaderClassName
    extends CompilerMessage.CompilerError {
        public String className;

        public InvalidPreLoaderClassName(String className) {
            this.className = className;
        }
    }

    public static class EmbedNotAllowed
    extends CompilerMessage.CompilerError {
    }

    public static class LibAttributeError
    extends CompilerMessage.CompilerError {
    }

    public static class RslAttributeError
    extends CompilerMessage.CompilerError {
    }

    public static class ThemeAttributeError
    extends CompilerMessage.CompilerError {
    }

    public static class MissingAttribute
    extends CompilerMessage.CompilerError {
        public String attribute;

        public MissingAttribute(String attribute) {
            this.attribute = attribute;
        }
    }

    public static class IdNotAllowedOnRoot
    extends CompilerMessage.CompilerError {
    }

    public static class DefaultPropertyError
    extends CompilerMessage.CompilerError {
    }

    protected class RootAttributeParser
    extends Builder.TextValueParser {
        protected RootAttributeParser(TypeTable typeTable) {
            super(ApplicationBuilder.this, typeTable);
        }

        public Object parseUInt(String text, int line, String name) {
            return this.parseValue(text, ApplicationBuilder.this.typeTable.uintType, 0, line, name);
        }

        public Object parseColor(String text, int line, String name) {
            return this.parseValue(text, ApplicationBuilder.this.typeTable.uintType, 4, line, name);
        }

        public Object parseNumberOrPercentage(String text, int line, String name) {
            return this.parseValue(text, ApplicationBuilder.this.typeTable.numberType, 8, line, name);
        }

        public Object parseBoolean(String text, int line, String name) {
            return this.parseValue(text, ApplicationBuilder.this.typeTable.booleanType, 0, line, name);
        }

        public Object embed(String text, Type type) {
            ApplicationBuilder.this.log(this.line, new EmbedNotAllowed());
            return null;
        }

        public Object bindingExpression(String converted) {
            ApplicationBuilder.this.log(this.line, new Builder.BindingNotAllowed());
            return null;
        }
    }

    protected static class PrimitiveDeclarationBindingHandler
    implements BindingHandler {
        protected PrimitiveDeclarationBindingHandler() {
        }

        public BindingExpression invoke(BindingExpression bindingExpression, Model dest) {
            bindingExpression.setDestination(dest);
            ((Primitive)dest).setValue(null);
            return bindingExpression;
        }
    }

    protected static class ComponentDeclarationBindingHandler
    implements BindingHandler {
        protected ComponentDeclarationBindingHandler() {
        }

        public BindingExpression invoke(BindingExpression bindingExpression, Model dest) {
            if (dest.getParent() != null) {
                bindingExpression.setDestination(dest.getParent());
                bindingExpression.setDestinationProperty(dest.getId());
                bindingExpression.setDestinationLValue(dest.getId());
                dest.getParent().setProperty(dest.getId(), (Object)bindingExpression, bindingExpression.getXmlLineNumber());
            } else {
                bindingExpression.setDestination(dest);
                bindingExpression.setDestinationLValue("");
            }
            return bindingExpression;
        }
    }

    protected class NestedDeclarationNodeHandler
    extends ValueNodeHandler {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected NestedDeclarationNodeHandler() {
        }

        protected void componentNode(Node node) {
            ComponentBuilder builder = new ComponentBuilder(ApplicationBuilder.this.unit, ApplicationBuilder.this.typeTable, ApplicationBuilder.this.configuration, ApplicationBuilder.this.document, ApplicationBuilder.this.component, true, ApplicationBuilder.this.componentDeclarationBindingHandler);
            node.analyze(builder);
        }

        protected void arrayNode(ArrayNode node) {
            ArrayBuilder builder = new ArrayBuilder(ApplicationBuilder.this.unit, ApplicationBuilder.this.typeTable, ApplicationBuilder.this.configuration, ApplicationBuilder.this.document);
            node.analyze(builder);
        }

        protected void primitiveNode(PrimitiveNode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(ApplicationBuilder.this.unit, ApplicationBuilder.this.typeTable, ApplicationBuilder.this.configuration, ApplicationBuilder.this.document, true, ApplicationBuilder.this.primitiveDeclarationBindingHandler);
            node.analyze(builder);
        }

        protected void xmlNode(XMLNode node) {
            XMLBuilder builder = new XMLBuilder(ApplicationBuilder.this.unit, ApplicationBuilder.this.typeTable, ApplicationBuilder.this.configuration, ApplicationBuilder.this.document);
            node.analyze(builder);
            ApplicationBuilder.this.registerModel(node, (Model)builder.xml, true);
        }

        protected void xmlListNode(XMLListNode node) {
            XMLListBuilder builder = new XMLListBuilder(ApplicationBuilder.this.unit, ApplicationBuilder.this.typeTable, ApplicationBuilder.this.configuration, ApplicationBuilder.this.document);
            node.analyze(builder);
            ApplicationBuilder.this.registerModel(node, (Model)builder.xmlList, true);
        }

        protected void modelNode(ModelNode node) {
            ModelBuilder builder = new ModelBuilder(ApplicationBuilder.this.unit, ApplicationBuilder.this.typeTable, ApplicationBuilder.this.configuration, ApplicationBuilder.this.document);
            node.analyze(builder);
        }

        protected void inlineComponentNode(InlineComponentNode node) {
            InlineComponentBuilder builder = new InlineComponentBuilder(ApplicationBuilder.this.unit, ApplicationBuilder.this.typeTable, ApplicationBuilder.this.configuration, ApplicationBuilder.this.document, true);
            node.analyze(builder);
        }

        protected void unknown(Node node) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unexpected node class in processNestedDeclaration: " + node.getClass()));
            }
        }

        static {
            $assertionsDisabled = !(class$flex2$compiler$mxml$builder$ApplicationBuilder == null ? (class$flex2$compiler$mxml$builder$ApplicationBuilder = ApplicationBuilder.class$("flex2.compiler.mxml.builder.ApplicationBuilder")) : class$flex2$compiler$mxml$builder$ApplicationBuilder).desiredAssertionStatus();
        }
    }

    protected class ApplicationChildNodeHandler
    extends ComponentBuilder.ComponentChildNodeHandler {
        ApplicationChildNodeHandler(TypeTable typeTable) {
            super(ApplicationBuilder.this, typeTable);
        }

        protected void dynamicProperty(String name) {
            this.nestedDeclaration();
        }

        protected void defaultPropertyElement(boolean locError) {
            if (ApplicationBuilder.this.document.getIsInlineComponent()) {
                super.defaultPropertyElement(locError);
            } else {
                this.nestedDeclaration();
            }
        }

        protected void processNestedDeclaration() {
            ApplicationBuilder.this.nestedDeclarationNodeHandler.invoke(this.child);
        }
    }

    protected class ApplicationAttributeHandler
    extends ComponentBuilder.ComponentAttributeHandler {
        protected ApplicationAttributeHandler() {
            super(ApplicationBuilder.this);
        }

        protected void dynamicProperty(String name) {
            ApplicationBuilder.this.unknownAttributeError(name, this.line);
        }
    }
}

