/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.Builder;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.XML;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.IntegerPool;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import flex2.compiler.util.XMLStringSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;

class XMLBuilder
extends Builder {
    private String id;
    private Set temp;
    private Model parent;
    private boolean allowTopLevelBinding;
    XML xml;

    XMLBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        this(unit, typeTable, configuration, document, null);
        this.allowTopLevelBinding = true;
    }

    XMLBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document, Model parent) {
        super(unit, typeTable, configuration, document);
        this.parent = parent;
        this.allowTopLevelBinding = false;
        this.temp = new HashSet();
    }

    public void analyze(XMLNode node) {
        this.id = (String)node.getAttribute("id");
        boolean e4x = node.isE4X();
        Type t = this.typeTable.getType(StandardDefs.getXmlBackingClassName(e4x));
        this.xml = new XML(this.document, t, this.parent, e4x, node.beginLine);
        if (this.id != null) {
            this.xml.setId(this.id, false);
        }
        if (!this.checkFormat(node)) {
            this.xml.setLiteralXML("null");
            return;
        }
        StringWriter writer = new StringWriter();
        XMLStringSerializer xmlStringSerializer = new XMLStringSerializer(writer);
        try {
            if (node.getChildCount() == 0) {
                writer.write("null");
            } else if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
                CDATANode cdata = (CDATANode)node.getChildAt(0);
                if (cdata.image.length() > 0) {
                    String bindingExprString = TextParser.getBindingExpressionFromString(cdata.image.trim());
                    if (bindingExprString == null) {
                        if (e4x) {
                            writer.write(TextParser.cleanupBindingEscapes(cdata.image));
                        } else {
                            xmlStringSerializer.writeString(TextParser.cleanupBindingEscapes(cdata.image));
                        }
                    } else if (this.allowTopLevelBinding) {
                        BindingExpression be = new BindingExpression(bindingExprString, cdata.beginLine, this.document);
                        be.setDestination(this.xml);
                    } else {
                        this.log(cdata, (CompilerMessage)new Builder.BindingNotAllowed());
                    }
                }
            } else if (e4x) {
                this.processChildren(e4x, node, writer, null, new Stack(), new Stack());
            } else {
                this.processChildren(e4x, node, xmlStringSerializer, null, new Stack(), null);
            }
        }
        catch (IOException e) {
            this.logError(node, e.getLocalizedMessage());
        }
        this.xml.setLiteralXML(writer.toString());
    }

    private boolean checkFormat(XMLNode node) {
        if (node.getChildCount() > 1) {
            this.log(node, (CompilerMessage)new OnlyOneRootTag());
            return false;
        }
        if (node.getChildAt(0) instanceof CDATANode) {
            this.log(node, (CompilerMessage)new RequireXMLContent());
            return false;
        }
        return true;
    }

    private void pushNodeNamespace(Node node, Stack namespaces) {
        this.temp.clear();
        String uri = node.getNamespace();
        int size = namespaces.size();
        for (int i = 0; i < size; ++i) {
            PrefixMapping pm = (PrefixMapping)namespaces.get(i);
            this.temp.add(pm);
            if (!pm.uri.equals(uri)) continue;
            namespaces.push(pm);
            return;
        }
        namespaces.push(new PrefixMapping(this.temp.size() + 1, uri));
    }

    private int getNamespaceId(String nsUri, Stack namespaces) {
        this.temp.clear();
        int size = namespaces.size();
        for (int i = 0; i < size; ++i) {
            PrefixMapping pm = (PrefixMapping)namespaces.get(i);
            this.temp.add(pm);
            if (!pm.uri.equals(nsUri)) continue;
            return pm.ns;
        }
        return this.temp.size() + 1;
    }

    private void popNodeNamespace(Stack namespaces) {
        namespaces.pop();
    }

    private void pushNamespaces(BindingExpression be, Stack namespaces) {
        this.temp.clear();
        int count = namespaces.size();
        for (int i = 0; i < count; ++i) {
            PrefixMapping pm = (PrefixMapping)namespaces.get(i);
            this.temp.add(pm);
        }
        Iterator j = this.temp.iterator();
        while (j.hasNext()) {
            PrefixMapping pm = (PrefixMapping)j.next();
            be.addNamespace(pm.uri, pm.ns);
        }
    }

    private void processNode(boolean e4x, Node node, Object serializer, String getElementsByLocalName, Stack destinationPropertyStack, Stack namespaces) {
        QNameMap attributeBindings = this.processAttributes(node);
        if (attributeBindings != null) {
            String destinationProperty = this.createExpression(destinationPropertyStack);
            Iterator i = attributeBindings.keySet().iterator();
            while (i.hasNext()) {
                String attrExpr;
                QName attrName = (QName)i.next();
                String nsUri = null;
                int nsId = 0;
                if (e4x) {
                    nsUri = attrName.getNamespace();
                    if (nsUri.length() > 0) {
                        nsId = this.getNamespaceId(nsUri, namespaces);
                        attrExpr = getElementsByLocalName + ".@ns" + nsId + "::" + attrName.getLocalPart();
                    } else {
                        attrExpr = getElementsByLocalName + ".@" + attrName.getLocalPart();
                    }
                } else {
                    attrExpr = getElementsByLocalName + ".attributes[\"" + attrName.getLocalPart() + "\"]";
                }
                BindingExpression be = new BindingExpression((String)attributeBindings.get(attrName), node.beginLine, this.document);
                be.setDestinationXMLAttribute(true);
                be.setDestinationLValue(attrExpr);
                be.setDestinationProperty(destinationProperty + "[" + node.getIndex() + "]");
                be.setDestination(this.xml);
                this.xml.setHasBindings(true);
                if (!e4x) continue;
                this.pushNamespaces(be, namespaces);
                if (nsUri.length() <= 0) continue;
                be.addNamespace(nsUri, nsId);
            }
        }
        try {
            if (e4x) {
                node.toStartElement((StringWriter)serializer);
            } else {
                QName qname = new QName(node.getNamespace(), node.getLocalPart(), node.getPrefix());
                ((XMLStringSerializer)serializer).startElement(qname, new AttributesHelper(node));
            }
            if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
                CDATANode cdata = (CDATANode)node.getChildAt(0);
                if (cdata.image.length() > 0) {
                    String bindingExprString = TextParser.getBindingExpressionFromString(cdata.image);
                    if (bindingExprString != null && !cdata.inCDATA) {
                        String destinationProperty = this.createExpression(destinationPropertyStack);
                        BindingExpression be = new BindingExpression(bindingExprString, cdata.beginLine, this.document);
                        be.setDestinationLValue(getElementsByLocalName);
                        be.setDestinationProperty(destinationProperty + "[" + node.getIndex() + "]");
                        be.setDestination(this.xml);
                        be.setDestinationXMLNode(true);
                        this.xml.setHasBindings(true);
                        if (e4x) {
                            be.setDestinationE4X(true);
                            this.pushNamespaces(be, namespaces);
                        }
                    } else if (e4x) {
                        if (!cdata.inCDATA) {
                            ((StringWriter)serializer).write(TextParser.replaceBindingEscapesForE4X(cdata.image));
                        } else {
                            ((StringWriter)serializer).write("<![CDATA[" + cdata.image + "]]>");
                        }
                    } else {
                        String cdataString = "";
                        cdataString = !cdata.inCDATA ? TextParser.cleanupBindingEscapes(cdata.image) : cdata.image;
                        ((XMLStringSerializer)serializer).writeString(cdataString);
                    }
                }
            } else {
                this.processChildren(e4x, node, serializer, getElementsByLocalName, destinationPropertyStack, namespaces);
            }
            if (e4x) {
                node.toEndElement((StringWriter)serializer);
            } else {
                ((XMLStringSerializer)serializer).endElement();
            }
        }
        catch (IOException e) {
            this.logError(node, e.getLocalizedMessage());
        }
    }

    private void processChildren(boolean e4x, Node node, Object serializer, String getElementsByLocalName, Stack destinationProperty, Stack namespaces) {
        this.assignIndices(node);
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = (Node)node.getChildAt(i);
            if (child instanceof CDATANode) {
                CDATANode cdata = (CDATANode)child;
                if (cdata.image.trim().length() > 0) {
                    this.log(child, (CompilerMessage)new MixedContent(child.image));
                    continue;
                }
                if (e4x) {
                    ((StringWriter)serializer).write(cdata.image);
                    continue;
                }
                try {
                    ((XMLStringSerializer)serializer).writeString(cdata.image);
                }
                catch (IOException e) {
                    this.logError(cdata, e.getLocalizedMessage());
                }
                continue;
            }
            if (e4x) {
                this.pushNodeNamespace(child, namespaces);
                if (getElementsByLocalName != null) {
                    StringBuffer e4xbuffer = new StringBuffer(getElementsByLocalName);
                    String destProp = child.getLocalPart();
                    if (child.getNamespace().length() > 0) {
                        PrefixMapping pm = (PrefixMapping)namespaces.peek();
                        destProp = "ns" + pm.ns + "::" + destProp;
                    }
                    e4xbuffer.append(".").append(destProp).append("[").append(child.getIndex()).append("]");
                    destinationProperty.push(destProp);
                    this.processNode(e4x, child, serializer, e4xbuffer.toString(), destinationProperty, namespaces);
                    destinationProperty.pop();
                } else {
                    this.processNode(e4x, child, serializer, this.xml.getId(), destinationProperty, namespaces);
                }
                this.popNodeNamespace(namespaces);
                continue;
            }
            String classNamespaceUtil = NameFormatter.toDot(StandardDefs.CLASS_NAMESPACEUTIL);
            this.document.addImport(classNamespaceUtil, node.beginLine);
            StringBuffer buffer = new StringBuffer(classNamespaceUtil + ".getElementsByLocalName(");
            buffer.append(getElementsByLocalName == null ? this.xml.getId() : getElementsByLocalName);
            buffer.append(", \"").append(child.getLocalPart()).append("\")[").append(child.getIndex()).append("]");
            destinationProperty.push(child.getLocalPart());
            this.processNode(e4x, child, serializer, buffer.toString(), destinationProperty, null);
            destinationProperty.pop();
        }
    }

    private QNameMap processAttributes(Node node) {
        QNameMap attributeBindings = null;
        Iterator i = node.getAttributeNames();
        while (i != null && i.hasNext()) {
            QName qname = (QName)i.next();
            String value = (String)node.getAttribute(qname);
            String bindingExprString = TextParser.getBindingExpressionFromString(value);
            if (bindingExprString == null) continue;
            if (attributeBindings == null) {
                attributeBindings = new QNameMap();
            }
            attributeBindings.put(qname, bindingExprString);
            i.remove();
        }
        return attributeBindings;
    }

    private void assignIndices(Node parent) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Integer zero = IntegerPool.getNumber(0);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = (Node)parent.getChildAt(i);
            if (child instanceof CDATANode) continue;
            if (!counts.containsKey(child.image)) {
                counts.put(child.image, zero);
                child.setIndex(0);
                continue;
            }
            int num = (Integer)counts.get(child.image) + 1;
            counts.put(child.image, IntegerPool.getNumber(num));
            child.setIndex(num);
        }
    }

    private String createExpression(Stack stack) {
        StringBuffer buffer = new StringBuffer();
        int count = stack.size();
        for (int i = 0; i < count; ++i) {
            buffer.append(stack.get(i));
            if (i >= count - 1) continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public static class RequireXMLContent
    extends CompilerMessage.CompilerError {
    }

    public static class OnlyOneRootTag
    extends CompilerMessage.CompilerError {
    }

    public static class MixedContent
    extends CompilerMessage.CompilerWarning {
        public String image;

        public MixedContent(String image) {
            this.image = image;
        }
    }

    class AttributesHelper
    implements Attributes {
        private String[] namespaces;
        private String[] localParts;
        private Object[] values;

        AttributesHelper(Node node) {
            this.namespaces = new String[node.getAttributeCount()];
            this.localParts = new String[node.getAttributeCount()];
            this.values = new Object[node.getAttributeCount()];
            Iterator names = node.getAttributeNames();
            int i = 0;
            while (names != null && names.hasNext()) {
                QName qname = (QName)names.next();
                this.namespaces[i] = qname.getNamespace();
                this.localParts[i] = qname.getLocalPart();
                this.values[i] = node.getAttribute(qname);
                ++i;
            }
        }

        public int getLength() {
            return this.values.length;
        }

        public String getURI(int index) {
            return this.namespaces[index];
        }

        public String getLocalName(int index) {
            return this.localParts[index];
        }

        public String getQName(int index) {
            if (this.namespaces[index] == null || this.namespaces[index].equals("")) {
                return this.localParts[index];
            }
            return this.namespaces[index] + ":" + this.localParts[index];
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getValue(int index) {
            return (String)this.values[index];
        }

        public int getIndex(String uri, String localName) {
            int count = this.namespaces.length;
            for (int i = 0; i < count; ++i) {
                if (!this.namespaces[i].equals(uri) || !this.localParts[i].equals(localName)) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String qName) {
            int count = this.namespaces.length;
            for (int i = 0; i < count; ++i) {
                if (!this.getQName(i).equals(qName)) continue;
                return i;
            }
            return -1;
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getType(String qName) {
            return "CDATA";
        }

        public String getValue(String uri, String localName) {
            int count = this.namespaces.length;
            for (int i = 0; i < count; ++i) {
                if (!this.namespaces[i].equals(uri) || !this.localParts[i].equals(localName)) continue;
                return (String)this.values[i];
            }
            return null;
        }

        public String getValue(String qName) {
            int count = this.namespaces.length;
            for (int i = 0; i < count; ++i) {
                if (!this.getQName(i).equals(qName)) continue;
                return (String)this.values[i];
            }
            return null;
        }
    }

    class PrefixMapping {
        int ns;
        String uri;

        PrefixMapping(int ns, String uri) {
            this.ns = ns;
            this.uri = uri;
        }

        public boolean equals(Object obj) {
            return this.uri.equals(obj);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }
    }
}

