/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flex2.compiler.CompilationUnit;
import flex2.compiler.DependencyGraph;
import flex2.compiler.Source;
import flex2.compiler.util.Algorithms;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.Vertex;
import flex2.compiler.util.Visitor;
import flex2.linker.Configuration;
import flex2.linker.LinkerException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ConsoleApplication {
    private List abcList = new ArrayList();
    private byte[] main;
    public final boolean enableDebugger;
    private List exportedUnits;

    public ConsoleApplication(Configuration configuration) {
        this.enableDebugger = configuration.generateDebugTags();
        this.exportedUnits = new LinkedList();
    }

    public List getABCs() {
        return this.abcList;
    }

    public void generate(List units) throws LinkerException {
        DependencyGraph dependencies = this.extractCompilationUnitInfo(units);
        this.exportDependencies(dependencies);
        if (ThreadLocalToolkit.errorCount() > 0) {
            throw new LinkerException.LinkingFailed();
        }
    }

    private DependencyGraph extractCompilationUnitInfo(List units) {
        Source s;
        CompilationUnit u;
        int i;
        DependencyGraph dependencies = new DependencyGraph();
        HashMap qnames = new HashMap();
        int length = units.size();
        for (i = 0; i < length; ++i) {
            u = (CompilationUnit)units.get(i);
            s = u.getSource();
            String path = s.getName();
            dependencies.put(path, u);
            if (!dependencies.containsVertex(s.getName())) {
                dependencies.addVertex(new Vertex(path));
            }
            Iterator j = u.topLevelDefinitions.iterator();
            while (j.hasNext()) {
                qnames.put(j.next(), s.getName());
            }
        }
        int size = units.size();
        for (i = 0; i < size; ++i) {
            u = (CompilationUnit)units.get(i);
            s = u.getSource();
            String head = s.getName();
            Iterator k = u.inheritance.iterator();
            while (k.hasNext()) {
                QName qname;
                String tail;
                Object obj = k.next();
                if (!(obj instanceof QName) || (tail = (String)qnames.get(qname = (QName)obj)) == null || head.equals(tail) || dependencies.dependencyExists(head, tail)) continue;
                dependencies.addDependency(head, tail);
            }
        }
        return dependencies;
    }

    private void exportDependencies(final DependencyGraph dependencies) {
        Algorithms.topologicalSort(dependencies, new Visitor(){

            public void visit(Object v) {
                String fileName = (String)((Vertex)v).getWeight();
                CompilationUnit u = (CompilationUnit)dependencies.get(fileName);
                if (!u.getSource().isInternal()) {
                    if (u.isRoot()) {
                        ConsoleApplication.access$002(ConsoleApplication.this, u.getByteCodes());
                    } else {
                        ConsoleApplication.this.abcList.add(u.getByteCodes());
                    }
                    ConsoleApplication.this.exportedUnits.add(u);
                }
            }
        });
        this.abcList.add(this.main);
    }

    public List getExportedUnits() {
        return this.exportedUnits;
    }

    static /* synthetic */ byte[] access$002(ConsoleApplication x0, byte[] x1) {
        x0.main = x1;
        return x1;
    }
}

