/*
 * Decompiled with CFR 0.152.
 */
package flex2.linker;

import flash.swf.Frame;
import flash.swf.tags.FrameLabel;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Source;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.swc.SwcLibrary;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.Visitor;
import flex2.linker.CULinkable;
import flex2.linker.Configuration;
import flex2.linker.DependencyWalker;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class FlexMovie
extends SimpleMovie {
    private List frameInfoList;
    private List configFrameInfoList;
    private String mainDef;
    private Set externs;
    private Set includes;
    private Set unresolved;
    private SortedSet resourceBundles;
    private Set metadata;

    public FlexMovie(Configuration configuration) {
        super(configuration);
        this.mainDef = configuration.getMainDefinition();
        this.externs = new HashSet(configuration.getExterns());
        this.includes = new HashSet(configuration.getIncludes());
        this.unresolved = new HashSet(configuration.getUnresolved());
        this.generateLinkReport = configuration.generateLinkReport();
        this.generateRBList = configuration.generateRBList();
        this.resourceBundles = new TreeSet(configuration.getResourceBundles());
        this.frameInfoList = new LinkedList();
        this.configFrameInfoList = new LinkedList();
        this.configFrameInfoList.addAll(configuration.getFrameList());
        this.metadata = new HashSet();
    }

    private void prelink(List units) throws LinkerException {
        HashMap def2unit = new HashMap();
        Iterator it = units.iterator();
        while (it.hasNext()) {
            CompilationUnit unit = (CompilationUnit)it.next();
            FlexMovie.mapAll(def2unit, unit.topLevelDefinitions.getStringSet(), unit);
        }
        this.buildFrames(def2unit, this.mainDef, new HashSet());
        this.frameInfoList.addAll(this.configFrameInfoList);
        if (this.frameInfoList.size() > 0) {
            this.topLevelClass = FlexMovie.formatSymbolClassName((String)((FramesConfiguration.FrameInfo)this.frameInfoList.get((int)0)).frameClasses.get(0));
        }
    }

    private boolean hasFrameClass(String queryClassName) {
        Iterator fit = this.frameInfoList.iterator();
        while (fit.hasNext()) {
            FramesConfiguration.FrameInfo frameInfo = (FramesConfiguration.FrameInfo)fit.next();
            Iterator cit = frameInfo.frameClasses.iterator();
            while (cit.hasNext()) {
                String className = (String)cit.next();
                if (!className.equals(queryClassName)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildFrames(Map def2unit, String className, Set progress) throws LinkerException {
        if (this.hasFrameClass(className)) {
            return;
        }
        if (progress.contains(className)) {
            return;
        }
        progress.add(className);
        CompilationUnit unit = (CompilationUnit)def2unit.get(className);
        if (unit == null) {
            throw new LinkerException.UndefinedSymbolException(className);
        }
        if (unit.loaderClass != null) {
            this.buildFrames(def2unit, unit.loaderClass, progress);
        }
        FramesConfiguration.FrameInfo info = new FramesConfiguration.FrameInfo();
        info.label = className.replaceAll("[^A-Za-z0-9]", "_");
        info.frameClasses.add(className);
        info.frameClasses.addAll(unit.resourceBundles);
        info.frameClasses.addAll(unit.extraClasses);
        this.frameInfoList.add(info);
    }

    public void generate(List units) throws LinkerException {
        try {
            this.prelink(units);
        }
        catch (LinkerException e) {
            ThreadLocalToolkit.log(e);
            throw e;
        }
        LinkedList<CULinkable> linkables = new LinkedList<CULinkable>();
        String serverConfigDef = null;
        CULinkable mainLinkable = null;
        Iterator it = units.iterator();
        while (it.hasNext()) {
            CompilationUnit unit = (CompilationUnit)it.next();
            Source source = unit.getSource();
            String sourceName = source.getName();
            if (sourceName.equals("serverConfigData.as")) {
                serverConfigDef = unit.topLevelDefinitions.first().toString();
            }
            CULinkable linkable = new CULinkable(unit);
            if (unit.isRoot()) {
                mainLinkable = linkable;
            }
            if (source.isInternal()) {
                this.externs.addAll(unit.topLevelDefinitions.getStringSet());
            }
            linkables.add(linkable);
        }
        this.frames = new ArrayList();
        if (mainLinkable != null && serverConfigDef != null) {
            mainLinkable.addDep(serverConfigDef);
        }
        try {
            final HashSet librariesProcessed = new HashSet();
            int counter = 0;
            DependencyWalker.LinkState state = new DependencyWalker.LinkState(linkables, this.externs, this.includes, this.unresolved);
            Iterator it2 = this.frameInfoList.iterator();
            while (it2.hasNext()) {
                FramesConfiguration.FrameInfo frameInfo = (FramesConfiguration.FrameInfo)it2.next();
                final Frame f = new Frame();
                f.pos = ++counter;
                if (frameInfo.label != null) {
                    f.label = new FrameLabel();
                    f.label.label = frameInfo.label;
                }
                DependencyWalker.traverse(frameInfo.frameClasses, state, !it2.hasNext(), !it2.hasNext(), new Visitor(){

                    public void visit(Object o) {
                        SwcScript script;
                        SwcLibrary library;
                        CULinkable l = (CULinkable)o;
                        FlexMovie.this.exportUnitOnFrame(l.getUnit(), f, FlexMovie.this.lazyInit);
                        Source source = l.getUnit().getSource();
                        if (source.isSwcScriptOwner() && !source.isInternal() && !librariesProcessed.contains(library = (script = (SwcScript)source.getOwner()).getLibrary())) {
                            librariesProcessed.add(library);
                            FlexMovie.this.metadata.addAll(library.getMetadata());
                        }
                    }
                });
                this.frames.add(f);
            }
            if (this.generateLinkReport) {
                this.linkReport = DependencyWalker.dump(state);
            }
            if (this.generateRBList) {
                this.rbList = FlexMovie.dumpRBList(this.resourceBundles);
            }
            if (this.unresolved.size() != 0) {
                boolean fatal = false;
                Iterator it3 = this.unresolved.iterator();
                while (it3.hasNext()) {
                    String u = (String)it3.next();
                    if (this.externs.contains(u)) continue;
                    ThreadLocalToolkit.log(new LinkerException.UndefinedSymbolException(u));
                    fatal = true;
                }
                if (fatal) {
                    throw new LinkerException.LinkingFailed();
                }
            }
        }
        catch (LinkerException e) {
            ThreadLocalToolkit.log(e);
            throw e;
        }
    }

    public static String dumpRBList(Set bundles) {
        StringBuffer b = new StringBuffer();
        b.append("bundles = ");
        Iterator iterator = bundles.iterator();
        while (iterator.hasNext()) {
            String str = (String)iterator.next();
            b.append(str + " ");
        }
        return b.toString();
    }

    private static void mapAll(Map map, Set keys, Object val) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String defname = (String)it.next();
            map.put(defname, val);
        }
    }

    public Set getMetadata() {
        return this.metadata;
    }
}

