/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.impl.ICUBinary;
import com.adobe.agl.impl.ICUDebug;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

final class UConverterAliasDataReader
implements ICUBinary.Authenticate {
    private static final boolean debug = ICUDebug.enabled("UConverterAliasDataReader");
    private DataInputStream dataInputStream;
    private byte[] unicodeVersion;
    private static final byte[] DATA_FORMAT_ID = new byte[]{67, 118, 65, 108};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{3};
    private static final int UNSIGNED_SHORT_MASK = 65535;
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;

    protected UConverterAliasDataReader(InputStream inputStream) throws IOException {
        if (debug) {
            System.out.println("Bytes in inputStream " + inputStream.available());
        }
        this.unicodeVersion = ICUBinary.readHeader(inputStream, DATA_FORMAT_ID, this);
        if (debug) {
            System.out.println("Bytes left in inputStream " + inputStream.available());
        }
        this.dataInputStream = new DataInputStream(inputStream);
        if (debug) {
            System.out.println("Bytes left in dataInputStream " + this.dataInputStream.available());
        }
    }

    protected long[] readToc(int n) throws IOException {
        long[] toc = new long[n];
        for (int i = 0; i < n; ++i) {
            toc[i] = (long)this.dataInputStream.readInt() & 0xFFFFFFFFL;
        }
        return toc;
    }

    protected void read(int[] convList, int[] tagList, int[] aliasList, int[] untaggedConvArray, int[] taggedAliasArray, int[] taggedAliasLists, byte[] reservedBytes, byte[] stringTable) throws IOException {
        int i;
        boolean listnum = true;
        for (i = 0; i < convList.length; ++i) {
            convList[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < tagList.length; ++i) {
            tagList[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < aliasList.length; ++i) {
            aliasList[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < untaggedConvArray.length; ++i) {
            untaggedConvArray[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < taggedAliasArray.length; ++i) {
            taggedAliasArray[i] = this.dataInputStream.readUnsignedShort();
        }
        for (i = 0; i < taggedAliasLists.length; ++i) {
            taggedAliasLists[i] = this.dataInputStream.readUnsignedShort();
        }
        this.dataInputStream.read(reservedBytes);
        this.dataInputStream.read(stringTable);
    }

    public byte[] getDataFormatVersion() {
        return DATA_FORMAT_VERSION;
    }

    public boolean isDataVersionAcceptable(byte[] version) {
        return version[0] == DATA_FORMAT_VERSION[0];
    }

    public byte[] getUnicodeVersion() {
        return this.unicodeVersion;
    }
}

