/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.html;

import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.html.DetectionRenderer;
import flex.webtier.server.j2ee.html.EventsRenderer;
import flex.webtier.server.j2ee.html.HistoryRenderer;
import flex.webtier.server.j2ee.html.HtmlRenderer;
import flex.webtier.server.j2ee.html.SwfRenderer;
import java.io.IOException;
import java.io.PrintWriter;

public class MxmlRenderer {
    private HtmlRenderer htmlRenderer = new HtmlRenderer();
    private SwfRenderer swfRenderer = new SwfRenderer();
    private EventsRenderer eventsRenderer = new EventsRenderer();
    private HistoryRenderer historyRenderer;
    private DetectionRenderer detectionRenderer;

    public MxmlRenderer(MxmlContext context) {
        this.historyRenderer = new HistoryRenderer(context);
        this.detectionRenderer = new DetectionRenderer(context);
    }

    public void render(MxmlContext context) throws IOException {
        context.getResponse().setContentType("text/html;charset=UTF-8");
        PrintWriter output = context.getResponseWriter();
        this.htmlRenderer.renderBeginHtml(output);
        String pageTitle = context.getPageTitle();
        this.htmlRenderer.renderBeginHead(pageTitle, output);
        this.historyRenderer.renderJavaScriptImport(output, true);
        this.detectionRenderer.renderTagImport(output, true);
        this.htmlRenderer.renderBeginStyle(output);
        boolean scroll = true;
        if (!(!context.getWidth().equals("100%") || !context.getHeight().equals("100%") || context.hasErrors() || context.hasWarnings() && context.showAllWarnings())) {
            scroll = false;
        }
        if (!context.hasWarnings() || !context.showAllWarnings()) {
            this.htmlRenderer.renderStyle(output, scroll);
        } else {
            this.eventsRenderer.renderEventsStyle(output);
        }
        this.htmlRenderer.renderEndStyle(output);
        this.detectionRenderer.renderRequiredInfo(output, true);
        this.htmlRenderer.renderEndHead(output);
        this.htmlRenderer.renderBeginBody(output, scroll);
        if (context.hasWarnings() && context.showAllWarnings()) {
            this.eventsRenderer.renderEventsScript(output);
        }
        if (context.hasWarnings() && context.showAllWarnings()) {
            this.eventsRenderer.renderEvents(context, output);
        }
        this.htmlRenderer.renderBeginTable(output);
        this.renderCompiledMxml(context, output);
        this.historyRenderer.renderIframe(context, output, true);
        this.htmlRenderer.renderEndTable(output);
        this.htmlRenderer.renderEndBody(output);
        this.htmlRenderer.renderEndHtml(output);
    }

    private void renderCompiledMxml(MxmlContext context, PrintWriter output) {
        this.swfRenderer.renderEmbeddedSwf(context, output, SwfRenderer.NO_SCRIPT);
        output.println();
        output.println();
        this.detectionRenderer.renderSwf(context, output);
        output.println();
        output.println();
    }
}

