/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import java.io.Serializable;

public abstract class AbstractCache
implements Serializable {
    private Lock lock = new Lock();
    private Thread busyThread;
    long hits;
    long misses;
    long missPenalty;
    public static boolean verbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object fetch(Object key) {
        Lock lock;
        Object object = this.lock;
        synchronized (object) {
            Thread currentThread = Thread.currentThread();
            if (this.busyThread == currentThread) {
                throw new IllegalStateException("AbstractCache.fetch is not re-entrant");
            }
            while (this.busyThread != null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {}
            }
            this.busyThread = currentThread;
        }
        try {
            object = this.fetchSerial(key);
            Object var7_6 = null;
            lock = this.lock;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Lock lock2 = this.lock;
            synchronized (lock2) {
                this.busyThread = null;
                this.lock.notify();
            }
            throw throwable;
        }
        synchronized (lock) {
            this.busyThread = null;
            this.lock.notify();
        }
        return object;
    }

    protected Object fetchSerial(Object key) {
        return null;
    }

    public abstract Object get(Object var1);

    public abstract void remove(Object var1);

    public abstract void put(Object var1, Object var2);

    public abstract void setSize(int var1);

    public abstract void clear();

    final void report() {
        if (verbose) {
            double tries = this.misses + this.hits;
            double penalty = (double)this.missPenalty / (double)this.misses;
            System.out.println(this + " hit rate: " + (double)(this.hits * 100L) / tries + " " + this.hits + "/" + this.misses + " penalty " + penalty);
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

