/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.RecoverableSerializationException;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.ActionMessageInput;
import flex.messaging.io.amf.Amf0Input;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import java.io.IOException;
import java.io.InputStream;

public class AmfMessageDeserializer
implements MessageDeserializer {
    private static final int UNSUPPORTED_AMF_VERSION = 10310;
    protected ActionMessageInput amfIn;
    protected AmfTrace debugTrace;
    protected boolean isDebug;

    public void initialize(SerializationContext context, InputStream in, AmfTrace trace) {
        this.amfIn = new Amf0Input(context);
        this.amfIn.setInputStream(in);
        this.debugTrace = trace;
        this.isDebug = this.debugTrace != null;
        this.amfIn.setDebugTrace(this.debugTrace);
    }

    public void readMessage(ActionMessage m, ActionContext context) throws ClassNotFoundException, IOException {
        int version;
        if (this.isDebug) {
            this.debugTrace.startRequest("Deserializing AMF/HTTP request");
        }
        if ((version = this.amfIn.readUnsignedShort()) != 0 && version != 3) {
            MessageException ex = new MessageException();
            ex.setMessage(10310, new Object[]{new Integer(version)});
            ex.setCode("VersionMismatch");
            throw ex;
        }
        m.setVersion(version);
        context.setVersion(version);
        if (this.isDebug) {
            this.debugTrace.version(version);
        }
        int headerCount = this.amfIn.readUnsignedShort();
        for (int i = 0; i < headerCount; ++i) {
            MessageHeader header = new MessageHeader();
            m.addHeader(header);
            this.readHeader(header, i);
        }
        int bodyCount = this.amfIn.readUnsignedShort();
        for (int i = 0; i < bodyCount; ++i) {
            MessageBody body = new MessageBody();
            m.addBody(body);
            this.readBody(body, i);
        }
    }

    public void readHeader(MessageHeader header, int index) throws ClassNotFoundException, IOException {
        String name = this.amfIn.readUTF();
        header.setName(name);
        boolean mustUnderstand = this.amfIn.readBoolean();
        header.setMustUnderstand(mustUnderstand);
        this.amfIn.readInt();
        this.amfIn.reset();
        Object data = null;
        if (this.isDebug) {
            this.debugTrace.startHeader(name, mustUnderstand, index);
        }
        try {
            data = this.readObject();
        }
        catch (RecoverableSerializationException ex) {
            ex.setCode("Client.Header.Encoding");
            data = ex;
        }
        catch (MessageException ex) {
            ex.setCode("Client.Header.Encoding");
            throw ex;
        }
        header.setData(data);
        if (this.isDebug) {
            this.debugTrace.endHeader();
        }
    }

    public void readBody(MessageBody body, int index) throws ClassNotFoundException, IOException {
        String targetURI = this.amfIn.readUTF();
        body.setTargetURI(targetURI);
        String responseURI = this.amfIn.readUTF();
        body.setResponseURI(responseURI);
        this.amfIn.readInt();
        this.amfIn.reset();
        Object data = null;
        if (this.isDebug) {
            this.debugTrace.startMessage(targetURI, responseURI, index);
        }
        try {
            data = this.readObject();
        }
        catch (RecoverableSerializationException ex) {
            ex.setCode("Client.Message.Encoding");
            data = ex;
        }
        catch (MessageException ex) {
            ex.setCode("Client.Message.Encoding");
            throw ex;
        }
        body.setData(data);
        if (this.isDebug) {
            this.debugTrace.endMessage();
        }
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        return this.amfIn.readObject();
    }
}

