/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GlobalOptimizer {
    final boolean PRESERVE_METHOD_NAMES = false;
    final boolean USE_CALLMETHOD = false;
    final boolean OUTPUT_DOT = false;
    final boolean SHOW_DFG = false;
    final boolean SHOW_CODE = false;
    final boolean STRIP_DEBUG_INFO = true;
    Symtab<Type> namedTypes = new Symtab();
    Symtab<Typeref> globals = new Symtab();
    Map<Namespace, Name> namespaceNames = new HashMap<Namespace, Name>();
    static final Handler[] nohandlers = new Handler[0];
    static int rtcounter;
    static final Object UNDEFINED;
    static final Object BOTTOM;
    static final Double NAN;
    Type ANY = new Type(new Name("*"), null);
    static Namespace PUBLIC;
    static Namespace PKG_PUBLIC;
    static Namespace AS3;
    static Name AS3_TOSTRING;
    Type OBJECT;
    Type FUNCTION;
    Type CLASS;
    Type ARRAY;
    Type INT;
    Type UINT;
    Type NUMBER;
    Type BOOLEAN;
    Type STRING;
    Type NAMESPACE;
    Type XML;
    Type XMLLIST;
    Type QNAME;
    Type NULL;
    Type VOID;
    static final Metadata[] nometadata;
    List<Method> ready = new ArrayList<Method>();
    static final Expr[] noexprs;
    static final Edge[] noedges;
    static Type[] notypes;
    static Typeref[] notyperefs;
    static int[] refArgc;
    static final int OPER = 1;
    static final int EFFECT = 2;
    static final int COERCE = 4;
    static final int PX = 8;
    static final int SYNTH = 16;
    static final int SCPVAL = 32;
    static final int STKVAL = 64;
    static final int LOCVAL = 128;
    static int[] flagTable;
    static String[] opNames;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.out.println("usage: GlobalOptimizer [imports] file.abc");
            return;
        }
        GlobalOptimizer globalOptimizer = new GlobalOptimizer();
        InputAbc inputAbc = null;
        String string = null;
        byte[] byArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            byArray = GlobalOptimizer.load(string);
            inputAbc = globalOptimizer.new InputAbc();
            inputAbc.readAbc(byArray);
        }
        globalOptimizer.optimize(inputAbc);
        byte[] byArray2 = globalOptimizer.emit(inputAbc, string);
        System.out.println();
        System.out.println("BEFORE " + byArray.length);
        System.out.println("AFTER  " + byArray2.length);
        int n = byArray.length - byArray2.length;
        long l = Math.round((double)n / (double)byArray.length * 100.0);
        System.out.println("SAVED  " + n + " " + l + "%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] load(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            byte[] byArray = new byte[((InputStream)fileInputStream).available()];
            ((InputStream)fileInputStream).read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static int match(Name name, Name name2) {
        block7: {
            block6: {
                if (name == name2) {
                    return 0;
                }
                int n = name.attr() - name2.attr();
                if (n != 0) {
                    return n;
                }
                n = name.name.compareTo(name2.name);
                if (n != 0) {
                    return n;
                }
                if (name.isQname() && name2.isQname()) {
                    return name.nsset(0).compareTo(name2.nsset(0));
                }
                if (!name2.isQname() || name2.isQname()) break block6;
                for (Namespace namespace : name2.nsset) {
                    if (!namespace.equals(name.nsset(0))) continue;
                    return 0;
                }
                break block7;
            }
            if (!name2.isQname() || name.isQname()) break block7;
            for (Namespace namespace : name.nsset) {
                if (!namespace.equals(name2.nsset(0))) continue;
                return 0;
            }
        }
        return name.nsset.compareTo(name2.nsset);
    }

    static String unique() {
        return GlobalOptimizer.unique("[]");
    }

    static String unique(String string) {
        return string + rtcounter++;
    }

    static Namespace uniqueNs() {
        return new Namespace(GlobalOptimizer.unique("ns"));
    }

    public static int deepHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            int n2 = 0;
            if (object != null) {
                n2 = object.hashCode();
            }
            n = 31 * n + n2;
        }
        return n;
    }

    public static boolean deepEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object == object2) continue;
            if (object == null) {
                return false;
            }
            if (object.equals(object2)) continue;
            return false;
        }
        return true;
    }

    void readyType(Type type) {
        this.ready.add(type.init);
        for (Binding binding : type.defs.values()) {
            if (binding.method == null) continue;
            this.readyMethod(binding.method);
        }
    }

    void readyMethod(Method method) {
        if (method.entry != null) {
            this.ready.add(method);
        }
    }

    void optimize(InputAbc inputAbc) throws IOException {
        for (Type type : inputAbc.scripts) {
            this.readyType(type);
        }
        while (!this.ready.isEmpty()) {
            this.optimize(this.remove(this.ready));
        }
    }

    int argc(Expr expr) {
        switch (expr.op) {
            case 69: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 79: {
                return expr.args.length - refArgc[expr.ref.kind] - 1;
            }
            case 66: 
            case 67: 
            case 68: 
            case 73: {
                return expr.args.length - 1;
            }
            case 65: {
                return expr.args.length - 2;
            }
            case 86: {
                return expr.args.length;
            }
            case 85: {
                assert (expr.args.length % 2 == 0);
                return expr.args.length / 2;
            }
        }
        assert (false);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] emit(InputAbc inputAbc, String string) throws IOException {
        Abc abc = new Abc();
        for (Type type : inputAbc.scripts) {
            abc.addScript(type);
        }
        abc.sort();
        String string2 = string.substring(0, string.lastIndexOf(46));
        byte[] byArray = this.emitAbc(abc);
        FileOutputStream fileOutputStream = new FileOutputStream(string2 + ".abc2");
        try {
            ((OutputStream)fileOutputStream).write(byArray);
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
        if (abc.haveNatives) {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string2 + ".h2"));
            IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(new FileWriter(string2 + ".cpp2"));
            try {
                this.emitSource(abc, string2, byArray, printWriter, indentingPrintWriter);
            }
            finally {
                indentingPrintWriter.close();
                printWriter.close();
            }
        }
        return byArray;
    }

    void emitSource(Abc abc, String string, byte[] byArray, PrintWriter printWriter, IndentingPrintWriter indentingPrintWriter) throws IOException {
        printWriter.println("/* machine generated file -- do not edit */");
        printWriter.println("extern const unsigned char " + string + "_abc_data[" + byArray.length + "];");
        printWriter.println("DECLARE_NATIVE_MAP(" + string + ", " + abc.methodPool1.size() + ")");
        printWriter.printf("    #ifdef AVMPLUS_64BIT\n", new Object[0]);
        printWriter.printf("    #error createThunkArgs is not 64-bit clean yet, sorry\n", new Object[0]);
        printWriter.printf("    #endif\n", new Object[0]);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter2 = new PrintWriter(stringWriter);
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        for (Type type : abc.scripts) {
            this.emitSourceTraits("", abc, type, printWriter, treeMap, printWriter2);
        }
        indentingPrintWriter.println("/* machine generated file -- do not edit */");
        indentingPrintWriter.print("BEGIN_NATIVE_MAP(" + string + ")");
        ++indentingPrintWriter.indent;
        indentingPrintWriter.println();
        Iterator<Type> iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)((Object)iterator.next());
            String string2 = (String)treeMap.get(n);
            if (string2.charAt(0) == 'f') {
                indentingPrintWriter.println("FORTH_METHOD(" + string2.substring(1) + ")");
                continue;
            }
            indentingPrintWriter.println("NATIVE_METHOD(" + string2.substring(1) + ")");
        }
        --indentingPrintWriter.indent;
        indentingPrintWriter.println("END_NATIVE_MAP()");
        indentingPrintWriter.println();
        printWriter2.flush();
        indentingPrintWriter.println(stringWriter);
        indentingPrintWriter.println();
        indentingPrintWriter.print("const unsigned char " + string + "_abc_data[" + byArray.length + "] = {");
        ++indentingPrintWriter.indent;
        indentingPrintWriter.println();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (n2 < 10) {
                indentingPrintWriter.print("  ");
            } else if (n2 < 100) {
                indentingPrintWriter.print(' ');
            }
            indentingPrintWriter.print(n2);
            if (i + 1 < n) {
                indentingPrintWriter.print(", ");
            }
            if (i % 16 != 15) continue;
            indentingPrintWriter.println();
        }
        --indentingPrintWriter.indent;
        indentingPrintWriter.println("};");
    }

    void emitSourceTraits(String string, Abc abc, Type type, PrintWriter printWriter, Map<Integer, String> map, PrintWriter printWriter2) {
        printWriter.println();
        for (Binding binding : type.defs.values()) {
            Namespace namespace = binding.name.nsset(0);
            if (binding.method != null && binding.method.isNative()) {
                this.emitSourceMethod(string, abc, binding, namespace, printWriter, map, printWriter2);
                continue;
            }
            if (GlobalOptimizer.isClass(binding)) {
                this.emitSourceClass(abc, printWriter, map, printWriter2, binding, namespace);
                continue;
            }
            if (!GlobalOptimizer.isSlot(binding)) continue;
            this.emitSourceSlot(string, abc, binding, namespace, printWriter, printWriter2);
        }
    }

    void emitSourceSlot(String string, Abc abc, Binding binding, Namespace namespace, PrintWriter printWriter, PrintWriter printWriter2) {
        String string2 = string + this.propLabel(binding, namespace);
        boolean bl = false;
        String string3 = null;
        if (binding.md.length > 0) {
            for (Metadata metadata : binding.md) {
                if (!metadata.name.equals("native")) continue;
                bl = true;
                for (Attr attr : metadata.attrs) {
                    if (!attr.name.equals("type")) continue;
                    string3 = attr.value;
                }
            }
        }
        if (bl) {
            if (this.isAtom(binding.type.t)) {
                if (string3 != null) {
                    if (binding.type.t != this.ANY || !namespace.isPrivateOrInternal()) {
                        throw new RuntimeException("native field " + string2 + " must be private or internal and type *");
                    }
                    printWriter.println("AVMPLUS_NATIVE_SLOT_DECL_GC(" + string3 + "," + binding.offset + "," + string2 + ")");
                    printWriter2.println("AVMPLUS_NATIVE_SLOT_IMPL_GC(" + string3 + "," + binding.offset + "," + string2 + ")");
                } else {
                    printWriter.println("AVMPLUS_NATIVE_SLOT_DECL_ATOM(" + binding.offset + "," + string2 + ")");
                    printWriter2.println("AVMPLUS_NATIVE_SLOT_IMPL_ATOM(" + binding.offset + "," + string2 + ")");
                }
            } else if (binding.type.t.numeric) {
                string3 = this.ctype(binding.type);
                printWriter.println("AVMPLUS_NATIVE_SLOT_DECL_PRIM(" + string3 + "," + binding.offset + "," + string2 + ")");
                printWriter2.println("AVMPLUS_NATIVE_SLOT_IMPL_PRIM(" + string3 + "," + binding.offset + "," + string2 + ")");
            } else {
                string3 = this.ctype(binding.type);
                printWriter.println("AVMPLUS_NATIVE_SLOT_DECL_RC(" + string3 + "," + binding.offset + "," + string2 + ")");
                printWriter2.println("AVMPLUS_NATIVE_SLOT_IMPL_RC(" + string3 + "," + binding.offset + "," + string2 + ")");
            }
        }
    }

    void emitSourceClass(Abc abc, PrintWriter printWriter, Map<Integer, String> map, PrintWriter printWriter2, Binding binding, Namespace namespace) {
        String string = namespace.isPublic() || namespace.isInternal() ? binding.name.name : (namespace.isProtected() ? "protected_" + binding.name.name : (this.namespaceNames.containsKey(namespace) ? this.namespaceNames.get(namespace) + "_" + binding.name.name : namespace.uri.replace(' ', '_').replace('.', '_').replace('$', '_') + '_' + binding.name.name));
        Type type = binding.type.t;
        printWriter.println("const int abcclass_" + string + " = " + abc.classId(type) + ";");
        this.emitSourceTraits(string + "_", abc, type, printWriter, map, printWriter2);
        this.emitSourceTraits(string + "_", abc, type.itype, printWriter, map, printWriter2);
    }

    String ctype(Typeref typeref) {
        Type type = typeref.t;
        if (type == this.VOID) {
            return "void";
        }
        if (this.isAtom(type)) {
            return "Atom";
        }
        if (type == this.INT) {
            return "int32";
        }
        if (type == this.BOOLEAN) {
            return "bool";
        }
        if (type == this.UINT) {
            return "uint32";
        }
        if (type == this.STRING) {
            return "Stringp";
        }
        if (type == this.NAMESPACE) {
            return "Namespacep";
        }
        if (type == this.NUMBER) {
            return "double";
        }
        return "ScriptObject* /*" + typeref.toString() + "*/";
    }

    void emitSourceMethod(String string, Abc abc, Binding binding, Namespace namespace, PrintWriter printWriter, Map<Integer, String> map, PrintWriter printWriter2) {
        Method method = binding.method;
        String string2 = string + this.propLabel(binding, namespace);
        if (this.isGetter(binding)) {
            string2 = string2 + "_get";
        } else if (this.isSetter(binding)) {
            string2 = string2 + "_set";
        }
        String string3 = null;
        if (binding.md.length > 0) {
            for (Metadata metadata : binding.md) {
                if (!metadata.name.equals("forth")) continue;
                for (Attr attr : metadata.attrs) {
                    if (!attr.name.equals("word")) continue;
                    string3 = attr.value;
                    break;
                }
                if (string3 != null) break;
                throw new RuntimeException("the forth metadata must specify the word attribute");
            }
        }
        if (string3 != null) {
            printWriter.printf("AVMPLUS_FORTH_METHOD_DECL(%s, %s)\n", string3, string2);
            map.put(abc.methodId(method), "f" + string3);
        } else {
            if (method.hasOptional()) {
                throw new RuntimeException("native methods may not have optional parameters: " + string2);
            }
            this.createThunkArgs(printWriter, string2, method);
            printWriter.printf("AVMPLUS_NATIVE_METHOD_DECL(%s, %s)\n", this.ctype(method.returns), string2);
            map.put(abc.methodId(method), "n" + string2);
        }
    }

    String propLabel(Binding binding, Namespace namespace) {
        return namespace.isPublic() || namespace.isInternal() ? binding.name.name : (namespace.isPrivate() ? "private_" + binding.name.name : (namespace.isProtected() ? "protected_" + binding.name.name : this.namespaceNames.get(namespace) + "_" + binding.name.name));
    }

    void createThunkArgs(PrintWriter printWriter, String string, Method method) {
        if (!method.hasParamNames() && method.params.length > 1) {
            throw new RuntimeException("native method " + string + " must be generated with debug info (have no fear, it will be stripped)");
        }
        printWriter.println();
        printWriter.println("struct " + string + "_args");
        printWriter.println("{");
        int n = method.params.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = i == 0 ? (method.params[i].toString().indexOf("$") >= 0 ? "classself" : "self") : (string2 = method.paramNames[i].name);
            if (method.params[i].t == this.NUMBER) {
                printWriter.printf("    public: double %s;\n", string2);
                continue;
            }
            if (method.params[i].t == this.BOOLEAN) {
                printWriter.printf("    public: int32 %s_b; private: int32 %s_pad; public: inline bool %s() const { return %s_b != 0; }\n", string2, string2, string2, string2);
                continue;
            }
            if (method.params[i].t == this.OBJECT || method.params[i].t == this.ANY) {
                printWriter.printf("    public: Box %s;\n", string2);
                continue;
            }
            printWriter.printf("    public: %s %s; private: int32 %s_pad; \n", this.ctype(method.params[i]), string2, string2);
        }
        if (method.needsRest()) {
            printWriter.printf("    public: Box rest[1]; /* actually, rest_count() */\n", new Object[0]);
            printWriter.printf("    public: inline uintptr rest_count(uint32 argc) const { return argc-%d; }\n", method.params.length - 1);
        }
        printWriter.println("};");
    }

    /*
     * WARNING - void declaration
     */
    byte[] emitAbc(Abc abc) throws IOException {
        AbcWriter abcWriter = new AbcWriter();
        abcWriter.writeU16(16);
        abcWriter.writeU16(46);
        int n = abcWriter.size();
        abcWriter.writeU30(abc.intPool.size());
        Iterator iterator = abc.intPool.values.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            abcWriter.writeU30(n2);
        }
        System.out.println("ints count " + abc.intPool.size() + " size " + (abcWriter.size() - n));
        n = abcWriter.size();
        abcWriter.writeU30(abc.uintPool.size());
        iterator = abc.uintPool.values.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            abcWriter.writeU30((int)l);
        }
        System.out.println("uints count " + abc.uintPool.size() + " size " + (abcWriter.size() - n));
        n = abcWriter.size();
        System.out.println("doubles " + abc.doublePool.size());
        abcWriter.writeU30(abc.doublePool.size());
        iterator = abc.doublePool.values.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            abcWriter.write64(Double.doubleToLongBits(d));
        }
        System.out.println("double count " + abc.doublePool.size() + " size " + (abcWriter.size() - n));
        n = abcWriter.size();
        abcWriter.writeU30(abc.stringPool.size());
        for (String string : abc.stringPool.values) {
            abcWriter.writeU30(string.length());
            abcWriter.write(string.getBytes("UTF-8"));
        }
        System.out.println("strings count " + abc.stringPool.size() + " size " + (abcWriter.size() - n));
        n = abcWriter.size();
        abcWriter.writeU30(abc.nsPool.size());
        for (Namespace namespace : abc.nsPool.values) {
            this.emitNamespace(abc, abcWriter, namespace);
        }
        System.out.println("ns count " + abc.nsPool.size() + " size " + (abcWriter.size() - n));
        n = abcWriter.size();
        abcWriter.writeU30(abc.nssetPool.size());
        for (Nsset nsset : abc.nssetPool.values) {
            abcWriter.writeU30(nsset.length);
            for (Object object : nsset) {
                abcWriter.writeU30(abc.nsPool.id((Namespace)object));
            }
        }
        System.out.println("nsset count " + abc.nssetPool.size() + " size " + (abcWriter.size() - n));
        n = abcWriter.size();
        abcWriter.writeU30(abc.namePool.size());
        block14: for (Name name : abc.namePool.values) {
            abcWriter.write(name.kind);
            switch (name.kind) {
                case 7: 
                case 13: {
                    abcWriter.writeU30(abc.nsPool.id(name.nsset(0)));
                    abcWriter.writeU30(abc.stringPool.id(name.name));
                    continue block14;
                }
                case 9: 
                case 14: {
                    abcWriter.writeU30(abc.stringPool.id(name.name));
                    abcWriter.writeU30(abc.nssetPool.id(name.nsset));
                    continue block14;
                }
                case 15: 
                case 16: {
                    abcWriter.writeU30(abc.stringPool.id(name.name));
                    continue block14;
                }
                case 27: 
                case 28: {
                    abcWriter.writeU30(abc.nssetPool.id(name.nsset));
                    continue block14;
                }
                case 17: 
                case 18: {
                    continue block14;
                }
            }
            assert (false);
        }
        System.out.println("name count " + abc.namePool.size() + " size " + (abcWriter.size() - n));
        n = abcWriter.size();
        abcWriter.writeU30(abc.methodPool2.size());
        int n3 = 0;
        for (Method method : abc.methodPool1.values) {
            this.emitMethod(abc, abcWriter, n3++, method);
        }
        for (Method method : abc.methodPool2.values) {
            this.emitMethod(abc, abcWriter, n3++, method);
        }
        abcWriter.writeU30(abc.metaPool.size());
        for (Metadata metadata : abc.metaPool.values) {
            abcWriter.writeU30(abc.stringPool.id(metadata.name));
            abcWriter.writeU30(metadata.attrs.length);
            for (Attr attr : metadata.attrs) {
                abcWriter.writeU30(abc.stringPool.id(attr.name));
            }
            for (Attr attr : metadata.attrs) {
                abcWriter.writeU30(abc.stringPool.id(attr.value));
            }
        }
        abcWriter.writeU30(abc.classes.size());
        for (Type type : abc.classes) {
            void var10_36;
            Object object;
            object = type.itype;
            abcWriter.writeU30(abc.namePool.id(((Type)object).name));
            abcWriter.writeU30(abc.typeRef(((Type)object).base));
            abcWriter.write(((Type)object).flags);
            if (((Type)object).hasProtectedNs()) {
                abcWriter.writeU30(abc.nsPool.id(((Type)object).protectedNs));
            }
            abcWriter.writeU30(((Type)object).interfaces.length);
            Type[] typeArray = ((Type)object).interfaces;
            int n2 = typeArray.length;
            boolean bl = false;
            while (var10_36 < n2) {
                Type type2 = typeArray[var10_36];
                abcWriter.writeU30(abc.typeRef(type2));
                ++var10_36;
            }
            abcWriter.writeU30(abc.methodId(((Type)object).init));
            this.emitTraits(abcWriter, abc, (Type)object);
        }
        for (Type type : abc.classes) {
            abcWriter.writeU30(abc.methodId(type.init));
            this.emitTraits(abcWriter, abc, type);
        }
        abcWriter.writeU30(abc.scripts.size());
        for (Type type : abc.scripts) {
            abcWriter.writeU30(abc.methodId(type.init));
            this.emitTraits(abcWriter, abc, type);
        }
        abcWriter.writeU30(abc.bodyCount);
        this.emitBodies(abc, abcWriter, abc.methodPool1);
        this.emitBodies(abc, abcWriter, abc.methodPool2);
        return abcWriter.toByteArray();
    }

    void emitNamespace(Abc abc, AbcWriter abcWriter, Namespace namespace) {
        if (namespace.isPrivateOrInternal()) {
            abcWriter.write(5);
            abcWriter.writeU30(0);
        } else {
            abcWriter.write(namespace.kind);
            abcWriter.writeU30(abc.stringPool.id(namespace.uri));
        }
    }

    void emitBodies(Abc abc, AbcWriter abcWriter, Pool<Method> pool) throws IOException {
        for (Method method : pool.values) {
            if (method.entry == null) continue;
            abcWriter.writeU30(abc.methodId(method));
            abcWriter.writeU30(method.max_stack);
            abcWriter.writeU30(method.local_count);
            if (method.cx != null && method.cx.scopes != null) {
                abcWriter.writeU30(method.cx.scopes.length);
                abcWriter.writeU30(method.cx.scopes.length + method.max_scope);
            } else {
                abcWriter.writeU30(0);
                abcWriter.writeU30(method.max_scope);
            }
            this.emitCode(abcWriter, abc, method);
            this.emitTraits(abcWriter, abc, method.activation.t);
        }
    }

    void emitMethod(Abc abc, AbcWriter abcWriter, int n, Method method) {
        int n2;
        System.out.println("METHOD " + n + " was " + method.id);
        abcWriter.writeU30(method.params.length - 1);
        abcWriter.writeU30(abc.typeRef(method.returns));
        int n3 = method.params.length;
        for (n2 = 1; n2 < n3; ++n2) {
            abcWriter.writeU30(abc.typeRef(method.params[n2]));
        }
        abcWriter.writeU30(0);
        n2 = method.flags;
        abcWriter.write(n2 &= 0xFFFFFF7F);
        if (method.hasOptional()) {
            n3 = 0;
            for (Object object : method.values) {
                if (object == null) continue;
                ++n3;
            }
            assert (n3 > 0);
            abcWriter.writeU30(n3);
            for (int i = method.params.length - n3; i < method.params.length; ++i) {
                int n4 = abc.constKind(method.values[i]);
                abcWriter.writeU30(abc.constId(n4, method.values[i]));
                abcWriter.write(n4);
            }
        }
        if ((n2 & 0x80) != 0) {
            for (n3 = 1; n3 < method.paramNames.length; ++n3) {
                abcWriter.writeU30(abc.namePool.id(method.paramNames[n3]));
            }
        }
    }

    int intValue(Object object) {
        return ((Number)object).intValue();
    }

    long uintValue(Object object) {
        return ((Number)object).longValue() & 0xFFFFFFFFL;
    }

    double doubleValue(Object object) {
        return object instanceof Number ? ((Number)object).doubleValue() : Double.NaN;
    }

    boolean booleanValue(Object object) {
        if (object instanceof Boolean) {
            return object == Boolean.TRUE;
        }
        if (object instanceof String || object instanceof Namespace) {
            return true;
        }
        if (object == this.NULL || object == UNDEFINED) {
            return false;
        }
        return this.doubleValue(object) != 0.0;
    }

    String stringValue(Object object) {
        return String.valueOf(object);
    }

    void emitBlock(AbcWriter abcWriter, Block block, Abc abc) {
        for (Expr expr : block) {
            if (expr.succ != null) break;
            abcWriter.write(expr.op);
            switch (expr.op) {
                case 50: {
                    abcWriter.writeU30(expr.imm[0]);
                    abcWriter.writeU30(expr.imm[1]);
                    break;
                }
                case 4: 
                case 5: 
                case 89: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 102: 
                case 104: 
                case 106: 
                case 128: 
                case 134: 
                case 178: {
                    abcWriter.writeU30(abc.namePool.id(expr.ref));
                    break;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 78: 
                case 79: {
                    abcWriter.writeU30(abc.namePool.id(expr.ref));
                    abcWriter.writeU30(this.argc(expr));
                    break;
                }
                case 65: 
                case 66: 
                case 73: 
                case 85: 
                case 86: {
                    abcWriter.writeU30(this.argc(expr));
                    break;
                }
                case 98: 
                case 99: {
                    if (expr.imm[0] < 4) {
                        abcWriter.rewind(1);
                        abcWriter.write((expr.op == 98 ? 208 : 212) + expr.imm[0]);
                        break;
                    }
                }
                case 8: 
                case 108: 
                case 109: 
                case 146: 
                case 148: 
                case 194: 
                case 195: {
                    abcWriter.writeU30(expr.imm[0]);
                    break;
                }
                case 88: {
                    abcWriter.writeU30(abc.classId(expr.c));
                    break;
                }
                case 64: {
                    abcWriter.writeU30(abc.methodId(expr.m));
                    break;
                }
                case 68: {
                    abcWriter.writeU30(abc.methodId(expr.m));
                    abcWriter.writeU30(this.argc(expr));
                    break;
                }
                case 37: {
                    abcWriter.writeU30(this.intValue(expr.value));
                    break;
                }
                case 36: {
                    abcWriter.write(this.intValue(expr.value));
                    break;
                }
                case 101: {
                    abcWriter.write(expr.imm[0]);
                    break;
                }
                case 6: 
                case 44: {
                    abcWriter.writeU30(abc.stringPool.id((String)expr.value));
                    break;
                }
                case 241: {
                    throw new RuntimeException("impossible");
                }
                case 49: {
                    abcWriter.writeU30(abc.nsPool.id((Namespace)expr.value));
                    break;
                }
                case 45: {
                    abcWriter.writeU30(abc.intPool.id(this.intValue(expr.value)));
                    break;
                }
                case 46: {
                    abcWriter.writeU30(abc.uintPool.id(this.uintValue(expr.value)));
                    break;
                }
                case 47: {
                    abcWriter.writeU30(abc.doublePool.id(this.doubleValue(expr.value)));
                    break;
                }
                case 240: 
                case 242: {
                    throw new RuntimeException("impossible");
                }
                case 239: {
                    throw new RuntimeException("impossible");
                }
            }
        }
    }

    void emitCode(AbcWriter abcWriter, Abc abc, Method method) throws IOException {
        HashMap<Block, Integer> hashMap = new HashMap<Block, Integer>();
        Deque<Block> deque = this.schedule(method.entry.to);
        HashMap<Block, AbcWriter> hashMap2 = new HashMap<Block, AbcWriter>();
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        for (Block block : deque) {
            bitSet2.set(block.id);
            for (Edge object : block.succ()) {
                if (!bitSet2.get(object.to.id)) continue;
                bitSet.set(object.to.id);
            }
        }
        HashMap hashMap3 = new HashMap();
        int n = 0;
        ArrayDeque<Block> arrayDeque = new ArrayDeque<Block>((Collection<Block>)deque);
        while (!arrayDeque.isEmpty()) {
            Block block = (Block)arrayDeque.removeFirst();
            hashMap3.put(block, n);
            AbcWriter abcWriter2 = new AbcWriter();
            hashMap2.put(block, abcWriter2);
            if (bitSet.get(block.id)) {
                abcWriter2.write(9);
            }
            this.emitBlock(abcWriter2, block, abc);
            n += abcWriter2.size();
            Expr expr = block.last();
            if (expr.succ.length == 0) {
                abcWriter2.write(expr.op);
                ++n;
                continue;
            }
            if (this.isJump(expr)) {
                if (!arrayDeque.isEmpty() && expr.succ[0].to == arrayDeque.peekFirst()) continue;
                n += 4;
                hashMap.put(block, 4);
                continue;
            }
            if (this.isBranch(expr)) {
                if (arrayDeque.isEmpty() || expr.succ[0].to != arrayDeque.peekFirst()) {
                    n += 8;
                    hashMap.put(block, 8);
                    continue;
                }
                n += 4;
                hashMap.put(block, 4);
                continue;
            }
            assert (expr.op == 27);
            assert (false);
        }
        abcWriter.writeU30(n);
        int n2 = abcWriter.size();
        for (Block block : deque) {
            ((AbcWriter)hashMap2.get(block)).writeTo(abcWriter);
            if (!hashMap.containsKey(block)) continue;
            Expr expr = block.last();
            if (this.isBranch(expr)) {
                this.emitBranch(abcWriter, expr.op, expr.succ[1].to, n2, hashMap3);
                hashMap.put(block, (Integer)hashMap.get(block) - 4);
            }
            if ((Integer)hashMap.get(block) != 4) continue;
            this.emitBranch(abcWriter, 16, expr.succ[0].to, n2, hashMap3);
        }
        abcWriter.writeU30(method.handlers.length);
        for (Handler handler : method.handlers) {
            abcWriter.writeU30(0);
            abcWriter.writeU30(1);
            abcWriter.writeU30(0);
            abcWriter.writeU30(abc.typeRef(handler.type));
            abcWriter.writeU30(abc.namePool.id(handler.name));
        }
    }

    void emitBranch(AbcWriter abcWriter, int n, Block block, int n2, Map<Block, Integer> map) {
        abcWriter.write(n);
        int n3 = n2 + map.get(block);
        int n4 = abcWriter.size() + 3;
        abcWriter.writeS24(n3 - n4);
    }

    boolean defaultValueChanged(Binding binding) {
        return !binding.type.t.defaultValue.equals(binding.value);
    }

    void emitTraits(AbcWriter abcWriter, Abc abc, Type type) {
        Symtab<Binding> symtab = type.defs;
        abcWriter.writeU30(symtab.size());
        block5: for (Binding binding : symtab.values()) {
            abcWriter.writeU30(abc.namePool.id(binding.name));
            abcWriter.write(binding.flags_kind & 0xFFFFFFBF);
            switch (binding.kind()) {
                case 0: 
                case 6: {
                    abcWriter.writeU30(binding.slot);
                    abcWriter.writeU30(abc.typeRef(binding.type));
                    if (!this.defaultValueChanged(binding)) {
                        abcWriter.writeU30(0);
                        break;
                    }
                    int n = abc.constKind(binding.value);
                    int n2 = abc.constId(n, binding.value);
                    abcWriter.writeU30(n2);
                    if (n2 == 0) continue block5;
                    abcWriter.write(n);
                    break;
                }
                case 4: {
                    abcWriter.writeU30(binding.slot);
                    abcWriter.writeU30(abc.classId(binding.type.t));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    abcWriter.writeU30(binding.slot);
                    abcWriter.writeU30(abc.methodId(binding.method));
                    break;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
    }

    void optimize(Method method) {
        System.out.println("OPTIMIZE " + method.id + " " + method.name);
        System.out.println("BEFORE OPT");
        this.print(this.dfs(method.entry.to));
        this.sccp(method);
        this.dvn(method);
        if (this.cfgopt(method)) {
            System.out.println("AFTER CFGOPT");
            this.print(this.dfs(method.entry.to));
            this.sccp(method);
            this.dvn(method);
        }
        this.fold(method);
        System.out.println("AFTER FOLD");
        this.print(this.dfs(method.entry.to));
        this.insert_casts(method);
        this.remove_phi(method);
        this.printabc(this.schedule(method.entry.to));
        System.out.println();
    }

    void fold(Method method) {
        Deque<Block> deque = this.dfs(method.entry.to);
        EdgeMap<Expr> edgeMap = this.findUses(deque);
        for (Block block : deque) {
            for (Expr expr : block) {
                switch (expr.op) {
                    case 17: 
                    case 18: {
                        Expr expr2 = expr.args[0];
                        if (!this.containsOnly(edgeMap.get(expr2), expr)) break;
                        if (expr2.op == 150) {
                            this.subsume_arg(expr, expr.op == 17 ? 18 : 17, edgeMap);
                            break;
                        }
                        if (expr2.op == 118) {
                            this.subsume_arg(expr, expr.op, edgeMap);
                            break;
                        }
                        if (expr2.op == 176) {
                            this.subsume_arg(expr, expr.op == 17 ? 24 : 15, edgeMap);
                            break;
                        }
                        if (expr2.op == 175) {
                            this.subsume_arg(expr, expr.op == 17 ? 23 : 14, edgeMap);
                            break;
                        }
                        if (expr2.op == 173) {
                            this.subsume_arg(expr, expr.op == 17 ? 21 : 12, edgeMap);
                            break;
                        }
                        if (expr2.op == 174) {
                            this.subsume_arg(expr, expr.op == 17 ? 22 : 13, edgeMap);
                            break;
                        }
                        if (expr2.op != 172) break;
                        this.subsume_arg(expr, expr.op == 17 ? 25 : 26, edgeMap);
                        break;
                    }
                    case 102: {
                        Expr expr2 = expr.args[0];
                        if (!this.containsOnly(edgeMap.get(expr2), expr) || expr2.op != 93 || expr2.args.length != 0 || expr.args.length != 1) break;
                        expr.op = 96;
                        expr.args = noexprs;
                        expr.scopes = expr2.scopes;
                        expr2.setPure();
                        expr.flags |= expr2.flags & 8 | expr2.flags & 2;
                    }
                }
            }
        }
        this.dce(method);
    }

    SetMap<Block, Edge> preds(Deque<Block> deque) {
        SetMap<Block, Edge> setMap = new SetMap<Block, Edge>();
        for (Block block : deque) {
            for (Edge object : block.succ()) {
                setMap.get(object.to).add(object);
            }
        }
        block2: for (Block block : deque) {
            for (Expr expr : block) {
                if (expr.op != 10) continue block2;
                TreeSet<Edge> treeSet = new TreeSet<Edge>();
                for (Edge edge : expr.pred) {
                    treeSet.add(edge);
                }
                Set<Edge> set = setMap.get(block);
                assert (((Object)treeSet).equals(set));
            }
        }
        return setMap;
    }

    SetMap<Block, Edge> allpreds(Deque<Block> deque) {
        SetMap<Block, Edge> setMap = new SetMap<Block, Edge>();
        for (Block block : deque) {
            for (Edge edge : block.succ()) {
                setMap.get(edge.to).add(edge);
            }
            for (Edge edge : block.xsucc) {
                setMap.get(edge.to).add(edge);
            }
        }
        return setMap;
    }

    int findPhiArg(Expr expr, Edge edge) {
        int n = expr.pred.length;
        for (int i = 0; i < n; ++i) {
            if (!expr.pred[i].equals(edge)) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    boolean sameExScope(Block block, Block block2) {
        if (block == block2) {
            return true;
        }
        Edge[] edgeArray = block.xsucc;
        Edge[] edgeArray2 = block2.xsucc;
        if (edgeArray.length != edgeArray2.length) {
            return false;
        }
        int n = edgeArray.length;
        for (int i = 0; i < n; ++i) {
            Edge edge = edgeArray[i];
            Edge edge2 = edgeArray2[i];
            if (edge.to == edge2.to && edge.handler == edge2.handler) continue;
            return false;
        }
        return true;
    }

    boolean cfgopt(Method method) {
        boolean bl;
        Deque<Block> deque = this.dfs(method.entry.to);
        SetMap<Block, Edge> setMap = this.allpreds(deque);
        boolean bl2 = false;
        do {
            bl = false;
            block1: for (Block block : deque) {
                Block block2;
                Expr expr = block.last();
                if (this.isJump(expr) && this.sameExScope(block, block2 = expr.succ[0].to)) {
                    Edge edge = expr.succ[0];
                    if (this.containsOnly(setMap.get(block2), edge)) {
                        assert (block2.first().op != 10);
                        System.out.println("STRAIGHTEN " + edge);
                        block.remove(expr);
                        block.addAll(block2);
                        for (Edge edge2 : block2.succ()) {
                            edge2.from = block;
                        }
                        bl = true;
                        break;
                    }
                    Expr expr2 = block2.first();
                    if (expr2.op == 72 || expr2.op == 71) {
                        Expr[] exprArray;
                        System.out.println("PRUNE " + block + "->" + edge);
                        expr.op = expr2.op;
                        if (expr2.op == 71) {
                            exprArray = noexprs;
                        } else {
                            Expr[] exprArray2 = new Expr[1];
                            exprArray = exprArray2;
                            exprArray2[0] = expr2.args[0];
                        }
                        expr.args = exprArray;
                        expr.succ = noedges;
                        bl = true;
                        break;
                    }
                    if (expr2.op == 10 && block2.size() == 2) {
                        Expr expr3 = block2.last();
                        if (expr3.op == 72 && expr3.args[0] == expr2) {
                            System.out.println("PRUNE " + block + "->" + edge);
                            int n = this.findPhiArg(expr2, expr.succ[0]);
                            expr.op = expr3.op;
                            expr.args = new Expr[]{expr2.args[n]};
                            expr.succ = noedges;
                            expr2.remove(n);
                            bl = true;
                            break;
                        }
                    }
                }
                if (this.isBranch(expr)) {
                    Edge edge = expr.succ[1];
                    Expr expr4 = expr.args[0];
                    block2 = edge.to;
                    if (expr.args.length == 1 && block2.size() == 2) {
                        Expr expr5 = block2.first();
                        if (expr5.op == 10) {
                            int n;
                            Expr expr6 = block2.last();
                            if ((expr6.op == 17 || expr6.op == 18) && expr5.args[n = this.findPhiArg(expr5, edge)] == expr4) {
                                Edge edge3 = expr6.op == expr.op ? expr6.succ[1] : expr6.succ[0];
                                System.out.println("SKIPTEST old " + edge + " new " + edge3);
                                expr5.remove(n);
                                this.copyTargetPhi(expr5, expr4, edge3, edge);
                                bl = true;
                                break;
                            }
                        }
                    }
                    if (setMap.get(expr.succ[0].to).size() > 1 && setMap.get(block2).size() == 1) {
                        this.invert(expr);
                        bl = true;
                        break;
                    }
                }
                for (Edge edge : expr.succ) {
                    if (!this.skip(edge)) continue;
                    bl = true;
                    break block1;
                }
                if (!this.skip(method.entry)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            this.dce(method);
            deque = this.dfs(method.entry.to);
            setMap = this.allpreds(deque);
            bl2 = true;
        } while (bl);
        return bl2;
    }

    boolean skip(Edge edge) {
        Block block = edge.to;
        Expr expr = block.last();
        if (block.size() == 1 && this.isJump(expr)) {
            System.out.println("SKIP " + expr.succ[0]);
            this.copyTarget(expr.succ[0], edge);
            return true;
        }
        return false;
    }

    void invert(Expr expr) {
        System.out.println("INVERT " + expr);
        switch (expr.op) {
            case 17: {
                expr.op = 18;
                break;
            }
            case 18: {
                expr.op = 17;
                break;
            }
            case 12: {
                expr.op = 21;
                break;
            }
            case 13: {
                expr.op = 22;
                break;
            }
            case 14: {
                expr.op = 23;
                break;
            }
            case 15: {
                expr.op = 24;
                break;
            }
            case 19: {
                expr.op = 20;
                break;
            }
            case 20: {
                expr.op = 19;
                break;
            }
            case 21: {
                expr.op = 12;
                break;
            }
            case 22: {
                expr.op = 13;
                break;
            }
            case 23: {
                expr.op = 14;
                break;
            }
            case 24: {
                expr.op = 15;
                break;
            }
            case 25: {
                expr.op = 26;
                break;
            }
            case 26: {
                expr.op = 25;
            }
        }
        Edge edge = expr.succ[0];
        Edge edge2 = expr.succ[1];
        edge.label = 1;
        edge2.label = 0;
        expr.succ[0] = edge2;
        expr.succ[1] = edge;
    }

    int ifoper(int n) {
        switch (n) {
            default: {
                assert (false);
                return 0;
            }
            case 12: 
            case 21: {
                return 173;
            }
            case 13: 
            case 22: {
                return 174;
            }
            case 14: 
            case 23: {
                return 175;
            }
            case 15: 
            case 24: {
                return 176;
            }
            case 19: 
            case 20: {
                return 171;
            }
            case 25: 
            case 26: 
        }
        return 172;
    }

    void copyTarget(Edge edge, Edge edge2) {
        edge2.to = edge.to;
        for (Expr expr : edge.to) {
            if (expr.op != 10) continue;
            expr.append(expr.args[this.findPhiArg(expr, edge)], edge2);
        }
    }

    void copyTargetPhi(Expr expr, Expr expr2, Edge edge, Edge edge2) {
        edge2.to = edge.to;
        for (Expr expr3 : edge.to) {
            if (expr3.op != 10) break;
            Expr expr4 = expr3.args[this.findPhiArg(expr3, edge)];
            expr3.append(expr4 == expr ? expr2 : expr4, edge2);
        }
    }

    boolean containsOnly(Collection collection, Object object) {
        return collection.size() == 1 && collection.contains(object);
    }

    boolean equiv(Name name, Name name2) {
        return GlobalOptimizer.match(name, name2) == 0;
    }

    boolean equiv(Expr[] exprArray, Expr[] exprArray2) {
        if (exprArray == null || exprArray2 == null) {
            return false;
        }
        if (exprArray.length != exprArray2.length) {
            return false;
        }
        for (int i = 0; i < exprArray.length; ++i) {
            if (this.equiv(exprArray[i], exprArray2[i])) continue;
            return false;
        }
        return true;
    }

    boolean equiv(Expr expr, Expr expr2) {
        if (expr == expr2) {
            return true;
        }
        if (expr != null && expr2 != null && expr.op == expr2.op) {
            switch (expr.op) {
                case 32: 
                case 33: 
                case 38: 
                case 39: 
                case 40: 
                case 208: 
                case 209: 
                case 210: 
                case 211: {
                    return true;
                }
                case 36: 
                case 37: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: {
                    return expr.value.equals(expr2.value);
                }
                case 0: 
                case 98: {
                    return expr.imm[0] == expr2.imm[0];
                }
                case 100: {
                    return expr.scopes.length == 0 && expr2.scopes.length == 0 || expr.scopes.length > 0 && expr2.scopes.length > 0 && this.equiv(expr.scopes[0], expr2.scopes[0]);
                }
                case 95: {
                    return this.equiv(expr.ref, expr2.ref);
                }
            }
        }
        return false;
    }

    void makeCopy(Expr expr, Expr expr2) {
        assert (expr != expr2);
        expr.op = 42;
        expr.locals = new Expr[]{expr2};
        expr.args = noexprs;
        expr.scopes = noexprs;
        expr.setPure();
    }

    void makeNop(Expr expr) {
        expr.op = 2;
        expr.scopes = noexprs;
        expr.locals = noexprs;
        expr.args = expr.locals;
        expr.setPure();
    }

    Expr dvn_find(Expr expr, Block block, Map<Block, Block> map) {
        do {
            for (Expr expr2 : block) {
                if (expr2 == expr) break;
                if (!this.equiv(expr2, expr)) continue;
                return expr2;
            }
        } while ((block = map.get(block)) != null);
        return null;
    }

    void dvn(Method method) {
        boolean bl;
        Deque<Block> deque = this.dfs(method.entry.to);
        Map<Block, Block> map = this.idoms(deque, this.preds(deque));
        do {
            bl = false;
            for (Block block : deque) {
                for (Expr expr : block) {
                    Expr expr2 = this.dvn_find(expr, block, map);
                    if (expr2 == null) continue;
                    this.makeCopy(expr, expr2);
                    bl = true;
                }
            }
            if (!bl) continue;
            this.dce(method);
        } while (bl);
    }

    boolean constify(Expr expr, Object object) {
        if (object != null && object != BOTTOM && expr.value == null && !this.hasSideEffect(expr)) {
            if (object instanceof Integer) {
                int n = this.intValue(object);
                expr.op = n == (byte)n ? 36 : (n == (short)n ? 37 : 45);
            } else if (object instanceof Long) {
                expr.op = 46;
            } else if (object instanceof Number) {
                double d = this.doubleValue(object);
                expr.op = Double.isNaN(d) ? 40 : 47;
            } else if (object instanceof Boolean) {
                expr.op = object == Boolean.TRUE ? 38 : 39;
            } else if (object == UNDEFINED) {
                expr.op = 33;
            } else if (object == this.NULL) {
                assert (!expr.onScope());
                expr.op = 32;
            } else {
                assert (object instanceof String);
                expr.op = 44;
            }
            expr.pred = noedges;
            expr.locals = noexprs;
            expr.scopes = noexprs;
            expr.args = expr.scopes;
            expr.value = object;
            return true;
        }
        return false;
    }

    boolean jumpify(Expr expr, Set<Edge> set) {
        Edge edge = null;
        for (Edge edge2 : expr.succ) {
            if (!set.contains(edge2)) continue;
            if (edge == null) {
                edge = edge2;
                continue;
            }
            if (edge2 == edge) continue;
            edge = null;
            break;
        }
        if (edge != null) {
            expr.op = 16;
            expr.args = noexprs;
            expr.succ = new Edge[]{edge};
            return true;
        }
        return false;
    }

    boolean makeConvert(Expr expr, Type type, int n, Map<Expr, Typeref> map) {
        expr.op = n;
        expr.args = new Expr[]{expr.args[1]};
        expr.flags = flagTable[n];
        if (this.type(map, (Expr)expr.args[0]).primitive) {
            expr.setPure();
        }
        return true;
    }

    boolean convertify(Expr expr, Binding binding, Map<Expr, Typeref> map) {
        if (binding.type != null && expr.args.length == 2) {
            if (binding.type.t.itype == this.NUMBER) {
                return this.makeConvert(expr, this.NUMBER, 117, map);
            }
            if (binding.type.t.itype == this.INT) {
                return this.makeConvert(expr, this.INT, 115, map);
            }
            if (binding.type.t.itype == this.UINT) {
                return this.makeConvert(expr, this.UINT, 116, map);
            }
            if (binding.type.t.itype == this.STRING) {
                return this.makeConvert(expr, this.STRING, 112, map);
            }
            if (binding.type.t.itype == this.BOOLEAN) {
                return this.makeConvert(expr, this.BOOLEAN, 118, map);
            }
        }
        return false;
    }

    Expr unwrapScope(Expr expr, int n) {
        assert (expr.scopes[n].onScope());
        return expr.scopes[n].args[0];
    }

    static Type[] copyOf(Type[] typeArray, int n) {
        Type[] typeArray2 = new Type[n];
        if (n > typeArray.length) {
            n = typeArray.length;
        }
        System.arraycopy(typeArray, 0, typeArray2, 0, n);
        return typeArray2;
    }

    static Typeref[] copyOf(Typeref[] typerefArray, int n) {
        Typeref[] typerefArray2 = new Typeref[n];
        if (n > typerefArray.length) {
            n = typerefArray.length;
        }
        System.arraycopy(typerefArray, 0, typerefArray2, 0, n);
        return typerefArray2;
    }

    static Expr[] copyOf(Expr[] exprArray, int n) {
        Expr[] exprArray2 = new Expr[n];
        if (n > exprArray.length) {
            n = exprArray.length;
        }
        System.arraycopy(exprArray, 0, exprArray2, 0, n);
        return exprArray2;
    }

    static Edge[] copyOf(Edge[] edgeArray, int n) {
        Edge[] edgeArray2 = new Edge[n];
        if (n > edgeArray.length) {
            n = edgeArray.length;
        }
        System.arraycopy(edgeArray, 0, edgeArray2, 0, n);
        return edgeArray2;
    }

    void sccp(Method method) {
        Deque<Block> deque = this.dfs(method.entry.to);
        EdgeMap<Expr> edgeMap = this.findUses(deque);
        TreeMap<Expr, Object> treeMap = new TreeMap<Expr, Object>();
        TreeMap<Expr, Typeref> treeMap2 = new TreeMap<Expr, Typeref>();
        TreeSet<Edge> treeSet = new TreeSet<Edge>();
        this.sccp_analyze(method, edgeMap, treeMap, treeMap2, treeSet);
        System.out.println("REACHED " + treeSet);
        System.out.println("TYPES " + treeMap2);
        this.sccp_cfgopt(treeMap, treeMap2, treeSet);
        this.dce(method);
        deque = this.dfs(method.entry.to);
        edgeMap = this.findUses(deque);
        WorkSet<Expr> workSet = new WorkSet<Expr>();
        for (Block block : deque) {
            for (Expr expr : block) {
                workSet.add(expr);
            }
        }
        while (!workSet.isEmpty()) {
            Expr expr = this.remove((Set<Expr>)workSet);
            this.sccp_modify(method, edgeMap, treeMap, treeMap2, expr, workSet);
        }
        this.dce(method);
    }

    void sccp_cfgopt(Map<Expr, Object> map, Map<Expr, Typeref> map2, Set<Edge> set) {
        WorkSet<Block> workSet = new WorkSet<Block>();
        for (Edge comparable : set) {
            workSet.add(comparable.to);
        }
        for (Block block : workSet) {
            for (Expr expr : block) {
                int n;
                if (expr.op == 10) {
                    for (n = expr.pred.length - 1; n >= 0; --n) {
                        Edge edge = expr.pred[n];
                        if (set.contains(edge)) continue;
                        expr.remove(n);
                    }
                    continue;
                }
                if (expr.succ != null) {
                    if (expr.succ.length <= 1 || this.jumpify(expr, set) || expr.op != 27 || block.size() != 2) continue;
                    Expr expr2 = block.first();
                    if (expr2.op != 10 || expr.args[0] != expr2) continue;
                    for (int i = expr2.args.length - 1; i >= 0; --i) {
                        Object object = map.get(expr2.args[i]);
                        if (!(object instanceof Number)) continue;
                        int n2 = this.intValue(object);
                        Comparable<Expr> comparable = expr2.pred[i];
                        Edge edge = expr.succ[n2];
                        this.copyTarget(edge, (Edge)comparable);
                        expr2.remove(i);
                    }
                    continue;
                }
                if (!expr.isOper() || !expr.onStack()) continue;
                n = 1;
                for (Comparable<Expr> comparable : expr.args) {
                    if (this.type(map2, (Expr)comparable).primitive) continue;
                    n = 0;
                }
                for (Comparable<Expr> comparable : expr.locals) {
                    if (this.type(map2, (Expr)comparable).primitive) continue;
                    n = 0;
                }
                if (n != 0) {
                    expr.setPure();
                }
                this.constify(expr, map.get(expr));
            }
        }
    }

    boolean subsume_arg(Expr expr, int n, EdgeMap<Expr> edgeMap) {
        expr.op = n;
        Expr expr2 = expr.args[0];
        expr.flags |= expr2.flags & 0xA;
        expr2.setPure();
        edgeMap.get(expr2).remove(expr);
        for (Expr expr3 : expr.args = GlobalOptimizer.copyOf(expr2.args, expr2.args.length)) {
            edgeMap.get(expr3).add(expr);
        }
        return true;
    }

    boolean canEarlyBind(Method method, Binding binding) {
        return binding.slot != 0 && method.abc == binding.abc;
    }

    void sccp_modify(Method method, EdgeMap<Expr> edgeMap, Map<Expr, Object> map, Map<Expr, Typeref> map2, Expr expr, WorkSet<Expr> workSet) {
        boolean bl;
        this.sccp_rename(edgeMap, expr, expr.args);
        this.sccp_rename(edgeMap, expr, expr.locals);
        do {
            bl = false;
            switch (expr.op) {
                case 88: {
                    Type type = expr.c;
                    type.scopes = GlobalOptimizer.copyOf(method.cx.scopes, method.cx.scopes.length + expr.scopes.length);
                    int n = method.cx.scopes.length;
                    for (Expr expr2 : expr.scopes) {
                        type.scopes[n++] = map2.get(expr2);
                    }
                    this.readyType(type);
                    Type n2 = type.itype;
                    n2.scopes = GlobalOptimizer.copyOf(type.scopes, type.scopes.length + 1);
                    n2.scopes[type.scopes.length] = type.ref.nonnull();
                    this.readyType(n2);
                    break;
                }
                case 64: {
                    Method method2 = expr.m;
                    Type type = new Type(method.name, this.FUNCTION);
                    type.scopes = GlobalOptimizer.copyOf(method.cx.scopes, method.cx.scopes.length + expr.scopes.length);
                    int typeref2 = method.cx.scopes.length;
                    for (Expr expr3 : expr.scopes) {
                        type.scopes[++var10_39] = map2.get(expr3);
                    }
                    method2.cx = type;
                    this.readyMethod(method2);
                    break;
                }
                case 72: {
                    if (this.type(map2, expr.args[0]) == this.VOID) {
                        expr.op = 71;
                        expr.args = noexprs;
                        break;
                    }
                    Type type = this.type(map2, expr.args[0]);
                    if (!this.istype(type, method.returns.t)) break;
                    Expr expr4 = expr.args[0];
                    if (method.returns.t != this.INT || expr4.op != 115) break;
                    edgeMap.get(expr4).remove(expr);
                    expr4 = expr.args[0] = expr4.args[0];
                    edgeMap.get(expr4).add(expr);
                    break;
                }
                case 100: {
                    if (method.cx.scopes.length != 0) break;
                    this.makeCopy(expr, this.unwrapScope(expr, 0));
                    bl = true;
                    break;
                }
                case 101: {
                    this.makeCopy(expr, this.unwrapScope(expr, 0));
                    bl = true;
                    break;
                }
                case 179: {
                    Type type = this.type(map2, expr.args[1]);
                    if (type.itype == null || !this.namedTypes.contains(type.itype.name)) break;
                    expr.op = 178;
                    expr.ref = type.itype.name;
                    expr.args = new Expr[]{expr.args[0]};
                    expr.clearPx();
                    bl = true;
                    break;
                }
                case 178: {
                    if (!this.namedTypes.contains(expr.ref)) break;
                    expr.clearPx();
                    break;
                }
                case 28: 
                case 48: {
                    if (map2.get((Object)expr.args[0]).nullable) break;
                    expr.clearPx();
                    break;
                }
                case 128: {
                    Expr expr5 = expr.args[0];
                    Typeref typeref = map2.get(expr);
                    Typeref typeref2 = map2.get(expr5);
                    if (typeref == typeref2) {
                        this.makeCopy(expr, expr5);
                        bl = true;
                        break;
                    }
                    Object object = map.get(expr5);
                    if (object == this.NULL && typeref2.nullable && typeref2.t != this.VOID) {
                        this.makeCopy(expr, expr5);
                        bl = true;
                        break;
                    }
                    if (this.namedTypes.get(expr.ref) != this.OBJECT) break;
                    expr.op = 137;
                    expr.clearEffect();
                    expr.ref = null;
                    expr.imm = null;
                    bl = true;
                    break;
                }
                case 93: 
                case 94: {
                    n = this.findInner(expr.ref, expr.scopes, map2);
                    if (n >= 0) {
                        this.makeCopy(expr, this.unwrapScope(expr, n));
                        for (Expr expr8 : expr.scopes) {
                            edgeMap.get(expr8).remove(expr);
                        }
                        bl = true;
                        break;
                    }
                    n = this.findOuter(expr.ref, method.cx.scopes);
                    if (n >= 0) {
                        if (n == 0) {
                            expr.op = 100;
                            expr.scopes = noexprs;
                            expr.setPure();
                            for (Expr expr9 : expr.scopes) {
                                edgeMap.get(expr9).remove(expr);
                            }
                            bl = true;
                            break;
                        }
                        expr.setPure();
                        break;
                    }
                    if (this.globals.contains(expr.ref)) {
                        expr.op = 95;
                        expr.flags = flagTable[expr.op];
                        expr.scopes = noexprs;
                        expr.ref = this.globals.getName(expr.ref);
                        for (Expr expr10 : expr.scopes) {
                            edgeMap.get(expr10).remove(expr);
                        }
                        bl = true;
                        break;
                    }
                    if (expr.op != 94) break;
                    if (method.cx.scopes.length == 0) {
                        this.makeCopy(expr, this.unwrapScope(expr, 0));
                        for (Expr expr4 : expr.scopes) {
                            edgeMap.get(expr4).remove(expr);
                        }
                        bl = true;
                        break;
                    }
                    expr.op = 100;
                    for (Expr expr5 : expr.scopes) {
                        edgeMap.get(expr5).remove(expr);
                    }
                    expr.scopes = noexprs;
                    expr.setPure();
                    bl = true;
                    break;
                }
                case 4: 
                case 102: {
                    Typeref typeref = map2.get(expr.args[0]);
                    Binding binding = typeref.find(expr.ref);
                    if (GlobalOptimizer.isSlot(binding)) {
                        expr.clearEffect();
                        if (!typeref.nullable) {
                            expr.clearPx();
                        }
                        expr.ref = binding.name;
                        if (!this.canEarlyBind(method, binding) || GlobalOptimizer.isConst(binding) && this.constify(expr, map.get(expr))) break;
                        expr.op = 108;
                        expr.imm = new int[]{binding.slot};
                        bl = true;
                        break;
                    }
                    if (binding == null) break;
                    expr.ref = binding.name;
                    break;
                }
                case 104: {
                    Type type = this.type(map2, expr.args[0]);
                    Object object = map.get(expr.args[1]);
                    Binding object2 = type.find(expr.ref);
                    if (object2 == null) break;
                    expr.ref = object2.name;
                    if (!GlobalOptimizer.isConst(object2)) break;
                    if (object2.value != null && object2.value.equals(object)) {
                        this.makeNop(expr);
                        for (Expr expr3 : expr.args) {
                            edgeMap.get(expr3).remove(expr);
                        }
                        break;
                    }
                    if (!this.canEarlyBind(method, object2)) break;
                    expr.op = 109;
                    expr.imm = new int[]{object2.slot};
                    bl = true;
                    break;
                }
                case 5: 
                case 97: {
                    Type type = this.type(map2, expr.args[0]);
                    Binding binding = type.find(expr.ref);
                    if (GlobalOptimizer.isSlot(binding)) {
                        expr.ref = binding.name;
                        if (!this.canEarlyBind(method, binding)) break;
                        expr.op = 109;
                        expr.imm = new int[]{binding.slot};
                        bl = true;
                        break;
                    }
                    if (binding == null) break;
                    expr.ref = binding.name;
                    break;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 79: {
                    Type type = this.type(map2, expr.args[0]);
                    Binding binding = type.find(expr.ref);
                    if (binding != null) {
                        expr.ref = binding.name;
                        if (expr.op == 70 && this.isMethod(binding)) {
                            if (type.primitive && expr.args.length == 1 && expr.ref.equals(AS3_TOSTRING) && this.type(map2, expr) == this.STRING) {
                                expr.op = 112;
                                expr.setPure();
                                bl = true;
                            } else if (this.canEarlyBind(method, binding) && (type.isFinal() || binding.isFinal())) {
                                expr.op = 68;
                                expr.m = binding.method;
                                bl = true;
                            }
                        } else if (expr.op == 70 && GlobalOptimizer.isClass(binding)) {
                            bl |= this.convertify(expr, binding, map2);
                        }
                    }
                    if (!edgeMap.get(expr).isEmpty()) break;
                    if (expr.op == 69) {
                        expr.op = 78;
                    }
                    if (expr.op != 70) break;
                    expr.op = 79;
                    break;
                }
                case 116: {
                    if (expr.args[0].op == 115) {
                        expr.args[0] = expr.args[0].args[0];
                    }
                }
                case 112: 
                case 115: 
                case 117: 
                case 118: 
                case 130: 
                case 133: 
                case 137: {
                    Expr expr11 = expr.args[0];
                    Type type = this.type(map2, expr);
                    Type type2 = this.type(map2, expr.args[0]);
                    if (type == type2) {
                        this.makeCopy(expr, expr.args[0]);
                        bl = true;
                        break;
                    }
                    if (expr.op != 115 || expr11.op != 144 || this.type(map2, expr11.args[0]) != this.INT) break;
                    expr.op = 196;
                    expr.args = new Expr[]{expr11.args[0]};
                    bl = true;
                    break;
                }
                case 161: {
                    Object object = map.get(expr.args[1]);
                    if (this.doubleValue(object) == 1.0) {
                        expr.args = new Expr[]{expr.args[0]};
                        expr.op = 147;
                        bl = true;
                        break;
                    }
                    if (this.doubleValue(object) != -1.0) break;
                    expr.args = new Expr[]{expr.args[0]};
                    expr.op = 145;
                    bl = true;
                    break;
                }
                case 160: {
                    Type type = this.type(map2, expr);
                    Object object = map.get(expr.args[0]);
                    Object object2 = map.get(expr.args[1]);
                    if (type.numeric) {
                        if (this.doubleValue(object) == 1.0) {
                            expr.args = new Expr[]{expr.args[1]};
                            expr.op = 145;
                            bl = true;
                            break;
                        }
                        if (this.doubleValue(object2) == 1.0) {
                            expr.args = new Expr[]{expr.args[0]};
                            expr.op = 145;
                            bl = true;
                            break;
                        }
                        if (this.doubleValue(object) == -1.0) {
                            expr.args = new Expr[]{expr.args[1]};
                            expr.op = 147;
                            bl = true;
                            break;
                        }
                        if (this.doubleValue(object2) != -1.0) break;
                        expr.args = new Expr[]{expr.args[0]};
                        expr.op = 147;
                        bl = true;
                        break;
                    }
                    if (type != this.STRING) break;
                    if ("".equals(object)) {
                        expr.args = new Expr[]{expr.args[1]};
                        expr.op = 112;
                        bl = true;
                        break;
                    }
                    if (!"".equals(object2)) break;
                    expr.args = new Expr[]{expr.args[0]};
                    expr.op = 112;
                    bl = true;
                }
            }
            if (!bl) continue;
            workSet.addAll(edgeMap.get(expr));
        } while (bl);
    }

    void sccp_rename(EdgeMap<Expr> edgeMap, Expr expr, Expr[] exprArray) {
        for (int i = exprArray.length - 1; i >= 0; --i) {
            Expr expr2 = exprArray[i];
            if (expr2.op != 42) continue;
            edgeMap.get(expr2).remove(expr);
            expr2 = exprArray[i] = expr2.locals[0];
            edgeMap.get(expr2).add(expr);
        }
    }

    Map<Expr, Typeref> verify_types(Method method, Deque<Block> deque, Map<Block, Block> map) {
        Object object;
        EdgeMap<Expr> edgeMap = this.findUses(deque);
        TreeMap<Expr, Typeref> treeMap = new TreeMap<Expr, Typeref>();
        WorkSet<Expr> workSet = new WorkSet<Expr>();
        Object object2 = deque.iterator();
        while (object2.hasNext()) {
            object = (Block)object2.next();
            workSet.addAll(((Block)object).exprs);
        }
        do {
            if (!((Expr)(object2 = this.remove((Set<Expr>)workSet))).onStack() && !((Expr)object2).inLocal() && !((Expr)object2).onScope() && ((Expr)object2).op != 10 || ((Typeref)(object = this.verify_eval(method, (Expr)object2, treeMap, map))).equals(treeMap.get(object2))) continue;
            treeMap.put((Expr)object2, (Typeref)object);
            workSet.addAll(edgeMap.get((Expr)object2));
        } while (!workSet.isEmpty());
        return treeMap;
    }

    void sccp_analyze(Method method, EdgeMap<Expr> edgeMap, Map<Expr, Object> map, Map<Expr, Typeref> map2, Set<Edge> set) {
        WorkSet<Edge> workSet = new WorkSet<Edge>();
        WorkSet<Expr> workSet2 = new WorkSet<Expr>();
        WorkSet<Expr> workSet3 = new WorkSet<Expr>();
        workSet.add(method.entry);
        block0: while (true) {
            Comparable<Edge> comparable;
            if (!workSet.isEmpty()) {
                comparable = this.remove((Set<Edge>)workSet);
                if (set.contains(comparable)) continue;
                set.add((Edge)comparable);
                Block block = comparable.to;
                workSet3.addAll(block.exprs);
                workSet2.addAll(block.exprs);
                Edge[] edgeArray = block.xsucc;
                int n = edgeArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    Edge edge = edgeArray[n2];
                    workSet.add(edge);
                    ++n2;
                }
            }
            while (!workSet2.isEmpty()) {
                comparable = this.remove((Set<Expr>)workSet2);
                if (!workSet3.contains(comparable)) continue;
                this.sccp_eval(method, (Expr)comparable, map, map2, workSet, workSet2, edgeMap);
            }
            if (workSet.isEmpty()) break;
        }
    }

    boolean isCopy(Expr expr, Map<Expr, Type> map, Set<Expr> set) {
        Type type;
        Type type2 = map.get(expr);
        return type2 == (type = map.get(expr.args[0])) || this.isUpcast(expr, map) && !set.contains(expr);
    }

    boolean isUpcast(Expr expr, Map<Expr, Type> map) {
        if (expr.isCoerce()) {
            Type type = map.get(expr.args[0]);
            Type type2 = map.get(expr);
            return type2 != type && this.istype(type, type2);
        }
        return false;
    }

    void insert_casts(Method method) {
        Deque<Block> deque = this.dfs(method.entry.to);
        SetMap<Block, Edge> setMap = this.preds(deque);
        Map<Block, Block> map = this.idoms(deque, setMap);
        Map<Expr, Typeref> map2 = this.verify_types(method, deque, map);
        block0: for (Block block : deque) {
            for (Expr expr : block) {
                if (expr.op != 10) continue block0;
                Typeref typeref = map2.get(expr);
                for (int i = expr.args.length - 1; i >= 0; --i) {
                    Expr expr2 = expr.args[i];
                    Edge edge = expr.pred[i];
                    Typeref typeref2 = map2.get(expr2);
                    if (!(this.isLoop(edge, map) ? !typeref.equals(typeref2) : this.isAtom(typeref.t) != this.isAtom(typeref2.t))) continue;
                    System.out.println("MISSING CAST " + expr2 + " " + typeref2 + "->" + typeref + " on " + edge);
                    if (this.isCritical(edge, setMap)) {
                        this.split(edge, method, setMap);
                        edge = expr.pred[i];
                    }
                    Expr expr3 = this.upcast(expr2, method, typeref.t);
                    this.append(edge, expr3);
                    expr.args[i] = expr3;
                }
            }
        }
        System.out.println("VERIFY TYPES " + map2);
    }

    Expr upcast(Expr expr, Method method, Type type) {
        if (type == this.ANY) {
            return new Expr(method, 130, expr);
        }
        if (type == this.OBJECT) {
            return new Expr(method, 137, expr);
        }
        return new Expr(method, 128, type.name, expr);
    }

    boolean isAtom(Type type) {
        return type.atom;
    }

    boolean isPointer(Type type) {
        return !this.isAtom(type) && !type.numeric;
    }

    Object eval_convert_i(Object object) {
        return object instanceof Number ? Integer.valueOf(this.intValue(object)) : (object == Boolean.TRUE ? Integer.valueOf(1) : (object == Boolean.FALSE ? Integer.valueOf(0) : BOTTOM));
    }

    Object eval_convert_u(Object object) {
        return object instanceof Number ? Long.valueOf(this.uintValue(object)) : (object == Boolean.TRUE ? Integer.valueOf(1) : (object == Boolean.FALSE ? Integer.valueOf(0) : BOTTOM));
    }

    Object eval_convert_d(Object object) {
        return object instanceof Number ? Double.valueOf(this.doubleValue(object)) : (object == Boolean.TRUE ? Integer.valueOf(1) : (object == Boolean.FALSE ? Integer.valueOf(0) : BOTTOM));
    }

    Object eval_convert_b(Object object) {
        return object == BOTTOM ? BOTTOM : (this.booleanValue(object) ? Boolean.TRUE : Boolean.FALSE);
    }

    Object eval_convert_s(Object object) {
        return object != BOTTOM ? this.stringValue(object) : BOTTOM;
    }

    Typeref eval_coerce_s(Typeref typeref) {
        if (typeref.nullable) {
            return typeref.t == this.VOID || typeref.t == this.NULL ? this.NULL.ref : this.STRING.ref;
        }
        return this.STRING.ref.nonnull();
    }

    Object eval_coerce_s(Object object) {
        return object == UNDEFINED || object == this.NULL ? this.NULL : (object != BOTTOM ? this.stringValue(object) : BOTTOM);
    }

    Typeref eval_coerce_o(Typeref typeref) {
        if (typeref.nullable) {
            return this.istype(typeref.t, this.OBJECT) ? typeref : (typeref.t == this.VOID || typeref.t == this.NULL ? this.NULL.ref : this.OBJECT.ref);
        }
        return this.istype(typeref.t, this.OBJECT) ? typeref : this.OBJECT.ref.nonnull();
    }

    Object eval_coerce_o(Object object, Type type) {
        return this.istype(type, this.OBJECT) ? object : (type == this.VOID || type == this.NULL ? this.NULL : BOTTOM);
    }

    boolean lessthan(Object object, Object object2) {
        if (object instanceof String && object2 instanceof String) {
            return ((String)object).compareTo((String)object2) < 0;
        }
        return this.doubleValue(object) < this.doubleValue(object2);
    }

    Type type(Map<Expr, Typeref> map, Expr expr) {
        return map.get((Object)expr).t;
    }

    boolean nullable(Expr expr, Map<Expr, Typeref> map) {
        return map.get((Object)expr).nullable;
    }

    /*
     * WARNING - void declaration
     */
    void sccp_eval(Method method, Expr expr, Map<Expr, Object> map, Map<Expr, Typeref> map2, Set<Edge> set, Set<Expr> set2, EdgeMap<Expr> edgeMap) {
        Object object = null;
        Object object2 = null;
        if (expr.op == 10) {
            for (Expr expr2 : expr.args) {
                Object object3 = map.get(expr2);
                if (object3 == null) continue;
                if (object == null) {
                    object = object3;
                } else if (!object3.equals(object)) {
                    object = BOTTOM;
                }
                Typeref typeref = map2.get(expr2);
                if (object2 == null) {
                    object2 = typeref;
                    continue;
                }
                if (((Typeref)object2).equals(typeref)) continue;
                object2 = this.mdb((Typeref)object2, typeref);
            }
        } else {
            for (Expr object4 : expr.args) {
                if (map.containsKey(object4)) continue;
                return;
            }
            for (Expr expr2 : expr.scopes) {
                if (map.containsKey(expr2)) continue;
                return;
            }
            for (Expr expr3 : expr.locals) {
                if (map.containsKey(expr3)) continue;
                return;
            }
            object = BOTTOM;
            object2 = this.ANY.ref;
            switch (expr.op) {
                default: {
                    assert (false);
                }
                case 30: 
                case 35: 
                case 52: 
                case 65: 
                case 69: {
                    break;
                }
                case 119: {
                    object2 = map2.get(expr.args[0]).nonnull();
                    object = map.get(expr.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    object2 = this.STRING.ref.nonnull();
                    break;
                }
                case 90: {
                    object2 = method.handlers[expr.imm[0]].activation;
                    break;
                }
                case 85: {
                    object2 = this.OBJECT.ref.nonnull();
                    break;
                }
                case 86: {
                    object2 = this.ARRAY.ref.nonnull();
                    break;
                }
                case 87: {
                    object2 = method.activation;
                    break;
                }
                case 100: {
                    if (method.cx.scopes.length > 0) {
                        object2 = method.cx.scopes[0];
                        break;
                    }
                    object = map.get(expr.scopes[0].args[0]);
                    object2 = map2.get(expr.scopes[0].args[0]);
                    break;
                }
                case 101: {
                    object = map.get(expr.scopes[0].args[0]);
                    object2 = map2.get(expr.scopes[0].args[0]);
                    break;
                }
                case 88: {
                    object2 = expr.c.ref.nonnull();
                    break;
                }
                case 64: {
                    object2 = this.FUNCTION.ref.nonnull();
                    break;
                }
                case 95: {
                    if (this.globals.contains(expr.ref)) {
                        object2 = this.globals.get(expr.ref);
                    }
                    break;
                }
                case 93: 
                case 94: {
                    int n = this.findInner(expr.ref, expr.scopes, map2);
                    if (n >= 0) {
                        object = map.get(expr.scopes[n]);
                        object2 = map2.get(expr.scopes[n]);
                        break;
                    }
                    n = this.findOuter(expr.ref, method.cx.scopes);
                    if (n >= 0) {
                        object2 = method.cx.scopes[n];
                        break;
                    }
                    if (this.globals.contains(expr.ref)) {
                        object2 = this.globals.get(expr.ref);
                        break;
                    }
                    if (method.cx.scopes.length > 0) {
                        object2 = method.cx.scopes[0];
                        break;
                    }
                    object = map.get(expr.scopes[0]);
                    object2 = map2.get(expr.scopes[0]);
                    break;
                }
                case 96: {
                    int n = this.findInner(expr.ref, expr.scopes, map2);
                    Typeref typeref = n >= 0 ? map2.get(expr.scopes[n]) : ((n = this.findOuter(expr.ref, method.cx.scopes)) >= 0 ? method.cx.scopes[n] : (this.globals.contains(expr.ref) ? this.globals.get(expr.ref) : (method.cx.scopes.length > 0 ? method.cx.scopes[0] : map2.get(expr.scopes[0]))));
                    Binding binding = typeref.t.find(expr.ref);
                    if (binding != null && binding.type != null) {
                        object2 = binding.type;
                    }
                    break;
                }
                case 66: {
                    object2 = this.OBJECT.ref.nonnull();
                    break;
                }
                case 74: {
                    Object object5 = this.type(map2, expr.args[0]);
                    Binding binding = ((Type)object5).find(expr.ref);
                    if (binding != null && binding.type != null && binding.type.t.itype != null) {
                        object2 = binding.type.t.itype.ref.nonnull();
                    }
                    break;
                }
                case 70: 
                case 76: {
                    Object object5 = this.type(map2, expr.args[0]);
                    Binding binding = ((Type)object5).find(expr.ref);
                    if (this.isMethod(binding)) {
                        object2 = binding.method.returns;
                        break;
                    }
                    if (GlobalOptimizer.isSlot(binding) && binding.type != null) {
                        if (binding.type.t.itype == this.INT) {
                            object2 = this.INT.ref;
                            object = this.eval_convert_i(map.get(expr.args[1]));
                            break;
                        }
                        if (binding.type.t.itype == this.UINT) {
                            object2 = this.UINT.ref;
                            object = this.eval_convert_u(map.get(expr.args[1]));
                            break;
                        }
                        if (binding.type.t.itype == this.STRING) {
                            object2 = this.STRING.ref;
                            object = this.eval_convert_s(map.get(expr.args[1]));
                            break;
                        }
                        if (binding.type.t.itype == this.BOOLEAN) {
                            object2 = this.BOOLEAN.ref;
                            object = this.eval_convert_b(map.get(expr.args[1]));
                            break;
                        }
                        if (binding.type.t.itype == this.NUMBER) {
                            object2 = this.NUMBER.ref;
                            object = this.eval_convert_d(map.get(expr.args[1]));
                        }
                    }
                    break;
                }
                case 68: {
                    object2 = expr.m.returns;
                    break;
                }
                case 0: {
                    if (expr.imm[0] < method.params.length) {
                        object2 = method.params[expr.imm[0]];
                        break;
                    }
                    if (method.needsArguments() || method.needsRest() && expr.imm[0] == method.params.length) {
                        object2 = this.ARRAY.ref.nonnull();
                        break;
                    }
                    object2 = this.VOID.ref;
                    break;
                }
                case 11: {
                    object2 = method.handlers[expr.imm[0]].type;
                    break;
                }
                case 108: {
                    Object object5 = this.type(map2, expr.args[0]);
                    Binding binding = ((Type)object5).findSlot(expr.imm[0]);
                    if (binding != null) {
                        object2 = binding.type;
                    }
                    break;
                }
                case 102: {
                    Object object5 = this.type(map2, expr.args[0]);
                    Binding binding = ((Type)object5).find(expr.ref);
                    if (GlobalOptimizer.isSlot(binding)) {
                        object2 = binding.type;
                        if (GlobalOptimizer.isConst(binding) && this.defaultValueChanged(binding)) {
                            object = binding.value;
                        }
                    } else {
                        if (this.isMethod(binding)) {
                            object2 = this.FUNCTION.ref.nonnull();
                            break;
                        }
                        if (this.isGetter(binding)) {
                            object2 = binding.method.returns;
                        }
                    }
                    break;
                }
                case 33: {
                    object = expr.value;
                    object2 = this.VOID.ref;
                    break;
                }
                case 32: {
                    object = expr.value;
                    object2 = this.NULL.ref;
                    break;
                }
                case 38: 
                case 39: {
                    object = expr.value;
                    object2 = this.BOOLEAN.ref;
                    break;
                }
                case 36: 
                case 37: 
                case 45: {
                    object = expr.value;
                    object2 = this.INT.ref;
                    break;
                }
                case 46: {
                    object = expr.value;
                    object2 = this.UINT.ref;
                    break;
                }
                case 44: {
                    object = expr.value;
                    object2 = this.STRING.ref.nonnull();
                    break;
                }
                case 40: 
                case 47: {
                    object = expr.value;
                    object2 = this.NUMBER.ref;
                    break;
                }
                case 49: {
                    object = expr.value;
                    object2 = this.NAMESPACE.ref.nonnull();
                    break;
                }
                case 16: {
                    set.add(expr.succ[0]);
                    return;
                }
                case 27: {
                    Object object5 = map.get(expr.args[0]);
                    if (object5 == BOTTOM) {
                        void var13_40;
                        Edge[] edgeArray = expr.succ;
                        int n = edgeArray.length;
                        boolean bl = false;
                        while (var13_40 < n) {
                            Edge edge = edgeArray[var13_40];
                            set.add(edge);
                            ++var13_40;
                        }
                    } else {
                        int n = this.intValue(object5);
                        if (n < 0 || n >= expr.succ.length - 1) {
                            n = expr.succ.length - 1;
                        }
                        set.add(expr.succ[n]);
                    }
                    return;
                }
                case 17: 
                case 18: {
                    Object object5 = map.get(expr.args[0]);
                    if (object5 == BOTTOM) {
                        set.add(expr.succ[0]);
                        set.add(expr.succ[1]);
                    } else if (expr.op == 18) {
                        set.add(expr.succ[this.booleanValue(object5) ? 0 : 1]);
                    } else if (expr.op == 17) {
                        set.add(expr.succ[this.booleanValue(object5) ? 1 : 0]);
                    }
                    return;
                }
                case 28: 
                case 48: {
                    object = map.get(expr.args[0]);
                    object2 = map2.get(expr.args[0]).nonnull();
                    break;
                }
                case 118: {
                    object2 = this.BOOLEAN.ref;
                    object = this.eval_convert_b(map.get(expr.args[0]));
                    break;
                }
                case 150: {
                    object2 = this.BOOLEAN.ref;
                    Object object5 = map.get(expr.args[0]);
                    if (object5 != BOTTOM) {
                        object = this.booleanValue(object5) ? Boolean.FALSE : Boolean.TRUE;
                    }
                    break;
                }
                case 31: 
                case 50: 
                case 91: 
                case 106: 
                case 171: 
                case 172: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    object2 = this.BOOLEAN.ref;
                    break;
                }
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    object2 = this.BOOLEAN.ref;
                    Object object5 = map.get(expr.args[0]);
                    Object object6 = map.get(expr.args[1]);
                    if (object5.equals(NAN) || object5 == UNDEFINED || object6.equals(NAN) || object6 == UNDEFINED) {
                        object = Boolean.FALSE;
                        break;
                    }
                    if (object5 != BOTTOM && object6 != BOTTOM) {
                        object = expr.op == 173 ? this.lessthan(object5, object6) : (expr.op == 174 ? !this.lessthan(object6, object5) : (expr.op == 175 ? this.lessthan(object6, object5) : !this.lessthan(object5, object6)));
                    }
                    break;
                }
                case 112: {
                    object2 = this.STRING.ref.nonnull();
                    object = this.eval_convert_s(map.get(expr.args[0]));
                    break;
                }
                case 133: {
                    object2 = this.eval_coerce_s(map2.get(expr.args[0]));
                    object = this.eval_coerce_s(map.get(expr.args[0]));
                    break;
                }
                case 137: {
                    Object object5 = map2.get(expr.args[0]);
                    object2 = this.eval_coerce_o((Typeref)object5);
                    object = this.eval_coerce_o(map.get(expr.args[0]), ((Typeref)object5).t);
                    break;
                }
                case 130: {
                    object = map.get(expr.args[0]);
                    object2 = map2.get(expr.args[0]);
                    break;
                }
                case 128: {
                    Object object5 = map2.get(expr.args[0]);
                    Object object7 = map.get(expr.args[0]);
                    Type type = this.namedTypes.get(expr.ref);
                    if (type == this.STRING) {
                        object2 = this.eval_coerce_s((Typeref)object5);
                        object = this.eval_coerce_s(object7);
                        break;
                    }
                    if (type == this.OBJECT) {
                        object2 = this.eval_coerce_o((Typeref)object5);
                        object = this.eval_coerce_o(object7, ((Typeref)object5).t);
                        break;
                    }
                    if (type == this.INT) {
                        object2 = type.ref;
                        object = this.eval_convert_i(object7);
                        break;
                    }
                    if (type == this.UINT) {
                        object2 = type.ref;
                        object = this.eval_convert_u(object7);
                        break;
                    }
                    if (type == this.NUMBER) {
                        object2 = type.ref;
                        object = this.eval_convert_d(object7);
                        break;
                    }
                    if (type == this.BOOLEAN) {
                        object2 = type.ref;
                        object = this.eval_convert_b(object7);
                        break;
                    }
                    if (this.istype(((Typeref)object5).t, type)) {
                        object2 = object5;
                        object = object7;
                        break;
                    }
                    if (((Typeref)object5).t == this.NULL || ((Typeref)object5).t == this.VOID) {
                        object2 = this.NULL.ref;
                        break;
                    }
                    object2 = type.ref;
                    break;
                }
                case 134: {
                    object2 = this.namedTypes.get((Name)expr.ref).ref;
                    break;
                }
                case 149: {
                    Object object5 = this.type(map2, expr.args[0]);
                    if (object5 == this.INT || object5 == this.UINT || object5 == this.NUMBER) {
                        object = "number";
                    } else if (object5 == this.STRING) {
                        object = "string";
                    } else if (this.istype((Type)object5, this.XML) || this.istype((Type)object5, this.XMLLIST)) {
                        object = "xml";
                    } else if (object5 == this.VOID) {
                        object = "undefined";
                    } else if (object5 == this.BOOLEAN) {
                        object = "boolean";
                    } else if (this.istype((Type)object5, this.FUNCTION)) {
                        object = "function";
                    } else if (object5 != this.OBJECT && this.istype((Type)object5, this.OBJECT)) {
                        object = "object";
                    }
                    object2 = this.STRING.ref.nonnull();
                    break;
                }
                case 160: {
                    Object object5 = expr.args[0];
                    Expr expr3 = expr.args[1];
                    Typeref typeref = map2.get(object5);
                    Typeref typeref2 = map2.get(expr3);
                    Object object4 = map.get(object5);
                    Object object6 = map.get(expr3);
                    if (typeref.t == this.STRING && !typeref.nullable || typeref2.t == this.STRING && !typeref2.nullable) {
                        object2 = this.STRING.ref.nonnull();
                        if (object4 != BOTTOM && object6 != BOTTOM) {
                            object = this.stringValue(object4) + this.stringValue(object6);
                        }
                        break;
                    }
                    if (typeref.t.numeric && typeref2.t.numeric) {
                        object2 = this.NUMBER.ref;
                        if (object4 instanceof Number && object6 instanceof Number) {
                            object = this.doubleValue(object4) + this.doubleValue(object6);
                        }
                        break;
                    }
                    object2 = this.OBJECT.ref.nonnull();
                    break;
                }
                case 163: {
                    object2 = this.NUMBER.ref;
                    Object object5 = map.get(expr.args[0]);
                    Object object10 = map.get(expr.args[1]);
                    if (object5 instanceof Number && object10 instanceof Number) {
                        object = this.doubleValue(object5) / this.doubleValue(object10);
                    }
                    break;
                }
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 164: {
                    object2 = this.NUMBER.ref;
                    break;
                }
                case 117: {
                    object2 = this.NUMBER.ref;
                    object = this.eval_convert_d(map.get(expr.args[0]));
                    break;
                }
                case 115: {
                    object2 = this.INT.ref;
                    object = this.eval_convert_i(map.get(expr.args[0]));
                    break;
                }
                case 116: {
                    object2 = this.UINT.ref;
                    object = this.eval_convert_u(map.get(expr.args[0]));
                    break;
                }
                case 169: {
                    object2 = this.INT.ref;
                    Object object5 = map.get(expr.args[0]);
                    Object object11 = map.get(expr.args[1]);
                    if (object5 instanceof Number && object11 instanceof Number) {
                        object = this.intValue(object5) | this.intValue(object11);
                    }
                    break;
                }
                case 168: {
                    object2 = this.INT.ref;
                    Object object5 = map.get(expr.args[0]);
                    Object object12 = map.get(expr.args[1]);
                    if (object5 instanceof Number && object12 instanceof Number) {
                        object = this.intValue(object5) & this.intValue(object12);
                    }
                    break;
                }
                case 51: 
                case 151: 
                case 165: 
                case 166: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: {
                    object2 = this.INT.ref;
                    break;
                }
                case 167: {
                    object2 = this.UINT.ref;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 29: 
                case 71: 
                case 72: 
                case 73: 
                case 78: 
                case 79: 
                case 97: 
                case 104: 
                case 109: 
                case 239: 
                case 240: 
                case 241: 
                case 242: {
                    return;
                }
            }
        }
        assert (object2 != null && ((Typeref)object2).t != null);
        if (((Typeref)object2).t == this.VOID) {
            object = UNDEFINED;
        } else if (((Typeref)object2).t == this.NULL) {
            object = this.NULL;
        }
        if (object != null && !object.equals(map.get(expr))) {
            map.put(expr, object);
            set2.addAll(edgeMap.get(expr));
        }
        if (!((Typeref)object2).equals(map2.get(expr))) {
            map2.put(expr, (Typeref)object2);
            set2.addAll(edgeMap.get(expr));
        }
    }

    Typeref verify_eval(Method method, Expr expr, Map<Expr, Typeref> map, Map<Block, Block> map2) {
        Object object = null;
        if (expr.op == 10) {
            boolean bl = false;
            for (int i = expr.args.length - 1; i >= 0; --i) {
                Expr expr2 = expr.args[i];
                bl |= this.isLoop(expr.pred[i], map2);
                Typeref typeref = map.get(expr2);
                if (typeref == null) continue;
                if (object == null) {
                    object = typeref;
                    continue;
                }
                if (((Typeref)object).equals(typeref)) continue;
                object = this.mdb((Typeref)object, typeref);
            }
            if (bl) {
                object = ((Typeref)object).t.ref;
            }
        } else {
            object = this.ANY.ref;
            for (Expr object2 : expr.args) {
                if (map.containsKey(object2)) continue;
                return object;
            }
            for (Expr expr2 : expr.scopes) {
                if (map.containsKey(expr2)) continue;
                return object;
            }
            for (Expr expr3 : expr.locals) {
                if (map.containsKey(expr3)) continue;
                return object;
            }
            switch (expr.op) {
                default: {
                    assert (false);
                }
                case 30: 
                case 35: 
                case 52: 
                case 65: {
                    object = this.ANY.ref;
                    break;
                }
                case 119: {
                    object = map.get(expr.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    object = this.STRING.ref.nonnull();
                    break;
                }
                case 90: {
                    object = method.handlers[expr.imm[0]].activation;
                    break;
                }
                case 85: {
                    object = this.OBJECT.ref.nonnull();
                    break;
                }
                case 86: {
                    object = this.ARRAY.ref.nonnull();
                    break;
                }
                case 87: {
                    object = method.activation;
                    break;
                }
                case 100: {
                    if (method.cx.scopes.length > 0) {
                        object = method.cx.scopes[0];
                        break;
                    }
                    object = map.get(expr.scopes[0].args[0]);
                    break;
                }
                case 101: {
                    object = map.get(expr.scopes[0].args[0]);
                    break;
                }
                case 88: {
                    object = expr.c.ref.nonnull();
                    break;
                }
                case 64: {
                    object = this.FUNCTION.ref.nonnull();
                    break;
                }
                case 95: {
                    if (!this.globals.contains(expr.ref)) break;
                    object = this.globals.get(expr.ref);
                    break;
                }
                case 93: 
                case 94: {
                    int n = this.findInner(expr.ref, expr.scopes, map);
                    if (n >= 0) {
                        object = map.get(expr.scopes[n]);
                        break;
                    }
                    n = this.findOuter(expr.ref, method.cx.scopes);
                    if (n >= 0) {
                        object = method.cx.scopes[n];
                        break;
                    }
                    if (this.globals.contains(expr.ref)) {
                        object = this.globals.get(expr.ref);
                        break;
                    }
                    if (method.cx.scopes.length > 0) {
                        object = method.cx.scopes[0];
                        break;
                    }
                    object = map.get(expr.scopes[0]);
                    break;
                }
                case 96: {
                    int n = this.findInner(expr.ref, expr.scopes, map);
                    Typeref typeref = n >= 0 ? map.get(expr.scopes[n]) : ((n = this.findOuter(expr.ref, method.cx.scopes)) >= 0 ? method.cx.scopes[n] : (this.globals.contains(expr.ref) ? this.globals.get(expr.ref) : (method.cx.scopes.length > 0 ? method.cx.scopes[0] : map.get(expr.scopes[0]))));
                    Binding binding = typeref.t.find(expr.ref);
                    if (binding == null || binding.type == null) break;
                    object = binding.type;
                    break;
                }
                case 66: {
                    object = this.OBJECT.ref.nonnull();
                    break;
                }
                case 74: {
                    Object object3 = this.type(map, expr.args[0]);
                    Binding binding = ((Type)object3).find(expr.ref);
                    if (binding == null || binding.type == null || binding.type.t.itype == null) break;
                    object = binding.type.t.itype.ref.nonnull();
                    break;
                }
                case 70: 
                case 76: {
                    Object object3 = this.type(map, expr.args[0]);
                    Binding binding = ((Type)object3).find(expr.ref);
                    if (this.isMethod(binding)) {
                        object = binding.method.returns;
                        break;
                    }
                    if (!GlobalOptimizer.isSlot(binding) || binding.type == null || binding.type.t.itype == null) break;
                    object = binding.type.t.itype.ref;
                    break;
                }
                case 69: {
                    Object object3 = method.cx.base;
                    Binding binding = ((Type)object3).find(expr.ref);
                    if (!this.isMethod(binding)) break;
                    object = binding.method.returns;
                    break;
                }
                case 68: {
                    object = expr.m.returns;
                    break;
                }
                case 0: {
                    if (expr.imm[0] < method.params.length) {
                        object = method.params[expr.imm[0]];
                        break;
                    }
                    if (method.needsArguments() || method.needsRest() && expr.imm[0] == method.params.length) {
                        object = this.ARRAY.ref.nonnull();
                        break;
                    }
                    object = this.VOID.ref;
                    break;
                }
                case 11: {
                    object = method.handlers[expr.imm[0]].type;
                    break;
                }
                case 108: {
                    Object object3 = this.type(map, expr.args[0]);
                    Binding binding = ((Type)object3).findSlot(expr.imm[0]);
                    if (binding == null) break;
                    object = binding.type;
                    break;
                }
                case 102: {
                    Object object3 = this.type(map, expr.args[0]);
                    Binding binding = ((Type)object3).find(expr.ref);
                    if (GlobalOptimizer.isSlot(binding)) {
                        object = binding.type;
                        break;
                    }
                    if (this.isMethod(binding)) {
                        object = this.ANY.ref;
                        break;
                    }
                    if (!this.isGetter(binding)) break;
                    object = binding.method.returns;
                    break;
                }
                case 8: {
                    object = this.ANY.ref;
                    break;
                }
                case 33: {
                    object = this.VOID.ref;
                    break;
                }
                case 32: {
                    object = this.NULL.ref;
                    break;
                }
                case 49: {
                    object = this.NAMESPACE.ref.nonnull();
                    break;
                }
                case 28: 
                case 48: {
                    object = map.get(expr.args[0]).nonnull();
                    break;
                }
                case 31: 
                case 38: 
                case 39: 
                case 50: 
                case 91: 
                case 106: 
                case 118: 
                case 150: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    object = this.BOOLEAN.ref;
                    break;
                }
                case 44: 
                case 112: {
                    object = this.STRING.ref.nonnull();
                    break;
                }
                case 133: {
                    Object object3 = map.get(expr.args[0]);
                    object = new Typeref(this.STRING, ((Typeref)object3).nullable);
                    break;
                }
                case 137: {
                    Object object3 = map.get(expr.args[0]);
                    object = new Typeref(this.OBJECT, ((Typeref)object3).nullable);
                    break;
                }
                case 130: {
                    Object object3 = map.get(expr.args[0]);
                    object = new Typeref(this.ANY, ((Typeref)object3).nullable);
                    break;
                }
                case 128: {
                    object = this.namedTypes.get((Name)expr.ref).ref;
                    break;
                }
                case 134: {
                    Object object3 = map.get(expr.args[0]);
                    Type type = this.namedTypes.get(expr.ref);
                    if (!this.istype(((Typeref)object3).t, type) || this.isAtom(((Typeref)object3).t) != this.isAtom(type)) {
                        object = type.ref;
                        break;
                    }
                    object = object3;
                    break;
                }
                case 135: {
                    Object object3 = map.get(expr.args[1]);
                    if (((Typeref)object3).t.itype != null) {
                        if (((Typeref)object3).t.itype.atom || ((Typeref)object3).t.itype.numeric) {
                            object = this.OBJECT.ref;
                            break;
                        }
                        object = ((Typeref)object3).t.itype.ref;
                        break;
                    }
                    object = this.ANY.ref;
                    break;
                }
                case 149: {
                    object = this.STRING.ref.nonnull();
                    break;
                }
                case 160: {
                    Object object3 = expr.args[0];
                    Expr expr3 = expr.args[1];
                    Typeref typeref = map.get(object3);
                    Typeref typeref2 = map.get(expr3);
                    if (typeref.t == this.STRING && !typeref.nullable || typeref2.t == this.STRING && !typeref2.nullable) {
                        object = this.STRING.ref.nonnull();
                        break;
                    }
                    if (typeref.t.numeric && typeref2.t.numeric) {
                        object = this.NUMBER.ref;
                        break;
                    }
                    object = this.OBJECT.ref.nonnull();
                    break;
                }
                case 40: 
                case 47: 
                case 117: 
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    object = this.NUMBER.ref;
                    break;
                }
                case 36: 
                case 37: 
                case 45: 
                case 51: 
                case 115: 
                case 151: 
                case 165: 
                case 166: 
                case 168: 
                case 169: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: {
                    object = this.INT.ref;
                    break;
                }
                case 46: 
                case 116: 
                case 167: {
                    object = this.UINT.ref;
                }
            }
        }
        assert (object != null && ((Typeref)object).t != null);
        return object;
    }

    EdgeMap<Expr> findUses(Deque<Block> deque) {
        EdgeMap<Expr> edgeMap = new EdgeMap<Expr>();
        for (Block block : deque) {
            for (Expr expr : block) {
                for (Expr expr2 : expr.args) {
                    edgeMap.get(expr2).add(expr);
                }
                for (Expr expr2 : expr.locals) {
                    edgeMap.get(expr2).add(expr);
                }
                for (Expr expr2 : expr.scopes) {
                    edgeMap.get(expr2).add(expr);
                }
            }
        }
        return edgeMap;
    }

    Typeref mdb(Typeref typeref, Typeref typeref2) {
        assert (typeref != typeref2 && typeref != null && typeref2 != null);
        if (typeref.t == this.NULL && this.isPointer(typeref2.t)) {
            return typeref2;
        }
        if (typeref2.t == this.NULL && this.isPointer(typeref.t)) {
            return typeref;
        }
        HashSet<Type> hashSet = new HashSet<Type>();
        Type type = typeref.t;
        while (type != null) {
            hashSet.add(type);
            type = type.base;
        }
        type = typeref2.t;
        while (type != null) {
            if (hashSet.contains(type)) {
                return new Typeref(type, typeref.nullable | typeref2.nullable);
            }
            type = type.base;
        }
        return new Typeref(this.ANY, typeref.nullable | typeref2.nullable);
    }

    int findInner(Name name, Expr[] exprArray, Map<Expr, Typeref> map) {
        for (int i = exprArray.length - 1; i >= 0; --i) {
            Type type = this.type(map, exprArray[i]);
            Binding binding = type.find(name);
            if (binding == null) continue;
            return i;
        }
        return -1;
    }

    int findOuter(Name name, Typeref[] typerefArray) {
        for (int i = typerefArray.length - 1; i >= 1; --i) {
            Type type = typerefArray[i].t;
            Binding binding = type.find(name);
            if (binding == null) continue;
            return i;
        }
        Typeref typeref = this.globals.get(name);
        if (typeref != null) {
            return -1;
        }
        if (typerefArray.length > 0 && typerefArray[0].t.find(name) != null) {
            return 0;
        }
        return -1;
    }

    boolean istype(Type type, Type type2) {
        while (type != null) {
            if (type == type2) {
                return true;
            }
            type = type.base;
        }
        return false;
    }

    boolean isCritical(Edge edge, SetMap<Block, Edge> setMap) {
        return edge.from.succ().length > 1 && setMap.get(edge.to).size() > 1;
    }

    void split(Edge edge, Method method, SetMap<Block, Edge> setMap) {
        assert (edge.handler == null);
        System.out.println("SPLIT " + edge);
        Expr expr = new Expr(method, 16);
        Block block = new Block(method);
        Block block2 = edge.to;
        Edge edge2 = new Edge(method, block, 0, block2);
        expr.succ = new Edge[]{edge2};
        block.add(expr);
        edge.to = block;
        setMap.get(block).add(edge);
        setMap.get(block2).remove(edge);
        setMap.get(block2).add(edge2);
        this.replacePred(block2, edge, edge2);
    }

    void replacePred(Block block, Edge edge, Edge edge2) {
        for (Expr expr : block) {
            if (expr.op != 10) continue;
            int n = expr.pred.length;
            for (int i = 0; i < n; ++i) {
                if (expr.pred[i] != edge) continue;
                expr.pred[i] = edge2;
            }
        }
    }

    Expr append(Edge edge, Expr expr) {
        Deque<Expr> deque = edge.from.exprs;
        Expr expr2 = deque.removeLast();
        deque.add(expr);
        deque.add(expr2);
        return expr;
    }

    Expr prepend(Edge edge, Expr expr) {
        Deque<Expr> deque = edge.from.exprs;
        deque.addFirst(expr);
        return expr;
    }

    Expr setlocal(Method method, int n, Expr expr) {
        return new Expr(method, 99, n, new Expr[]{expr}, 1, 1);
    }

    Expr getlocal(Method method, int n) {
        return new Expr(method, 98, n);
    }

    Expr dup(Method method, Expr expr) {
        Expr expr2 = new Expr(method, 42);
        expr2.locals = new Expr[]{expr};
        return expr2;
    }

    void remove_phi(Method method) {
        int n;
        ConflictGraph conflictGraph;
        TreeMap<Block, Deque<Expr>> treeMap;
        TreeMap<Integer, Integer> treeMap2;
        SetMap<Block, Edge> setMap;
        Deque<Block> deque;
        block21: {
            deque = this.dfs(method.entry.to);
            setMap = this.preds(deque);
            treeMap2 = new TreeMap<Integer, Integer>();
            treeMap = new TreeMap<Block, Deque<Expr>>();
            conflictGraph = new ConflictGraph();
            System.out.println("BEFORE SCHED");
            this.print(deque);
            if (method.needsArguments() || method.needsRest()) {
                n = method.params.length;
                for (Expr expr : method.entry.to) {
                    if (expr.op != 0 || expr.imm[0] != n) continue;
                    break block21;
                }
                method.flags &= 0xFFFFFFFA;
                method.flags |= 0x10;
            }
        }
        this.sched_greedy(method, deque, treeMap2, setMap, treeMap, conflictGraph);
        this.alloc_locals(deque, treeMap2, conflictGraph);
        n = method.params.length - 1;
        int n2 = 0;
        int n3 = 0;
        TreeMap<Block, Integer> treeMap3 = new TreeMap<Block, Integer>();
        TreeMap<Block, Integer> treeMap4 = new TreeMap<Block, Integer>();
        treeMap3.put(method.entry.to, 0);
        treeMap4.put(method.entry.to, 0);
        TreeSet<Edge> treeSet = new TreeSet<Edge>();
        for (Block block : deque) {
            int n4;
            int n5;
            for (Expr expr : block) {
                if (expr.op != 10) break;
                if (!treeMap2.containsKey(expr.id)) continue;
                int n6 = (Integer)treeMap2.get(expr.id);
                for (n5 = expr.args.length - 1; n5 >= 0; --n5) {
                    n4 = (Integer)treeMap2.get(expr.args[n5].id);
                    if (n6 == n4) continue;
                    Edge edge = expr.pred[n5];
                    if (!treeSet.contains(edge)) {
                        this.split(edge, method, setMap);
                        edge = expr.pred[n5];
                        treeSet.add(edge);
                    }
                    Expr expr2 = this.getlocal(method, n4);
                    this.prepend(edge, expr2);
                    this.append(edge, this.setlocal(method, n6, expr2));
                }
            }
            block.exprs = (Deque)treeMap.get(block);
            int n7 = (Integer)treeMap3.get(block);
            int n8 = (Integer)treeMap4.get(block);
            for (Expr expr : block) {
                assert (!expr.isSynthetic());
                assert (n7 >= expr.args.length);
                n7 -= expr.args.length;
                if (expr.onStack()) {
                    ++n7;
                }
                if (n7 > n2) {
                    n2 = n7;
                }
                assert (n8 >= expr.scopes.length);
                if (expr.op == 29) {
                    --n8;
                } else if (expr.onScope()) {
                    ++n8;
                }
                if (n8 > n3) {
                    n3 = n8;
                }
                n4 = n;
                if (expr.op == 98 || expr.op == 99) {
                    n4 = expr.imm[0] = ((Integer)treeMap2.get(expr.imm[0])).intValue();
                } else if (expr.op == 50) {
                    int n9 = (Integer)treeMap2.get(expr.locals[0].id);
                    int n10 = (Integer)treeMap2.get(expr.locals[1].id);
                    expr.imm = new int[]{n9, n10};
                    int n11 = n4 = n9 > n10 ? n9 : n10;
                }
                if (n4 <= n) continue;
                n = n4;
            }
            for (Edge edge : block.succ()) {
                this.update_depth(edge.to, n7, treeMap3, n8, treeMap4);
            }
            Edge[] edgeArray = block.xsucc;
            n5 = edgeArray.length;
            for (n4 = 0; n4 < n5; ++n4) {
                Edge edge = edgeArray[n4];
                this.update_depth(edge.to, 1, treeMap3, 0, treeMap4);
            }
        }
        method.local_count = n + 1;
        method.max_stack = n2;
        method.max_scope = n3;
        System.out.println("AFTER SCHED " + method.name + " local_count=" + method.local_count + " max_stack=" + n2 + " max_scope=" + n3);
        this.cfgopt(method);
    }

    void alloc_locals(Deque<Block> deque, Map<Integer, Integer> map, ConflictGraph conflictGraph) {
        for (Block block : deque) {
            for (Expr expr : block) {
                if (!map.containsKey(expr.id)) continue;
                this.alloc1(expr, conflictGraph, map);
            }
        }
        for (Block block : deque) {
            for (Expr expr : block) {
                if (!map.containsKey(expr.id)) continue;
                this.alloc2(expr, conflictGraph, map);
            }
        }
        System.out.println("CONFLICTS " + conflictGraph);
        System.out.println("LOCALS " + map);
    }

    void update_depth(Block block, int n, Map<Block, Integer> map, int n2, Map<Block, Integer> map2) {
        if (map.containsKey(block)) {
            assert (map.get(block) == n);
        } else {
            map.put(block, n);
        }
        if (map2.containsKey(block)) {
            assert (map2.get(block) == n2);
        } else {
            map2.put(block, n2);
        }
    }

    void allocate(int n, int n2, Map<Integer, Integer> map, ConflictGraph conflictGraph) {
        assert (map.get(n) == -1 && n2 != -1);
        map.put(n, n2);
        for (int n3 : conflictGraph.get(n)) {
            assert (map.get(n3) != n2);
        }
    }

    void alloc1(Expr expr, ConflictGraph conflictGraph, Map<Integer, Integer> map) {
        if (map.get(expr.id) != -1) {
            return;
        }
        BitSet bitSet = new BitSet();
        for (int n : conflictGraph.get(expr.id)) {
            if (map.get(n) == -1) continue;
            bitSet.set(map.get(n));
        }
        int n = -1;
        if (expr.locals.length == 1 && expr.inLocal() && map.containsKey(expr.locals[0].id) && (n = map.get(expr.locals[0].id).intValue()) != -1) {
            assert (!bitSet.get(n));
            this.allocate(expr.id, n, map, conflictGraph);
        }
        if (expr.op != 10) {
            return;
        }
        for (Expr expr2 : expr.args) {
            if (!map.containsKey(expr2.id) || (n = map.get(expr2.id).intValue()) == -1 || bitSet.get(n)) continue;
            this.allocate(expr.id, n, map, conflictGraph);
            break;
        }
        if (n == -1) {
            n = 0;
            while (bitSet.get(n)) {
                ++n;
            }
            this.allocate(expr.id, n, map, conflictGraph);
        }
        block3: for (Expr expr2 : expr.args) {
            if (map.get(expr2.id) != -1) continue;
            for (int n2 : conflictGraph.get(expr2.id)) {
                if (map.get(n2) != n) continue;
                continue block3;
            }
            this.allocate(expr2.id, n, map, conflictGraph);
        }
    }

    void alloc2(Expr expr, ConflictGraph conflictGraph, Map<Integer, Integer> map) {
        int n;
        int n2;
        if (map.get(expr.id) != -1) {
            return;
        }
        BitSet bitSet = new BitSet();
        for (int n3 : conflictGraph.get(expr.id)) {
            if (map.get(n3) == -1) continue;
            bitSet.set(map.get(n3));
        }
        if (expr.locals.length == 1 && expr.inLocal() && map.containsKey(expr.locals[0].id) && (n2 = map.get(expr.locals[0].id).intValue()) != -1) {
            assert (!bitSet.get(n2));
            this.allocate(expr.id, n2, map, conflictGraph);
        }
        if (expr.args.length != 0 && map.containsKey(expr.args[0].id) && (n = map.get(expr.args[0].id).intValue()) != -1 && !bitSet.get(n)) {
            this.allocate(expr.id, n, map, conflictGraph);
            return;
        }
        int n4 = 0;
        while (bitSet.get(n4)) {
            ++n4;
        }
        this.allocate(expr.id, n4, map, conflictGraph);
    }

    boolean hasStackEffect(Expr expr) {
        if (expr == null || expr.op == 0) {
            return true;
        }
        return expr.onStack() || expr.args.length > 0;
    }

    ConflictGraph sched_greedy(Method method, Deque<Block> deque, Map<Integer, Integer> map, SetMap<Block, Edge> setMap, Map<Block, Deque<Expr>> map2, ConflictGraph conflictGraph) {
        SetMap<Block, Expr> setMap2 = new SetMap<Block, Expr>();
        TreeMap<Block, Deque<Expr>> treeMap = new TreeMap<Block, Deque<Expr>>();
        TreeMap<Block, Deque<Expr>> treeMap2 = new TreeMap<Block, Deque<Expr>>();
        HashMap<Object, LinkedDeque<Object>> hashMap = new HashMap<Object, LinkedDeque<Object>>();
        PriorityQueue<Block> priorityQueue = new PriorityQueue<Block>(deque.size(), new Comparator<Block>(){

            @Override
            public int compare(Block block, Block block2) {
                return block.postorder - block2.postorder;
            }
        });
        priorityQueue.addAll(deque);
        while (!priorityQueue.isEmpty()) {
            Block block = (Block)priorityQueue.remove();
            while (priorityQueue.peek() == block) {
                priorityQueue.remove();
            }
            TreeSet<Expr> iterable = new TreeSet<Expr>();
            ArrayDeque<Expr> arrayDeque = new ArrayDeque<Expr>((Collection<Expr>)block.exprs);
            ArrayDeque arrayDeque2 = new ArrayDeque();
            ArrayDeque<Expr> arrayDeque3 = new ArrayDeque<Expr>();
            LinkedDeque<Object> linkedDeque = new LinkedDeque<Object>();
            LinkedDeque<Expr> linkedDeque2 = new LinkedDeque<Expr>();
            iterable.addAll(setMap2.get(block));
            for (Expr expr : iterable) {
                map.put(expr.id, expr.op == 0 ? expr.imm[0] : -1);
            }
            map2.put(block, linkedDeque2);
            hashMap.put(block, linkedDeque);
            TreeSet treeSet = new TreeSet();
            while (!arrayDeque.isEmpty() || !arrayDeque2.isEmpty()) {
                Expr expr;
                while (!arrayDeque2.isEmpty() && this.hasStackEffect((Expr)arrayDeque.peekLast())) {
                    this.showstate(iterable, arrayDeque2, arrayDeque3, linkedDeque);
                    expr = this.remove_dup(arrayDeque2, method, linkedDeque2, linkedDeque);
                    if (expr.inLocal() || expr.op == 10 || expr != arrayDeque.peekLast() || arrayDeque2.contains(expr)) {
                        this.issue_load(expr, method, linkedDeque2, linkedDeque, iterable, map);
                        continue;
                    }
                    if (iterable.contains(expr)) {
                        this.define(expr, iterable, conflictGraph);
                        this.issue_store(expr, method, linkedDeque2, linkedDeque, arrayDeque2);
                        arrayDeque2.add((Expr)expr);
                        continue;
                    }
                    if (expr.op == 11) {
                        while (!arrayDeque2.isEmpty()) {
                            this.loadTOS(method, arrayDeque2, arrayDeque3, linkedDeque2, linkedDeque, iterable, map);
                        }
                        linkedDeque.addFirst(arrayDeque.removeLast());
                        continue;
                    }
                    this.issue_expr((Expr)arrayDeque.removeLast(), method, linkedDeque2, linkedDeque, arrayDeque2, arrayDeque3, iterable, map);
                }
                if (arrayDeque.isEmpty()) continue;
                this.showstate(iterable, arrayDeque2, arrayDeque3, linkedDeque);
                expr = (Expr)arrayDeque.removeLast();
                if (expr.op == 10) {
                    this.issue_phi(expr, linkedDeque, treeSet, iterable, conflictGraph);
                    continue;
                }
                if (expr.op == 0) {
                    linkedDeque.addFirst(expr);
                    if (!iterable.contains(expr)) continue;
                    this.define(expr, iterable, conflictGraph);
                    continue;
                }
                if (iterable.contains(expr)) {
                    this.define(expr, iterable, conflictGraph);
                    if (expr.onStack()) {
                        this.issue_store(expr, method, linkedDeque2, linkedDeque, arrayDeque2);
                        arrayDeque.add(expr);
                        continue;
                    }
                    if (!expr.inLocal()) continue;
                    this.issue_expr(expr, method, linkedDeque2, linkedDeque, arrayDeque2, arrayDeque3, iterable, map);
                    continue;
                }
                if (expr.op == 11) {
                    this.issue_pop(method, linkedDeque2, linkedDeque, expr);
                    linkedDeque.addFirst(expr);
                    continue;
                }
                if (expr.onStack()) {
                    this.issue_pop(method, linkedDeque2, linkedDeque, expr);
                }
                this.issue_expr(expr, method, linkedDeque2, linkedDeque, arrayDeque2, arrayDeque3, iterable, map);
            }
            this.fwd_state(method, map, setMap, setMap2, treeMap, treeMap2, priorityQueue, block, iterable, arrayDeque2, arrayDeque3, linkedDeque, linkedDeque2, treeSet);
        }
        System.out.println("STK_LIVEOUT " + setMap2);
        System.out.println("CONFLICTS " + conflictGraph);
        for (Block block : deque) {
            System.out.println("");
            System.out.println(block);
            for (ArrayDeque arrayDeque2 : (Deque)hashMap.get(block)) {
                if (arrayDeque2 instanceof Expr) {
                    this.print((Expr)((Object)arrayDeque2));
                    continue;
                }
                System.out.println(arrayDeque2);
            }
        }
        return conflictGraph;
    }

    void showstate(Set<Expr> set, Deque<Expr> deque, Deque<Expr> deque2, Deque<Object> deque3) {
        deque3.addFirst("              live " + set + " stk " + deque);
        if (!deque2.isEmpty()) {
            deque3.addFirst("              scp  " + deque2);
        }
    }

    Expr remove_dup(Deque<Expr> deque, Method method, Deque<Expr> deque2, Deque<Object> deque3) {
        Expr expr = deque.removeLast();
        while (expr == deque.peekLast()) {
            this.issue_dup(deque.removeLast(), method, deque2, deque3);
        }
        return expr;
    }

    void try_dup(Deque<Expr> deque, Method method, Deque<Expr> deque2, Deque<Object> deque3) {
        if (deque.size() > 2) {
            Expr expr = deque.removeLast();
            while (expr == deque.peekLast()) {
                this.issue_dup(deque.removeLast(), method, deque2, deque3);
            }
            deque.add(expr);
        }
    }

    void issue_phi(Expr expr, Deque<Object> deque, Set<Expr> set, Set<Expr> set2, ConflictGraph conflictGraph) {
        deque.addFirst(expr);
        set.add(expr);
        if (set2.contains(expr)) {
            for (Expr expr2 : set2) {
                if (expr2 == expr) continue;
                conflictGraph.add(expr2, expr);
            }
        }
    }

    ConflictGraph sched_lazy(Method method, Deque<Block> deque, Map<Integer, Integer> map, SetMap<Block, Edge> setMap, Map<Block, Deque<Expr>> map2, ConflictGraph conflictGraph) {
        SetMap<Block, Expr> setMap2 = new SetMap<Block, Expr>();
        TreeMap<Block, Deque<Expr>> treeMap = new TreeMap<Block, Deque<Expr>>();
        TreeMap<Block, Deque<Expr>> treeMap2 = new TreeMap<Block, Deque<Expr>>();
        HashMap<Object, LinkedDeque<Object>> hashMap = new HashMap<Object, LinkedDeque<Object>>();
        PriorityQueue<Block> priorityQueue = new PriorityQueue<Block>(deque.size(), new Comparator<Block>(){

            @Override
            public int compare(Block block, Block block2) {
                return block.postorder - block2.postorder;
            }
        });
        priorityQueue.addAll(deque);
        while (!priorityQueue.isEmpty()) {
            Block block = (Block)priorityQueue.remove();
            while (priorityQueue.peek() == block) {
                priorityQueue.remove();
            }
            TreeSet<Expr> iterable = new TreeSet<Expr>();
            ArrayDeque<Expr> arrayDeque = new ArrayDeque<Expr>((Collection<Expr>)block.exprs);
            ArrayDeque arrayDeque2 = new ArrayDeque();
            ArrayDeque<Expr> arrayDeque3 = new ArrayDeque<Expr>();
            LinkedDeque<Object> linkedDeque = new LinkedDeque<Object>();
            LinkedDeque<Expr> linkedDeque2 = new LinkedDeque<Expr>();
            if (treeMap.containsKey(block)) {
                arrayDeque2.addAll((Collection)treeMap.get(block));
            }
            iterable.addAll(setMap2.get(block));
            for (Expr expr : iterable) {
                map.put(expr.id, expr.op == 0 ? expr.imm[0] : -1);
            }
            map2.put(block, linkedDeque2);
            hashMap.put(block, linkedDeque);
            TreeSet treeSet = new TreeSet();
            while (!arrayDeque.isEmpty()) {
                Expr expr;
                this.showstate(iterable, arrayDeque2, arrayDeque3, linkedDeque);
                expr = (Expr)arrayDeque.removeLast();
                if (expr.op == 10) {
                    this.issue_phi(expr, linkedDeque, treeSet, iterable, conflictGraph);
                    continue;
                }
                assert (treeSet.isEmpty());
                boolean bl = false;
                while (arrayDeque2.contains(expr)) {
                    bl = true;
                    Expr expr2 = this.remove_dup(arrayDeque2, method, linkedDeque2, linkedDeque);
                    if (expr2 == expr && !arrayDeque2.contains(expr)) continue;
                    this.issue_load(expr2, method, linkedDeque2, linkedDeque, iterable, map);
                }
                if (expr.op == 0) {
                    if (bl) {
                        this.issue_load(expr, method, linkedDeque2, linkedDeque, iterable, map);
                    }
                    linkedDeque.addFirst(expr);
                    if (!iterable.contains(expr)) continue;
                    this.define(expr, iterable, conflictGraph);
                    continue;
                }
                if (iterable.contains(expr)) {
                    if (expr.op == 11) {
                        while (!arrayDeque2.isEmpty()) {
                            this.loadTOS(method, arrayDeque2, arrayDeque3, linkedDeque2, linkedDeque, iterable, map);
                        }
                    }
                    this.define(expr, iterable, conflictGraph);
                    if (bl) {
                        arrayDeque2.add((Expr)expr);
                    }
                    this.issue_store(expr, method, linkedDeque2, linkedDeque, arrayDeque2);
                    arrayDeque.add(expr);
                    continue;
                }
                if (expr.op == 11) {
                    if (!arrayDeque2.isEmpty()) {
                        while (!arrayDeque2.isEmpty()) {
                            this.loadTOS(method, arrayDeque2, arrayDeque3, linkedDeque2, linkedDeque, iterable, map);
                        }
                        arrayDeque.add(expr);
                        if (!bl) continue;
                        arrayDeque2.add((Expr)expr);
                        continue;
                    }
                    if (!bl) {
                        this.issue_pop(method, linkedDeque2, linkedDeque, expr);
                    }
                    linkedDeque.addFirst(expr);
                    continue;
                }
                if (!bl && expr.onStack()) {
                    this.issue_pop(method, linkedDeque2, linkedDeque, expr);
                }
                this.issue_expr(expr, method, linkedDeque2, linkedDeque, arrayDeque2, arrayDeque3, iterable, map);
            }
            this.fwd_state(method, map, setMap, setMap2, treeMap, treeMap2, priorityQueue, block, iterable, arrayDeque2, arrayDeque3, linkedDeque, linkedDeque2, treeSet);
        }
        System.out.println("SCHED LIVEOUT " + setMap2);
        System.out.println("SCHED STKOUT " + treeMap);
        System.out.println("SCHED CONFLICTS " + conflictGraph);
        for (Block block : deque) {
            System.out.println("");
            System.out.println(block);
            for (ArrayDeque arrayDeque2 : (Deque)hashMap.get(block)) {
                if (arrayDeque2 instanceof Expr) {
                    this.print((Expr)((Object)arrayDeque2));
                    continue;
                }
                System.out.println(arrayDeque2);
            }
        }
        return conflictGraph;
    }

    static boolean isThrowEdge(Edge edge) {
        return edge.handler != null;
    }

    void loadTOS(Method method, Deque<Expr> deque, Deque<Expr> deque2, Deque<Expr> deque3, Deque<Object> deque4, Set<Expr> set, Map<Integer, Integer> map) {
        this.showstate(set, deque, deque2, deque4);
        Expr expr = deque.removeLast();
        if (expr == deque.peekLast()) {
            this.issue_dup(expr, method, deque3, deque4);
        } else {
            this.issue_load(expr, method, deque3, deque4, set, map);
        }
    }

    void fwd_state(Method method, Map<Integer, Integer> map, SetMap<Block, Edge> setMap, SetMap<Block, Expr> setMap2, Map<Block, Deque<Expr>> map2, Map<Block, Deque<Expr>> map3, PriorityQueue<Block> priorityQueue, Block block, Set<Expr> set, Deque<Expr> deque, Deque<Expr> deque2, Deque<Object> deque3, Deque<Expr> deque4, Set<Expr> set2) {
        Collection<Expr> collection;
        Block block2;
        TreeMap<Block, Deque<Expr>> treeMap = new TreeMap<Block, Deque<Expr>>(map2);
        for (Edge edge : setMap.get(block)) {
            block2 = edge.from;
            collection = this.clone_stk(set2, deque, edge);
            if (!treeMap.containsKey(block2)) {
                treeMap.put(block2, (Deque<Expr>)collection);
                continue;
            }
            int n = this.stacks_equal((Deque<Expr>)collection, treeMap.get(block2));
            assert (deque.size() >= n);
            while (deque.size() > n) {
                this.loadTOS(method, deque, deque2, deque4, deque3, set, map);
            }
        }
        this.showstate(set, deque, deque2, deque3);
        for (Edge edge : setMap.get(block)) {
            block2 = edge.from;
            collection = this.clone_live(set2, set, edge);
            if (setMap2.get(block2).addAll(collection)) {
                priorityQueue.add(block2);
            }
            Deque<Expr> deque5 = this.clone_stk(set2, deque, edge);
            if (!map2.containsKey(block2)) {
                map2.put(block2, deque5);
                continue;
            }
            int n = this.stacks_equal(deque5, map2.get(block2));
            assert (deque5.size() == n && map2.get(block2).size() >= n);
            if (map2.get(block2).size() <= n) continue;
            map2.put(block2, deque5);
            priorityQueue.add(block2);
            for (Edge edge2 : block2.succ()) {
                if (edge2.to == block) continue;
                priorityQueue.add(edge2.to);
            }
        }
    }

    Set<Expr> clone_live(Set<Expr> set, Set<Expr> set2, Edge edge) {
        if (set.isEmpty() || set2.isEmpty()) {
            return set2;
        }
        TreeSet<Expr> treeSet = new TreeSet<Expr>();
        for (Expr expr : set2) {
            treeSet.add(set.contains(expr) ? expr.args[this.findPhiArg(expr, edge)] : expr);
        }
        return treeSet;
    }

    Deque<Expr> clone_stk(Set<Expr> set, Deque<Expr> deque, Edge edge) {
        if (set.isEmpty() || deque.isEmpty()) {
            return deque;
        }
        ArrayDeque<Expr> arrayDeque = new ArrayDeque<Expr>();
        for (Expr expr : deque) {
            arrayDeque.add(set.contains(expr) ? expr.args[this.findPhiArg(expr, edge)] : expr);
        }
        return arrayDeque;
    }

    int stacks_equal(Deque<Expr> deque, Deque<Expr> deque2) {
        int n = 0;
        Iterator iterator = deque.iterator();
        Iterator iterator2 = deque2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (iterator.next() != iterator2.next()) {
                return n;
            }
            ++n;
        }
        return n;
    }

    void define(Expr expr, Set<Expr> set, ConflictGraph conflictGraph) {
        set.remove(expr);
        for (Expr expr2 : set) {
            conflictGraph.add(expr, expr2);
        }
    }

    void issue_expr(Expr expr, Method method, Deque<Expr> deque, Deque<Object> deque2, Deque<Expr> deque3, Deque<Expr> deque4, Set<Expr> set, Map<Integer, Integer> map) {
        if (!expr.isSynthetic()) {
            deque.addFirst(expr);
        }
        deque2.addFirst(expr);
        for (Expr expr2 : expr.args) {
            deque3.add(expr2);
        }
        for (Expr expr2 : expr.locals) {
            this.use(expr2, set, map);
        }
        this.try_dup(deque3, method, deque, deque2);
    }

    void issue_store(Expr expr, Method method, Deque<Expr> deque, Deque<Object> deque2, Deque<Expr> deque3) {
        Expr expr2 = this.setlocal(method, expr.id, expr);
        deque.addFirst(expr2);
        deque2.addFirst(expr2);
        deque3.add(expr);
    }

    void issue_dup(Expr expr, Method method, Deque<Expr> deque, Deque<Object> deque2) {
        Expr expr2 = this.dup(method, expr);
        deque.addFirst(expr2);
        deque2.addFirst(expr2);
    }

    void issue_pop(Method method, Deque<Expr> deque, Deque<Object> deque2, Expr expr) {
        Expr expr2 = new Expr(method, 41, expr);
        deque.addFirst(expr2);
        deque2.addFirst(expr2);
    }

    void issue_load(Expr expr, Method method, Deque<Expr> deque, Deque<Object> deque2, Set<Expr> set, Map<Integer, Integer> map) {
        this.use(expr, set, map);
        Expr expr2 = this.getlocal(method, expr.id);
        deque.addFirst(expr2);
        deque2.addFirst(expr2);
    }

    void use(Expr expr, Set<Expr> set, Map<Integer, Integer> map) {
        set.add(expr);
        map.put(expr.id, expr.op == 0 ? expr.imm[0] : -1);
    }

    void rename(Expr expr, Expr[] exprArray, Map<Expr, Expr> map, EdgeMap<Expr> edgeMap) {
        for (Expr expr2 : exprArray) {
            while (map.containsKey(expr2)) {
                edgeMap.get(expr2).remove(expr);
                expr2 = exprArray[var5_5] = map.get(expr2);
                edgeMap.get(expr2).add(expr);
            }
        }
    }

    void cp(Deque<Block> deque) {
        EdgeMap<Expr> edgeMap = this.findUses(deque);
        HashMap<Expr, Expr> hashMap = new HashMap<Expr, Expr>();
        WorkSet<Expr> workSet = new WorkSet<Expr>();
        for (Comparable<Block> comparable : deque) {
            for (Expr expr : comparable) {
                if (expr.op != 10 && expr.op != 42) continue;
                workSet.add(expr);
            }
        }
        while (!workSet.isEmpty()) {
            Comparable<Block> comparable;
            Expr expr = this.remove((Set<Expr>)workSet);
            this.rename(expr, expr.args, hashMap, edgeMap);
            this.rename(expr, expr.scopes, hashMap, edgeMap);
            this.rename(expr, expr.locals, hashMap, edgeMap);
            if (expr.op == 42) {
                hashMap.put(expr, expr.locals[0]);
                workSet.addAll(edgeMap.get(expr));
                continue;
            }
            if (expr.op != 10) continue;
            assert (expr.args.length == expr.pred.length);
            for (int i = expr.pred.length - 1; i >= 0; --i) {
                if (deque.contains(expr.pred[i].from)) continue;
                expr.remove(i);
            }
            comparable = null;
            for (int i = expr.pred.length - 1; i >= 0; --i) {
                if (expr.args[i] == expr || expr.args[i] == comparable) continue;
                if (comparable == null) {
                    comparable = expr.args[i];
                    continue;
                }
                comparable = null;
                break;
            }
            if (comparable == null || hashMap.get(expr) == comparable) continue;
            hashMap.put(expr, (Expr)comparable);
            workSet.addAll(edgeMap.get(expr));
            expr.clearEffect();
        }
    }

    boolean hasSideEffect(Expr expr) {
        return expr.isPx() || expr.hasEffect();
    }

    void dfs_visit_el(Edge[] edgeArray, BitSet bitSet, Deque<Block> deque) {
        for (int i = edgeArray.length - 1; i >= 0; --i) {
            this.dfs_visit(edgeArray[i].to, bitSet, deque);
        }
    }

    Deque<Block> dfs_visit(Block block, BitSet bitSet, Deque<Block> deque) {
        if (!bitSet.get(block.id)) {
            bitSet.set(block.id);
            this.dfs_visit_el(block.xsucc, bitSet, deque);
            this.dfs_visit_el(block.succ(), bitSet, deque);
            block.postorder = deque.size();
            deque.addFirst(block);
        }
        return deque;
    }

    Deque<Block> dfs(Block block) {
        return this.dfs_visit(block, new BitSet(), new LinkedDeque<Block>());
    }

    void schedule_loop(Block block, EdgeMap<Block> edgeMap, Deque<Block> deque) {
        Set<Block> set = edgeMap.get(block);
        for (Block block2 : this.dfs(block)) {
            if (deque.contains(block2) || !set.contains(block2)) continue;
            deque.add(block2);
            if (!edgeMap.containsKey(block2)) continue;
            this.schedule_loop(block2, edgeMap, deque);
        }
    }

    Deque<Block> schedule(Block block) {
        Deque<Block> deque = this.dfs(block);
        ArrayDeque<Block> arrayDeque = new ArrayDeque<Block>();
        SetMap<Block, Edge> setMap = this.preds(deque);
        Map<Block, Block> map = this.idoms(deque, setMap);
        EdgeMap<Block> edgeMap = this.findLoops(deque, map, setMap);
        if (!edgeMap.isEmpty()) {
            System.out.println("LOOPS " + edgeMap);
        }
        for (Comparable<Block> comparable : deque) {
            if (!arrayDeque.contains(comparable)) {
                arrayDeque.add((Block)comparable);
            }
            if (!edgeMap.containsKey(comparable)) continue;
            this.schedule_loop((Block)comparable, edgeMap, (Deque<Block>)arrayDeque);
        }
        deque.clear();
        deque.addAll(arrayDeque);
        while (deque.size() > 1) {
            Comparable<Block> comparable;
            Block block2 = deque.removeFirst();
            comparable = block2.last();
            Block block3 = deque.peekFirst();
            if (!this.isBranch((Expr)comparable) || ((Expr)comparable).succ[0].to == block3 || ((Expr)comparable).succ[1].to != block3) continue;
            this.invert((Expr)comparable);
        }
        return arrayDeque;
    }

    boolean isJump(Expr expr) {
        return expr.op == 16;
    }

    boolean isBranch(Expr expr) {
        return expr.succ != null && expr.succ.length == 2 && expr.op != 27;
    }

    Block intersect(Block block, Block block2, Block[] blockArray) {
        while (block != block2) {
            while (block.postorder < block2.postorder) {
                block = blockArray[block.postorder];
            }
            while (block2.postorder < block.postorder) {
                block2 = blockArray[block2.postorder];
            }
        }
        return block;
    }

    Map<Block, Block> idoms(Deque<Block> deque, SetMap<Block, Edge> setMap) {
        boolean bl;
        Block block = deque.peekFirst();
        Block[] blockArray = new Block[block.postorder + 1];
        blockArray[block.postorder] = block;
        do {
            bl = false;
            for (Block object : deque) {
                Block block2;
                if (object == block) continue;
                Block block3 = null;
                for (Edge edge : setMap.get(object)) {
                    block2 = edge.from;
                    if (blockArray[block2.postorder] == null) continue;
                    block3 = block2;
                    break;
                }
                for (Edge edge : setMap.get(object)) {
                    block2 = edge.from;
                    if (block2 == block3 || blockArray[block2.postorder] == null) continue;
                    block3 = this.intersect(block2, block3, blockArray);
                }
                if (blockArray[object.postorder] == block3) continue;
                blockArray[object.postorder] = block3;
                bl = true;
            }
        } while (bl);
        TreeMap treeMap = new TreeMap();
        for (Block block3 : deque) {
            if (block3 == block) continue;
            treeMap.put(block3, blockArray[block3.postorder]);
        }
        return treeMap;
    }

    boolean dominates(Block block, Block block2, Map<Block, Block> map) {
        Block block3 = block2;
        while (block3 != null) {
            if (block3 == block) {
                return true;
            }
            block3 = map.get(block3);
        }
        return false;
    }

    boolean isLoop(Edge edge, Map<Block, Block> map) {
        return edge.from.postorder < edge.to.postorder && this.dominates(edge.to, edge.from, map);
    }

    Block remove(Set<Block> set) {
        Iterator<Block> iterator = set.iterator();
        Block block = iterator.next();
        iterator.remove();
        return block;
    }

    Expr remove(Set<Expr> set) {
        Iterator<Expr> iterator = set.iterator();
        Expr expr = iterator.next();
        iterator.remove();
        return expr;
    }

    Edge remove(Set<Edge> set) {
        Iterator<Edge> iterator = set.iterator();
        Edge edge = iterator.next();
        iterator.remove();
        return edge;
    }

    Method remove(List<Method> list) {
        return list.remove(list.size() - 1);
    }

    EdgeMap<Block> findLoops(Deque<Block> deque) {
        SetMap<Block, Edge> setMap = this.preds(deque);
        return this.findLoops(deque, this.idoms(deque, setMap), setMap);
    }

    EdgeMap<Block> findLoops(Deque<Block> deque, Map<Block, Block> map, SetMap<Block, Edge> setMap) {
        EdgeMap<Block> edgeMap = new EdgeMap<Block>();
        for (Block block : deque) {
            for (Edge edge : block.succ()) {
                if (!this.isLoop(edge, map)) continue;
                System.out.println("backedge " + edge);
                Block block2 = edge.to;
                Set<Block> set = edgeMap.get(block2);
                WorkSet<Block> workSet = new WorkSet<Block>();
                for (Edge edge2 : setMap.get(block2)) {
                    if (!this.isLoop(edge2, map) || set.contains(edge2.from) || edge2.from == block2) continue;
                    set.add(edge2.from);
                    workSet.add(edge2.from);
                }
                while (!workSet.isEmpty()) {
                    Block block3 = this.remove((Set<Block>)workSet);
                    for (Edge edge3 : setMap.get(block3)) {
                        if (edge3.from == block2 || set.contains(edge3.from)) continue;
                        set.add(edge3.from);
                        workSet.add(edge3.from);
                    }
                }
            }
        }
        return edgeMap;
    }

    void dce_mark(BitSet bitSet, Expr expr) {
        if (bitSet.get(expr.id)) {
            return;
        }
        bitSet.set(expr.id);
        for (Expr expr2 : expr.args) {
            this.dce_mark(bitSet, expr2);
        }
        for (Expr expr2 : expr.scopes) {
            this.dce_mark(bitSet, expr2);
        }
        for (Expr expr2 : expr.locals) {
            this.dce_mark(bitSet, expr2);
        }
    }

    void dce(Method method) {
        Deque<Block> deque = this.dfs(method.entry.to);
        this.cp(deque);
        BitSet bitSet = new BitSet();
        for (Block block : deque) {
            for (Expr expr : block) {
                if (!this.hasSideEffect(expr)) continue;
                this.dce_mark(bitSet, expr);
            }
        }
        for (Block block : deque) {
            Iterator<Expr> iterator = block.iterator();
            while (iterator.hasNext()) {
                if (bitSet.get(iterator.next().id)) continue;
                iterator.remove();
            }
        }
    }

    String format(char c, Object[] objectArray, char c2) {
        if (objectArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        for (Object object : objectArray) {
            stringBuilder.append(object).append(' ');
        }
        if (objectArray.length > 0) {
            stringBuilder.setCharAt(stringBuilder.length() - 1, c2);
        } else {
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    static boolean isSlot(Binding binding) {
        if (binding == null) {
            return false;
        }
        int n = binding.kind();
        return n == 0 || n == 6 || n == 4;
    }

    static boolean isConst(Binding binding) {
        if (binding == null) {
            return false;
        }
        int n = binding.kind();
        return n == 6 || n == 2;
    }

    static boolean isClass(Binding binding) {
        if (binding == null) {
            return false;
        }
        int n = binding.kind();
        return n == 4;
    }

    boolean isMethod(Binding binding) {
        if (binding == null) {
            return false;
        }
        int n = binding.kind();
        return n == 1;
    }

    boolean isGetter(Binding binding) {
        if (binding == null) {
            return false;
        }
        int n = binding.kind();
        return n == 2;
    }

    boolean isSetter(Binding binding) {
        if (binding == null) {
            return false;
        }
        int n = binding.kind();
        return n == 3;
    }

    static boolean isLive(int n, Method method, int n2) {
        return n < n2 || n >= method.local_count + method.max_scope;
    }

    Block createBlock(Method method, Edge edge, Map<Block, FrameState> map, Expr[] exprArray, int n, int n2) {
        Block block = new Block(method);
        FrameState frameState = new FrameState(exprArray, n, n2);
        if (edge != null) {
            edge.to = block;
        }
        for (int i = 0; i < n; ++i) {
            if (!GlobalOptimizer.isLive(i, method, n2) || exprArray[i] == null) continue;
            Expr expr = new Expr(method, 10);
            if (edge != null) {
                expr.args = new Expr[]{exprArray[i]};
                expr.pred = new Edge[]{edge};
            }
            frameState.frame[i] = expr;
            block.add(frameState.frame[i]);
        }
        map.put(block, frameState);
        return block;
    }

    void merge(Method method, Edge edge, Map<Integer, Block> map, Map<Block, FrameState> map2, int n, Expr[] exprArray, int n2, int n3) {
        if (!map.containsKey(n)) {
            Block block = this.createBlock(method, edge, map2, exprArray, n2, n3);
            map.put(n, block);
        } else if (edge != null) {
            edge.to = map.get(n);
            this.merge(method, edge, map2, exprArray, n2, n3);
        }
    }

    void merge(Method method, Edge edge, Map<Block, FrameState> map, Expr[] exprArray, int n, int n2) {
        FrameState frameState = map.get(edge.to);
        assert (frameState.sp == n);
        assert (frameState.scopep == n2);
        for (int i = 0; i < n; ++i) {
            if (!GlobalOptimizer.isLive(i, method, n2) || exprArray[i] == frameState.frame[i]) continue;
            assert (exprArray[i] != null && frameState.frame[i].op == 10);
            frameState.frame[i].append(exprArray[i], edge);
        }
    }

    void xmerge(Method method, Edge edge, Map<Integer, Block> map, Map<Block, FrameState> map2, int n, Expr[] exprArray, int n2, int n3) {
        n3 = method.local_count;
        n2 = n3 + method.max_scope;
        Handler handler = edge.handler;
        if (handler.entry == null) {
            Block block = handler.entry = this.createBlock(method, edge, map2, exprArray, n2, n3);
            Expr expr = new Expr(method, 11, edge.label);
            block.add(expr);
            Expr expr2 = new Expr(method, 16);
            block.add(expr2);
            expr2.succ = new Edge[]{new Edge(method, block, 0, map.get(n))};
            Expr expr3 = exprArray[n2];
            exprArray[n2] = expr;
            this.merge(method, expr2.succ[0], map, map2, n, exprArray, n2 + 1, n3);
            exprArray[n2] = expr3;
        } else {
            edge.to = handler.entry;
            this.merge(method, edge, map2, exprArray, n2, n3);
        }
    }

    static Expr[] capture(Expr[] exprArray, int n, int n2) {
        Expr[] exprArray2 = new Expr[n2];
        System.arraycopy(exprArray, n - n2, exprArray2, 0, n2);
        return exprArray2;
    }

    boolean isPx(int n) {
        return (flagTable[n] & 8) != 0;
    }

    void print(Expr expr) {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.printssa(expr, printWriter);
        printWriter.flush();
    }

    void printabc(Expr expr, PrintWriter printWriter) {
        printWriter.print("    " + opNames[expr.op]);
        if (expr.imm != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('<');
            for (int n : expr.imm) {
                stringBuilder.append(n).append(',');
            }
            stringBuilder.setCharAt(stringBuilder.length() - 1, '>');
            printWriter.print(stringBuilder);
        }
        if (expr.succ != null) {
            printWriter.print(this.format('[', expr.succ, ']'));
        }
        if (expr.value != null) {
            printWriter.print(" ");
            this.print(expr.value, printWriter);
        }
        if (expr.ref != null) {
            printWriter.print(" " + expr.ref);
        }
        printWriter.println();
    }

    void printssa(Expr expr, PrintWriter printWriter) {
        printWriter.print(expr);
        if (expr.onStack() || expr.inLocal() || expr.onScope()) {
            printWriter.print(" =");
        } else {
            printWriter.print("  ");
        }
        if (expr.value == null) {
            printWriter.print(" " + opNames[expr.op]);
        }
        if (expr.imm != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('<');
            for (int n : expr.imm) {
                stringBuilder.append(n).append(',');
            }
            stringBuilder.setCharAt(stringBuilder.length() - 1, '>');
            printWriter.print(stringBuilder);
        }
        if (expr.args.length > 0) {
            printWriter.print(this.format('(', expr.args, ')'));
        }
        if (expr.locals.length > 0) {
            printWriter.print(this.format('(', expr.locals, ')'));
        }
        if (expr.scopes.length > 0) {
            printWriter.print(this.format('{', expr.scopes, '}'));
        }
        if (expr.pred.length > 0) {
            printWriter.print(this.format('[', expr.pred, ']'));
        }
        if (expr.succ != null) {
            printWriter.print(this.format('[', expr.succ, ']'));
        }
        if (expr.value != null) {
            this.print(expr.value, printWriter);
        }
        if (expr.ref != null) {
            printWriter.print(" " + expr.ref);
        }
        printWriter.println();
    }

    void print(Object object, PrintWriter printWriter) {
        if (object instanceof String) {
            printWriter.print(" \"" + ((String)object).replace("\n", "\\n").replace("\r", "\\r") + "\"");
        } else {
            printWriter.print(" " + object);
        }
    }

    void print(Deque<Block> deque) {
        System.out.println(deque);
        PrintWriter printWriter = new PrintWriter(System.out);
        for (Block block : deque) {
            this.print(block, printWriter);
        }
        printWriter.flush();
    }

    void printabc(Deque<Block> deque) {
        System.out.println(deque);
        PrintWriter printWriter = new PrintWriter(System.out);
        for (Block block : deque) {
            this.printabc(block, printWriter);
        }
        printWriter.flush();
    }

    void print(Block block, PrintWriter printWriter) {
        printWriter.println();
        this.printssa(block, printWriter);
    }

    void printabc(Block block, PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(block);
        if (block.xsucc.length > 0) {
            printWriter.println(Arrays.toString(block.xsucc));
        }
        for (Expr expr : block) {
            this.printabc(expr, printWriter);
        }
    }

    void printssa(Block block, PrintWriter printWriter) {
        printWriter.println(block);
        if (block.xsucc.length > 0) {
            printWriter.println(Arrays.toString(block.xsucc));
        }
        for (Expr expr : block) {
            this.printssa(expr, printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dot(String string, Method method) {
        if (method.entry.to.succ().length == 0) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(method.name + string + ".dot"));
            try {
                Deque<Block> deque = this.dfs(method.entry.to);
                printWriter.println("digraph {");
                printWriter.println("compound=true;");
                printWriter.println("label=\"" + method.name + string + "\";");
                printWriter.println("labelloc=top;");
                printWriter.println("fontsize=10;");
                printWriter.println("ranksep=.25; nodesep=.25;");
                printWriter.println("node [shape=box,width=.1,height=.1,fontsize=7];");
                printWriter.println("edge [arrowsize=.5,fontsize=8,labelfontsize=8];");
                for (Block object : deque) {
                    this.dot(object, printWriter);
                }
                Map<Block, Block> map = this.idoms(deque, this.allpreds(deque));
                printWriter.println("node [shape=box];");
                printWriter.println("subgraph cluster1 { label=\"Dominators\"; color=white; ");
                for (Block block : this.dfs(method.entry.to)) {
                    printWriter.println("D" + block + " [label=" + block + "];");
                    if (!map.containsKey(block)) continue;
                    printWriter.println("D" + map.get(block) + " -> D" + block);
                }
                printWriter.println("}");
                printWriter.println("}");
            }
            finally {
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    void dot(Block block, PrintWriter printWriter) {
        LabelWriter labelWriter = new LabelWriter(new StringWriter());
        labelWriter.print(block);
        String string = "label=\"" + labelWriter + "\"";
        printWriter.println(block + " [" + string + "];");
        for (Edge edge : block.succ()) {
            this.dot(edge, printWriter);
        }
        for (Edge edge : block.xsucc) {
            this.dot(edge, printWriter);
        }
    }

    void dot_dfg(Block block, PrintWriter printWriter) {
        LabelWriter labelWriter = new LabelWriter(new StringWriter());
        labelWriter.print(block);
        String string = "label=\"" + labelWriter + "\"; labeljust=l";
        printWriter.println("subgraph cluster" + block + " { " + string + ";");
        Expr expr = null;
        Iterator<Expr> iterator = block.iterator();
        if (iterator.hasNext()) {
            expr = iterator.next();
        }
        while (expr != null) {
            Edge[] edgeArray = expr;
            labelWriter = new LabelWriter(new StringWriter());
            this.printssa((Expr)edgeArray, (PrintWriter)labelWriter);
            printWriter.print("E" + edgeArray.id + " [label=\"" + labelWriter + "\"];");
            if (iterator.hasNext()) {
                expr = iterator.next();
                printWriter.print("E" + edgeArray.id + " -> E" + expr.id + " [style=invisible,arrowhead=none,weight=4];");
                continue;
            }
            expr = null;
        }
        printWriter.println("}");
        for (Expr expr2 : block) {
            for (Expr expr3 : expr2.args) {
                printWriter.print("E" + expr3.id + " -> E" + expr2.id + " [color=green];");
            }
            for (Expr n : expr2.locals) {
                printWriter.print("E" + n.id + " -> E" + expr2.id + " [color=green];");
            }
            for (Expr expr4 : expr2.scopes) {
                printWriter.print("E" + expr4.id + " -> E" + expr2.id + " [color=grey,style=dashed];");
            }
            if (!expr2.isPx()) continue;
            for (Comparable<Expr> comparable : block.xsucc) {
                printWriter.print("E" + expr2.id + " -> E" + ((Edge)comparable).to.first().id + " [weight=2,style=dashed,color=red];");
            }
        }
        for (Edge edge : block.succ()) {
            Expr expr3 = block.last();
            int n = edge == block.last().succ[0] ? 4 : 2;
            printWriter.print("E" + expr3.id + " -> E" + edge.to.first().id + " [weight=" + n + "];");
        }
    }

    void dot(Edge edge, PrintWriter printWriter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (GlobalOptimizer.isThrowEdge(edge)) {
            arrayList.add("style=dashed");
        } else {
            if (edge.from.postorder < edge.to.postorder) {
                arrayList.add("tailport=w,headport=w");
            }
            if (edge.label == 0) {
                arrayList.add("weight=2");
            } else {
                arrayList.add("taillabel=\"" + edge.label + "\"");
            }
        }
        printWriter.println(edge.from + " -> " + edge.to + " " + arrayList + ";");
    }

    static {
        UNDEFINED = new Object(){

            public String toString() {
                return "undefined";
            }
        };
        BOTTOM = new Object(){

            public String toString() {
                return "?";
            }
        };
        NAN = Double.NaN;
        PUBLIC = new Namespace("");
        PKG_PUBLIC = new Namespace(22, "");
        AS3 = new Namespace("http://adobe.com/AS3/2006/builtin");
        AS3_TOSTRING = new Name(AS3, "toString");
        nometadata = new Metadata[0];
        noexprs = new Expr[0];
        noedges = new Edge[0];
        notypes = new Type[0];
        notyperefs = new Typeref[0];
        refArgc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1};
        flagTable = new int[]{144, 2, 0, 8, 74, 10, 10, 10, 128, 2, 16, 80, 10, 10, 10, 10, 2, 2, 2, 10, 10, 10, 10, 10, 10, 2, 2, 10, 40, 2, 72, 72, 64, 64, 0, 72, 64, 64, 64, 64, 64, 2, 66, 2, 64, 64, 64, 64, 40, 64, 72, 144, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 74, 74, 74, 74, 74, 74, 10, 10, 10, 74, 0, 74, 0, 10, 10, 0, 0, 0, 0, 0, 64, 64, 64, 74, 72, 64, 0, 0, 72, 74, 64, 74, 10, 66, 2, 64, 64, 74, 0, 10, 0, 74, 0, 72, 10, 72, 10, 75, 75, 75, 75, 75, 75, 65, 73, 8, 0, 0, 0, 0, 0, 0, 0, 79, 69, 69, 79, 79, 79, 75, 75, 79, 77, 0, 0, 0, 0, 0, 0, 75, 75, 139, 75, 139, 65, 65, 75, 0, 0, 0, 0, 0, 0, 0, 0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 65, 75, 75, 75, 75, 75, 75, 73, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 75, 139, 139, 75, 75, 75, 75, 0, 0, 0, 0, 0, 0, 0, 0, 66, 66, 66, 66, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 2, 2, 2, 2, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
        opNames = new String[]{"arg", "bkpt", "nop", "throw", "getsuper", "setsuper", "dxns", "dxnslate", "kill", "label", "phi", "xarg", "ifnlt", "ifnle", "ifngt", "ifnge", "jump", "iftrue", "iffalse", "ifeq", "ifne", "iflt", "ifle", "ifgt", "ifge", "ifstricteq", "ifstrictne", "lookupswitch", "pushwith", "popscope", "nextname", "hasnext", "pushnull", "pushundefined", "OP_0x22", "nextvalue", "pushbyte", "pushshort", "pushtrue", "pushfalse", "pushnan", "pop", "dup", "swap", "pushstring", "pushint", "pushuint", "pushdouble", "pushscope", "pushnamespace", "hasnext2", "hasnext2_i", "hasnext2_o", "OP_0x35", "OP_0x36", "OP_0x37", "OP_0x38", "OP_0x39", "OP_0x3A", "OP_0x3B", "OP_0x3C", "OP_0x3D", "OP_0x3E", "OP_0x3F", "newfunction", "call", "construct", "callmethod", "callstatic", "callsuper", "callproperty", "returnvoid", "returnvalue", "constructsuper", "constructprop", "OP_0x4B", "callproplex", "OP_0x4D", "callsupervoid", "callpropvoid", "OP_0x50", "OP_0x51", "OP_0x52", "OP_0x53", "OP_0x54", "newobject", "newarray", "newactivation", "newclass", "getdescendants", "newcatch", "OP_0x5B", "OP_0x5C", "findpropstrict", "findproperty", "finddef", "getlex", "setproperty", "getlocal", "setlocal", "getglobalscope", "getscopeobject", "getproperty", "OP_0x67", "initproperty", "OP_0x69", "deleteproperty", "OP_0x6B", "getslot", "setslot", "getglobalslot", "setglobalslot", "convert_s", "esc_xelem", "esc_xattr", "convert_i", "convert_u", "convert_d", "convert_b", "convert_o", "checkfilter", "OP_0x79", "OP_0x7A", "OP_0x7B", "OP_0x7C", "OP_0x7D", "OP_0x7E", "OP_0x7F", "coerce", "coerce_b", "coerce_a", "coerce_i", "coerce_d", "coerce_s", "astype", "astypelate", "coerce_u", "coerce_o", "OP_0x8A", "OP_0x8B", "OP_0x8C", "OP_0x8D", "OP_0x8E", "OP_0x8F", "negate", "increment", "inclocal", "decrement", "declocal", "typeof", "not", "bitnot", "OP_0x98", "OP_0x99", "OP_0x9A", "OP_0x9B", "OP_0x9C", "OP_0x9D", "OP_0x9E", "OP_0x9F", "add", "subtract", "multiply", "divide", "modulo", "lshift", "rshift", "urshift", "bitand", "bitor", "bitxor", "equals", "strictequals", "lessthan", "lessequals", "greaterthan", "greaterequals", "instanceof", "istype", "istypelate", "in", "OP_0xB5", "OP_0xB6", "OP_0xB7", "OP_0xB8", "OP_0xB9", "OP_0xBA", "OP_0xBB", "OP_0xBC", "OP_0xBD", "OP_0xBE", "OP_0xBF", "increment_i", "decrement_i", "inclocal_i", "declocal_i", "negate_i", "add_i", "subtract_i", "multiply_i", "OP_0xC8", "OP_0xC9", "OP_0xCA", "OP_0xCB", "OP_0xCC", "OP_0xCD", "OP_0xCE", "OP_0xCF", "getlocal0", "getlocal1", "getlocal2", "getlocal3", "setlocal0", "setlocal1", "setlocal2", "setlocal3", "OP_0xD8", "OP_0xD9", "OP_0xDA", "OP_0xDB", "OP_0xDC", "OP_0xDD", "OP_0xDE", "OP_0xDF", "OP_0xE0", "OP_0xE1", "OP_0xE2", "OP_0xE3", "OP_0xE4", "OP_0xE5", "OP_0xE6", "OP_0xE7", "OP_0xE8", "OP_0xE9", "OP_0xEA", "OP_0xEB", "OP_0xEC", "OP_0xED", "OP_0xEE", "debug", "debugline", "debugfile", "bkptline", "timestamp", "OP_0xF4", "OP_0xF5", "OP_0xF6", "OP_0xF7", "OP_0xF8", "OP_0xF9", "OP_0xFA", "OP_0xFB", "OP_0xFC", "OP_0xFD", "OP_0xFE", "OP_0xFF"};
    }

    class AbcWriter
    extends ByteArrayOutputStream {
        AbcWriter() {
        }

        void rewind(int n) {
            this.count -= n;
        }

        void writeU16(int n) {
            this.write(n);
            this.write(n >> 8);
        }

        void writeS24(int n) {
            this.writeU16(n);
            this.write(n >> 16);
        }

        void write64(long l) {
            this.writeS24((int)l);
            this.writeS24((int)(l >> 24));
            this.writeU16((int)(l >> 48));
        }

        void writeU30(int n) {
            if (n < 128 && n >= 0) {
                this.write(n);
            } else if (n < 16384 && n >= 0) {
                this.write(n & 0x7F | 0x80);
                this.write(n >> 7);
            } else if (n < 0x200000 && n >= 0) {
                this.write(n & 0x7F | 0x80);
                this.write(n >> 7 | 0x80);
                this.write(n >> 14);
            } else if (n < 0x10000000 && n >= 0) {
                this.write(n & 0x7F | 0x80);
                this.write(n >> 7 | 0x80);
                this.write(n >> 14 | 0x80);
                this.write(n >> 21);
            } else {
                this.write(n & 0x7F | 0x80);
                this.write(n >> 7 | 0x80);
                this.write(n >> 14 | 0x80);
                this.write(n >> 21 | 0x80);
                this.write(n >> 28);
            }
        }
    }

    class Reader {
        int pos;
        byte[] abc;

        Reader(int n, byte[] byArray) {
            this.pos = n;
            this.abc = byArray;
        }

        Reader(Reader reader) {
            this(reader.pos, reader.abc);
        }

        int readU8() {
            return 0xFF & this.abc[this.pos++];
        }

        int readU16() {
            return this.readU8() | this.readU8() << 8;
        }

        int readS24() {
            return this.readU16() | (byte)this.readU8() << 16;
        }

        int readU30() {
            int n = this.readU8();
            if (0 == (n & 0x80)) {
                return n;
            }
            if (0 == ((n = n & 0x7F | this.readU8() << 7) & 0x4000)) {
                return n;
            }
            if (0 == ((n = n & 0x3FFF | this.readU8() << 14) & 0x200000)) {
                return n;
            }
            if (0 == ((n = n & 0x1FFFFF | this.readU8() << 21) & 0x10000000)) {
                return n;
            }
            return n & 0xFFFFFFF | this.readU8() << 28;
        }

        double readDouble() {
            return Double.longBitsToDouble((long)this.readU16() | (long)this.readU16() << 16 | (long)this.readU16() << 32 | (long)this.readU16() << 48);
        }
    }

    static class LabelWriter
    extends PrintWriter {
        StringWriter w;

        LabelWriter(StringWriter stringWriter) {
            super(stringWriter);
            this.w = stringWriter;
        }

        public void println() {
            this.print("\\l");
            this.flush();
        }

        public void print(String string) {
            super.print(string.replace("\"", "''").replace("\u0278", "&phi;"));
        }

        public String toString() {
            return this.w.toString();
        }
    }

    static class FrameState {
        Expr[] frame;
        int sp;
        int scopep;

        public FrameState(Expr[] exprArray, int n, int n2) {
            this.frame = new Expr[exprArray.length];
            this.sp = n;
            this.scopep = n2;
        }
    }

    class Type {
        Name name;
        Type base;
        Type[] interfaces = notypes;
        Symtab<Binding> defs;
        Method init;
        Type itype;
        int flags;
        Namespace protectedNs;
        Typeref[] scopes = notyperefs;
        boolean numeric;
        boolean primitive;
        boolean atom;
        Object defaultValue;
        Typeref ref;
        int size;
        int slotCount;

        Type() {
            this.defaultValue = GlobalOptimizer.this.NULL;
            this.ref = new Typeref(this, true);
        }

        Type(Name name, Type type) {
            this();
            this.name = name;
            this.base = type;
            this.defs = new Symtab();
        }

        public String toString() {
            return String.valueOf(this.name);
        }

        boolean isFinal() {
            return (this.flags & 2) != 0;
        }

        Binding find(Name name) {
            Type type = this;
            while (type != null) {
                Binding binding = type.defs.get(name);
                if (binding != null) {
                    return binding;
                }
                type = type.base;
            }
            return null;
        }

        Binding findSlot(int n) {
            for (Binding binding : this.defs.values()) {
                if (!GlobalOptimizer.isSlot(binding) || binding.slot != n) continue;
                return binding;
            }
            return null;
        }

        boolean hasProtectedNs() {
            return (this.flags & 8) != 0;
        }
    }

    class Typeref {
        final Type t;
        final boolean nullable;

        Typeref(Type type, boolean bl) {
            assert (type != null);
            this.t = type;
            this.nullable = bl;
        }

        Typeref nonnull() {
            return this.nullable ? new Typeref(this.t, false) : this;
        }

        public boolean equals(Object object) {
            return object instanceof Typeref && ((Typeref)object).t == this.t && ((Typeref)object).nullable == this.nullable;
        }

        Binding find(Name name) {
            return this.t.find(name);
        }

        public String toString() {
            return !this.t.ref.nullable || this.t == GlobalOptimizer.this.NULL || this.t == GlobalOptimizer.this.VOID || this.t == GlobalOptimizer.this.ANY ? this.t.toString() : (this.nullable ? this.t.toString() + "?" : this.t.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Expr
    implements Comparable<Expr>,
    Indexable {
        int op;
        Expr[] args = noexprs;
        Expr[] scopes = noexprs;
        Expr[] locals = noexprs;
        int[] imm;
        Edge[] pred = noedges;
        Edge[] succ;
        int id;
        int flags;
        Name ref;
        Object value;
        Type c;
        Method m;

        Expr(Method method, int n) {
            this.op = n;
            this.flags = flagTable[n];
            this.id = method.exprId++;
        }

        Expr(Method method, int n, int n2) {
            this(method, n);
            this.imm = new int[]{n2};
        }

        Expr(Method method, int n, Object object) {
            this(method, n);
            this.value = object;
        }

        Expr(Method method, int n, Expr expr) {
            this(method, n);
            this.args = new Expr[]{expr};
        }

        Expr(Method method, int n, Expr[] exprArray, int n2, int n3) {
            this(method, n);
            this.args = GlobalOptimizer.capture(exprArray, n2, n3);
        }

        Expr(Method method, int n, int n2, Expr[] exprArray, int n3, int n4) {
            this(method, n, exprArray, n3, n4);
            this.imm = new int[]{n2};
        }

        Expr(Method method, int n, Name name, Expr[] exprArray, int n2, int n3) {
            this(method, n, exprArray, n2, n3);
            this.ref = name;
        }

        Expr(Method method, int n, Name name, Expr expr) {
            this(method, n);
            this.ref = name;
            this.args = new Expr[]{expr};
        }

        @Override
        public int id() {
            return this.id;
        }

        void append(Expr expr, Edge edge) {
            this.args = GlobalOptimizer.copyOf(this.args, this.args.length + 1);
            this.args[this.args.length - 1] = expr;
            this.pred = GlobalOptimizer.copyOf(this.pred, this.pred.length + 1);
            this.pred[this.pred.length - 1] = edge;
        }

        void remove(int n) {
            Expr[] exprArray = new Expr[this.args.length - 1];
            System.arraycopy(this.args, 0, exprArray, 0, n);
            System.arraycopy(this.args, n + 1, exprArray, n, this.args.length - n - 1);
            this.args = exprArray;
            Edge[] edgeArray = new Edge[this.pred.length - 1];
            System.arraycopy(this.pred, 0, edgeArray, 0, n);
            System.arraycopy(this.pred, n + 1, edgeArray, n, this.pred.length - n - 1);
            this.pred = edgeArray;
        }

        public String toString() {
            return (this.onStack() ? "t" : (this.onScope() ? "s" : (this.inLocal() ? "l" : "i"))) + this.id;
        }

        void clearEffect() {
            this.flags &= 0xFFFFFFFD;
        }

        void clearPx() {
            this.flags &= 0xFFFFFFF7;
        }

        void setPure() {
            this.clearEffect();
            this.clearPx();
        }

        boolean hasEffect() {
            return (this.flags & 2) != 0;
        }

        boolean isPx() {
            return (this.flags & 8) != 0;
        }

        boolean isSynthetic() {
            return (this.flags & 0x10) != 0;
        }

        boolean onStack() {
            return (flagTable[this.op] & 0x40) != 0;
        }

        boolean isOper() {
            return (flagTable[this.op] & 1) != 0;
        }

        boolean onScope() {
            return (flagTable[this.op] & 0x20) != 0;
        }

        boolean inLocal() {
            return (flagTable[this.op] & 0x80) != 0;
        }

        boolean isCoerce() {
            return (flagTable[this.op] & 4) != 0;
        }

        @Override
        public int compareTo(Expr expr) {
            assert (this.id != expr.id || this == expr);
            return this.id - expr.id;
        }
    }

    static interface Indexable {
        public int id();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Block
    implements Iterable<Expr>,
    Comparable<Block>,
    Indexable {
        Deque<Expr> exprs = new ArrayDeque<Expr>();
        int id;
        int postorder;
        Edge[] xsucc = noedges;

        Block(Method method) {
            this.id = method.blockId++;
        }

        @Override
        public int id() {
            return this.id;
        }

        public String toString() {
            return 'B' + String.valueOf(this.id);
        }

        Expr first() {
            return this.exprs.peekFirst();
        }

        Expr last() {
            return this.exprs.peekLast();
        }

        Edge[] succ() {
            return this.last().succ;
        }

        @Override
        public Iterator<Expr> iterator() {
            return this.exprs.iterator();
        }

        void add(Expr expr) {
            this.exprs.add(expr);
        }

        void addAll(Block block) {
            this.exprs.addAll(block.exprs);
        }

        boolean isEmpty() {
            return this.exprs.isEmpty();
        }

        int size() {
            return this.exprs.size();
        }

        void remove(Expr expr) {
            this.exprs.remove(expr);
        }

        @Override
        public int compareTo(Block block) {
            return this.id - block.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConflictGraph {
        Map<Integer, Set<Integer>> conflicts = new TreeMap<Integer, Set<Integer>>();

        ConflictGraph() {
        }

        void add(Expr expr, Expr expr2) {
            this.get(expr.id).add(expr2.id);
            this.get(expr2.id).add(expr.id);
        }

        boolean contains(Expr expr, Expr expr2) {
            return this.conflicts.containsKey(expr.id) && this.conflicts.get(expr.id).contains(expr2.id);
        }

        public String toString() {
            return String.valueOf(this.conflicts);
        }

        Set<Integer> get(int n) {
            Set<Integer> set = this.conflicts.get(n);
            if (set == null) {
                set = new TreeSet<Integer>();
                this.conflicts.put(n, set);
            }
            return set;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LinkedDeque<E>
    extends LinkedList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        LinkedDeque() {
        }

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.getFirst();
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.getLast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayDeque<E>
    extends ArrayList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        ArrayDeque() {
        }

        ArrayDeque(Collection<E> collection) {
            this.addAll(collection);
        }

        @Override
        public void addFirst(E e) {
            this.add(0, e);
        }

        @Override
        public E removeFirst() {
            return this.remove(0);
        }

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.get(0);
        }

        @Override
        public E removeLast() {
            return this.remove(this.size() - 1);
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.get(this.size() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Deque<E>
    extends List<E> {
        @Override
        public E removeFirst();

        public E peekFirst();

        @Override
        public E removeLast();

        public E peekLast();

        @Override
        public void addFirst(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WorkSet<E extends Indexable>
    extends TreeSet<E> {
        static final long serialVersionUID = 0L;

        WorkSet() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EdgeMap<E extends Indexable>
    extends SetMap<E, E> {
        static final long serialVersionUID = 0L;

        EdgeMap() {
        }

        @Override
        public Set<E> get(E e) {
            return super.get(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetMap<K, V extends Indexable>
    extends TreeMap<K, Set<V>> {
        static final long serialVersionUID = 0L;

        SetMap() {
        }

        @Override
        public Set<V> get(K k) {
            TreeSet treeSet = (TreeSet)super.get(k);
            if (treeSet == null) {
                treeSet = new TreeSet();
                this.put(k, treeSet);
            }
            return treeSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Edge
    implements Comparable<Edge>,
    Indexable {
        Block from;
        Block to;
        int label;
        int id;
        Handler handler;

        Edge(Method method, Block block, int n) {
            this.from = block;
            this.label = n;
            this.id = method.edgeId++;
        }

        Edge(Method method, Block block, int n, Block block2) {
            this(method, block, n);
            this.to = block2;
        }

        Edge(Method method, Block block, int n, Handler handler) {
            this(method, block, n);
            this.handler = handler;
        }

        @Override
        public int id() {
            return this.id;
        }

        public int hashCode() {
            return this.label ^ this.to.hashCode() ^ (this.from != null ? this.from.hashCode() : 0);
        }

        public boolean equals(Object object) {
            return object instanceof Edge && ((Edge)object).from == this.from && ((Edge)object).to == this.to && ((Edge)object).label == this.label;
        }

        public String toString() {
            return (GlobalOptimizer.isThrowEdge(this) ? this.handler.toString() + " " : "") + (this.from != null ? this.label + ":" + this.from : "") + "->" + this.to;
        }

        @Override
        public int compareTo(Edge edge) {
            int n = this.label - edge.label;
            if (n != 0) {
                return n;
            }
            if (this.from != null && edge.from == null) {
                return 1;
            }
            if (this.from == null && edge.from != null) {
                return -1;
            }
            if (this.from != null && (n = this.from.compareTo(edge.from)) != 0) {
                return n;
            }
            return this.to.compareTo(edge.to);
        }
    }

    static class IndentingPrintWriter
    extends PrintWriter {
        int indent;

        IndentingPrintWriter(Writer writer) {
            super(writer);
        }

        public void println() {
            super.println();
            for (int i = 0; i < this.indent; ++i) {
                this.print("    ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Abc {
        Pool<Integer> intPool = new Pool(1);
        Pool<Long> uintPool = new Pool(1);
        Pool<Double> doublePool = new Pool(1);
        Pool<String> stringPool = new Pool(1);
        Pool<Namespace> nsPool = new Pool(1);
        Pool<Nsset> nssetPool = new Pool(1);
        Pool<Name> namePool = new Pool(1);
        Pool<Method> methodPool1 = new Pool(0);
        Pool<Method> methodPool2 = new Pool(0);
        Pool<Metadata> metaPool = new Pool(0);
        int bodyCount;
        boolean haveNatives;
        List<Type> scripts = new ArrayList<Type>();
        List<Type> classes = new ArrayList<Type>();

        Abc() {
        }

        int typeRef(Typeref typeref) {
            return this.typeRef(typeref.t);
        }

        int typeRef(Type type) {
            if (type == GlobalOptimizer.this.ANY) {
                return 0;
            }
            return this.namePool.id(type.name);
        }

        Pool<Method> poolFor(Method method) {
            return method.isNative() ? this.methodPool2 : this.methodPool1;
        }

        int methodId(Method method) {
            return this.poolFor(method).id(method);
        }

        void addScript(Type type) {
            this.addMethod(type.init);
            this.addTraits(type.defs);
            this.scripts.add(type);
        }

        void addClass(Type type) {
            Type type2 = type.itype;
            this.addName(type2.name);
            if (type2.base != GlobalOptimizer.this.NULL) {
                this.addTypeRef(type2.base);
            }
            if (type2.hasProtectedNs()) {
                this.addNamespace(type2.protectedNs);
            }
            for (Type type3 : type2.interfaces) {
                this.addTypeRef(type3);
            }
            this.addMethod(type2.init);
            this.addTraits(type2.defs);
            this.addMethod(type.init);
            this.addTraits(type.defs);
            this.classes.add(type);
        }

        int classId(Type type) {
            return this.classes.indexOf(type);
        }

        void addTraits(Symtab<Binding> symtab) {
            for (Binding binding : symtab.values()) {
                this.addName(binding.name);
                switch (binding.kind()) {
                    case 4: {
                        this.addClass(binding.type.t);
                        break;
                    }
                    case 0: 
                    case 6: {
                        this.addTypeRef(binding.type);
                        if (binding.value == null) break;
                        this.addConst(binding.value);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.addMethod(binding.method);
                    }
                }
                if (!binding.hasMetadata()) continue;
                for (Metadata metadata : binding.md) {
                    this.addMetadata(metadata);
                }
            }
        }

        void addMetadata(Metadata metadata) {
            if (this.metaPool.add(metadata) == 1) {
                this.stringPool.add(metadata.name);
                for (Attr attr : metadata.attrs) {
                    this.stringPool.add(attr.name);
                    this.stringPool.add(attr.value);
                }
            }
        }

        void addConst(Object object) {
            if (object instanceof Integer) {
                this.intPool.add(GlobalOptimizer.this.intValue(object));
            } else if (object instanceof Long) {
                this.uintPool.add(GlobalOptimizer.this.uintValue(object));
            } else if (object instanceof Double) {
                this.doublePool.add(GlobalOptimizer.this.doubleValue(object));
            } else if (object instanceof String) {
                this.stringPool.add((String)object);
            } else if (object instanceof Namespace) {
                this.addNamespace((Namespace)object);
            }
        }

        int constId(int n, Object object) {
            switch (n) {
                case 3: {
                    return this.intPool.id(GlobalOptimizer.this.intValue(object));
                }
                case 4: {
                    return this.uintPool.id(GlobalOptimizer.this.uintValue(object));
                }
                case 1: {
                    return this.stringPool.id((String)object);
                }
                case 6: {
                    return this.doublePool.id(GlobalOptimizer.this.doubleValue(object));
                }
                case 8: {
                    return this.nsPool.id((Namespace)object);
                }
            }
            return 0;
        }

        int constKind(Object object) {
            if (object instanceof Integer) {
                return 3;
            }
            if (object instanceof Long) {
                return 4;
            }
            if (object instanceof Double) {
                return 6;
            }
            if (object instanceof String) {
                return 1;
            }
            if (object instanceof Namespace) {
                return ((Namespace)object).kind;
            }
            if (object == Boolean.TRUE) {
                return 11;
            }
            if (object == Boolean.FALSE) {
                return 10;
            }
            if (object == UNDEFINED) {
                return 0;
            }
            if (object == GlobalOptimizer.this.NULL) {
                return 12;
            }
            return 0;
        }

        void addNamespace(Namespace namespace) {
            if (this.nsPool.add(namespace) == 1 && !namespace.isPrivateOrInternal()) {
                this.stringPool.add(namespace.uri);
            }
        }

        void addNsset(Nsset nsset) {
            if (this.nssetPool.add(nsset) == 1) {
                for (Namespace namespace : nsset) {
                    this.addNamespace(namespace);
                }
            }
        }

        void addName(Name name) {
            if (this.namePool.add(name) == 1) {
                switch (name.kind) {
                    case 9: 
                    case 14: {
                        this.addNsset(name.nsset);
                        this.stringPool.add(name.name);
                        break;
                    }
                    case 7: 
                    case 13: {
                        this.addNamespace(name.nsset(0));
                        this.stringPool.add(name.name);
                        break;
                    }
                    case 15: 
                    case 16: {
                        this.stringPool.add(name.name);
                        break;
                    }
                    case 27: 
                    case 28: {
                        this.addNsset(name.nsset);
                    }
                }
            }
        }

        void addTypeRef(Typeref typeref) {
            this.addTypeRef(typeref.t);
        }

        void addTypeRef(Type type) {
            if (type != GlobalOptimizer.this.ANY) {
                this.addName(type.name);
            }
        }

        void addMethod(Method method) {
            if (this.poolFor(method).add(method) > 1) {
                return;
            }
            if (method.entry != null) {
                ++this.bodyCount;
            }
            this.addTypeRef(method.returns.t);
            int n = method.params.length;
            for (int i = 1; i < n; ++i) {
                this.addTypeRef(method.params[i]);
            }
            if (method.hasOptional()) {
                for (Object object : method.values) {
                    if (object == null) continue;
                    this.addConst(object);
                }
            }
            for (Handler handler : method.handlers) {
                this.addName(handler.name);
                this.addTypeRef(handler.type);
            }
            this.haveNatives |= method.isNative();
            if (method.entry == null) {
                return;
            }
            for (Block block : GlobalOptimizer.this.dfs(method.entry.to)) {
                for (Expr expr : block) {
                    switch (expr.op) {
                        case 241: {
                            break;
                        }
                        case 6: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 49: {
                            this.addConst(expr.value);
                            break;
                        }
                        case 69: 
                        case 70: 
                        case 74: 
                        case 76: 
                        case 78: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 102: 
                        case 104: 
                        case 106: 
                        case 128: 
                        case 134: 
                        case 178: {
                            this.addName(expr.ref);
                            break;
                        }
                        case 64: 
                        case 68: {
                            this.addMethod(expr.m);
                        }
                    }
                }
            }
            this.addTraits(method.activation.t.defs);
        }

        void sort() {
            System.out.println("NAMES RANK " + this.namePool.refs);
            this.intPool.sort();
            this.uintPool.sort();
            this.doublePool.sort();
            this.stringPool.sort();
            this.nsPool.sort();
            this.nssetPool.sort();
            this.namePool.sort();
            this.metaPool.sort();
            this.methodPool1.sort();
            this.methodPool2.countFrom = this.methodPool1.size();
            this.methodPool2.sort();
            System.out.println("NAMES " + this.namePool.values);
            TreeSet<Type> treeSet = new TreeSet<Type>(new Comparator<Type>(){

                @Override
                public int compare(Type type, Type type2) {
                    if (type == type2) {
                        return 0;
                    }
                    if (GlobalOptimizer.this.istype(type2.itype, type.itype)) {
                        return -1;
                    }
                    return 1;
                }
            });
            treeSet.addAll(this.classes);
            this.classes.clear();
            this.classes.addAll(treeSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pool<T extends Comparable> {
        Map<T, Integer> refs = new HashMap<T, Integer>();
        ArrayList<T> values;
        int countFrom;

        Pool(int n) {
            this.countFrom = n;
        }

        int add(T t) {
            int n = !this.refs.containsKey(t) ? 1 : this.refs.get(t) + 1;
            this.refs.put(t, n);
            return n;
        }

        void sort() {
            Object[] objectArray = new Ranker[this.refs.size()];
            int n = 0;
            for (Comparable comparable : this.refs.keySet()) {
                objectArray[n++] = new Ranker<Comparable>(comparable, this.refs.get(comparable));
            }
            assert (n == this.refs.size());
            Arrays.sort(objectArray);
            this.values = new ArrayList();
            n = this.countFrom;
            for (Object object : objectArray) {
                this.values.add(((Ranker)object).value);
                this.refs.put(((Ranker)object).value, n++);
            }
        }

        int id(T t) {
            assert (this.refs.containsKey(t));
            return this.refs.get(t);
        }

        public String toString() {
            return String.valueOf(this.refs);
        }

        int size() {
            return this.countFrom + this.refs.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Ranker<T>
    implements Comparable {
        T value;
        int rank;

        Ranker(T t, int n) {
            this.value = t;
            this.rank = n;
        }

        public int compareTo(Object object) {
            return ((Ranker)object).rank - this.rank;
        }
    }

    static class Attr
    implements Comparable {
        String name;
        String value;

        Attr(String string) {
            this.name = string;
        }

        public int compareTo(Object object) {
            Attr attr = (Attr)object;
            if (this == attr) {
                return 0;
            }
            int n = this.name.compareTo(attr.name);
            if (n != 0) {
                return n;
            }
            n = this.value.compareTo(attr.value);
            if (n != 0) {
                return n;
            }
            return 0;
        }
    }

    static class Metadata
    implements Comparable {
        String name;
        Attr[] attrs;

        Metadata() {
        }

        public int compareTo(Object object) {
            Metadata metadata = (Metadata)object;
            if (this == metadata) {
                return 0;
            }
            int n = metadata.name.compareTo(this.name);
            if (n != 0) {
                return n;
            }
            n = this.attrs.length - metadata.attrs.length;
            if (n != 0) {
                return n;
            }
            int n2 = this.attrs.length;
            for (int i = 0; i < n2; ++i) {
                n = this.attrs[i].compareTo(metadata.attrs[i]);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Name
    implements Comparable<Name> {
        final int kind;
        private final Nsset nsset;
        final String name;

        Name(int n) {
            this(n, GlobalOptimizer.uniqueNs(), GlobalOptimizer.unique());
        }

        Name(Namespace namespace, String string) {
            this(7, namespace, string);
        }

        Name(int n, Namespace namespace, String string) {
            this(n, string, new Nsset(new Namespace[]{namespace}));
        }

        Name(int n, String string, Nsset nsset) {
            assert (nsset != null);
            this.kind = n;
            this.nsset = nsset;
            this.name = string;
        }

        Name(String string) {
            this(7, PUBLIC, string);
        }

        Namespace nsset(int n) {
            return this.nsset.nsset[n];
        }

        public String toString() {
            return this.name;
        }

        public String format() {
            if (this.nsset.length == 1) {
                return this.nsset(0) + "::" + this.name;
            }
            ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
            for (Namespace namespace : this.nsset) {
                arrayList.add(namespace);
            }
            return arrayList + "::" + this.name;
        }

        public Name append(String string) {
            return new Name(this.kind, this.name + string, this.nsset);
        }

        public Name prepend(String string) {
            return new Name(this.kind, string + this.name, this.nsset);
        }

        int hc(Object object) {
            return object != null ? object.hashCode() : 0;
        }

        public int hashCode() {
            return this.kind ^ this.hc(this.nsset) ^ this.hc(this.name);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Name)) {
                return false;
            }
            Name name = (Name)object;
            return this.kind == name.kind && this.name.equals(name.name) && this.nsset.equals(name.nsset);
        }

        @Override
        public int compareTo(Name name) {
            int n = this.kind - name.kind;
            if (n != 0) {
                return n;
            }
            n = this.name.compareTo(name.name);
            if (n != 0) {
                return n;
            }
            return this.nsset.compareTo(name.nsset);
        }

        int attr() {
            return this.kind == 14 || this.kind == 13 || this.kind == 16 || this.kind == 18 || this.kind == 28 ? 1 : 0;
        }

        boolean isQname() {
            return this.kind == 7 || this.kind == 13 || this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 18;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Nsset
    implements Comparable<Nsset>,
    Iterable<Namespace> {
        final Namespace[] nsset;
        final int length;

        Nsset(Namespace[] namespaceArray) {
            this.nsset = namespaceArray;
            this.length = namespaceArray.length;
        }

        public int hashCode() {
            int n = GlobalOptimizer.deepHashCode(this.nsset);
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Nsset)) {
                return false;
            }
            Object[] objectArray = ((Nsset)object).nsset;
            Object[] objectArray2 = this.nsset;
            return GlobalOptimizer.deepEquals(objectArray2, objectArray);
        }

        @Override
        public int compareTo(Nsset nsset) {
            Namespace[] namespaceArray = this.nsset;
            Namespace[] namespaceArray2 = nsset.nsset;
            int n = namespaceArray.length - namespaceArray2.length;
            if (n != 0) {
                return n;
            }
            int n2 = namespaceArray.length;
            for (int i = 0; i < n2; ++i) {
                n = namespaceArray[i].compareTo(namespaceArray2[i]);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        @Override
        public Iterator<Namespace> iterator() {
            return Arrays.asList(this.nsset).iterator();
        }

        public String toString() {
            return Arrays.toString(this.nsset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Namespace
    implements Comparable<Namespace> {
        final int kind;
        final String uri;
        private final String comparableUri;

        Namespace(String string) {
            this(8, string);
        }

        Namespace(int n, String string) {
            this.kind = n;
            this.uri = string;
            this.comparableUri = this.isPrivate() ? GlobalOptimizer.unique() : string;
        }

        boolean isPublic() {
            return (this.kind == 8 || this.kind == 22) && "".equals(this.uri);
        }

        boolean isInternal() {
            return this.kind == 23;
        }

        boolean isPrivate() {
            return this.kind == 5;
        }

        boolean isPrivateOrInternal() {
            return this.isPrivate() || this.isInternal();
        }

        boolean isProtected() {
            return this.kind == 24 || this.kind == 26;
        }

        public String toString() {
            return this.uri.length() > 0 ? this.uri : "public";
        }

        public int hashCode() {
            return this.kind ^ this.uri.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Namespace)) {
                return false;
            }
            Namespace namespace = (Namespace)object;
            return this.kind == namespace.kind && this.comparableUri.equals(this.comparableUri);
        }

        @Override
        public int compareTo(Namespace namespace) {
            if (namespace == null) {
                return 1;
            }
            int n = this.kind - namespace.kind;
            if (n != 0) {
                return n;
            }
            return this.comparableUri.compareTo(namespace.comparableUri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Symtab<E> {
        private List<Name> names = new ArrayList<Name>();
        private List<E> values = new ArrayList();

        Symtab() {
        }

        E get(Name name) {
            if (name.nsset != null && name.name != null) {
                if (((Name)name).nsset.length == 1) {
                    int n = this.names.size();
                    for (int i = 0; i < n; ++i) {
                        if (0 != GlobalOptimizer.match(name, this.names.get(i))) continue;
                        return this.values.get(i);
                    }
                    return null;
                }
                for (Namespace namespace : name.nsset) {
                    E e = this.get(new Name(name.kind, namespace, name.name));
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        Name getName(Name name) {
            if (((Name)name).nsset.length > 1) {
                for (Namespace namespace : name.nsset) {
                    Name name2 = new Name(name.kind, namespace, name.name);
                    if (!this.names.contains(name2)) continue;
                    return name2;
                }
            }
            return name;
        }

        boolean contains(Name name) {
            return name != null && this.get(name) != null;
        }

        void put(Name name, E e) {
            assert (((Name)name).nsset.length == 1);
            this.names.add(name);
            this.values.add(e);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.names.get(i)).append('=').append(this.values.get(i));
                if (i + 1 >= n) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        public Collection<E> values() {
            return this.values;
        }

        int size() {
            return this.names.size();
        }
    }

    static class Binding {
        final InputAbc abc;
        final Name name;
        private final int flags_kind;
        int slot;
        int id;
        int offset;
        Object value;
        Typeref type;
        Method method;
        Metadata[] md = nometadata;

        Binding(int n, Name name, InputAbc inputAbc) {
            this.name = name;
            this.flags_kind = n;
            this.abc = inputAbc;
        }

        int kind() {
            return this.flags_kind & 0xF;
        }

        boolean isFinal() {
            return (this.flags_kind >> 4 & 1) != 0;
        }

        boolean isOverride() {
            return (this.flags_kind >> 4 & 2) != 0;
        }

        boolean hasMetadata() {
            return (this.flags_kind >> 4 & 4) != 0;
        }

        public String toString() {
            switch (this.kind()) {
                case 4: {
                    return "[" + this.slot + "] class";
                }
                case 0: {
                    return "[" + this.slot + "] var";
                }
                case 6: {
                    return "[" + this.slot + "] const";
                }
                case 1: {
                    return "[" + this.slot + "] method";
                }
                case 2: {
                    return "[" + this.slot + "] get";
                }
                case 3: {
                    return "[" + this.slot + "] set";
                }
            }
            assert (false);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Method
    implements Comparable<Method> {
        final InputAbc abc;
        final int id;
        Edge entry;
        Typeref[] params;
        Object[] values;
        Typeref returns;
        Name name;
        Name debugName;
        Name[] paramNames;
        int flags;
        Type cx;
        int blockId;
        int exprId;
        int edgeId;
        String kind;
        int max_stack;
        int local_count;
        int max_scope;
        int code_len;
        Typeref activation;
        Handler[] handlers = nohandlers;

        Method(int n, InputAbc inputAbc) {
            this.id = n;
            this.abc = inputAbc;
        }

        boolean needsRest() {
            return (this.flags & 4) != 0;
        }

        boolean needsArguments() {
            return (this.flags & 1) != 0;
        }

        boolean hasParamNames() {
            return (this.flags & 0x80) != 0;
        }

        boolean hasOptional() {
            return (this.flags & 8) != 0;
        }

        boolean isNative() {
            return (this.flags & 0x20) != 0;
        }

        @Override
        public int compareTo(Method method) {
            return this.id - method.id;
        }

        public String toString() {
            return this.kind + " " + String.valueOf(this.name);
        }
    }

    static class Handler {
        Typeref type;
        Block entry;
        Typeref activation;
        Name name;

        Handler() {
        }

        public String toString() {
            return "catch " + this.type;
        }
    }

    class InputAbc {
        String[] strings;
        int[] ints;
        long[] uints;
        double[] doubles;
        Namespace[] namespaces;
        Nsset[] nssets;
        Name[] names;
        Method[] methods;
        Metadata[] metadata;
        Type[] classes;
        Type[] scripts;
        boolean containsObject;
        Set<Type> toResolve;

        InputAbc() {
        }

        Type lookup(String string, Type type) {
            Name name;
            Name name2 = new Name(string);
            Type type2 = GlobalOptimizer.this.namedTypes.get(name2);
            if (type2 == null && (type2 = GlobalOptimizer.this.namedTypes.get(name = new Name(7, new Namespace(22, ""), string))) == null) {
                type2 = new Type(name, type);
                GlobalOptimizer.this.namedTypes.put(name, type2);
            }
            return type2;
        }

        Type lookup(String string) {
            return this.lookup(string, GlobalOptimizer.this.OBJECT);
        }

        void lookupBuiltins() {
            assert (this.containsObject);
            GlobalOptimizer.this.CLASS = this.lookup("Class");
            GlobalOptimizer.this.FUNCTION = this.lookup("Function");
            GlobalOptimizer.this.ARRAY = this.lookup("Array");
            GlobalOptimizer.this.INT = this.lookup("int");
            GlobalOptimizer.this.UINT = this.lookup("uint");
            GlobalOptimizer.this.NUMBER = this.lookup("Number");
            GlobalOptimizer.this.BOOLEAN = this.lookup("Boolean");
            GlobalOptimizer.this.STRING = this.lookup("String");
            GlobalOptimizer.this.NAMESPACE = this.lookup("Namespace");
            GlobalOptimizer.this.XML = this.lookup("XML");
            GlobalOptimizer.this.XMLLIST = this.lookup("XMLList");
            GlobalOptimizer.this.QNAME = this.lookup("QName");
            GlobalOptimizer.this.VOID = this.lookup("void", null);
            GlobalOptimizer.this.BOOLEAN.numeric = true;
            GlobalOptimizer.this.UINT.numeric = true;
            GlobalOptimizer.this.NUMBER.numeric = true;
            GlobalOptimizer.this.INT.numeric = true;
            GlobalOptimizer.this.BOOLEAN.primitive = true;
            GlobalOptimizer.this.STRING.primitive = true;
            GlobalOptimizer.this.UINT.primitive = true;
            GlobalOptimizer.this.NUMBER.primitive = true;
            GlobalOptimizer.this.INT.primitive = true;
            GlobalOptimizer.this.NULL.primitive = true;
            GlobalOptimizer.this.VOID.primitive = true;
            GlobalOptimizer.this.VOID.atom = true;
            GlobalOptimizer.this.OBJECT.atom = true;
            GlobalOptimizer.this.ANY.atom = true;
            GlobalOptimizer.this.INT.ref = GlobalOptimizer.this.INT.ref.nonnull();
            GlobalOptimizer.this.NUMBER.ref = GlobalOptimizer.this.NUMBER.ref.nonnull();
            GlobalOptimizer.this.UINT.ref = GlobalOptimizer.this.UINT.ref.nonnull();
            GlobalOptimizer.this.BOOLEAN.ref = GlobalOptimizer.this.BOOLEAN.ref.nonnull();
            GlobalOptimizer.this.OBJECT.defaultValue = GlobalOptimizer.this.NULL;
            GlobalOptimizer.this.NULL.defaultValue = GlobalOptimizer.this.NULL;
            GlobalOptimizer.this.ANY.defaultValue = UNDEFINED;
            GlobalOptimizer.this.VOID.defaultValue = UNDEFINED;
            GlobalOptimizer.this.BOOLEAN.defaultValue = Boolean.FALSE;
            GlobalOptimizer.this.NUMBER.defaultValue = Double.NaN;
            GlobalOptimizer.this.INT.defaultValue = 0;
            GlobalOptimizer.this.UINT.defaultValue = 0;
        }

        Type lookup(int n) {
            if (n == 0) {
                return GlobalOptimizer.this.ANY;
            }
            if (!GlobalOptimizer.this.namedTypes.contains(this.names[n])) {
                Name name = new Name(7, this.names[n].nsset(0), this.names[n].name);
                GlobalOptimizer.this.namedTypes.put(name, new Type(name, null));
            }
            return GlobalOptimizer.this.namedTypes.get(this.names[n]);
        }

        void readAbc(byte[] byArray) throws IOException {
            int n;
            int n2;
            int n3;
            Reader reader = new Reader(0, byArray);
            if (reader.readU16() != 16 || reader.readU16() != 46) {
                throw new RuntimeException("not an abc file");
            }
            this.ints = new int[reader.readU30() + 1];
            int n4 = this.ints.length - 1;
            for (n3 = 1; n3 < n4; ++n3) {
                this.ints[n3] = reader.readU30();
            }
            this.uints = new long[reader.readU30() + 1];
            n4 = this.uints.length - 1;
            for (n3 = 1; n3 < n4; ++n3) {
                this.uints[n3] = 0xFFFFFFFFL & (long)reader.readU30();
            }
            this.doubles = new double[reader.readU30() + 1];
            n4 = this.doubles.length - 1;
            for (n3 = 1; n3 < n4; ++n3) {
                this.doubles[n3] = reader.readDouble();
            }
            this.strings = new String[reader.readU30() + 1];
            this.strings[0] = "";
            n4 = this.strings.length - 1;
            for (n3 = 1; n3 < n4; ++n3) {
                n2 = reader.readU30();
                this.strings[n3] = new String(byArray, reader.pos, n2, "UTF-8");
                reader.pos += n2;
            }
            this.namespaces = new Namespace[reader.readU30() + 1];
            this.namespaces[0] = PUBLIC;
            n4 = this.namespaces.length - 1;
            for (n3 = 1; n3 < n4; ++n3) {
                this.namespaces[n3] = new Namespace(reader.readU8(), this.strings[reader.readU30()]);
            }
            this.nssets = new Nsset[reader.readU30() + 1];
            n4 = this.nssets.length - 1;
            for (n3 = 1; n3 < n4; ++n3) {
                this.nssets[n3] = new Nsset(new Namespace[reader.readU30()]);
                n = this.nssets[n3].length;
                for (n2 = 0; n2 < n; ++n2) {
                    this.nssets[n3].nsset[n2] = this.namespaces[reader.readU30()];
                }
            }
            this.names = new Name[reader.readU30() + 1];
            n4 = this.names.length - 1;
            for (n3 = 1; n3 < n4; ++n3) {
                this.names[n3] = this.readName(reader);
            }
            this.methods = new Method[reader.readU30()];
            int[] nArray = new int[this.methods.length];
            n2 = this.methods.length;
            for (n4 = 0; n4 < n2; ++n4) {
                this.methods[n4] = this.readMethod(reader, nArray, n4);
            }
            this.metadata = new Metadata[reader.readU30()];
            n2 = this.metadata.length;
            for (n4 = 0; n4 < n2; ++n4) {
                this.metadata[n4] = this.readMetadata(reader);
            }
            this.toResolve = new HashSet<Type>();
            Type[] typeArray = new Type[reader.readU30()];
            n = typeArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                typeArray[n2] = this.readInstance(reader);
            }
            if (this.containsObject) {
                this.lookupBuiltins();
            }
            n = this.methods.length;
            for (n2 = 0; n2 < n; ++n2) {
                this.resolveSignatureType(new Reader(nArray[n2], reader.abc), n2, this.methods[n2]);
            }
            this.classes = new Type[typeArray.length];
            n = this.classes.length;
            for (n2 = 0; n2 < n; ++n2) {
                this.classes[n2] = this.readClass(reader, typeArray[n2]);
            }
            this.scripts = new Type[reader.readU30()];
            n = this.scripts.length;
            for (n2 = 0; n2 < n; ++n2) {
                this.scripts[n2] = this.readScript(reader, n2);
            }
            n = reader.readU30();
            for (n2 = 0; n2 < n; ++n2) {
                this.readBody(reader);
            }
            for (Type type : this.toResolve) {
                this.resolveType(type);
            }
            this.toResolve = null;
        }

        void resolveType(Type type) {
            if (type.size != 0) {
                return;
            }
            int n = 0;
            int n2 = 0;
            if (type.base != null) {
                this.resolveType(type.base);
                n = type.base.size;
                n2 = type.base.slotCount;
            }
            int n3 = -1;
            for (Binding binding : type.defs.values()) {
                if (!GlobalOptimizer.isSlot(binding)) continue;
                if (!GlobalOptimizer.isClass(binding)) {
                    this.resolveSlotType(binding);
                }
                if (binding.type.t == GlobalOptimizer.this.NUMBER) {
                    if (n % 8 != 0) {
                        n3 = n;
                        n += 4;
                    }
                    binding.offset = n;
                    n += 8;
                    continue;
                }
                if (n3 != -1) {
                    binding.offset = n3;
                    n3 = -1;
                    continue;
                }
                binding.offset = n;
                n += 4;
            }
            int n4 = type.slotCount;
            for (int i = n2; i < n4; ++i) {
            }
            if (n > 0) {
                System.out.println("sizeof " + type + " " + n);
            }
            type.size = n;
        }

        Metadata readMetadata(Reader reader) {
            int n;
            Metadata metadata = new Metadata();
            metadata.name = this.strings[reader.readU30()];
            metadata.attrs = new Attr[reader.readU30()];
            Attr[] attrArray = metadata.attrs;
            int n2 = attrArray.length;
            for (n = 0; n < n2; ++n) {
                attrArray[n] = new Attr(this.strings[reader.readU30()]);
            }
            n2 = attrArray.length;
            for (n = 0; n < n2; ++n) {
                attrArray[n].value = this.strings[reader.readU30()];
            }
            return metadata;
        }

        void resolveSignatureType(Reader reader, int n, Method method) {
            int n2;
            method.returns = this.lookup((int)reader.readU30()).ref;
            for (n2 = 1; n2 < method.params.length; ++n2) {
                method.params[n2] = this.lookup((int)reader.readU30()).ref;
            }
            reader.readU30();
            reader.readU8();
            if (method.hasOptional()) {
                n2 = reader.readU30();
                method.values = new Object[method.params.length];
                int n3 = method.params.length - 1;
                for (int i = n3 - n2 + 1; i <= n3; ++i) {
                    method.values[i] = this.readArgDefault(reader);
                    assert (method.values[i] != null);
                }
            }
        }

        void readBody(Reader reader) {
            Method method = this.methods[reader.readU30()];
            method.max_stack = reader.readU30();
            method.local_count = reader.readU30();
            method.max_scope = -(reader.readU30() - reader.readU30());
            method.code_len = reader.readU30();
            Reader reader2 = new Reader(reader);
            reader.pos += method.code_len;
            this.readCode(method, reader2, reader);
            Type type = new Type();
            method.activation = type.ref.nonnull();
            type.base = GlobalOptimizer.this.ANY;
            if (method.name != null) {
                type.name = method.name.append(" activation");
            }
            this.readTraits(reader, type);
        }

        Method readMethod(Reader reader, int[] nArray, int n) {
            int n2;
            Method method = new Method(n, this);
            int n3 = reader.readU30();
            method.params = new Typeref[n3 + 1];
            method.params[0] = GlobalOptimizer.this.ANY.ref;
            nArray[n] = reader.pos;
            reader.readU30();
            for (n2 = 1; n2 <= n3; ++n2) {
                reader.readU30();
            }
            method.name = method.debugName = new Name(this.strings[reader.readU30()]);
            method.flags = reader.readU8();
            if (method.hasOptional()) {
                n2 = reader.readU30();
                assert (n2 > 0);
                while (n2-- > 0) {
                    this.readArgDefault(reader);
                }
                method.values = new Object[method.params.length];
                for (int i = n3 - n2 + 1; i <= n3; ++i) {
                    method.values[i] = this.readArgDefault(reader);
                }
            }
            if (method.hasParamNames()) {
                method.paramNames = new Name[n3 + 1];
                for (n2 = 1; n2 <= n3; ++n2) {
                    method.paramNames[n2] = new Name(this.strings[reader.readU30()]);
                }
            }
            return method;
        }

        Name readName(Reader reader) {
            int n = reader.readU8();
            switch (n) {
                default: {
                    assert (false);
                }
                case 7: 
                case 13: {
                    return new Name(n, this.namespaces[reader.readU30()], this.strings[reader.readU30()]);
                }
                case 9: 
                case 14: {
                    return new Name(n, this.strings[reader.readU30()], this.nssets[reader.readU30()]);
                }
                case 15: 
                case 16: {
                    return new Name(n, GlobalOptimizer.uniqueNs(), this.strings[reader.readU30()]);
                }
                case 27: 
                case 28: {
                    return new Name(n, GlobalOptimizer.unique(), this.nssets[reader.readU30()]);
                }
                case 17: 
                case 18: 
            }
            return new Name(n);
        }

        void readTraits(Reader reader, Type type) {
            this.toResolve.add(type);
            type.defs = new Symtab();
            int n = 0;
            if (type.base != null) {
                n = type.base.slotCount;
            }
            int n2 = reader.readU30();
            for (int i = 0; i < n2; ++i) {
                Name name = this.names[reader.readU30()];
                Binding binding = new Binding(reader.readU8(), name, this);
                type.defs.put(name, binding);
                int n3 = reader.readU30();
                binding.id = reader.readU30();
                switch (binding.kind()) {
                    case 0: 
                    case 4: 
                    case 6: {
                        if (GlobalOptimizer.isClass(binding)) {
                            binding.type = this.classes[binding.id].ref.nonnull();
                            binding.value = GlobalOptimizer.this.NULL;
                        } else {
                            binding.value = this.readSlotDefault(reader);
                            binding.type = GlobalOptimizer.this.ANY.ref;
                            if (binding.value instanceof Namespace) {
                                GlobalOptimizer.this.namespaceNames.put((Namespace)binding.value, name);
                            }
                        }
                        if (n3 == 0) {
                            n3 = ++n;
                        } else if (n3 > n) {
                            n = n3;
                        }
                        binding.slot = n3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        binding.slot = 0;
                        Method method = binding.method = this.methods[binding.id];
                        method.cx = type;
                        method.params[0] = type.ref.nonnull();
                        method.kind = GlobalOptimizer.this.isMethod(binding) ? "function" : (GlobalOptimizer.this.isGetter(binding) ? "get" : "set");
                        method.name = name;
                        break;
                    }
                    default: {
                        System.err.println("illegal trait kind " + binding.kind() + " at offset " + reader.pos);
                        assert (false);
                        break;
                    }
                }
                if (!binding.hasMetadata()) continue;
                binding.md = new Metadata[reader.readU30()];
                int n4 = binding.md.length;
                for (int j = 0; j < n4; ++j) {
                    binding.md[j] = this.metadata[reader.readU30()];
                }
            }
            type.slotCount = n;
        }

        Object readSlotDefault(Reader reader) {
            int n = reader.readU30();
            if (n != 0) {
                int n2 = reader.readU8();
                return this.defaultValue(n2, n);
            }
            return null;
        }

        Object readArgDefault(Reader reader) {
            int n = reader.readU30();
            int n2 = reader.readU8();
            Object object = this.defaultValue(n2, n);
            return object;
        }

        Object defaultValue(int n, int n2) {
            switch (n) {
                case 10: {
                    return Boolean.FALSE;
                }
                case 11: {
                    return Boolean.TRUE;
                }
                case 12: {
                    return GlobalOptimizer.this.NULL;
                }
                case 0: {
                    return UNDEFINED;
                }
                case 1: {
                    return this.strings[n2];
                }
                case 3: {
                    return this.ints[n2];
                }
                case 4: {
                    return this.uints[n2];
                }
                case 6: {
                    return this.doubles[n2];
                }
                case 5: 
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    return this.namespaces[n2];
                }
            }
            assert (false);
            return null;
        }

        void resolveSlotType(Binding binding) {
            binding.type = this.lookup((int)binding.id).ref;
            if (binding.value == null) {
                binding.value = binding.type.t.defaultValue;
            }
        }

        Type readScript(Reader reader, int n) {
            Typeref typeref;
            Type type = new Type();
            assert (GlobalOptimizer.this.OBJECT != null);
            type.base = GlobalOptimizer.this.OBJECT;
            type.name = new Name("global" + n);
            Method method = type.init = this.methods[reader.readU30()];
            method.cx = type;
            method.params[0] = typeref = type.ref.nonnull();
            method.name = type.name;
            method.kind = "init";
            this.readTraits(reader, type);
            for (Binding binding : type.defs.values()) {
                GlobalOptimizer.this.globals.put(binding.name, typeref);
            }
            return type;
        }

        Type readClass(Reader reader, Type type) {
            Type type2 = new Type();
            assert (GlobalOptimizer.this.CLASS != null);
            type2.base = GlobalOptimizer.this.CLASS;
            type2.itype = type;
            type2.name = type.name.append("$");
            Method method = type2.init = this.methods[reader.readU30()];
            method.cx = type2;
            method.params[0] = type2.ref.nonnull();
            method.name = type2.name;
            method.kind = "init";
            this.readTraits(reader, type2);
            return type2;
        }

        Type readInstance(Reader reader) {
            Type type = new Type();
            type.name = this.names[reader.readU30()];
            type.base = this.lookup(reader.readU30());
            type.flags = reader.readU8();
            if (type.hasProtectedNs()) {
                type.protectedNs = this.namespaces[reader.readU30()];
            }
            type.interfaces = new Type[reader.readU30()];
            int n = type.interfaces.length;
            for (int i = 0; i < n; ++i) {
                type.interfaces[i] = this.lookup(reader.readU30());
            }
            type.init = this.methods[reader.readU30()];
            type.init.cx = type;
            type.init.params[0] = type.ref.nonnull();
            type.init.kind = "init";
            type.init.name = type.name;
            this.readTraits(reader, type);
            GlobalOptimizer.this.namedTypes.put(type.name, type);
            if (type.name.equals(new Name(PKG_PUBLIC, "Object"))) {
                this.containsObject = true;
                GlobalOptimizer.this.OBJECT = type;
                GlobalOptimizer.this.NULL = this.lookup("null", GlobalOptimizer.this.OBJECT);
            }
            return type;
        }

        void readCode(Method method, Reader reader, Reader reader2) {
            int n;
            Expr expr;
            int n2;
            int n3 = method.local_count;
            int n4 = reader.pos + method.code_len;
            Expr[] exprArray = new Expr[n3 + method.max_scope + method.max_stack];
            TreeMap<Integer, Block> treeMap = new TreeMap<Integer, Block>();
            TreeMap<Block, FrameState> treeMap2 = new TreeMap<Block, FrameState>();
            int n5 = n3;
            int n6 = n3 + method.max_scope;
            method.entry = new Edge(method, null, 0);
            Block block = GlobalOptimizer.this.createBlock(method, method.entry, treeMap2, exprArray, n6, n5);
            for (n2 = 0; n2 < method.params.length; ++n2) {
                expr = exprArray[n2] = new Expr(method, 0, n2);
                block.add(exprArray[n2]);
                expr.ref = n2 == 0 ? new Name("this") : (method.paramNames != null ? method.paramNames[n2] : new Name("arg" + n2));
            }
            if (method.needsArguments() || method.needsRest()) {
                expr = exprArray[n2] = new Expr(method, 0, n2);
                block.add(exprArray[n2]);
                expr.ref = new Name(method.needsArguments() ? "arguments" : "rest");
                ++n2;
            }
            while (n2 < n3) {
                expr = exprArray[n2] = new Expr(method, 0, n2);
                block.add(exprArray[n2]);
                expr.ref = new Name("local" + n2);
                ++n2;
            }
            BitSet bitSet = new BitSet();
            BitSet bitSet2 = new BitSet();
            int n7 = reader.pos;
            int n8 = reader2.pos;
            method.handlers = new Handler[reader2.readU30()];
            Handler[] handlerArray = method.handlers;
            int n9 = handlerArray.length;
            for (n = 0; n < n9; ++n) {
                Handler handler = handlerArray[n] = new Handler();
                int n10 = reader2.readU30();
                int n11 = reader2.readU30();
                int n12 = reader2.readU30();
                handler.type = this.lookup((int)reader2.readU30()).ref.nonnull();
                Name name = handler.name = this.names[reader2.readU30()];
                Type type = new Type(name, GlobalOptimizer.this.ANY);
                handler.activation = type.ref.nonnull();
                Binding binding = new Binding(0, name, this);
                binding.type = handler.type;
                type.defs.put(name, binding);
                bitSet.set(n10);
                bitSet.set(n11);
                bitSet2.set(n12);
            }
            n = 1;
            block74: while (reader.pos < n4) {
                n9 = reader.pos;
                int n13 = reader.readU8();
                if (n13 == 9 || treeMap.containsKey(reader.pos - 1) || bitSet.get(n9 - n7) || bitSet2.get(n9 - n7)) {
                    Edge edge = null;
                    if (n != 0) {
                        assert (!bitSet2.get(n9 - n7));
                        Edge[] edgeArray = block.succ();
                        if (edgeArray == null) {
                            expr = new Expr(method, 16);
                            block.add(expr);
                            edge = new Edge(method, block, 0, (Block)treeMap.get(n9));
                            expr.succ = new Edge[]{edge};
                        } else {
                            edge = edgeArray[0];
                        }
                    } else if (bitSet2.get(n9 - n7)) {
                        n5 = n3;
                        n6 = n3 + method.max_scope + 1;
                    }
                    GlobalOptimizer.this.merge(method, edge, treeMap, treeMap2, n9, exprArray, n6, n5);
                    block = (Block)treeMap.get(n9);
                    FrameState frameState = (FrameState)treeMap2.get(block);
                    System.arraycopy(frameState.frame, 0, exprArray, 0, exprArray.length);
                    n6 = frameState.sp;
                    n5 = frameState.scopep;
                    n = 1;
                }
                if (handlerArray.length > 0 && block.xsucc == noedges) {
                    ArrayList<Edge> arrayList = new ArrayList<Edge>();
                    reader2.pos = n8;
                    int n14 = reader2.readU30();
                    for (int i = 0; i < n14; ++i) {
                        int n15 = n7 + reader2.readU30();
                        int n16 = n7 + reader2.readU30();
                        int n17 = n7 + reader2.readU30();
                        if (n9 >= n15 && n9 < n16) {
                            Edge edge = new Edge(method, block, i, handlerArray[i]);
                            GlobalOptimizer.this.xmerge(method, edge, treeMap, treeMap2, n17, exprArray, n6, n5);
                            arrayList.add(edge);
                        }
                        reader2.readU30();
                        reader2.readU30();
                    }
                    block.xsucc = arrayList.toArray(new Edge[arrayList.size()]);
                }
                switch (n13) {
                    case 9: {
                        continue block74;
                    }
                    case 3: 
                    case 72: {
                        expr = new Expr(method, n13, exprArray, n6--, 1);
                        block.add(expr);
                        expr.succ = noedges;
                        n = 0;
                        GlobalOptimizer.this.merge(method, null, treeMap, treeMap2, reader.pos, exprArray, n6, n5);
                        continue block74;
                    }
                    case 7: {
                        block.add(new Expr(method, n13, exprArray, n6--, 1));
                        continue block74;
                    }
                    case 28: 
                    case 48: {
                        exprArray[n5++] = expr = new Expr(method, n13, exprArray, n6--, 1);
                        block.add(expr);
                        continue block74;
                    }
                    case 29: {
                        expr = new Expr(method, n13);
                        block.add(expr);
                        expr.scopes = new Expr[]{exprArray[--n5]};
                        exprArray[n5] = null;
                        continue block74;
                    }
                    case 30: 
                    case 31: 
                    case 35: {
                        expr = new Expr(method, n13, exprArray, n6, 2);
                        block.add(expr);
                        n6 -= 2;
                        exprArray[n6++] = expr;
                        continue block74;
                    }
                    case 32: {
                        int n18 = n6++;
                        Expr expr2 = new Expr(method, n13, GlobalOptimizer.this.NULL);
                        exprArray[n18] = expr2;
                        block.add(expr2);
                        continue block74;
                    }
                    case 33: {
                        int n19 = n6++;
                        Expr expr3 = new Expr(method, n13, UNDEFINED);
                        exprArray[n19] = expr3;
                        block.add(expr3);
                        continue block74;
                    }
                    case 38: {
                        int n20 = n6++;
                        Expr expr4 = new Expr(method, n13, Boolean.TRUE);
                        exprArray[n20] = expr4;
                        block.add(expr4);
                        continue block74;
                    }
                    case 39: {
                        int n21 = n6++;
                        Expr expr5 = new Expr(method, n13, Boolean.FALSE);
                        exprArray[n21] = expr5;
                        block.add(expr5);
                        continue block74;
                    }
                    case 40: {
                        int n22 = n6++;
                        Expr expr6 = new Expr(method, n13, Double.NaN);
                        exprArray[n22] = expr6;
                        block.add(expr6);
                        continue block74;
                    }
                    case 87: {
                        int n23 = n6++;
                        Expr expr7 = new Expr(method, n13);
                        exprArray[n23] = expr7;
                        block.add(expr7);
                        continue block74;
                    }
                    case 100: {
                        int n24 = n6++;
                        Expr expr8 = new Expr(method, n13);
                        exprArray[n24] = expr8;
                        expr = expr8;
                        block.add(expr8);
                        expr.scopes = GlobalOptimizer.capture(exprArray, n5, n5 - n3);
                        continue block74;
                    }
                    case 101: {
                        int n25 = n6++;
                        Expr expr9 = new Expr(method, n13);
                        exprArray[n25] = expr9;
                        expr = expr9;
                        block.add(expr9);
                        expr.scopes = GlobalOptimizer.capture(exprArray, n3 + reader.readU8() + 1, 1);
                        continue block74;
                    }
                    case 41: {
                        --n6;
                        continue block74;
                    }
                    case 42: {
                        exprArray[n6] = exprArray[n6 - 1];
                        ++n6;
                        continue block74;
                    }
                    case 43: {
                        expr = exprArray[n6 - 1];
                        exprArray[n6 - 1] = exprArray[n6 - 2];
                        exprArray[n6 - 2] = expr;
                        continue block74;
                    }
                    case 71: {
                        expr = new Expr(method, n13);
                        block.add(expr);
                        expr.succ = noedges;
                        n = 0;
                        GlobalOptimizer.this.merge(method, null, treeMap, treeMap2, reader.pos, exprArray, n6, n5);
                        continue block74;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 130: 
                    case 133: 
                    case 137: 
                    case 144: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 192: 
                    case 193: 
                    case 196: {
                        Expr expr10 = new Expr(method, n13, exprArray, n6, 1);
                        exprArray[n6 - 1] = expr10;
                        block.add(expr10);
                        continue block74;
                    }
                    case 120: {
                        block.add(new Expr(method, n13, exprArray, n6, 1));
                        continue block74;
                    }
                    case 135: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 197: 
                    case 198: 
                    case 199: {
                        Expr expr11 = new Expr(method, n13, exprArray, n6, 2);
                        exprArray[n6 - 2] = expr11;
                        block.add(expr11);
                        --n6;
                        continue block74;
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        exprArray[n6++] = exprArray[n13 - 208];
                        continue block74;
                    }
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: {
                        exprArray[n13 - 212] = exprArray[--n6];
                        continue block74;
                    }
                    case 8: {
                        Expr expr12 = new Expr(method, 33, UNDEFINED);
                        exprArray[reader.readU30()] = expr12;
                        block.add(expr12);
                        continue block74;
                    }
                    case 37: {
                        int n26 = n6++;
                        Expr expr13 = new Expr(method, n13, new Integer((short)reader.readU30()));
                        exprArray[n26] = expr13;
                        block.add(expr13);
                        continue block74;
                    }
                    case 44: {
                        int n27 = n6++;
                        Expr expr14 = new Expr(method, n13, this.strings[reader.readU30()]);
                        exprArray[n27] = expr14;
                        block.add(expr14);
                        continue block74;
                    }
                    case 45: {
                        int n28 = n6++;
                        Expr expr15 = new Expr(method, n13, new Integer(this.ints[reader.readU30()]));
                        exprArray[n28] = expr15;
                        block.add(expr15);
                        continue block74;
                    }
                    case 46: {
                        int n29 = n6++;
                        Expr expr16 = new Expr(method, n13, new Long(this.uints[reader.readU30()]));
                        exprArray[n29] = expr16;
                        block.add(expr16);
                        continue block74;
                    }
                    case 47: {
                        int n30 = n6++;
                        Expr expr17 = new Expr(method, n13, new Double(this.doubles[reader.readU30()]));
                        exprArray[n30] = expr17;
                        block.add(expr17);
                        continue block74;
                    }
                    case 49: {
                        int n31 = n6++;
                        Expr expr18 = new Expr(method, n13, this.namespaces[reader.readU30()]);
                        exprArray[n31] = expr18;
                        block.add(expr18);
                        continue block74;
                    }
                    case 98: {
                        exprArray[n6++] = exprArray[reader.readU30()];
                        continue block74;
                    }
                    case 99: {
                        exprArray[reader.readU30()] = exprArray[--n6];
                        continue block74;
                    }
                    case 128: 
                    case 134: 
                    case 178: {
                        Expr expr19 = new Expr(method, n13, this.names[reader.readU30()], exprArray, n6, 1);
                        exprArray[n6 - 1] = expr19;
                        expr = expr19;
                        block.add(expr19);
                        continue block74;
                    }
                    case 6: {
                        block.add(new Expr(method, n13, this.strings[reader.readU30()]));
                        continue block74;
                    }
                    case 146: 
                    case 148: 
                    case 194: 
                    case 195: {
                        int n32 = reader.readU30();
                        n13 = n13 == 194 ? 192 : (n13 == 146 ? 145 : (n13 == 195 ? 193 : 147));
                        expr = exprArray[n32] = new Expr(method, n13, n32, exprArray, n32 + 1, 1);
                        block.add(exprArray[n32]);
                        continue block74;
                    }
                    case 64: {
                        expr = new Expr(method, n13);
                        expr.m = this.methods[reader.readU30()];
                        expr.scopes = GlobalOptimizer.capture(exprArray, n5, n5 - n3);
                        int n33 = n6++;
                        Expr expr20 = expr;
                        exprArray[n33] = expr20;
                        block.add(expr20);
                        continue block74;
                    }
                    case 88: {
                        expr = new Expr(method, n13, exprArray, n6, 1);
                        expr.scopes = GlobalOptimizer.capture(exprArray, n5, n5 - n3);
                        expr.c = this.classes[reader.readU30()];
                        Expr expr21 = expr;
                        exprArray[n6 - 1] = expr21;
                        block.add(expr21);
                        continue block74;
                    }
                    case 85: {
                        int n34 = 2 * reader.readU30();
                        expr = new Expr(method, n13, exprArray, n6, n34);
                        n6 -= n34;
                        int n35 = n6++;
                        Expr expr22 = expr;
                        exprArray[n35] = expr22;
                        block.add(expr22);
                        continue block74;
                    }
                    case 86: {
                        int n36 = reader.readU30();
                        expr = new Expr(method, n13, exprArray, n6, n36);
                        n6 -= n36;
                        int n37 = n6++;
                        Expr expr23 = expr;
                        exprArray[n37] = expr23;
                        block.add(expr23);
                        continue block74;
                    }
                    case 90: {
                        expr = new Expr(method, n13, reader.readU30());
                        int n38 = n6++;
                        Expr expr24 = expr;
                        exprArray[n38] = expr24;
                        block.add(expr24);
                        continue block74;
                    }
                    case 4: {
                        Name name = this.names[reader.readU30()];
                        int n39 = 1 + refArgc[name.kind];
                        expr = new Expr(method, n13, name, exprArray, n6, n39);
                        n6 -= n39;
                        int n40 = n6++;
                        Expr expr25 = expr;
                        exprArray[n40] = expr25;
                        block.add(expr25);
                        continue block74;
                    }
                    case 5: {
                        Name name = this.names[reader.readU30()];
                        int n41 = 2 + refArgc[name.kind];
                        expr = new Expr(method, n13, name, exprArray, n6, n41);
                        block.add(expr);
                        n6 -= n41;
                        continue block74;
                    }
                    case 65: {
                        int n42 = 2 + reader.readU30();
                        expr = new Expr(method, n13, exprArray, n6, n42);
                        n6 -= n42;
                        int n43 = n6++;
                        Expr expr26 = expr;
                        exprArray[n43] = expr26;
                        block.add(expr26);
                        continue block74;
                    }
                    case 66: {
                        int n44 = 1 + reader.readU30();
                        expr = new Expr(method, n13, exprArray, n6, n44);
                        n6 -= n44;
                        int n45 = n6++;
                        Expr expr27 = expr;
                        exprArray[n45] = expr27;
                        block.add(expr27);
                        continue block74;
                    }
                    case 89: 
                    case 91: 
                    case 102: 
                    case 106: {
                        Name name = this.names[reader.readU30()];
                        int n46 = 1 + refArgc[name.kind];
                        expr = new Expr(method, n13, name, exprArray, n6, n46);
                        n6 -= n46;
                        int n47 = n6++;
                        Expr expr28 = expr;
                        exprArray[n47] = expr28;
                        block.add(expr28);
                        continue block74;
                    }
                    case 96: {
                        Name name = this.names[reader.readU30()];
                        assert (refArgc[name.kind] == 0);
                        expr = new Expr(method, 93, name, exprArray, n6, 0);
                        expr.scopes = GlobalOptimizer.capture(exprArray, n5, n5 - n3);
                        block.add(expr);
                        expr = new Expr(method, 102, name, new Expr[]{expr}, 1, 1);
                        int n48 = n6++;
                        Expr expr29 = expr;
                        exprArray[n48] = expr29;
                        block.add(expr29);
                        continue block74;
                    }
                    case 93: 
                    case 94: {
                        Name name = this.names[reader.readU30()];
                        int n49 = refArgc[name.kind];
                        expr = new Expr(method, n13, name, exprArray, n6, n49);
                        expr.scopes = GlobalOptimizer.capture(exprArray, n5, n5 - n3);
                        n6 -= n49;
                        int n50 = n6++;
                        Expr expr30 = expr;
                        exprArray[n50] = expr30;
                        block.add(expr30);
                        continue block74;
                    }
                    case 95: {
                        Name name = this.names[reader.readU30()];
                        int n51 = refArgc[name.kind];
                        expr = new Expr(method, n13, name, exprArray, n6, n51);
                        n6 -= n51;
                        int n52 = n6++;
                        Expr expr31 = expr;
                        exprArray[n52] = expr31;
                        block.add(expr31);
                        continue block74;
                    }
                    case 97: 
                    case 104: {
                        Name name = this.names[reader.readU30()];
                        int n53 = 2 + refArgc[name.kind];
                        expr = new Expr(method, n13, name, exprArray, n6, n53);
                        n6 -= n53;
                        block.add(expr);
                        continue block74;
                    }
                    case 108: {
                        expr = new Expr(method, n13, reader.readU30(), exprArray, n6, 1);
                        block.add(expr);
                        exprArray[n6 - 1] = expr;
                        continue block74;
                    }
                    case 109: {
                        expr = new Expr(method, n13, reader.readU30(), exprArray, n6, 2);
                        block.add(expr);
                        n6 -= 2;
                        continue block74;
                    }
                    case 16: {
                        int n54 = reader.readS24();
                        if (n == 0) continue block74;
                        expr = new Expr(method, n13);
                        block.add(expr);
                        expr.succ = new Edge[]{new Edge(method, block, 0, (Block)treeMap.get(reader.pos + n54))};
                        GlobalOptimizer.this.merge(method, null, treeMap, treeMap2, reader.pos, exprArray, n6, n5);
                        GlobalOptimizer.this.merge(method, expr.succ[0], treeMap, treeMap2, reader.pos + n54, exprArray, n6, n5);
                        n = 0;
                        continue block74;
                    }
                    case 17: 
                    case 18: {
                        expr = new Expr(method, n13, exprArray, n6--, 1);
                        block.add(expr);
                        int n55 = reader.readS24();
                        expr.succ = new Edge[]{new Edge(method, block, 0, (Block)treeMap.get(reader.pos)), new Edge(method, block, 1, (Block)treeMap.get(reader.pos + n55))};
                        GlobalOptimizer.this.merge(method, null, treeMap, treeMap2, reader.pos, exprArray, n6, n5);
                        GlobalOptimizer.this.merge(method, expr.succ[1], treeMap, treeMap2, reader.pos + n55, exprArray, n6, n5);
                        continue block74;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 26: {
                        expr = new Expr(method, GlobalOptimizer.this.ifoper(n13), exprArray, n6, 2);
                        block.add(expr);
                        expr = new Expr(method, 18, new Expr[]{expr}, 1, 1);
                        block.add(expr);
                        int n56 = reader.readS24();
                        expr.succ = new Edge[]{new Edge(method, block, 0, (Block)treeMap.get(reader.pos)), new Edge(method, block, 1, (Block)treeMap.get(reader.pos + n56))};
                        GlobalOptimizer.this.merge(method, null, treeMap, treeMap2, reader.pos, exprArray, n6 -= 2, n5);
                        GlobalOptimizer.this.merge(method, expr.succ[1], treeMap, treeMap2, reader.pos + n56, exprArray, n6, n5);
                        continue block74;
                    }
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        expr = new Expr(method, GlobalOptimizer.this.ifoper(n13), exprArray, n6, 2);
                        block.add(expr);
                        expr = new Expr(method, 17, new Expr[]{expr}, 1, 1);
                        block.add(expr);
                        int n57 = reader.readS24();
                        expr.succ = new Edge[]{new Edge(method, block, 0, (Block)treeMap.get(reader.pos)), new Edge(method, block, 1, (Block)treeMap.get(reader.pos + n57))};
                        GlobalOptimizer.this.merge(method, null, treeMap, treeMap2, reader.pos, exprArray, n6 -= 2, n5);
                        GlobalOptimizer.this.merge(method, expr.succ[1], treeMap, treeMap2, reader.pos + n57, exprArray, n6, n5);
                        continue block74;
                    }
                    case 27: {
                        expr = new Expr(method, n13, exprArray, n6--, 1);
                        block.add(expr);
                        int n58 = n9 + reader.readS24();
                        int n59 = 1 + reader.readU30();
                        expr.succ = new Edge[n59 + 1];
                        expr.succ[n59] = new Edge(method, block, n59, (Block)treeMap.get(n58));
                        GlobalOptimizer.this.merge(method, expr.succ[n59], treeMap, treeMap2, n58, exprArray, n6, n5);
                        for (int i = 0; i < n59; ++i) {
                            n58 = n9 + reader.readS24();
                            expr.succ[i] = new Edge(method, block, i, (Block)treeMap.get(n58));
                            GlobalOptimizer.this.merge(method, expr.succ[i], treeMap, treeMap2, n58, exprArray, n6, n5);
                        }
                        n = 0;
                        continue block74;
                    }
                    case 36: {
                        int n60 = n6++;
                        Expr expr32 = new Expr(method, n13, new Integer((byte)reader.readU8()));
                        exprArray[n60] = expr32;
                        expr = expr32;
                        block.add(expr);
                        continue block74;
                    }
                    case 50: {
                        int n61 = reader.readU30();
                        int n62 = reader.readU30();
                        Expr expr33 = exprArray[n62];
                        Expr expr34 = exprArray[n61];
                        expr = exprArray[n6] = new Expr(method, n13);
                        block.add(exprArray[n6]);
                        expr.locals = new Expr[]{expr34, expr33};
                        expr = exprArray[n61] = new Expr(method, 52);
                        block.add(exprArray[n61]);
                        expr.locals = new Expr[]{expr34};
                        expr = exprArray[n62] = new Expr(method, 51);
                        block.add(exprArray[n62]);
                        expr.locals = new Expr[]{expr33};
                        ++n6;
                        continue block74;
                    }
                    case 67: {
                        int n63 = reader.readU30();
                        int n64 = 1 + reader.readU30();
                        expr = new Expr(method, n13, n63, exprArray, n6, n64);
                        n6 -= n64;
                        int n65 = n6++;
                        Expr expr35 = expr;
                        exprArray[n65] = expr35;
                        block.add(expr35);
                        continue block74;
                    }
                    case 68: {
                        int n66 = reader.readU30();
                        int n67 = 1 + reader.readU30();
                        expr = new Expr(method, n13, exprArray, n6, n67);
                        expr.m = this.methods[n66];
                        n6 -= n67;
                        int n68 = n6++;
                        Expr expr36 = expr;
                        exprArray[n68] = expr36;
                        block.add(expr36);
                        continue block74;
                    }
                    case 73: {
                        int n69 = 1 + reader.readU30();
                        expr = new Expr(method, n13, exprArray, n6, n69);
                        n6 -= n69;
                        block.add(expr);
                        continue block74;
                    }
                    case 69: 
                    case 70: 
                    case 74: 
                    case 76: {
                        Name name = this.names[reader.readU30()];
                        int n70 = 1 + reader.readU30() + refArgc[name.kind];
                        expr = new Expr(method, n13, name, exprArray, n6, n70);
                        n6 -= n70;
                        int n71 = n6++;
                        Expr expr37 = expr;
                        exprArray[n71] = expr37;
                        block.add(expr37);
                        continue block74;
                    }
                    case 78: 
                    case 79: {
                        Name name = this.names[reader.readU30()];
                        int n72 = 1 + reader.readU30() + refArgc[name.kind];
                        expr = new Expr(method, n13, name, exprArray, n6, n72);
                        n6 -= n72;
                        block.add(expr);
                        continue block74;
                    }
                    case 241: {
                        int n73 = reader.readU30();
                        continue block74;
                    }
                    case 240: 
                    case 242: {
                        int n74 = reader.readU30();
                        continue block74;
                    }
                    case 239: {
                        int n75 = reader.readU8();
                        int n76 = reader.readU30();
                        int n77 = reader.readU8();
                        int n78 = reader.readU30();
                        continue block74;
                    }
                    case 1: {
                        continue block74;
                    }
                    case 243: {
                        block.add(new Expr(method, n13));
                        continue block74;
                    }
                    case 2: {
                        continue block74;
                    }
                }
                assert (false);
            }
            GlobalOptimizer.this.dce(method);
        }
    }
}

