/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import macromedia.abc.AbcParser;
import macromedia.abc.Optimizer;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.CompilerPlug;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.embedding.IncludeInfo;
import macromedia.asc.embedding.LintEvaluator;
import macromedia.asc.embedding.SwfMaker;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.NodePrinter;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.semantics.CodeGenerator;
import macromedia.asc.semantics.ConfigurationEvaluator;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.StringPrintWriter;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements ErrorConstants {
    static int ref_count = 0;
    private static final String newline = System.getProperty("line.separator");
    static int col_counter = 0;

    static void init() {
        if (ref_count == 0) {
            TypeValue.init();
            ObjectValue.init();
        }
        ++ref_count;
    }

    static void print_byte(byte by) {
        if (col_counter % 16 == 0) {
            System.out.print("\n\t");
        }
        System.out.print(Integer.toHexString(by));
        ++col_counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compile(Context context, ObjectValue objectValue, InputStream inputStream, String string, String string2, ObjectList<IncludeInfo> objectList, String string3, String string4, ObjectList<CompilerPlug> objectList2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, ObjectList<String> objectList3) {
        Object object;
        ErrorConstants errorConstants;
        Object object2;
        ProgramNode programNode = null;
        ObjectList<ImportNode> objectList5 = new ObjectList<ImportNode>();
        for (String object32 : objectList3) {
            object2 = new Context(context.statics);
            Object i = null;
            try {
                if (object32.endsWith(".abc")) {
                    programNode = new AbcParser((Context)object2, object32).parseAbc();
                    if (programNode == null) {
                        context.error(-1, 1111, object32);
                    }
                } else {
                    i = new BufferedInputStream(new FileInputStream(object32));
                    ((Context)object2).setPath(new File(object32).getAbsoluteFile().getParent());
                    programNode = new Parser((Context)object2, (InputStream)i, object32, null, bl, bl7).parseProgram();
                }
            }
            catch (IOException iOException) {
                context.error(-1, 1063, object32);
            }
            finally {
                if (i != null) {
                    try {
                        ((BufferedInputStream)i).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            NodeFactory nodeFactory = ((Context)object2).getNodeFactory();
            objectList5.push_back(nodeFactory.Import((Context)object2, nodeFactory.literalString(object32, 0), programNode));
            ((Context)object2).getNodeFactory().pkg_defs.clear();
        }
        context.setPath(new File(string).getAbsoluteFile().getParent());
        ProgramNode programNode2 = new Parser(context, inputStream, string, string2, bl, bl7).parseProgram();
        programNode2.imports = objectList5;
        ObjectList<Object> objectList4 = new ObjectList<Object>();
        if (objectList != null) {
            for (IncludeInfo includeInfo : objectList) {
                errorConstants = new Context(context.statics);
                object2 = new Parser((Context)errorConstants, includeInfo.script, includeInfo.name, includeInfo.encoding, bl, bl7).parseProgram();
                objectList4.add(object2);
            }
        }
        context.pushScope(objectValue);
        if (objectList != null && objectList.size() > 0) {
            object2 = programNode2.statements.items;
            for (int i = objectList4.size() - 1; i >= 0; --i) {
                Context context2 = ((ProgramNode)objectList4.get((int)i)).cx;
                errorConstants = context2.getNodeFactory();
                String string5 = ((IncludeInfo)objectList.get((int)i)).name;
                object = ((NodeFactory)errorConstants).literalString(string5, 0);
                IncludeDirectiveNode includeDirectiveNode = ((NodeFactory)errorConstants).includeDirective(context2, (LiteralStringNode)object, (ProgramNode)objectList4.get(i));
                StatementListNode statementListNode = ((NodeFactory)errorConstants).statementList(null, includeDirectiveNode);
                ObjectList<Node> objectList6 = statementListNode.items;
                ((ArrayList)object2).addAll(0, objectList6);
            }
        }
        programNode2.pkgdefs.clear();
        programNode2.pkgdefs.addAll(context.getNodeFactory().pkg_defs);
        if (bl2 && context.errorCount() == 0) {
            Compiler.printParseTrees(context.scriptName(), programNode2, context, ".p");
            return;
        }
        if (context.errorCount() == 0) {
            object2 = new ConfigurationEvaluator();
            programNode2.evaluate(context, (Evaluator)object2);
        }
        if (context.errorCount() == 0) {
            object2 = new FlowGraphEmitter(context, string, bl4);
            FlowAnalyzer stringBuffer = new FlowAnalyzer((Emitter)object2);
            programNode2.evaluate(context, stringBuffer);
            programNode2.evaluate(context, stringBuffer);
        }
        if (context.errorCount() == 0 && bl6) {
            object2 = new MetaDataEvaluator(bl8);
            programNode2.evaluate(context, (Evaluator)object2);
        }
        if (context.errorCount() == 0) {
            object2 = new ConstantEvaluator(context);
            programNode2.evaluate(context, (Evaluator)object2);
        }
        if (context.errorCount() == 0 && bl) {
            object2 = new MetaDataEvaluator();
            programNode2.evaluate(context, (Evaluator)object2);
            StringBuffer codeGenerator = new StringBuffer();
            codeGenerator.append("<asdoc>").append(newline);
            ObjectList<DocCommentNode> objectList7 = ((MetaDataEvaluator)object2).doccomments;
            int n = objectList7.size();
            for (int i = 0; i < n; ++i) {
                ((DocCommentNode)objectList7.get(i)).emit(context, codeGenerator);
            }
            codeGenerator.append(newline).append("</asdoc>").append(newline);
            FilterOutputStream filterOutputStream = null;
            try {
                object = new StringBuffer().append(context.scriptName()).append(".xml").toString();
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(context.path(), (String)object)));
                filterOutputStream.write(codeGenerator.toString().getBytes());
                ((BufferedOutputStream)filterOutputStream).flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                        System.err.println(new StringBuffer().append("wrote .xml doc file: ").append(context.path()).append("/").append(context.scriptName()).append("xml").toString());
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
        if (bl5 && context.errorCount() == 0) {
            object2 = new LintEvaluator(context, string, (String)null);
            programNode2.evaluate(context, (Evaluator)object2);
            ((LintEvaluator)object2).logWarnings(context);
            ((LintEvaluator)object2).clear();
        }
        if (context.errorCount() == 0) {
            object2 = context.getEmitter();
            CodeGenerator codeGenerator = new CodeGenerator((Emitter)object2);
            programNode2.evaluate(context, codeGenerator);
        }
        context.popScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean doCompile(InputStream inputStream, String string, String string2, String string3, String string4, String string5, String string6, ObjectList<IncludeInfo> objectList, ObjectList<String> objectList2, String string7, ObjectList<ConfigVar> objectList3, ObjectList<CompilerPlug> objectList4, CompilerHandler compilerHandler, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, int n, boolean bl13) {
        Compiler.init();
        ContextStatics contextStatics = new ContextStatics();
        contextStatics.handler = compilerHandler;
        contextStatics.use_static_semantics = bl10;
        contextStatics.dialect = n;
        Context context = new Context(contextStatics);
        context.setLanguage(string7);
        context.setPath(string);
        context.setScriptName(string2);
        ActionBlockEmitter actionBlockEmitter = new ActionBlockEmitter(context, string2, new StringPrintWriter(), new StringPrintWriter(), bl3, bl4, bl5, bl2);
        context.setEmitter(actionBlockEmitter);
        context.setHandler(compilerHandler);
        context.config_vars = objectList3;
        GlobalBuilder globalBuilder = new GlobalBuilder();
        ObjectValue objectValue = new ObjectValue(context, globalBuilder, null);
        Compiler.compile(context, objectValue, inputStream, string3, string4, objectList, string5, string6, objectList4, bl, bl6, bl7, bl8, bl9, bl11, bl12, bl2, objectList2);
        int n2 = Compiler.status(context);
        if (n2 == 1) {
            System.err.println();
            System.err.println("1 error found");
        } else if (n2 > 1) {
            System.err.println();
            System.err.println(new StringBuffer().append(n2).append(" errors found").toString());
        } else if (!bl6 && !bl) {
            if (bl3) {
                Compiler.printIL(context, string2, actionBlockEmitter);
            }
            if (n2 == 0 && !bl6) {
                ByteList byteList = new ByteList();
                actionBlockEmitter.emit(byteList);
                if (byteList.size() != 0) {
                    if (bl13) {
                        byteList = Optimizer.optimize(byteList);
                    }
                    FilterOutputStream filterOutputStream = null;
                    try {
                        filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string, new StringBuffer().append(string2).append(".abc").toString())));
                        filterOutputStream.write(byteList.toByteArray());
                        ((BufferedOutputStream)filterOutputStream).flush();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    finally {
                        if (filterOutputStream != null) {
                            try {
                                filterOutputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    System.err.println();
                    if (string5.length() == 0 && !ContextStatics.useSanityStyleErrors) {
                        System.err.println(new StringBuffer().append(string2).append(".abc, ").append(byteList.size()).append(" bytes written").toString());
                    }
                    if (string6 != null) {
                        Compiler.createProjector(string6, string, string2, byteList);
                    }
                    if (string5.length() != 0) {
                        SwfMaker swfMaker = new SwfMaker();
                        if (!swfMaker.EncodeABC(byteList, string5)) {
                            System.err.println("ERROR: invalid -swf options, should be classname,width,height");
                        } else {
                            FilterOutputStream filterOutputStream2 = null;
                            try {
                                filterOutputStream2 = new BufferedOutputStream(new FileOutputStream(new File(string, new StringBuffer().append(string2).append(".swf").toString())));
                                filterOutputStream2.write(swfMaker.buffer.toByteArray());
                                ((BufferedOutputStream)filterOutputStream2).flush();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            finally {
                                if (filterOutputStream2 != null) {
                                    try {
                                        filterOutputStream2.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                            System.err.println(new StringBuffer().append(string2).append(".swf, ").append(swfMaker.buffer.size()).append(" bytes written").toString());
                        }
                    }
                    if (actionBlockEmitter.native_method_count > 0) {
                        Compiler.printNative(context, string2, actionBlockEmitter, byteList.toByteArray(false));
                    }
                }
            }
        }
        contextStatics.clear();
        Compiler.fini();
        return n2 == 0;
    }

    /*
     * WARNING - void declaration
     */
    static boolean doCompile(CompilerPlug compilerPlug, ObjectList<CompilerPlug> objectList, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws Exception {
        void var9_16;
        Object object;
        if (compilerPlug != null) {
            void var9_11;
            File file = new File(compilerPlug.filename.trim());
            if (file.exists()) {
                BufferedInputStream object22 = new BufferedInputStream(new FileInputStream(file));
            } else {
                object = new byte[]{0};
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            }
            if (var9_11 != null) {
                compilerPlug.in = var9_11;
            }
        }
        for (CompilerPlug compilerPlug2 : objectList) {
            InputStream inputStream;
            object = new File(compilerPlug2.filename.trim());
            if (object.exists()) {
                inputStream = new BufferedInputStream(new FileInputStream((File)object));
            } else {
                byte[] byArray = new byte[]{0};
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (inputStream == null) continue;
            compilerPlug2.in = inputStream;
        }
        Object var9_14 = null;
        if (var9_14 == null) {
            CompilerHandler compilerHandler = compilerPlug.handler;
        }
        return Compiler.doCompile(compilerPlug.in, compilerPlug.pathspec, compilerPlug.scriptname, compilerPlug.filename, compilerPlug.file_encoding, compilerPlug.swf_options, compilerPlug.avmplus_exe, compilerPlug.includes, compilerPlug.import_filespecs, compilerPlug.language, compilerPlug.configs, objectList, (CompilerHandler)var9_16, compilerPlug.emit_doc_info, compilerPlug.emit_debug_info, bl, bl2, bl3, bl4, bl5, bl6, compilerPlug.lint_mode, compilerPlug.use_static_semantics, compilerPlug.emit_metadata, compilerPlug.save_comment_nodes, compilerPlug.dialect, compilerPlug.optimize);
    }

    static boolean doCompile(CompilerPlug compilerPlug) {
        return Compiler.doCompile(compilerPlug.in, compilerPlug.pathspec, compilerPlug.scriptname, compilerPlug.filename, compilerPlug.file_encoding, compilerPlug.swf_options, compilerPlug.avmplus_exe, compilerPlug.includes, compilerPlug.import_filespecs, compilerPlug.language, compilerPlug.configs, new ObjectList<CompilerPlug>(), compilerPlug.handler, compilerPlug.emit_doc_info, compilerPlug.emit_debug_info, false, false, false, false, false, false, compilerPlug.lint_mode, compilerPlug.use_static_semantics, compilerPlug.emit_metadata, compilerPlug.save_comment_nodes, compilerPlug.dialect, compilerPlug.optimize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createProjector(String string, String string2, String string3, ByteList byteList) {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        int n = 0;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(string)));
            int n2 = byteList.size();
            int n3 = bufferedInputStream.available();
            byte[] byArray = new byte[n3];
            bufferedInputStream.read(byArray);
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2, new StringBuffer().append(string3).append(".exe").toString())));
            filterOutputStream.write(byArray);
            n += byArray.length;
            filterOutputStream.write(byteList.toByteArray());
            n += n2;
            byte[] byArray2 = new byte[]{86, 52, 18, -6, (byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
            filterOutputStream.write(byArray2);
            n += 8;
            ((BufferedOutputStream)filterOutputStream).flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.err.println(new StringBuffer().append(string3).append(".exe, ").append(n).append(" bytes written").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printIL(Context context, String string, ActionBlockEmitter actionBlockEmitter) {
        if (Compiler.status(context) == 0) {
            OutputStreamWriter outputStreamWriter = null;
            String string2 = actionBlockEmitter.il_str();
            try {
                outputStreamWriter = new FileWriter(new File(context.path(), new StringBuffer().append(string).append(".il").toString()));
                outputStreamWriter.write(string2);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printNative(Context context, String string, ActionBlockEmitter actionBlockEmitter, byte[] byArray) {
        if (Compiler.status(context) == 0) {
            actionBlockEmitter.dumpCpoolVars();
            String string2 = actionBlockEmitter.header_str();
            int n = byArray.length;
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(new File(context.path(), new StringBuffer().append(string).append(".h").toString())));
                printWriter.write(string2);
                printWriter.println(new StringBuffer().append("const int ").append(string).append("_abc_length = ").append(n).append(";").toString());
                printWriter.println(new StringBuffer().append("const int ").append(string).append("_abc_method_count = ").append(actionBlockEmitter.native_method_count).append(";").toString());
                printWriter.println(new StringBuffer().append("const int ").append(string).append("_abc_class_count = ").append(actionBlockEmitter.native_class_count).append(";").toString());
                printWriter.println(new StringBuffer().append("const int ").append(string).append("_abc_script_count = ").append(actionBlockEmitter.native_package_count).append(";").toString());
                printWriter.println(new StringBuffer().append("extern const unsigned char ").append(string).append("_abc_data[];").toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            printWriter = null;
            try {
                printWriter = new PrintWriter(new FileWriter(new File(context.path(), new StringBuffer().append(string).append(".cpp").toString())));
                printWriter.println(new StringBuffer().append("const unsigned char ").append(string).append("_abc_data[").append(n).append("] = {").toString());
                for (int i = 0; i < n; ++i) {
                    int n2 = 0xFF & byArray[i];
                    printWriter.print("0x");
                    if (n2 < 16) {
                        printWriter.print('0');
                    }
                    printWriter.print(Integer.toHexString(n2));
                    if (i + 1 < n) {
                        printWriter.print(',');
                    }
                    if ((i + 1) % 16 == 0) {
                        printWriter.println();
                        continue;
                    }
                    printWriter.print(' ');
                }
                printWriter.println("};");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }

    static int status(Context context) {
        return context.errorCount();
    }

    static void fini() {
        if (--ref_count == 0) {
            ObjectValue.clear();
            TypeValue.clear();
        }
    }

    static void printParseTrees(String string, Node node, Context context, String string2) {
        if (Compiler.status(context) == 0) {
            PrintWriter printWriter;
            try {
                printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(context.path(), new StringBuffer().append(string).append(string2).toString())), "UTF-8")), true);
            }
            catch (IOException iOException) {
                printWriter = new PrintWriter(System.out, true);
            }
            NodePrinter nodePrinter = new NodePrinter(printWriter);
            node.evaluate(context, nodePrinter);
            printWriter.flush();
            printWriter.close();
        }
    }

    static void DetectFileImports(InputStream inputStream, String string, String string2, String string3, CompilerHandler compilerHandler) {
    }

    static ProgramNode parseAbcFile(Context context, String string) throws IOException {
        AbcParser abcParser = new AbcParser(context, string);
        return abcParser.parseAbc();
    }
}

