/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.embedding.avmplus.ByteCodeFactory;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.InputBuffer;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.Parser;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.UnresolvedNamespace;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Block;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Context
implements ErrorConstants {
    private String parser_scanner_input_origin;
    private String qualified_origin;
    public Parser parser;
    public PrintWriter err;
    public InputBuffer input;
    public ContextStatics statics;
    public CompilerHandler handler;
    public ObjectList<ConfigVar> config_vars = new ObjectList();
    public static final byte NS_PUBLIC = 0;
    public static final byte NS_INTERNAL = 1;
    public static final byte NS_PRIVATE = 2;
    public static final byte NS_PROTECTED = 3;
    public static final byte NS_EXPLICIT = 4;
    public static final byte NS_STATIC_PROTECTED = 5;
    public static final String NS_INTERNAL_SUFFIX = "$internal";
    public static final String NS_PRIVATE_SUFFIX = "$private";
    public static final String NS_PROTECTED_SUFFIX = "$protected";
    public static final String NS_STATIC_PROTECTED_SUFFIX = "$staticprotected";
    private static int contextIds;
    private int contextId;
    private TreeMap<UnresolvedNamespace, ObjectList<ObjectValue>> unresolved_namespaces;
    public ObjectList<Node> comments = new ObjectList();
    public boolean scriptAssistParsing = false;
    public ObjectList<TypeInfo> def_types = new ObjectList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Context(ContextStatics contextStatics) {
        this.statics = contextStatics;
        this.handler = null;
        this.qualified_origin = "";
        this.err = null;
        this.contextId = contextIds++;
        if (contextStatics != null) {
            if (contextStatics.nodeFactory == null) {
                contextStatics.nodeFactory = new NodeFactory(this);
            }
            if (contextStatics.builtins == null) {
                contextStatics.builtins = new HashMap();
                contextStatics.userDefined = new HashMap();
                contextStatics.namespaces = new HashMap();
                contextStatics.internal_namespaces = new HashMap();
                contextStatics.protected_namespaces = new HashMap();
                contextStatics.static_protected_namespaces = new HashMap();
                contextStatics.private_namespaces = new HashMap();
                contextStatics.validImports = new HashSet<String>();
            }
        }
    }

    private Context(Context context) {
        this.statics = context.statics;
        this.handler = context.handler;
        this.err = context.err;
        this.contextId = context.contextId;
        this.def_types = context.def_types;
        this.input = context.input;
        this.parser = context.parser;
        this.parser_scanner_input_origin = context.parser_scanner_input_origin;
        this.qualified_origin = context.qualified_origin;
    }

    public Context makeCopyOf() {
        return new Context(this);
    }

    public int getId() {
        return this.contextId;
    }

    public void switchToContext(Context context) {
        this.parser_scanner_input_origin = context.parser_scanner_input_origin;
        this.qualified_origin = context.qualified_origin;
        this.parser = context.parser;
        this.err = context.err;
        this.input = context.input;
        this.statics = context.statics;
        this.handler = context.handler;
        if (context.unresolved_namespaces != null) {
            if (this.unresolved_namespaces == null) {
                this.unresolved_namespaces = context.unresolved_namespaces;
            } else {
                ArrayList<UnresolvedNamespace> arrayList = new ArrayList<UnresolvedNamespace>(context.unresolved_namespaces.keySet());
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    UnresolvedNamespace unresolvedNamespace = (UnresolvedNamespace)arrayList.get(i);
                    ObjectList<ObjectValue> objectList = context.unresolved_namespaces.get(unresolvedNamespace);
                    if (this.unresolved_namespaces.get(unresolvedNamespace) != null) continue;
                    this.unresolved_namespaces.put(unresolvedNamespace, objectList);
                }
            }
        }
        this.def_types = context.def_types;
    }

    public void setCompoundNames(ObjectList<String> objectList) {
        this.statics.nodeFactory.init(objectList);
    }

    public String getUniqueNamespaceName(String string, Context context) {
        String string2 = new StringBuffer().append(string).append("$").append(context.statics.ticket_count++).toString();
        return string2.intern();
    }

    public String getFileInternalNamespaceName() {
        String string = this.getErrorOrigin();
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return this.getUniqueNamespaceName(string, this);
    }

    public String errorString(int n) {
        if (this.statics.errorCodeMap.get(Boxing.valueOf(n)) == null) {
            ErrorConstants.AscError[] ascErrorArray = allErrorConstants[this.statics.languageID];
            for (int i = 0; i < 175; ++i) {
                this.statics.errorCodeMap.put(Boxing.valueOf(ascErrorArray[i].code), ascErrorArray[i].errorMsg);
            }
        }
        return this.statics.errorCodeMap.get(Boxing.valueOf(n));
    }

    public static int replaceStringArg(StringBuffer stringBuffer, String string, int n, String string2) {
        if (n == -1) {
            return -1;
        }
        int n2 = -1;
        int n3 = string.length();
        int n4 = string.indexOf(37, n);
        if (n4 != -1) {
            if (n4 > n) {
                stringBuffer.append(string.substring(n, n4));
            }
            stringBuffer.append(string2);
            n2 = n4 + 2;
        } else {
            stringBuffer.append(string.substring(n, n3));
        }
        return n2;
    }

    public String shellErrorString(int n) {
        return new StringBuffer().append(ContextStatics.useVerboseErrors ? new StringBuffer().append("[Compiler] Error #").append(n).append(": ").toString() : "").append(this.errorString(n)).toString();
    }

    public void error(int n, int n2) {
        this.error(n, n2, "", "", "");
    }

    public void error(int n, int n2, String string) {
        this.error(n, n2, string, "", "");
    }

    public void error(int n, int n2, String string, String string2) {
        this.error(n, n2, string, string2, "");
    }

    public void error(int n, int n2, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (ContextStatics.useSanityStyleErrors) {
            stringBuffer.append(new StringBuffer().append("code=").append(n2).append("; arg1=").append(string).append("; arg2=").append(string2).append("; arg3=").append(string3).toString());
        } else {
            String string4 = this.shellErrorString(n2);
            int n3 = Context.replaceStringArg(stringBuffer, string4, 0, string);
            n3 = Context.replaceStringArg(stringBuffer, string4, n3, string2);
            if ((n3 = Context.replaceStringArg(stringBuffer, string4, n3, string3)) != -1) {
                stringBuffer.append(string4.substring(n3, string4.length()));
            }
        }
        this.localizedError(this.getErrorOrigin(), n, stringBuffer.toString(), n2);
    }

    public void localizedError(int n, String string) {
        this.localizedError(n, string, -1);
    }

    public void localizedError(int n, String string, int n2) {
        if (n < 0) {
            n = 0;
        }
        int n3 = this.getInputLine(n);
        int n4 = this.getInputCol(n);
        this.localizedError(this.getErrorOrigin(), n3, n4, string, this.getErrorLineText(n), n2);
    }

    public void localizedWarning(int n, String string) {
        this.localizedWarning(n, string, -1);
    }

    public void localizedWarning(int n, String string, int n2) {
        if (n < 0) {
            n = 0;
        }
        int n3 = this.getInputLine(n);
        int n4 = this.getInputCol(n);
        this.localizedWarning(this.getErrorOrigin(), n3, n4, string, this.getErrorLineText(n), n2);
    }

    public void localizedError(String string, int n, String string2) {
        this.localizedError(string, n, string2, -1);
    }

    public void localizedError(String string, int n, String string2, int n2) {
        if (n < 0) {
            n = 0;
        }
        int n3 = this.getInputLine(n);
        int n4 = this.getInputCol(n);
        this.localizedError(string, n3, n4, string2, this.getErrorLineText(n), n2);
    }

    public void localizedWarning(String string, int n, String string2, int n2) {
        if (n < 0) {
            n = 0;
        }
        int n3 = this.getInputLine(n);
        int n4 = this.getInputCol(n);
        this.localizedWarning(string, n3, n4, string2, this.getErrorLineText(n), n2);
    }

    public void localizedError2(int n, Object object) {
        this.localizedError2(this.getErrorOrigin(), n, object);
    }

    public void localizedError2(String string, int n, Object object) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.getInputLine(n);
        int n3 = this.getInputCol(n);
        this.localizedError2(string, n2, n3, object, this.getErrorLineText(n));
    }

    public void localizedError2(String string, int n, int n2, Object object, String string2) {
        if (this.handler != null) {
            this.handler.error2(string, n, n2, object, string2);
        } else if (this.statics.handler != null) {
            this.statics.handler.error2(string, n, n2, object, string2);
        } else {
            this.missingHandler(string, n, n2, object, string2);
        }
        ++this.statics.errCount;
    }

    public void localizedWarning2(int n, Object object) {
        this.localizedWarning2(this.getErrorOrigin(), n, object);
    }

    public void localizedWarning2(String string, int n, Object object) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.getInputLine(n);
        int n3 = this.getInputCol(n);
        this.localizedWarning2(string, n2, n3, object, this.getErrorLineText(n));
    }

    public void localizedWarning2(String string, int n, int n2, Object object, String string2) {
        if (this.handler != null) {
            this.handler.warning2(string, n, n2, object, string2);
        } else if (this.statics.handler != null) {
            this.statics.handler.warning2(string, n, n2, object, string2);
        } else {
            this.missingHandler(string, n, n2, object, string2);
        }
    }

    private void missingHandler(String string, int n, int n2, Object object, String string2) {
        System.err.println(object);
        System.err.println(new StringBuffer().append("   ").append(string).append(", Ln ").append(n).append(", Col ").append(n2).append(": ").toString());
        if (string2.length() > 0) {
            System.err.println(new StringBuffer().append("   ").append(string2).toString());
            System.err.println(new StringBuffer().append("   ").append(InputBuffer.getLinePointer(n2)).toString());
        }
        System.err.println();
    }

    public int getInputLine(int n) {
        int n2 = -1;
        if (this.input != null) {
            n2 = this.input.getLnNum(n);
        }
        return n2;
    }

    int getInputCol(int n) {
        int n2 = -1;
        if (this.input != null) {
            n2 = this.input.getColPos(n);
        }
        return n2;
    }

    String getErrorLineText(int n) {
        String string = "";
        if (this.input != null) {
            string = this.input.getLineText(n);
        }
        return string;
    }

    public String getErrorOrigin() {
        return this.parser_scanner_input_origin != null ? this.parser_scanner_input_origin : "";
    }

    public String getQualifiedErrorOrigin() {
        if (this.qualified_origin != null && this.qualified_origin.length() > 0) {
            return this.qualified_origin;
        }
        return this.getErrorOrigin();
    }

    public void localizedError(String string, int n, int n2, String string2, String string3) {
        this.localizedError(string, n, n2, string2, string3, -1);
    }

    public void localizedError(String string, int n, int n2, String string2, String string3, int n3) {
        if (this.handler != null) {
            this.handler.error(string, n, n2, string2, string3, n3);
        } else if (this.statics.handler != null) {
            this.statics.handler.error(string, n, n2, string2, string3, n3);
        } else {
            this.missingHandler(string, n, n2, string2, string3);
        }
        ++this.statics.errCount;
    }

    private void localizedWarning(String string, int n, int n2, String string2, String string3, int n3) {
        if (this.handler != null) {
            this.handler.warning(string, n, n2, string2, string3, n3);
        } else if (this.statics.handler != null) {
            this.statics.handler.warning(string, n, n2, string2, string3, n3);
        } else {
            this.missingHandler(string, n, n2, string2, string3);
        }
    }

    public void internalError(int n, String string) {
        this.localizedError(this.getErrorOrigin(), n, string, 1199);
    }

    public void internalError(String string) {
        this.internalError(-1, string);
    }

    public void importFile(String string) {
        if (this.handler != null) {
            this.handler.importFile(string);
        }
    }

    public void exit(int n) {
    }

    public void setDefType(BitSet bitSet, TypeInfo typeInfo) {
        if (BitSet.isEmpty(bitSet)) {
            return;
        }
        int n = BitSet.nextSetBit(bitSet, 0);
        if (n - this.def_types.size() >= 0) {
            this.def_types.resize(n + 1);
            this.def_types.set(n, typeInfo);
        } else if (this.def_types.get(n) == null) {
            this.def_types.set(n, typeInfo);
        } else if (!typeInfo.equals(this.def_types.get(n))) {
            this.def_types.set(n, typeInfo);
        }
    }

    public TypeInfo getDefType(BitSet bitSet) {
        TypeInfo typeInfo = this.voidType().getDefaultTypeInfo();
        if (BitSet.isEmpty(bitSet)) {
            return this.noType().getDefaultTypeInfo();
        }
        BitSet bitSet2 = bitSet;
        int n = BitSet.nextSetBit(bitSet2, 0);
        while (n >= 0) {
            int n2 = 0;
            n2 = n - this.def_types.size();
            if (n2 >= 0) {
                return this.noType().getDefaultTypeInfo();
            }
            if (typeInfo != null && typeInfo.getTypeValue() == this.voidType()) {
                typeInfo = (TypeInfo)this.def_types.get(n);
            } else if (this.def_types.get(n) != null && (typeInfo.getTypeId() & ((TypeInfo)this.def_types.get(n)).getTypeId()) == 0) {
                typeInfo = this.noType().getDefaultTypeInfo();
            }
            n = BitSet.nextSetBit(bitSet2, n + 1);
        }
        return typeInfo;
    }

    public Node coerce(Node node, TypeInfo[] typeInfoArray, TypeValue typeValue) {
        return this.coerce(node, typeInfoArray, typeValue != null ? typeValue.getDefaultTypeInfo() : null, false, false);
    }

    public Node coerce(Node node, TypeInfo[] typeInfoArray, TypeValue typeValue, boolean bl) {
        return this.coerce(node, typeInfoArray, typeValue != null ? typeValue.getDefaultTypeInfo() : null, bl, false);
    }

    public Node coerce(Node node, TypeInfo[] typeInfoArray, TypeInfo typeInfo) {
        return this.coerce(node, typeInfoArray, typeInfo, false, false);
    }

    public Node coerce(Node node, TypeInfo[] typeInfoArray, TypeInfo typeInfo, boolean bl) {
        return this.coerce(node, typeInfoArray, typeInfo, bl, false);
    }

    public Node coerce(Node node, TypeInfo[] typeInfoArray, TypeInfo typeInfo, boolean bl, boolean bl2) {
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            Node node2 = listNode.items.back();
            node2 = this.coerce(node2, typeInfoArray, typeInfo, bl, bl2);
            listNode.items.pop_back();
            listNode.items.push_back(node2);
            return node;
        }
        if (node instanceof ConditionalExpressionNode) {
            ConditionalExpressionNode conditionalExpressionNode = (ConditionalExpressionNode)node;
            typeInfoArray[0] = conditionalExpressionNode.thenvalue != null ? conditionalExpressionNode.thenvalue.getType(this) : null;
            conditionalExpressionNode.thenexpr = this.coerce(conditionalExpressionNode.thenexpr, typeInfoArray, typeInfo, bl, true);
            typeInfoArray[0] = conditionalExpressionNode.elsevalue != null ? conditionalExpressionNode.elsevalue.getType(this) : null;
            conditionalExpressionNode.elseexpr = this.coerce(conditionalExpressionNode.elseexpr, typeInfoArray, typeInfo, bl, true);
            return node;
        }
        if (node instanceof BinaryExpressionNode) {
            BinaryExpressionNode binaryExpressionNode = (BinaryExpressionNode)node;
            if ((binaryExpressionNode.op == -10 || binaryExpressionNode.op == -36) && (typeInfo != null && typeInfo.getTypeValue() != this.voidType() || binaryExpressionNode.lhstype != binaryExpressionNode.rhstype)) {
                TypeInfo typeInfo2 = typeInfo != null ? (typeInfo.getTypeValue() == this.voidType() ? this.noType().getDefaultTypeInfo() : typeInfo) : null;
                typeInfoArray[0] = binaryExpressionNode.lhstype;
                binaryExpressionNode.lhs = this.coerce(binaryExpressionNode.lhs, typeInfoArray, typeInfo2, bl, true);
                binaryExpressionNode.lhstype = typeInfoArray[0];
                typeInfoArray[0] = binaryExpressionNode.rhstype;
                binaryExpressionNode.rhs = this.coerce(binaryExpressionNode.rhs, typeInfoArray, typeInfo2, bl, true);
                binaryExpressionNode.rhstype = typeInfoArray[0];
                return node;
            }
        }
        if (typeInfo == null) {
            if (bl2) {
                typeInfoArray[0] = this.noType().getDefaultTypeInfo();
                return this.statics.nodeFactory.coerce(node, null, this.noType().getDefaultTypeInfo(), bl);
            }
            return node;
        }
        if (typeInfo.getTypeValue() == this.voidType()) {
            typeInfoArray[0] = typeInfo;
            node.voidResult();
            return node;
        }
        if (typeInfoArray[0] == null) {
            typeInfoArray[0] = typeInfo;
            return this.statics.nodeFactory.coerce(node, null, typeInfo, bl);
        }
        if (typeInfo == typeInfoArray[0] || typeInfo.includes(this, typeInfoArray[0])) {
            return bl2 ? this.statics.nodeFactory.coerce(node, null, typeInfo, bl) : node;
        }
        if (this.useStaticSemantics() && typeInfoArray[0].getTypeValue() != this.nullType() && typeInfo.getTypeValue() != this.booleanType()) {
            if (typeInfoArray[0].getTypeValue().getTypeInfo(true).includes(this, typeInfo)) {
                if (!bl && typeInfoArray[0].getTypeValue() != this.noType()) {
                    this.error(node.pos() - 1, 1118, typeInfoArray[0].getName(this).toString(), typeInfo.getName(this).toString());
                }
            } else if ((typeInfo.getTypeValue() != this.stringType() || typeInfoArray[0].getTypeValue() != this.xmlType() && typeInfoArray[0].getTypeValue() != this.xmlListType()) && (typeInfo.getTypeValue() != this.numberType() || typeInfoArray[0].getTypeValue() != this.intType() && typeInfoArray[0].getTypeValue() != this.uintType()) && (typeInfo.getTypeValue() != this.uintType() || typeInfoArray[0].getTypeValue() != this.intType() && typeInfoArray[0].getTypeValue() != this.numberType()) && (typeInfo.getTypeValue() != this.intType() || typeInfoArray[0].getTypeValue() != this.uintType() && typeInfoArray[0].getTypeValue() != this.numberType())) {
                this.error(node.pos() - 1, 1067, typeInfoArray[0].getName(this).toString(), typeInfo.getName(this).toString());
            }
        }
        return bl2 || bl ? this.statics.nodeFactory.coerce(node, typeInfoArray[0], typeInfo, bl) : node;
    }

    public int errorCount() {
        return this.statics.errCount;
    }

    private void pushStaticClassScopesHelper(TypeValue typeValue) {
        if (typeValue.baseclass != null) {
            this.pushStaticClassScopesHelper(typeValue.baseclass);
        }
        this.pushScope(typeValue);
    }

    public void pushStaticClassScopes(ClassDefinitionNode classDefinitionNode) {
        this.pushStaticClassScopesHelper(classDefinitionNode.cframe);
    }

    public void popStaticClassScopes(ClassDefinitionNode classDefinitionNode) {
        TypeValue typeValue = classDefinitionNode.cframe;
        while (typeValue != null) {
            this.popScope();
            typeValue = typeValue.baseclass;
        }
    }

    public void pushScope(ObjectValue objectValue) {
        if (this.statics.scopes.isEmpty()) {
            this.statics.global = objectValue;
        }
        this.statics.scopes.add(objectValue);
    }

    public void popScope() {
        this.statics.scopes.removeLast();
        if (this.statics.scopes.isEmpty()) {
            this.statics.global = null;
        }
    }

    public ObjectList<ObjectValue> getScopes() {
        return this.statics.scopes;
    }

    public ObjectList<ObjectValue> swapScopeChain(ObjectList<ObjectValue> objectList) {
        ObjectList<ObjectValue> objectList2 = this.statics.scopes;
        this.statics.scopes = objectList;
        return objectList2;
    }

    public ObjectValue scope() {
        if (this.statics.scopes.size() > 0) {
            return this.statics.scopes.back();
        }
        return this.statics.global;
    }

    public int getScopeDepth() {
        return this.statics.scopes.size();
    }

    public ObjectValue scope(int n) {
        if (n >= 0 && n < this.statics.scopes.size()) {
            return (ObjectValue)this.statics.scopes.get(n);
        }
        return this.statics.global;
    }

    public ObjectValue globalScope() {
        return this.statics.global;
    }

    public ObjectValue builtinScope() {
        return this.statics.globalPrototype;
    }

    public void setEmitter(Emitter emitter) {
        this.statics.emitter = emitter;
    }

    public Emitter getEmitter() {
        return this.statics.emitter;
    }

    public void setPath(String string) {
        this.statics.pathspec = string;
    }

    public String path() {
        return this.statics.pathspec;
    }

    public void setScriptName(String string) {
        this.statics.scriptname = string;
    }

    public String scriptName() {
        return this.statics.scriptname;
    }

    public NodeFactory getNodeFactory() {
        if (this.statics.nodeFactory == null) {
            this.statics.nodeFactory = new NodeFactory(this);
        }
        return this.statics.nodeFactory;
    }

    public ByteCodeFactory getByteCodeFactory() {
        if (this.statics.bytecodeFactory == null) {
            this.statics.bytecodeFactory = new ByteCodeFactory();
        }
        return this.statics.bytecodeFactory;
    }

    public void setHandler(CompilerHandler compilerHandler) {
        this.handler = compilerHandler;
        if (this.statics.handler == null) {
            this.statics.handler = compilerHandler;
        }
    }

    public void setLanguage(String string) {
        this.statics.languageID = Context.getLanguageID(string);
    }

    public static int getLanguageID(String string) {
        int n = 0;
        if (string.equals("EN")) {
            n = 0;
        } else if (string.equals("DE")) {
            n = 1;
        } else if (string.equals("ES")) {
            n = 2;
        } else if (string.equals("FR")) {
            n = 3;
        } else if (string.equals("IT")) {
            n = 4;
        } else if (string.equals("JP")) {
            n = 5;
        } else if (string.equals("KR")) {
            n = 6;
        } else if (string.equals("CN")) {
            n = 7;
        } else if (string.equals("TW")) {
            n = 8;
        }
        return n;
    }

    public CompilerHandler getHandler() {
        return this.handler;
    }

    public Writer getErrOut() {
        return this.err;
    }

    public Block newBlock() {
        return new Block();
    }

    public ObjectValue publicNamespace() {
        if (this.statics._publicNamespace == null) {
            this.statics._publicNamespace = this.getNamespace("");
        }
        return this.statics._publicNamespace;
    }

    public ObjectValue anyNamespace() {
        if (this.statics._anyNamespace == null) {
            this.statics._anyNamespace = this.getNamespace("*");
        }
        return this.statics._anyNamespace;
    }

    public TypeValue noType() {
        if (this.statics._noType == null) {
            String string = "*";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._noType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 32768);
            this.statics._noType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._noType);
            this.statics.builtins.put(string, this.statics._noType);
            this.statics._noType.prototype.builder.is_dynamic = true;
        }
        return this.statics._noType;
    }

    public TypeValue objectType() {
        if (this.statics._objectType == null) {
            String string = "Object";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._objectType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 8192);
            this.statics._objectType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._objectType);
            this.statics.builtins.put(string, this.statics._objectType);
        }
        return this.statics._objectType;
    }

    public TypeValue arrayType() {
        if (this.statics._arrayType == null) {
            String string = "Array";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._arrayType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 4096);
            this.statics._arrayType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._arrayType);
            this.statics.builtins.put(string, this.statics._arrayType);
        }
        return this.statics._arrayType;
    }

    public TypeValue voidType() {
        if (this.statics._voidType == null) {
            String string = "void";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._voidType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 1024);
            this.statics._voidType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._voidType);
            this.statics._voidType.prototype.setValue("undefined");
            this.statics.builtins.put(string, this.statics._voidType);
        }
        return this.statics._voidType;
    }

    public TypeValue nullType() {
        if (this.statics._nullType == null) {
            String string = "Null";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._nullType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 16);
            this.statics._nullType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._nullType);
            this.statics._nullType.prototype.setValue("null");
            this.statics.builtins.put(string, this.statics._nullType);
        }
        return this.statics._nullType;
    }

    public TypeValue booleanType() {
        if (this.statics._booleanType == null) {
            String string = "Boolean";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._booleanType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 1);
            this.statics._booleanType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._booleanType);
            this.statics.builtins.put(string, this.statics._booleanType);
        }
        return this.statics._booleanType;
    }

    public TypeValue stringType() {
        if (this.statics._stringType == null) {
            String string = "String";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._stringType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 4);
            this.statics._stringType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._stringType);
            this.statics.builtins.put(string, this.statics._stringType);
        }
        return this.statics._stringType;
    }

    public TypeValue typeType() {
        if (this.statics._typeType == null) {
            String string = "Class";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._typeType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 128);
            this.statics._typeType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._typeType);
            this.statics.builtins.put(string, this.statics._typeType);
        }
        return this.statics._typeType;
    }

    public TypeValue functionType() {
        if (this.statics._functionType == null) {
            String string = "Function";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._functionType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 2048);
            this.statics._functionType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._functionType);
            this.statics.builtins.put(string, this.statics._functionType);
        }
        return this.statics._functionType;
    }

    public TypeValue intType() {
        if (this.statics._intType == null) {
            String string = "int";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._intType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 256);
            this.statics._intType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._intType);
            this.statics.builtins.put(string, this.statics._intType);
        }
        return this.statics._intType;
    }

    public TypeValue uintType() {
        if (this.statics._uintType == null) {
            String string = "uint";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._uintType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 256);
            this.statics._uintType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._uintType);
            this.statics.builtins.put(string, this.statics._uintType);
        }
        return this.statics._uintType;
    }

    public TypeValue numberType() {
        if (this.statics._numberType == null) {
            String string = "Number";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._numberType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 2);
            this.statics._numberType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._numberType);
            this.statics.builtins.put(string, this.statics._numberType);
        }
        return this.statics._numberType;
    }

    public TypeValue xmlType() {
        if (this.statics._xmlType == null) {
            String string = "XML";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._xmlType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 16384);
            this.statics._xmlType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._xmlType);
            this.statics.builtins.put(string, this.statics._xmlType);
        }
        return this.statics._xmlType;
    }

    public TypeValue regExpType() {
        if (this.statics._regExpType == null) {
            String string = "RegExp";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._regExpType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 8192);
            this.statics._regExpType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._regExpType);
            this.statics.builtins.put(string, this.statics._regExpType);
        }
        return this.statics._regExpType;
    }

    public TypeValue xmlListType() {
        if (this.statics._xmlListType == null) {
            String string = "XMLList";
            QName qName = new QName(this.publicNamespace(), string);
            ObjectValue objectValue = this.getNamespace(qName.toString(), (byte)3);
            ObjectValue objectValue2 = this.getNamespace(qName.toString(), (byte)5);
            this.statics._xmlListType = new TypeValue(this, new ClassBuilder(qName, objectValue, objectValue2), qName, 16384);
            this.statics._xmlListType.prototype = new ObjectValue(this, new InstanceBuilder(qName), this.statics._xmlListType);
            this.statics.builtins.put(string, this.statics._xmlListType);
        }
        return this.statics._xmlListType;
    }

    public boolean isBuiltin(String string) {
        return this.statics.builtins.containsKey(string);
    }

    public TypeValue builtin(String string) {
        return this.statics.builtins.get(string);
    }

    public TypeValue userDefined(String string) {
        return this.statics.userDefined.get(string);
    }

    public void setUserDefined(String string, TypeValue typeValue) {
        this.statics.userDefined.put(string, typeValue);
    }

    public ObjectValue getNamespace(String string) {
        return this.getNamespace(string, (byte)0);
    }

    public ObjectValue getNamespace(String string, byte by) {
        HashMap<String, ObjectValue> hashMap;
        if (!$assertionsDisabled && string != string.intern()) {
            throw new Error();
        }
        switch (by) {
            case 1: {
                hashMap = this.statics.internal_namespaces;
                break;
            }
            case 2: {
                hashMap = this.statics.private_namespaces;
                break;
            }
            case 3: {
                hashMap = this.statics.protected_namespaces;
                break;
            }
            case 5: {
                hashMap = this.statics.static_protected_namespaces;
                break;
            }
            default: {
                hashMap = this.statics.namespaces;
            }
        }
        ObjectValue objectValue = (ObjectValue)hashMap.get(string);
        if (objectValue == null) {
            objectValue = new NamespaceValue(by);
            objectValue.setValue(string);
            objectValue.name = string;
            hashMap.put(string, objectValue);
        }
        return objectValue;
    }

    public ObjectValue getOpaqueNamespace(String string) {
        return this.getNamespace(string);
    }

    public boolean isValidImport(String string) {
        return this.statics != null ? this.statics.validImports.contains(string) : false;
    }

    public void addValidImport(String string) {
        if (this.statics.validImports == null) {
            this.statics.validImports = new HashSet<String>();
        }
        this.statics.validImports.add(string);
    }

    public boolean useStaticSemantics() {
        return this.statics.use_static_semantics;
    }

    public boolean dialect(int n) {
        return this.statics.dialect == n;
    }

    public boolean isNamespace(String string) {
        return this.statics.namespaces.containsKey(string);
    }

    public boolean isNamespace(ObjectValue objectValue) {
        boolean bl = false;
        if (objectValue != null) {
            if (objectValue.isPrivate() && this.statics.private_namespaces.containsKey(objectValue.name)) {
                bl = true;
            } else if (objectValue.isProtected() && this.statics.protected_namespaces.containsKey(objectValue.name)) {
                bl = true;
            } else if (objectValue.isInternal() && this.statics.internal_namespaces.containsKey(objectValue.name)) {
                bl = true;
            } else if (this.statics.namespaces.containsKey(objectValue.name)) {
                bl = true;
            }
        }
        return bl;
    }

    public ObjectValue getUnresolvedNamespace(Context context, Node node, ReferenceValue referenceValue) {
        if (this.unresolved_namespaces == null) {
            this.unresolved_namespaces = new TreeMap(new ObjectValue.ObjectValueCompare());
        }
        for (UnresolvedNamespace object2 : this.unresolved_namespaces.keySet()) {
            ReferenceValue referenceValue2 = object2.ref;
            if (!referenceValue2.name.equals(referenceValue.name) || referenceValue2.getImmutableNamespaces().size() != referenceValue.getImmutableNamespaces().size()) continue;
            boolean bl = true;
            int n = referenceValue2.getImmutableNamespaces().size();
            for (int i = 0; i < n; ++i) {
                if (((ObjectValue)referenceValue2.getImmutableNamespaces().get((int)i)).name.equals(((ObjectValue)referenceValue.getImmutableNamespaces().get((int)i)).name)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return object2;
        }
        UnresolvedNamespace unresolvedNamespace = new UnresolvedNamespace(context, node, referenceValue);
        unresolvedNamespace.name = new StringBuffer().append("__unresolved__ns__").append(this.statics.unresolved_ns_count++).toString();
        ObjectList<ObjectValue> objectList = new ObjectList<ObjectValue>((Collection<ObjectValue>)this.statics.scopes);
        this.unresolved_namespaces.put(unresolvedNamespace, objectList);
        return unresolvedNamespace;
    }

    public void processUnresolvedNamespaces() {
        if (this.unresolved_namespaces != null) {
            ArrayList<UnresolvedNamespace> arrayList = new ArrayList<UnresolvedNamespace>(this.unresolved_namespaces.keySet());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ObjectValue objectValue;
                UnresolvedNamespace unresolvedNamespace = (UnresolvedNamespace)arrayList.get(i);
                ObjectList<ObjectValue> objectList = this.unresolved_namespaces.get(unresolvedNamespace);
                ObjectList<ObjectValue> objectList2 = this.statics.scopes;
                this.statics.scopes = objectList;
                Value value = unresolvedNamespace.ref.getValue(this);
                this.statics.scopes = objectList2;
                ObjectValue objectValue2 = objectValue = value instanceof ObjectValue ? (ObjectValue)value : null;
                if (objectValue != null) {
                    unresolvedNamespace.name = objectValue.name;
                    unresolvedNamespace.ns_kind = objectValue.getNamespaceKind();
                    unresolvedNamespace.resolved = true;
                } else {
                    unresolvedNamespace.cx.error(unresolvedNamespace.node.pos() - 1, 1004);
                }
                unresolvedNamespace.cx = null;
                unresolvedNamespace.node = null;
            }
            this.unresolved_namespaces.clear();
            this.unresolved_namespaces = null;
        }
    }

    public String debugName(String string, String string2, ObjectList<String> objectList, int n) {
        String string3 = n == -78 ? "/get" : (n == -98 ? "/set" : "");
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + string3.length() + (objectList != null ? objectList.size() * 8 : 0));
        stringBuffer.append(string);
        int n2 = string.length();
        if (n2 > 0) {
            stringBuffer.append('/');
            ++n2;
        }
        if (objectList != null) {
            int n3;
            for (int i = n3 = objectList.size() - 1; i >= 0; --i) {
                if (objectList.at(i).length() != 0 && i != n3) {
                    stringBuffer.append('|');
                }
                stringBuffer.append(objectList.at(i));
            }
        }
        if (stringBuffer.length() - n2 > 0) {
            stringBuffer.append(':');
        }
        return stringBuffer.append(string2).append(string3).toString();
    }

    public QName computeQualifiedName(String string, String string2, ObjectValue objectValue, int n) {
        String string3 = n == -78 ? "/get" : (n == -98 ? "/set" : "");
        String string4 = objectValue.name;
        byte by = objectValue.getNamespaceKind();
        return new QName(this.getNamespace(string.length() != 0 ? new StringBuffer().append(string).append(string4).toString().intern() : string4, by), string3.length() != 0 ? new StringBuffer().append(string2).append(string3).toString() : string2);
    }

    public ObjectList<Node> getComments() {
        return this.comments;
    }

    public String toString() {
        return super.toString();
    }

    public void setOrigin(String string) {
        this.parser_scanner_input_origin = string;
    }

    public void setQualifiedOrigin(String string) {
        this.qualified_origin = string;
    }

    public String getConfigVarCode() {
        String string = null;
        if (this.config_vars != null && this.config_vars.size() > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            StringBuffer stringBuffer = new StringBuffer(this.config_vars.size() * 10);
            int n = this.config_vars.size();
            for (int i = 0; i < n; ++i) {
                ConfigVar configVar = this.config_vars.at(i);
                if (!hashSet.contains(configVar.ns)) {
                    hashSet.add(configVar.ns);
                    stringBuffer.append(new StringBuffer().append("config namespace ").append(configVar.ns).append(";\n").toString());
                }
                stringBuffer.append(configVar.ns);
                stringBuffer.append(" const ");
                stringBuffer.append(new StringBuffer().append(configVar.name).append("=").append(configVar.value).append(";\n").toString());
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    static {
        $assertionsDisabled = true;
        contextIds = 0;
    }
}

