/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.EOFException;
import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentFragmentScannerImpl;
import org.apache.xerces.impl.XMLDocumentFragmentScannerMMImpl;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLScanner;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDScanner;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLDocumentScannerMMImpl
extends XMLDocumentFragmentScannerMMImpl {
    protected static final int SCANNER_STATE_XML_DECL = 0;
    protected static final int SCANNER_STATE_PROLOG = 5;
    protected static final int SCANNER_STATE_TRAILING_MISC = 12;
    protected static final int SCANNER_STATE_DTD_INTERNAL_DECLS = 17;
    protected static final int SCANNER_STATE_DTD_EXTERNAL = 18;
    protected static final int SCANNER_STATE_DTD_EXTERNAL_DECLS = 19;
    protected static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String DTD_SCANNER = "http://apache.org/xml/properties/internal/dtd-scanner";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/nonvalidating/load-external-dtd", "http://apache.org/xml/features/disallow-doctype-decl"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/dtd-scanner", "http://apache.org/xml/properties/internal/validation-manager"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null};
    protected XMLDTDScanner fDTDScanner;
    protected ValidationManager fValidationManager;
    protected boolean fScanningDTD;
    protected String fDoctypeName;
    protected String fDoctypePublicId;
    protected String fDoctypeSystemId;
    protected NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected boolean fLoadExternalDTD = true;
    protected boolean fDisallowDoctype = false;
    protected boolean fSeenDoctypeDecl;
    protected XMLDocumentFragmentScannerImpl.Dispatcher fXMLDeclDispatcher = new XMLDeclDispatcher();
    protected XMLDocumentFragmentScannerImpl.Dispatcher fPrologDispatcher = new PrologDispatcher();
    protected XMLDocumentFragmentScannerImpl.Dispatcher fDTDDispatcher = new DTDDispatcher();
    protected XMLDocumentFragmentScannerImpl.Dispatcher fTrailingMiscDispatcher = new TrailingMiscDispatcher();
    private String[] fStrings = new String[3];
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();

    public void setInputSource(XMLInputSource inputSource) throws IOException {
        ((XMLScanner)this).fEntityManager.setEntityHandler((XMLEntityHandler)this);
        ((XMLScanner)this).fEntityManager.startDocumentEntity(inputSource);
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        super.reset(componentManager);
        this.fDoctypeName = null;
        this.fDoctypePublicId = null;
        this.fDoctypeSystemId = null;
        this.fSeenDoctypeDecl = false;
        this.fNamespaceContext.reset();
        try {
            this.fLoadExternalDTD = componentManager.getFeature(LOAD_EXTERNAL_DTD);
        }
        catch (XMLConfigurationException e) {
            this.fLoadExternalDTD = true;
        }
        try {
            this.fDisallowDoctype = componentManager.getFeature(DISALLOW_DOCTYPE_DECL_FEATURE);
        }
        catch (XMLConfigurationException e) {
            this.fDisallowDoctype = false;
        }
        this.fDTDScanner = (XMLDTDScanner)componentManager.getProperty(DTD_SCANNER);
        try {
            this.fValidationManager = (ValidationManager)componentManager.getProperty(VALIDATION_MANAGER);
        }
        catch (XMLConfigurationException e) {
            this.fValidationManager = null;
        }
        this.fScanningDTD = false;
        this.setScannerState(0);
        this.setDispatcher(this.fXMLDeclDispatcher);
    }

    public String[] getRecognizedFeatures() {
        String[] featureIds = super.getRecognizedFeatures();
        int length = featureIds != null ? featureIds.length : 0;
        String[] combinedFeatureIds = new String[length + RECOGNIZED_FEATURES.length];
        if (featureIds != null) {
            System.arraycopy(featureIds, 0, combinedFeatureIds, 0, featureIds.length);
        }
        System.arraycopy(RECOGNIZED_FEATURES, 0, combinedFeatureIds, length, RECOGNIZED_FEATURES.length);
        return combinedFeatureIds;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        super.setFeature(featureId, state);
        if (featureId.startsWith("http://apache.org/xml/features/")) {
            String feature = featureId.substring("http://apache.org/xml/features/".length());
            if (feature.equals("nonvalidating/load-external-dtd")) {
                this.fLoadExternalDTD = state;
                return;
            }
            if (feature.equals("disallow-doctype-decl")) {
                this.fDisallowDoctype = state;
                return;
            }
        }
    }

    public String[] getRecognizedProperties() {
        String[] propertyIds = super.getRecognizedProperties();
        int length = propertyIds != null ? propertyIds.length : 0;
        String[] combinedPropertyIds = new String[length + RECOGNIZED_PROPERTIES.length];
        if (propertyIds != null) {
            System.arraycopy(propertyIds, 0, combinedPropertyIds, 0, propertyIds.length);
        }
        System.arraycopy(RECOGNIZED_PROPERTIES, 0, combinedPropertyIds, length, RECOGNIZED_PROPERTIES.length);
        return combinedPropertyIds;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        super.setProperty(propertyId, value);
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            String property = propertyId.substring("http://apache.org/xml/properties/".length());
            if (property.equals("internal/dtd-scanner")) {
                this.fDTDScanner = (XMLDTDScanner)value;
            }
            return;
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        int i = 0;
        while (i < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[i].equals(featureId)) {
                return FEATURE_DEFAULTS[i];
            }
            ++i;
        }
        return super.getFeatureDefault(featureId);
    }

    public Object getPropertyDefault(String propertyId) {
        int i = 0;
        while (i < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[i].equals(propertyId)) {
                return PROPERTY_DEFAULTS[i];
            }
            ++i;
        }
        return super.getPropertyDefault(propertyId);
    }

    public void startEntity(String name, XMLResourceIdentifier identifier, String encoding) throws XNIException {
        super.startEntity(name, identifier, encoding);
        if (!name.equals("[xml]") && ((XMLScanner)this).fEntityScanner.isExternal()) {
            this.setScannerState(16);
        }
        if (this.fDocumentHandler != null && name.equals("[xml]")) {
            this.fDocumentHandler.startDocument((XMLLocator)((XMLScanner)this).fEntityScanner, encoding, this.fNamespaceContext, null);
        }
    }

    public void endEntity(String name) throws XNIException {
        super.endEntity(name);
        if (this.fDocumentHandler != null && name.equals("[xml]")) {
            this.fDocumentHandler.endDocument(null);
        }
    }

    protected XMLDocumentFragmentScannerImpl.Dispatcher createContentDispatcher() {
        return new ContentDispatcher();
    }

    protected boolean scanDoctypeDecl() throws IOException, XNIException {
        if (!((XMLScanner)this).fEntityScanner.skipSpaces()) {
            this.reportFatalError("MSG_SPACE_REQUIRED_BEFORE_ROOT_ELEMENT_TYPE_IN_DOCTYPEDECL", null);
        }
        this.fDoctypeName = ((XMLScanner)this).fEntityScanner.scanName();
        if (this.fDoctypeName == null) {
            this.reportFatalError("MSG_ROOT_ELEMENT_TYPE_REQUIRED", null);
        }
        if (((XMLScanner)this).fEntityScanner.skipSpaces()) {
            this.scanExternalID(this.fStrings, false);
            this.fDoctypeSystemId = this.fStrings[0];
            this.fDoctypePublicId = this.fStrings[1];
            ((XMLScanner)this).fEntityScanner.skipSpaces();
        }
        boolean bl = this.fHasExternalDTD = this.fDoctypeSystemId != null;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(this.fDoctypeName, this.fDoctypePublicId, this.fDoctypeSystemId, null);
        }
        boolean internalSubset = true;
        if (!((XMLScanner)this).fEntityScanner.skipChar(91)) {
            internalSubset = false;
            ((XMLScanner)this).fEntityScanner.skipSpaces();
            if (!((XMLScanner)this).fEntityScanner.skipChar(62)) {
                this.reportFatalError("DoctypedeclUnterminated", new Object[]{this.fDoctypeName});
            }
            --this.fMarkupDepth;
        }
        return internalSubset;
    }

    protected String getScannerStateName(int state) {
        switch (state) {
            case 0: {
                return "SCANNER_STATE_XML_DECL";
            }
            case 5: {
                return "SCANNER_STATE_PROLOG";
            }
            case 12: {
                return "SCANNER_STATE_TRAILING_MISC";
            }
            case 17: {
                return "SCANNER_STATE_DTD_INTERNAL_DECLS";
            }
            case 18: {
                return "SCANNER_STATE_DTD_EXTERNAL";
            }
            case 19: {
                return "SCANNER_STATE_DTD_EXTERNAL_DECLS";
            }
        }
        return super.getScannerStateName(state);
    }

    protected final class TrailingMiscDispatcher
    implements XMLDocumentFragmentScannerImpl.Dispatcher {
        protected TrailingMiscDispatcher() {
        }

        public boolean dispatch(boolean complete) throws IOException, XNIException {
            try {
                boolean again;
                do {
                    again = false;
                    switch (XMLDocumentScannerMMImpl.this.fScannerState) {
                        case 12: {
                            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipSpaces();
                            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(60)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(1);
                                again = true;
                                break;
                            }
                            XMLDocumentScannerMMImpl.this.setScannerState(7);
                            again = true;
                            break;
                        }
                        case 1: {
                            ++XMLDocumentScannerMMImpl.this.fMarkupDepth;
                            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(63)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(3);
                                again = true;
                                break;
                            }
                            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(33)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(2);
                                again = true;
                                break;
                            }
                            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(47)) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                                again = true;
                                break;
                            }
                            if (XMLChar.isNameStart((int)((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.peekChar())) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                                XMLDocumentScannerMMImpl.this.scanStartElement();
                                XMLDocumentScannerMMImpl.this.setScannerState(7);
                                break;
                            }
                            XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                            break;
                        }
                        case 3: {
                            XMLDocumentScannerMMImpl.this.scanPI();
                            XMLDocumentScannerMMImpl.this.setScannerState(12);
                            break;
                        }
                        case 2: {
                            if (!((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipString("--")) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("InvalidCommentStart", null);
                            }
                            XMLDocumentScannerMMImpl.this.scanComment();
                            XMLDocumentScannerMMImpl.this.setScannerState(12);
                            break;
                        }
                        case 7: {
                            int ch = ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.peekChar();
                            if (ch == -1) {
                                XMLDocumentScannerMMImpl.this.setScannerState(14);
                                return false;
                            }
                            XMLDocumentScannerMMImpl.this.reportFatalError("ContentIllegalInTrailingMisc", null);
                            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.scanChar();
                            XMLDocumentScannerMMImpl.this.setScannerState(12);
                            break;
                        }
                        case 8: {
                            XMLDocumentScannerMMImpl.this.reportFatalError("ReferenceIllegalInTrailingMisc", null);
                            XMLDocumentScannerMMImpl.this.setScannerState(12);
                            break;
                        }
                        case 14: {
                            return false;
                        }
                    }
                } while (complete || again);
            }
            catch (EOFException e) {
                if (XMLDocumentScannerMMImpl.this.fMarkupDepth != 0) {
                    XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
                    return false;
                }
                XMLDocumentScannerMMImpl.this.setScannerState(14);
                return false;
            }
            return true;
        }
    }

    protected class ContentDispatcher
    extends XMLDocumentFragmentScannerImpl.FragmentContentDispatcher {
        protected ContentDispatcher() {
            super((XMLDocumentFragmentScannerImpl)XMLDocumentScannerMMImpl.this);
        }

        protected boolean scanForDoctypeHook() throws IOException, XNIException {
            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipString("DOCTYPE")) {
                XMLDocumentScannerMMImpl.this.setScannerState(4);
                return true;
            }
            return false;
        }

        protected boolean elementDepthIsZeroHook() throws IOException, XNIException {
            XMLDocumentScannerMMImpl.this.setScannerState(12);
            XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fTrailingMiscDispatcher);
            return true;
        }

        protected boolean scanRootElementHook() throws IOException, XNIException {
            if (XMLDocumentScannerMMImpl.this.scanStartElement()) {
                XMLDocumentScannerMMImpl.this.setScannerState(12);
                XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fTrailingMiscDispatcher);
                return true;
            }
            return false;
        }

        protected void endOfFileHook(EOFException e) throws IOException, XNIException {
            XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
        }
    }

    protected final class DTDDispatcher
    implements XMLDocumentFragmentScannerImpl.Dispatcher {
        protected DTDDispatcher() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean dispatch(boolean complete) throws IOException, XNIException {
            block16: {
                boolean bl;
                block15: {
                    boolean bl2;
                    block14: {
                        ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.setEntityHandler(null);
                        try {
                            try {
                                boolean again;
                                XMLResourceIdentifierImpl resourceIdentifier = new XMLResourceIdentifierImpl();
                                block9: do {
                                    again = false;
                                    switch (XMLDocumentScannerMMImpl.this.fScannerState) {
                                        case 17: {
                                            boolean completeDTD = true;
                                            boolean moreToScan = XMLDocumentScannerMMImpl.this.fDTDScanner.scanDTDInternalSubset(completeDTD, XMLDocumentScannerMMImpl.this.fStandalone, XMLDocumentScannerMMImpl.this.fHasExternalDTD && XMLDocumentScannerMMImpl.this.fLoadExternalDTD);
                                            if (moreToScan) continue block9;
                                            if (!((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(93)) {
                                                XMLDocumentScannerMMImpl.this.reportFatalError("EXPECTED_SQUARE_BRACKET_TO_CLOSE_INTERNAL_SUBSET", null);
                                            }
                                            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipSpaces();
                                            if (!((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(62)) {
                                                XMLDocumentScannerMMImpl.this.reportFatalError("DoctypedeclUnterminated", new Object[]{XMLDocumentScannerMMImpl.this.fDoctypeName});
                                            }
                                            --XMLDocumentScannerMMImpl.this.fMarkupDepth;
                                            if (!(XMLDocumentScannerMMImpl.this.fDoctypeSystemId == null || !((XMLScanner)XMLDocumentScannerMMImpl.this).fValidation && !XMLDocumentScannerMMImpl.this.fLoadExternalDTD || XMLDocumentScannerMMImpl.this.fValidationManager != null && XMLDocumentScannerMMImpl.this.fValidationManager.isCachedDTD())) {
                                                XMLDocumentScannerMMImpl.this.setScannerState(18);
                                                break;
                                            }
                                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                                            XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fPrologDispatcher);
                                            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                                            bl2 = true;
                                            Object var8_11 = null;
                                            break block14;
                                        }
                                        case 18: {
                                            resourceIdentifier.setValues(XMLDocumentScannerMMImpl.this.fDoctypePublicId, XMLDocumentScannerMMImpl.this.fDoctypeSystemId, null, null);
                                            XMLInputSource xmlInputSource = ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.resolveEntity((XMLResourceIdentifier)resourceIdentifier);
                                            XMLDocumentScannerMMImpl.this.fDTDScanner.setInputSource(xmlInputSource);
                                            XMLDocumentScannerMMImpl.this.setScannerState(19);
                                            again = true;
                                            break;
                                        }
                                        case 19: {
                                            boolean completeDTD = true;
                                            boolean moreToScan = XMLDocumentScannerMMImpl.this.fDTDScanner.scanDTDExternalSubset(completeDTD);
                                            if (moreToScan) continue block9;
                                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                                            XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fPrologDispatcher);
                                            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                                            bl = true;
                                            break block15;
                                        }
                                        default: {
                                            throw new XNIException("DTDDispatcher#dispatch: scanner state=" + XMLDocumentScannerMMImpl.this.fScannerState + " (" + XMLDocumentScannerMMImpl.this.getScannerStateName(XMLDocumentScannerMMImpl.this.fScannerState) + ')');
                                        }
                                    }
                                } while (complete || again);
                                break block16;
                            }
                            catch (EOFException e) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
                                boolean bl3 = false;
                                Object var8_14 = null;
                                ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                                return bl3;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_15 = null;
                            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                            throw throwable;
                        }
                    }
                    ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                    return bl2;
                }
                Object var8_12 = null;
                ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                return bl;
            }
            Object var8_13 = null;
            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
            return true;
        }
    }

    protected final class PrologDispatcher
    implements XMLDocumentFragmentScannerImpl.Dispatcher {
        protected PrologDispatcher() {
        }

        public boolean dispatch(boolean complete) throws IOException, XNIException {
            try {
                boolean again;
                do {
                    again = false;
                    switch (XMLDocumentScannerMMImpl.this.fScannerState) {
                        case 5: {
                            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipSpaces();
                            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(60)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(1);
                                again = true;
                                break;
                            }
                            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(38)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(8);
                                again = true;
                                break;
                            }
                            XMLDocumentScannerMMImpl.this.setScannerState(7);
                            again = true;
                            break;
                        }
                        case 1: {
                            ++XMLDocumentScannerMMImpl.this.fMarkupDepth;
                            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(63)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(3);
                                again = true;
                                break;
                            }
                            if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(33)) {
                                if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(45)) {
                                    if (!((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipChar(45)) {
                                        XMLDocumentScannerMMImpl.this.reportFatalError("InvalidCommentStart", null);
                                    }
                                    XMLDocumentScannerMMImpl.this.setScannerState(2);
                                    again = true;
                                    break;
                                }
                                if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipString("DOCTYPE")) {
                                    XMLDocumentScannerMMImpl.this.setScannerState(4);
                                    again = true;
                                    break;
                                }
                                XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInProlog", null);
                                break;
                            }
                            if (XMLChar.isNameStart((int)((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.peekChar())) {
                                XMLDocumentScannerMMImpl.this.setScannerState(6);
                                XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fContentDispatcher);
                                return true;
                            }
                            XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInProlog", null);
                            break;
                        }
                        case 2: {
                            XMLDocumentScannerMMImpl.this.scanComment();
                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                            break;
                        }
                        case 3: {
                            XMLDocumentScannerMMImpl.this.scanPI();
                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                            break;
                        }
                        case 4: {
                            if (XMLDocumentScannerMMImpl.this.fDisallowDoctype) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("DoctypeNotAllowed", null);
                            }
                            if (XMLDocumentScannerMMImpl.this.fSeenDoctypeDecl) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("AlreadySeenDoctype", null);
                            }
                            XMLDocumentScannerMMImpl.this.fSeenDoctypeDecl = true;
                            if (XMLDocumentScannerMMImpl.this.scanDoctypeDecl()) {
                                XMLDocumentScannerMMImpl.this.setScannerState(17);
                                XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fDTDDispatcher);
                                return true;
                            }
                            if (!(XMLDocumentScannerMMImpl.this.fDoctypeSystemId == null || !((XMLScanner)XMLDocumentScannerMMImpl.this).fValidation && !XMLDocumentScannerMMImpl.this.fLoadExternalDTD || XMLDocumentScannerMMImpl.this.fValidationManager != null && XMLDocumentScannerMMImpl.this.fValidationManager.isCachedDTD())) {
                                XMLDocumentScannerMMImpl.this.setScannerState(18);
                                XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fDTDDispatcher);
                                return true;
                            }
                            XMLDocumentScannerMMImpl.this.fDTDScanner.setInputSource(null);
                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                            break;
                        }
                        case 7: {
                            XMLDocumentScannerMMImpl.this.reportFatalError("ContentIllegalInProlog", null);
                            ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.scanChar();
                        }
                        case 8: {
                            XMLDocumentScannerMMImpl.this.reportFatalError("ReferenceIllegalInProlog", null);
                        }
                    }
                } while (complete || again);
                if (complete) {
                    if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.scanChar() != 60) {
                        XMLDocumentScannerMMImpl.this.reportFatalError("RootElementRequired", null);
                    }
                    XMLDocumentScannerMMImpl.this.setScannerState(6);
                    XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fContentDispatcher);
                }
            }
            catch (EOFException e) {
                XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
                return false;
            }
            return true;
        }
    }

    protected final class XMLDeclDispatcher
    implements XMLDocumentFragmentScannerImpl.Dispatcher {
        protected XMLDeclDispatcher() {
        }

        public boolean dispatch(boolean complete) throws IOException, XNIException {
            XMLDocumentScannerMMImpl.this.setScannerState(5);
            XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fPrologDispatcher);
            try {
                if (((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.skipString("<?xml")) {
                    ++XMLDocumentScannerMMImpl.this.fMarkupDepth;
                    if (XMLChar.isName((int)((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.peekChar())) {
                        XMLDocumentScannerMMImpl.this.fStringBuffer.clear();
                        XMLDocumentScannerMMImpl.this.fStringBuffer.append("xml");
                        while (XMLChar.isName((int)((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.peekChar())) {
                            XMLDocumentScannerMMImpl.this.fStringBuffer.append((char)((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityScanner.scanChar());
                        }
                        String target = ((XMLScanner)XMLDocumentScannerMMImpl.this).fSymbolTable.addSymbol(((XMLDocumentScannerMMImpl)XMLDocumentScannerMMImpl.this).fStringBuffer.ch, ((XMLDocumentScannerMMImpl)XMLDocumentScannerMMImpl.this).fStringBuffer.offset, ((XMLDocumentScannerMMImpl)XMLDocumentScannerMMImpl.this).fStringBuffer.length);
                        XMLDocumentScannerMMImpl.this.scanPIData(target, XMLDocumentScannerMMImpl.this.fString);
                    } else {
                        XMLDocumentScannerMMImpl.this.scanXMLDeclOrTextDecl(false);
                    }
                }
                ((XMLScanner)XMLDocumentScannerMMImpl.this).fEntityManager.fCurrentEntity.mayReadChunks = true;
                return true;
            }
            catch (EOFException e) {
                XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
                return false;
            }
        }
    }
}

