/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.analyzer.WebServiceAnalyzer;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.ServiceRequestBuilder;
import flex2.compiler.mxml.builder.XMLBuilder;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.OperationNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.dom.WebServiceNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.ThreadLocalToolkit;

class WebServiceBuilder
extends ComponentBuilder {
    private static final String OPERATIONS = "operations";
    private static final String WEB_SERVICE_OPERATION = "WebServiceOperation";
    private static final String REQUEST = "request";
    private static final String NAME = "name";
    private Model ops;

    WebServiceBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        super(unit, typeTable, configuration, document, null, true, null);
        this.childNodeHandler = new WebServiceChildNodeHandler(typeTable);
    }

    public void analyze(WebServiceNode node) {
        new WebServiceAnalyzer(this.unit, this.configuration).analyze(node);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        Type type = this.typeTable.getType(node.getNamespace(), node.getLocalPart());
        this.component = new Model(this.document, type, node.beginLine);
        this.registerModel(node, this.component, true);
        this.processAttributes(node, type);
        this.ops = new Model(this.document, this.typeTable.objectType, this.component, this.component.getXmlLineNumber());
        this.ops.setParentIndex(OPERATIONS);
        this.component.setProperty(OPERATIONS, this.ops);
        this.processChildren(node, type);
    }

    public void addOperation(Model ops, OperationNode node) {
        Type type = this.typeTable.getType(node.getNamespace(), WEB_SERVICE_OPERATION);
        Model ws = this.component;
        ComponentBuilder.ComponentChildNodeHandler wsChildNodeHandler = this.childNodeHandler;
        this.component = new Model(this.document, type, ops, node.beginLine);
        this.childNodeHandler = new RequestChildNodeHandler(this.typeTable);
        String name = (String)node.getAttribute(NAME);
        ops.setProperty(name, this.component);
        this.component.setParentIndex(name);
        this.processAttributes(node, type);
        this.processChildren(node, type);
        this.childNodeHandler = wsChildNodeHandler;
        this.component = ws;
    }

    public void addRequest(Model op, Node node) {
        Model request;
        if (node instanceof XMLNode) {
            XMLBuilder builder = new XMLBuilder(this.unit, this.typeTable, this.configuration, this.document, op);
            node.analyze(builder);
            request = builder.xml;
        } else {
            ServiceRequestBuilder builder = new ServiceRequestBuilder(this.unit, this.typeTable, this.configuration, this.document, REQUEST);
            node.analyze(builder);
            request = builder.graph;
        }
        op.setProperty(REQUEST, request);
        request.setParentIndex(REQUEST);
        request.setParent(op);
    }

    protected class RequestChildNodeHandler
    extends ComponentBuilder.ComponentChildNodeHandler {
        int requestCount;

        public RequestChildNodeHandler(TypeTable typeTable) {
            super(typeTable);
            this.requestCount = 0;
        }

        protected void languageNode() {
            if (this.child instanceof RequestNode && this.requestCount == 0) {
                this.requestCount = 1;
                WebServiceBuilder.this.addRequest(WebServiceBuilder.this.component, this.child);
            } else {
                super.languageNode();
            }
        }

        protected void nestedDeclaration() {
            if (this.child instanceof XMLNode && this.requestCount == 0) {
                this.requestCount = 1;
                WebServiceBuilder.this.addRequest(WebServiceBuilder.this.component, this.child);
            } else {
                super.languageNode();
            }
        }
    }

    protected class WebServiceChildNodeHandler
    extends ComponentBuilder.ComponentChildNodeHandler {
        public WebServiceChildNodeHandler(TypeTable typeTable) {
            super(typeTable);
        }

        protected void languageNode() {
            if (this.child instanceof OperationNode) {
                WebServiceBuilder.this.addOperation(WebServiceBuilder.this.ops, (OperationNode)this.child);
            } else {
                super.languageNode();
            }
        }
    }
}

