/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.dom;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.dom.Analyzer;
import flex2.compiler.mxml.dom.ArgumentsNode;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.BindingNode;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.ClassNode;
import flex2.compiler.mxml.dom.FunctionNode;
import flex2.compiler.mxml.dom.HTTPServiceNode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.MetaDataNode;
import flex2.compiler.mxml.dom.MethodNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.OperationNode;
import flex2.compiler.mxml.dom.RemoteObjectNode;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.dom.ScriptNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.StyleNode;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.dom.WebServiceNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.Collection;
import java.util.Iterator;

public abstract class AnalyzerAdapter
implements Analyzer {
    protected CompilationUnit unit;
    protected Configuration configuration;
    private Node currentNode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AnalyzerAdapter(CompilationUnit unit, Configuration configuration) {
        this.unit = unit;
        this.configuration = configuration;
    }

    public void prepare(Node node) {
        this.currentNode = node;
    }

    public void analyze(CDATANode node) {
        this.traverse(node);
    }

    public void analyze(StyleNode node) {
        this.traverse(node);
    }

    public void analyze(ScriptNode node) {
        this.traverse(node);
    }

    public void analyze(MetaDataNode node) {
        this.traverse(node);
    }

    public void analyze(ModelNode node) {
        this.traverse(node);
    }

    public void analyze(XMLNode node) {
        this.traverse(node);
    }

    public void analyze(XMLListNode node) {
        this.traverse(node);
    }

    public void analyze(ArrayNode node) {
        this.traverse(node);
    }

    public void analyze(BindingNode node) {
        this.traverse(node);
    }

    public void analyze(StringNode node) {
        this.traverse(node);
    }

    public void analyze(NumberNode node) {
        this.traverse(node);
    }

    public void analyze(IntNode node) {
        this.traverse(node);
    }

    public void analyze(UIntNode node) {
        this.traverse(node);
    }

    public void analyze(BooleanNode node) {
        this.traverse(node);
    }

    public void analyze(ClassNode node) {
        this.traverse(node);
    }

    public void analyze(FunctionNode node) {
        this.traverse(node);
    }

    public void analyze(WebServiceNode node) {
        this.traverse(node);
    }

    public void analyze(HTTPServiceNode node) {
        this.traverse(node);
    }

    public void analyze(RemoteObjectNode node) {
        this.traverse(node);
    }

    public void analyze(OperationNode node) {
        this.traverse(node);
    }

    public void analyze(RequestNode node) {
        this.traverse(node);
    }

    public void analyze(MethodNode node) {
        this.traverse(node);
    }

    public void analyze(ArgumentsNode node) {
        this.traverse(node);
    }

    public void analyze(InlineComponentNode node) {
        this.traverse(node);
    }

    public void analyze(Node node) {
        this.traverse(node);
    }

    private void traverse(Node node) {
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node n = (Node)node.getChildAt(i);
            n.analyze(this);
        }
    }

    protected int getLineNumber() {
        return this.currentNode.beginLine;
    }

    protected void logInfo(String message) {
        this.logInfo(this.currentNode, message);
    }

    protected void log(CompilerMessage msg) {
        this.log(this.currentNode, msg);
    }

    protected void logInfo(int line, String message) {
        this.logInfo(this.currentNode, line, message);
    }

    protected void log(int line, CompilerMessage msg) {
        this.log(this.currentNode, line, msg);
    }

    protected void logDebug(String message) {
        this.logDebug(this.currentNode, message);
    }

    protected void logDebug(int line, String message) {
        this.logDebug(this.currentNode, line, message);
    }

    protected void logWarning(String message) {
        this.logWarning(this.currentNode, message);
    }

    protected void logWarning(int line, String message) {
        this.logWarning(this.currentNode, line, message);
    }

    protected void logError(String message) {
        this.logError(this.currentNode, message);
    }

    protected void logError(int line, String message) {
        this.logError(this.currentNode, line, message);
    }

    protected void logInfo(Node node, String message) {
        ThreadLocalToolkit.logInfo(this.unit.getSource().getNameForReporting(), node.beginLine, message);
    }

    protected void log(Node node, CompilerMessage msg) {
        msg.path = this.unit.getSource().getNameForReporting();
        msg.line = node.beginLine;
        ThreadLocalToolkit.log(msg);
    }

    protected void logInfo(Node node, int line, String message) {
        ThreadLocalToolkit.logInfo(this.unit.getSource().getNameForReporting(), line == 0 ? node.beginLine : line, message);
    }

    protected void log(Node node, int line, CompilerMessage msg) {
        msg.path = this.unit.getSource().getNameForReporting();
        msg.line = line == 0 ? node.beginLine : line;
        ThreadLocalToolkit.log(msg);
    }

    protected void logDebug(Node node, String message) {
        ThreadLocalToolkit.logDebug(this.unit.getSource().getNameForReporting(), node.beginLine, message);
    }

    protected void logDebug(Node node, int line, String message) {
        ThreadLocalToolkit.logDebug(this.unit.getSource().getNameForReporting(), line == 0 ? node.beginLine : line, message);
    }

    protected void logWarning(Node node, String message) {
        ThreadLocalToolkit.logWarning(this.unit.getSource().getNameForReporting(), node.beginLine, message);
    }

    protected void logWarning(Node node, int line, String message) {
        ThreadLocalToolkit.logWarning(this.unit.getSource().getNameForReporting(), line == 0 ? node.beginLine : line, message);
    }

    protected void logError(Node node, String message) {
        ThreadLocalToolkit.logError(this.unit.getSource().getNameForReporting(), node.beginLine, message);
    }

    protected void logError(Node node, int line, String message) {
        ThreadLocalToolkit.logError(this.unit.getSource().getNameForReporting(), line == 0 ? node.beginLine : line, message);
    }

    protected String getLocalizedMessage(CompilerMessage msg) {
        return ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString((Object)msg);
    }

    protected CDATANode getTextContent(Collection nodes, boolean allowNonText) {
        if (!nodes.isEmpty()) {
            Iterator iter = nodes.iterator();
            Node first = (Node)iter.next();
            if (first instanceof CDATANode) {
                if (!iter.hasNext()) {
                    return (CDATANode)first;
                }
                Node second = (Node)iter.next();
                if (!$assertionsDisabled && second instanceof CDATANode) {
                    throw new AssertionError((Object)"internal error: multiple CDATA children");
                }
                this.log(second, (CompilerMessage)new MixedContentNotAllowed());
            } else if (!allowNonText) {
                this.log(first.beginLine, (CompilerMessage)new ChildElementsNotAllowed());
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !AnalyzerAdapter.class.desiredAssertionStatus();
    }

    public static class ChildElementsNotAllowed
    extends CompilerMessage.CompilerError {
    }

    public static class MixedContentNotAllowed
    extends CompilerMessage.CompilerError {
    }

    public static class CouldNotResolveToComponent
    extends CompilerMessage.CompilerError {
        public final String tag;

        public CouldNotResolveToComponent(String tag) {
            this.tag = tag;
        }
    }
}

