/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model

import com.we_lab_doc.spacecard.model.abstracts.*
import com.we_lab_doc.spacecard.utils.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 13, 2008
 */ 
final class Task extends WorkCard {
	boolean remove() {
		return super.remove()
	}
	////
	static Task create(params, Workspace workspace) {
		assert params != null
		assert workspace != null
		def pmtSerialManager = SpaceCardModel.pmtSerialManager
		params.serial = pmtSerialManager.generateSerial()
		assert params.serial != null
		def task = new Task(params)
		workspace.addToTasks(task)
		return task
	}
	static Task createSubTask(params, Task parent) {
		assert params != null
		assert parent != null
		def pmtSerialManager = SpaceCardModel.pmtSerialManager
		params.serial = pmtSerialManager.generateSerial()
		assert params.serial != null
		def task = new Task(params)
		parent.addToChildren(task)
		return task
	}
	/////////////////////////////////////////////
	def addToChildren(Task obj) {
		return CollectionBugEvasion.addToForBidirectionalManyToOne(
					this, Set.class, obj, Task.class, "children", "parent"  
				)	
	}
	def removeFromChildren(Task obj) {
		return CollectionBugEvasion.removeFromForBidirectionalManyToOne(
					this, obj, "children", "parent" 
				)
	}
	/////////////////////////////////////////////
	static mapping     = {
		serial column:'pmt_serial'
	}
	static belongsTo   = [workspace:Workspace, parent:Task]
	static hasMany     = [children:Task]	
	static constraints = {
		workspace(nullable:true)
		serial(nullable:false, unique:true)
		parent(nullable:true)		
		children()
	}
	long serial	
	/////////////////////////////////////////////
}
