/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model

import com.we_lab_doc.spacecard.model.abstracts.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 20, 2008
 */
final class UserDataTray extends DataTray {
	boolean remove() {
		user?.removeFromDataTrays(this)
		return super.remove()
	}	 
	////
	static UserDataTray create( User user, String dataName, String dataVersion) {
		return create(user, dataName, dataVersion, null, null)
	}
	static UserDataTray create( User user, String dataName, String dataFormatVersion, Map params) {
		return create( user, dataName, dataFormatVersion, null, params)
	}
	static UserDataTray create( User user, String dataName, String dataFormatVersion, String moduleName ) {
		return create( user, dataName, dataFormatVersion, moduleName, null)
	}
	static UserDataTray create( User user, String dataName, String dataFormatVersion, String moduleName, Map params ) {
		assert user != null && dataName != null && dataFormatVersion != null
		if(params == null) 	params = [:]
		params.user = user
		params.dataName = dataName
		params.moduleName = moduleName
		params.dataFormatVersion = dataFormatVersion
		def dataTray = new UserDataTray(params)
		dataTray.key = UserDataTray.makeKey(user.account, dataName, moduleName, dataFormatVersion )
		user?.addToDataTrays(dataTray)		
		return dataTray
	}
	static String makeKey( String account, String dataName, String dataFormatVersion ) {
		return makeKey( account, dataName, dataFormatVersion, null )
	}	
	static String makeKey( String account, String dataName, String dataFormatVersion, String moduleName ) {
		assert account != null
		return "UserData-${moduleName?moduleName:'%global%'}-${dataFormatVersion}-${account}-${dataName}"
	}
	/////////////////////////////////////////////
	static belongsTo   = [user:User]	
}