/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model.abstracts

import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.ac.AccessControllable
import com.we_lab_doc.spacecard.ac.Permission
import com.we_lab_doc.spacecard.utils.*

//import com.we_lab_doc.spacecard.ac.Permission.PermissionAttributes

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 13, 2008
 */ 
/* abstract */ class SpaceCard implements AccessControllable, SpaceCardDomainModel {
	def permissionFactory
	
	Permission getPermission() {
		 // TODO: とりあえず
		if(!permission)
			permission = permissionFactory.createSpaceCardPermission(this) 
		return permission
	}
	////
	boolean remove() { 
		if(! removeRelations()) return false
		return ModelUtils.delete(this)
	}
	////
	protected boolean removeRelations() {
		if(! removeLinks())	return false
		if(! removeCounterLinks()) return false		
		return true
	}
	protected boolean removeLinks() {
		for (link in ModelUtils.cloneCollection(this.links) ) {
			if(! link.remove()) return false
		}
		return true
	}
	protected boolean removeCounterLinks() {
		for (link in ModelUtils.cloneCollection(this.counterLinks) ) {
			if(! link.remove()) return false
		}
		return true
	}
	////
	def addToLinks(Link obj) {
		return CollectionBugEvasion.addToForBidirectionalManyToMany(
					this, Set.class, obj, Link.class, "links", "owners"  
				)	
	}
	def removeFromLinks(Link obj) {
		return CollectionBugEvasion.removeFromForBidirectionalManyToMany(
					this, obj, "links", "owners" 
				)		
	}
	def addToCounterLinks(CrossLink obj) {
		return CollectionBugEvasion.addToForBidirectionalManyToMany(
				this, Set.class, obj, CrossLink.class, "counterLinks", "targets"  
			)
	}
	def removeFromCounterLinks(CrossLink obj) {
		return CollectionBugEvasion.removeFromForBidirectionalManyToMany(
				this, obj, "counterLinks", "targets" 
			)
	}
	/////////////////////////////////////////////
	def beforeInsert = {
		ModelUtils.insertLog(this)
		onBeforeInsert(delegate)
	}
	def beforeUpdate = {
		ModelUtils.updateLog(this)
		onBeforeUpdate(delegate)
	}
	def beforeDelete = {
		ModelUtils.deleteLog(this)
		onBeforeDelete(delegate)
	}
	/////////////////////////////////////////////
	protected onBeforeInsert(obj) {
		obj.createdDate = new Date()
		if(!obj.creator) {
			def accessControlService = SpaceCardModel.accessControlService
			obj.creator = accessControlService.getLoggedInUser()
		}			
	}
	protected onBeforeUpdate(obj) {
		/* don't delete */
	}	
	protected onBeforeDelete(obj){
		/* don't delete */		
	}	
	/////////////////////////////////////////////
	static transients  = ['permission']
	static belongsTo   = [creator:User, cardHolder:CardHolder]
	static hasMany     = [counterLinks:CrossLink,
	                      links:Link,	                      
	                     ]
	static mappedBy    = [
	                      links:'owners',
	                      counterLinks:'targets'
	                     ]
//	static embedded = ['permissionAttributes']
	static constraints = {
		cardHolder(nullable:true)	
		creator(nullable:true)
		createdDate(nullable:true)
		updater(nullable:true)		
		updatedDate(nullable:true)
//		permissionAttributes(nullable:true)
	}
	/////////////////////////////////////////////
	Date createdDate
	Date updatedDate	
	User updater
//	SpaceCardPermissionAttributes permissionAttributes
	Permission permission = null
}

// TODO
/*
class SpaceCardPermissionAttributes implements PermissionAttributes {
}
*/




