import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class AttachedFileTests extends SpaceCardModelTestCase {
	
    void testCreateDelete() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)
		assertTrue ModelUtils.flush(p1)
		def resourceStream = new ByteArrayInputStream(new String("hogehoge").getBytes())
		assertNotNull "0-0", resourceStream
		
		def e1 = WorkCardAttachedFile.create(
				 [creator:sv],
				 "text.txt",
				 resourceStream
				)
		p1.add(e1)
		assertNotNull "1", e1
		assertTrue "2", ModelUtils.flush(e1)
		assertNotNull "3", e1.createdDate
		assertEquals  "4", e1.creator, sv
		assertEquals  "4-1", new String(e1.byteArray), "hogehoge"
		//assertTrue "5", e1.delete()
		assertTrue e1.remove()
    }
}
