/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package net.korabo.app.orientdb;

import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import net.korabo.lib.KConstant;
import net.korabo.lib.StreamUtil;
import net.korabo.lib.UriUtil;
import net.korabo.lib.file.FileUriUtil;
import net.korabo.lib.file.ResourceFilesUtil;
import net.korabo.lib.file.SysFilesUtil;
import net.korabo.lib.settings.KSettingsUtil;

/**
 *
 * @author cintake
 */
@WebListener()
public class AppServletContextListener implements ServletContextListener{

  @Override
  public void contextDestroyed(ServletContextEvent sce) {
//    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
      System.out.println("ServletContextListener destroyed");
  }

  @Override
  public void contextInitialized(ServletContextEvent sce) {
//    throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
        SysFilesUtil.getVarMap().replace(SysFilesUtil.V_CFGBASE, "VAADIN01");
        String home = SysFilesUtil.findDataUriPath();
        String orientDB = UriUtil.concatPath(home, "OrientDB");
        String orientDBcfg = UriUtil.concatPath(orientDB, "config", "orientdb-server-config.xml");
        String orientDBwww = UriUtil.concatPath(orientDB, "www");
        Properties props = System.getProperties();
        props.setProperty("ORIENTDB_HOME", orientDB);
        props.setProperty("orientdb.www.path", orientDBwww);
		
		try {
                    File cfgFile = FileUriUtil.getFileFor(orientDBcfg);
                    SysFilesUtil.chkAndMake(cfgFile);
                    if (cfgFile.length() == 0){
                      // initialize
                      String rp = ResourceFilesUtil.findPathFromClasspath("net.korabo.app.orientdb.smplconfig.xml");
                      StreamUtil.copy(FileUriUtil.getUriFor(rp).toURL().openStream(), new FileOutputStream(cfgFile),true);
                    }
                    OServer server = OServerMain.create();
                    server.startup(FileUriUtil.getFileFor(orientDBcfg));
                    server.activate();
		} catch (Exception e) {
			System.out.println(e.getMessage() + e.getStackTrace());
		}
		
		System.out.println("ServletContextListener started.");	
  }
  
}
