/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package net.korabo.app.vaadin01.srv;

import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.korabo.app.vaadin01.ent.Contact;
import net.korabo.lib.beans.ClassUtil;

/**
 *
 * @author cintake
 */
public class ContactService {

  // Create dummy data by randomly combining first and last names
  static String[] fnames = {"Peter", "Alice", "John", "Mike", "Olivia",
    "Nina", "Alex", "Rita", "Dan", "Umberto", "Henrik", "Rene", "Lisa",
    "Linda", "Timothy", "Daniel", "Brian", "George", "Scott",
    "Jennifer"};
  static String[] lnames = {"Smith", "Johnson", "Williams", "Jones",
    "Brown", "Davis", "Miller", "Wilson", "Moore", "Taylor",
    "Anderson", "Thomas", "Jackson", "White", "Harris", "Martin",
    "Thompson", "Young", "King", "Robinson"};

  private static ContactService instance;
  private static OPartitionedDatabasePool pool;

  public static ContactService createDemoService() {
    try {
      return createService0();
    } catch (IOException ex) {
      Logger.getLogger(ContactService.class.getName()).log(Level.SEVERE, null, ex);
    }
    return null;
  }

  private static ContactService createService0() throws IOException {
    if (instance == null) {

      final ContactService contactService = new ContactService();
      // OrientDB
//            ODatabaseDocumentTx db = 
//                    new ODatabaseDocumentTx("remote:127.0.0.1/DocumentTest")
//                            .open("root", "korabo");
//            OPartitionedDatabasePool pool = new OPartitionedDatabasePool("remote:127.0.0.1/dbtest","root","korabo");
//            pool.
//            OObjectDatabaseTx db = new OObjectDatabaseTx("remote:127.0.0.1/dbtest");
      String remote = "remote:127.0.0.1/";
      String nameDB = "TestPartitioned2";
      String url = remote + nameDB;

      OServerAdmin serverAdmin = new OServerAdmin(url).connect("root", "korabo");
      if (!serverAdmin.listDatabases().containsKey(nameDB)) {
        serverAdmin.createDatabase(nameDB, "object", "plocal");
        System.out.println(" Database '" + nameDB + "' created!..");
      }
//            OPartitionedDatabasePool pool = new OPartitionedDatabasePool(url, "admin", "admin");
      pool = new OPartitionedDatabasePool(url, "admin", "admin");

      try (
        OObjectDatabaseTx db = new OObjectDatabaseTx(pool.acquire())) {
        db.setAutomaticSchemaGeneration(true);
        db.getEntityManager().registerEntityClasses(Contact.class.getPackage().getName());

        if (db.countClass(Contact.class) == 0) {
          // init
          Random r = new Random(0);
          Calendar cal = Calendar.getInstance();
          for (int i = 0; i < 100; i++) {
            Contact contact = db.newInstance(Contact.class);
            contact.setFirstName(fnames[r.nextInt(fnames.length)]);
            contact.setLastName(lnames[r.nextInt(fnames.length)]);
            contact.setEmail(contact.getFirstName().toLowerCase() + "@"
              + contact.getLastName().toLowerCase() + ".com");
            contact.setPhone("+ 358 555 " + (100 + r.nextInt(900)));
            cal.set(1930 + r.nextInt(70),
              r.nextInt(11), r.nextInt(28));
            contact.setBirthDate(cal.getTime());
            db.attachAndSave(contact);
          }
          db.commit();
        }
      }
      instance = contactService;
    }

    return instance;
  }

//    private HashMap<Long, Contact> contacts = new HashMap<>();
//    private long nextId = 0;
  public synchronized List<Contact> findAll(String stringFilter) {

    ArrayList arrayList = new ArrayList();
    try (
      OObjectDatabaseTx db = new OObjectDatabaseTx(pool.acquire())) {
      db.setAutomaticSchemaGeneration(true);
      db.getEntityManager().registerEntityClasses(Contact.class.getPackage().getName());

      for (Contact contact : db.browseClass(Contact.class)) {
        boolean passesFilter = (stringFilter == null || stringFilter.isEmpty())
          || contact.toString().toLowerCase()
          .contains(stringFilter.toLowerCase());
        if (passesFilter) {
//                contact = db.detach(contact);
          arrayList.add(db.detach(contact, true));
        }
      }

    }
//        for (Contact contact : contacts.values()) {
//            try {
//                boolean passesFilter = (stringFilter == null || stringFilter.isEmpty())
//                        || contact.toString().toLowerCase()
//                        .contains(stringFilter.toLowerCase());
//                if (passesFilter) {
//                    arrayList.add(contact.clone());
//                }
//            } catch (CloneNotSupportedException ex) {
//                Logger.getLogger(ContactService.class.getName()).log(
//                        Level.SEVERE, null, ex);
//            }
//        }
//        Collections.sort(arrayList, new Comparator<Contact>() {
//
//            @Override
//            public int compare(Contact o1, Contact o2) {
//                return (int) (o2.getId() - o1.getId());
//            }
//        });
    return arrayList;
  }

  public synchronized long count() {
//        return contacts.size();
    try (
      OObjectDatabaseTx db = new OObjectDatabaseTx(pool.acquire())) {
      db.setAutomaticSchemaGeneration(true);
      db.getEntityManager().registerEntityClasses(Contact.class.getPackage().getName());
      return db.countClass(Contact.class);
    }
  }

  public synchronized void delete(Contact value) {
//        contacts.remove(value.getId());
  }

  public synchronized void save(Contact entry) {
    try (
      OObjectDatabaseTx db = new OObjectDatabaseTx(pool.acquire())) {
      db.setAutomaticSchemaGeneration(true);
      db.getEntityManager().registerEntityClasses(Contact.class.getPackage().getName());

      db.begin();
      db.attachAndSave(entry);
      db.commit();
    }
//        if (entry.getId() == null) {
//            entry.setId(nextId++);
//        }
//        try {
//            entry = (Contact) InstanceUtil.dupObj(entry);
//        } catch (Exception ex) {
//            throw new RuntimeException(ex);
//        }
//        contacts.put(entry.getId(), entry);
  }

  
  public List<Contact> loadBeans(int i, int i1) {
    ArrayList<Contact> arrayList = new ArrayList<>();
    try (
      OObjectDatabaseTx db = new OObjectDatabaseTx(pool.acquire())) {
      db.setAutomaticSchemaGeneration(true);
      db.getEntityManager().registerEntityClasses(Contact.class.getPackage().getName());

      //SELECT FROM <target> [WHERE ...] SKIP <records-to-skip> LIMIT <max-records>
      final OSQLSynchQuery<Contact> query = new OSQLSynchQuery<>("select * from Contact SKIP ? LIMIT ?");
      List<Contact> result = db.query(query, i, i1);
      result.stream().forEach((contact) -> {
        arrayList.add(db.detach(contact, true));
      });
    }
    return arrayList;
  }

}
