package jp.sf.ssoproxy.builder.impl;

import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import jp.sf.ssoproxy.builder.RequestBuilder;
import jp.sf.ssoproxy.builder.RequestBuilderChain;
import jp.sf.ssoproxy.config.HostConfig;

import org.apache.commons.httpclient.HttpMethod;

public class DefaultRequestBuilderImpl implements RequestBuilder {
    private static final String COOKIE = "cookie";

    private static final String ACCEPT_ENCODING = "accept-encoding";

    /* (non-Javadoc)
     * @see jp.sf.ssoproxy.builder.impl.RequestBuilder#buildRequest(int, javax.servlet.http.HttpServletRequest, jp.sf.ssoproxy.config.HostConfig, org.apache.commons.httpclient.HttpMethod, jp.sf.ssoproxy.builder.impl.RequestBuilderChain)
     */
    public void build(int type, HttpServletRequest request,
            HostConfig hostConfig, HttpMethod httpMethod,
            RequestBuilderChain chain) {
        // disabled redirect
        httpMethod.setFollowRedirects(false);

        // request headers
        for (Enumeration<?> e = request.getHeaderNames(); e.hasMoreElements();) {
            String name = (String) e.nextElement();
            // skip accept-encoding because of content-encoding issue(gzip..)
            // skip cookie. cookies are generated by storedCookies
            if (!ACCEPT_ENCODING.equals(name) && !COOKIE.equals(name)) {
                httpMethod.setRequestHeader(name, request.getHeader(name));
            }
        }

        chain.build(type, request, hostConfig, httpMethod);
    }
}
