/*
	Interface for ID-RP2C

*/

#define	MON_PORT	21000
#define	CONFIG_FILE	"/opt/dstar/conf/dstatus.conf"
#define LOG_FILE	"/var/log/dstatus.log"
#define	PID_FILE	"/var/run/dstatus.pid"
#define XCHANGE_CONF	"/opt/dstar/conf/xchange.conf"

#define	TRUE		1
#define	FALSE		0
#define INVALID		2

#include	<stdint.h>
#include	<string.h>
#include	<ctype.h>
#include	<time.h>
#include	<sys/time.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/socket.h>
#include 	<sys/types.h>
#include 	<netinet/in.h>
#include 	<netdb.h>
#include	<signal.h>
#include	<sys/ioctl.h>
#include	<sys/stat.h>
#include	<net/if.h>
#include	<errno.h>
#include	<sys/utsname.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<termios.h>
#include	"dstar.h"
#include	"packet.h"


struct	ModuleTable
{
	struct	ModuleTable	*f_chain;
	struct	timeval	recv_time;
	unsigned char	ModuleName[8];
	time_t		AccessTime;
	int		SendSeq;
	int		packet_cnt;
	int		aprs_msg_pnt;
	int		RadioVoicePacketCnt;
	int		HeaderCnt;
	int		rpt_save_length;
	int		lost_cnt;
	unsigned char	RadioLat[8];
	unsigned char	RadioLong[9];
	unsigned char	RadioCall[8];
	unsigned char	RadioMsg[20];
	unsigned char	RadioAtitude[6];
	unsigned char	RadioSpeed[3];
	unsigned char	RadioDirection[3];
	unsigned char	RadioTime[7];
	unsigned char	RadioGpsStatus;
	unsigned char	RadioGpsSkip;
	unsigned char   FrameID[2];
	unsigned char   mini_header;
	unsigned char   data_temp[5];
	char   		aprs_msg[256];
	char		aprs_msg_save[256];
	unsigned char	mycall[8];
	unsigned char	mycall_ex[4];
	unsigned char	urcall[8];
	unsigned char	rptcall[8];
	unsigned char	lost_frame_sw;
	struct	dstar_packet	rpt_save;
	struct	STATUS_frame	STATUS_Frm;
	struct	STATUS_frame	STATUS_Save;
	char	request_id[2];
};

struct STATUS_Login_frame
{
        unsigned char   StatusID[6];    /* "DSTRST" */
        unsigned char   Type[2];	/* 00 */
#if __WORDSIZE == 64
        time_t          EntryUpdateTime;
#else
        time_t          EntryUpdateTime;
        time_t          dummy_t;
#endif
	unsigned char	UserID[16];
	unsigned char	Passwd[64];
        unsigned char   reserve[4];
};

unsigned char	GpsMsg[20];

int		mon_port;
char		client_callsign[8];
time_t		status_keep_alive;

char		DprsTemp[512];

int	reload;
int	debug_sw;
int	sig_term;

FILE	*log_file;
FILE	*pid_file;

/* Monitor & Forward definition */

struct	status
{
	struct	status		*f_chain;
	char			fqdn[128];
	unsigned char		userID[16];
	unsigned char		passwd[64];
	in_port_t		port;
	int			status_sd;
	struct	addrinfo	*status_info;
	long int		packets;
};

struct	status		*status_pnt, *status_last;

fd_set          read_set;
fd_set		fd_save;


struct  ModuleTable     *module_pnt, *module_last;

unsigned char   dtmf_c, dtmf_c_save;
unsigned char	dtmf_c_save1, dtmf_c_save2;
int             dtmf_pos;
unsigned char   dtmf[10];

struct	sockaddr_in    	rpt_mon_addr;

struct	tm	*gt;

struct utsname      uname_buf;

struct	termios	termio_save;

struct	DprsMsg
{
	struct	DprsMsg	*next;
	char	src_call[8];
	char	dst_call[8];
	char	msg[20];
	char	ack[8];
};

struct	DprsMsg	*DprsMsg_pnt;

sigset_t	save_sig;
sigset_t	sigset;
struct  timespec        timeout;

