#include "dstatus.h"

int	GPS_SumCheck(char  string[])
{
	char	*pnt;
	unsigned char	sum, csum, tmp;
	time_t	atime;

	pnt = string;
	sum = 0;
	if (*pnt == '$') pnt++;
	while (*pnt !='*')
	{
		if ((*pnt == 0x0a) || (*pnt == 0x0d) || (*pnt == 0x00)) return FALSE;
		sum ^= *pnt;
		pnt++;
	}
	pnt++;
	tmp = *pnt - '0';
	if (tmp > 16) tmp -= 7;
	csum = tmp << 4;
	pnt++;
	tmp = *pnt - '0';
	if (tmp > 16) tmp -= 7;
	csum += tmp;
	if (debug_sw)
	{
		time(&atime);
		fprintf (log_file, "%24.24s Sum Check Src:Calc  %2.2x:%2.2x\n", ctime(&atime), sum, csum);
		fflush (log_file);
	}
	if (csum == sum) return TRUE;
	return FALSE;
}

void	GPGLL (char string[], struct ModuleTable *id)
{
	char	*pnt;
	unsigned char	i;
	unsigned char	LatTemp[8];
	unsigned char	LongTemp[9];
	unsigned char	TimeTemp[7];

	pnt = string;

	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 7)
		{
			LatTemp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	LatTemp[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 8)
		{
			LongTemp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	LongTemp[8] = *pnt;
	pnt += 2;
	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 6)
		{
			TimeTemp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	TimeTemp[6] = 'h';
	pnt++;
	if (*pnt == 'V')
	{
		memcpy (id->aprs_msg_save, id->aprs_msg, 256);
		return;
	}
	id->RadioGpsStatus = TRUE;
	memcpy (&id->RadioLat[0], LatTemp, 8);
	memcpy (&id->RadioLong[0], LongTemp, 9);
	memcpy (&id->RadioTime, TimeTemp, 7);
}

void	GPGGA (char string[], struct ModuleTable *id)
{
	char	*pnt;
	int	i;
	unsigned short int	d;
	unsigned char	tmp[10];
	unsigned char	LatTemp[8];
	unsigned char	LongTemp[9];
	unsigned char	TimeTemp[7];
	int	k;

	pnt = string;

	i = 0;
	while (*pnt != ',')
	{
                if ((*pnt == 0x00) || (!isdigit(*pnt) && (*pnt != '.')))
                {
                        return;
                }
		if (i < 6)
		{
			TimeTemp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	TimeTemp[6] = 'h';
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
                if ((*pnt == 0x00) || (!isdigit(*pnt) && (*pnt != '.'))) 
                {
                        return;
                }
		if (i < 7)
		{
			LatTemp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	LatTemp[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 8)
		{
			LongTemp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	LongTemp[8] = *pnt;

	pnt += 2;
	if (*pnt == '0')
	{
		memcpy (id->aprs_msg_save, id->aprs_msg, 256);
		return;
	}
	id->RadioGpsStatus = TRUE;
	memcpy (&id->RadioLat[0], LatTemp, 8);
	memcpy (&id->RadioLong[0], LongTemp, 9);
	memcpy (&id->RadioTime, TimeTemp, 7);

	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		pnt++;
	}
	pnt++;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		pnt++;
	}
	pnt++;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		pnt++;
	}
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 8)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d / 0.3048 + 0.5;
	for (i = 0 ; i < 6 ; i++)
	{
		id->RadioAtitude[5 - i] = (k % 10) + '0';
		k /= 10;
	}
}

void	GPRMC (char string[], struct ModuleTable *id)
{
	int	d;
	unsigned char	tmp[10];
	int	k;
	char	*pnt;
	unsigned char	TimeTemp[7];
	unsigned char	i;

	pnt = string;

	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 6)
		{
			TimeTemp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	TimeTemp[6] = 'h';
	pnt++;
	if (*pnt == 'V')
	{
		memcpy (id->aprs_msg_save, id->aprs_msg, 256);
		return;
	}
	id->RadioGpsStatus = TRUE;
	memcpy (&id->RadioTime, TimeTemp, 7);
	while (*pnt != ',') pnt++;
	pnt++;
	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 7)
		{
			id->RadioLat[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	id->RadioLat[7] = *pnt;
	pnt += 2;

	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 8)
		{
			id->RadioLong[i] = *pnt;
			i++;
		}
		pnt++;
	}
	pnt++;
	id->RadioLong[8] = *pnt;
	pnt += 2;
	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 9)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d + 0,5;
	for (i = 0 ; i < 3 ; i++)
	{
		id->RadioSpeed[2 - i] = (k % 10) + '0';
		k /= 10;
	}

	pnt++;
	i = 0;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		if (i < 9)
		{
			tmp[i] = *pnt;
			i++;
		}
		pnt++;
	}
	tmp[i] = 0x00;
	d = atof ((char *)tmp);
	k = d + 0,5;
	for (i = 0 ; i < 3 ; i++)
	{
		id->RadioDirection[2 - i] = (k % 10) + '0';
		k /= 10;
	}
}

void	GPVTG (char string[], struct ModuleTable *id)
{
	char	*pnt;
	unsigned char	tmp[10];
	unsigned char	DirectionTemp[3];
	unsigned char	SpeedTemp[3];
	int	i, k;
	int	d;

	pnt = string;

        i = 0;
        while (*pnt != ',')
        {
		if (*pnt == 0x00)
		{
			return;
		}
                if (i < 9)
                {
                        tmp[i] = *pnt;
                        i++;
                }
                pnt++;
        }
        tmp[i] = 0x00;
        d = atof ((char *)tmp);
        k = d + 0,5;
        for (i = 0 ; i < 3 ; i++)
        {
                DirectionTemp[2 - i] = (k % 10) + '0';
                k /= 10;
        }

	pnt += 3;
	while (*pnt != ',')
	{
                if (*pnt == 0x00)
                {
                        return;
                }
		pnt++;
	}
	pnt += 3;
        i = 0;
        while (*pnt != ',')
        {
                if (*pnt == 0x00)
                {
                        return;
                }
                if (i < 9)
                {
                        tmp[i] = *pnt;
                        i++;
                }
                pnt++;
        }
        tmp[i] = 0x00;
        d = atof ((char *)tmp);
        k = d + 0,5;
        for (i = 0 ; i < 3 ; i++)
        {
                SpeedTemp[2 - i] = (k % 10) + '0';
                k /= 10;
        }
	pnt += 3;
	while (*pnt != ',') pnt++;
	pnt += 3;
	if (*pnt == 'N') return;
	memcpy (&id->RadioDirection[0], DirectionTemp, 3);
	memcpy (&id->RadioSpeed[0], SpeedTemp, 3);
}

void	Dprs_Send(struct ModuleTable *id)
{
	double	f_temp;
	char	tmp[10];

        memset (tmp, 0x00, 10);
        memcpy (tmp, id->RadioLat, 8);
        f_temp = atof (&tmp[2]) / 60.;
        tmp[2] = 0x00;
        id->STATUS_Frm.body.status.Latitude = atoi (tmp) * 10000 + f_temp * 10000;
        if (id->RadioLat[7] == 'S') id->STATUS_Frm.body.status.Latitude = - id->STATUS_Frm.body.status.Latitude;

        memcpy (tmp, id->RadioLong, 9);
        f_temp = atof (&tmp[3]) / 60.;
        tmp[3] = 0x00;
        id->STATUS_Frm.body.status.Longitude = atoi (tmp) * 10000 + f_temp * 10000;
        if (id->RadioLong[8] == 'W') id->STATUS_Frm.body.status.Longitude = - id->STATUS_Frm.body.status.Longitude;

	id->RadioGpsStatus = FALSE;
}

void    gps (char msg[], struct ModuleTable *id)
{
	time_t	atime;

	if (debug_sw)
	{
		fprintf (log_file, "gps: %s", msg);
		fflush (log_file);
	}

        if (!GPS_SumCheck(msg))
	{
		memcpy (id->aprs_msg_save, id->aprs_msg, 256);
		time(&atime);
		fprintf (log_file, "%24.24s Check Sum error : %s", ctime(&atime), msg);
		fflush (log_file);
		return;
	}
        if (!strncmp (msg, "$GPGLL,", 7)) GPGLL (&msg[7], id);
        else if (!strncmp(msg, "$GPGGA,", 7)) GPGGA (&msg[7], id);
        else if (!strncmp(msg, "$GPRMC,", 7)) GPRMC (&msg[7], id);
        else if (!strncmp(msg, "$GPVTG,", 7)) GPVTG (&msg[7], id);
        //else if (!strncmp(msg, "$GPGSA,", 7)) GPGSA (&msg[7], id);
        //else if (!strncmp(msg, "$GPGSV,", 7)) GPGSV (&msg[7], id);
        else
        {
               	if (id->RadioGpsStatus)
               	{
			Dprs_Send (id);
               	}
        }
}

