#include "dstatus.h"

unsigned short int        update_crc_dstar( unsigned short int  crc, unsigned char c );
unsigned short int                result_crc_dstar(unsigned short int crc);

int	GPS_A_SumCheck(char  string[])
{
	unsigned short int	crc_dstar_ffff, k, k0, k1, k2, k3;
	char	*pnt;
	
    	crc_dstar_ffff = 0xffff;	/* nornal value 0xffff */
	pnt = string + 10;

	while (*pnt != 0x0a)
	{
		if (*pnt == 0x00) return FALSE;
		crc_dstar_ffff = update_crc_dstar( crc_dstar_ffff, *pnt);
		pnt++;
	}

	crc_dstar_ffff = result_crc_dstar(crc_dstar_ffff);

	k0 = string[5] - '0';
	if (k0 > 16) k0 -= 7;
	k1 = string[6] - '0';
	if (k1 > 16) k1 -= 7;
	k2 = string[7] - '0';
	if (k2 > 16) k2 -= 7;
	k3 = string[8] - '0';
	if (k3 > 16) k3 -= 7;
	k1 += k0 * 16;
	k3 += k2 * 16;
    	k = k1 | (k3 << 8);

	if (k == crc_dstar_ffff) return TRUE;
	return	FALSE;
}

void	GPS_A_Send(char string[], struct ModuleTable *id)
{
	char	CallSign[10];
	int	i, k, n, tmp;
	int	len;
	char	temp[20];
	char	string_temp[256];

	memset (CallSign, 0x20, 10);
	for (i = 0 ; i < 10 ; i++)
	{
		if (string[i] == 0x00) return;
		if (string[i] == '>') break;
		CallSign[i] = string[i];	
	}
	if (CallSign[0] == 0x20)
	{
		memcpy (id->aprs_msg_save, id->aprs_msg, 256);
		return;	
	}
	for (i = 0 ; i < 10 ; i++)
	{
		if (string[i] == '-')
		{
			if (isalpha(string[i+1]))
			{
				break;
			}
		}
	}

	len = strlen((char *)string);
	memset (string_temp, 0x00, 256);
	memcpy (string_temp, string, len);
	for (i = 0 ; i < len ; i++)
	{
		if ((string[i] == '!') || (string[i] == 'z') || (string[i] == 'h') 
			|| (string[i] == '='))
		{
			memset (temp, 0x00, 20);
			n = 0;
			for (k = i+1 ; k < len ; k++)
			{
				temp[n] = string[k];
				if (!(isdigit(string[k]) || (string[k] == '.')
					|| (string[k] == 'S') || (string[k] == 'N')))
				{
					temp[n] = 0x00;
					tmp = atof (&temp[2]) * 10000. / 60.;
					temp[2] = 0x00;
					tmp = tmp + (atoi(temp) * 10000);
					if (temp[7] == 'S') tmp = - tmp;
					id->STATUS_Frm.body.status.Latitude = tmp;
					break;
				}
				n++;
			}
			if (isdigit(string[k]))		// IC-2820 bug
			{
				return;
			}
			k++; 
                        memset (temp, 0x00, 20);
                        n = 0;
                        for ( ; k < len ; k++)
                        {
                                temp[n] = string[k];
				if (!(isdigit(string[k]) || (string[k] == '.') 
					|| (string[k] == 'W') || (string[k] == 'E')))
                                {
                                        temp[n] = 0x00;
                                        tmp = atof (&temp[3]) * 10000. / 60.;
                                        temp[3] = 0x00;
                                        tmp = tmp + (atoi(temp) * 10000);
                                        if (temp[8] == 'W') tmp = - tmp;
                                        id->STATUS_Frm.body.status.Longitude = tmp;
                                        break;
                                }
                                n++;
                        }
			k++;
			break;
		}
	}

}

void    gps_a (char msg[], struct ModuleTable *id)
{
	time_t	atime;

	time(&atime);
        if (debug_sw)
	{
		fprintf (log_file, "%24.24s gps_a: %s", ctime(&atime), msg);
		fflush (log_file);
	}
        if (!GPS_A_SumCheck(msg))
	{
		memcpy (id->aprs_msg_save, id->aprs_msg, 256);
		fprintf (log_file, "%24.24s CRC error : %s", ctime(&atime), msg);
		fflush (log_file);
		return;
	}
	GPS_A_Send (&msg[10], id);
}

