#include	"dstatus.h"

void    rep_send (struct ModuleTable *pnt);
void	module_delete (struct ModuleTable *pnt);
struct	ModuleTable	*module_check (char FrameID[]);
struct	ModuleTable	*module_check_ex (char FrameID[]);


extern  struct  sockaddr_in     in_sock;
extern  socklen_t       len_in_sock;

int	rpt_mon_sd;
char    mon_frame_id[2] = {0x00, 0x00};

union
{
	struct	dstar_packet	d_packet;
	char	zr_buffer[1024];
}	zr_buff;

union
{
	struct  dstar_packet    d_packet;
	char    gw_buffer[1024];
}	gw_buff;

union
{
	struct  dstar_packet    d_packet;
	char    mon_buffer[128];
}       mon_buff;

void    mon_reply (char pkt[])
{
        char    mon_reply_frame[10];
        int     err;
        time_t  atime;

        memset (mon_reply_frame, 0x00, 10);
        memcpy (mon_reply_frame, pkt, 6);
        mon_reply_frame[6] = 'r';

        err = sendto (rpt_mon_sd, mon_reply_frame, 10, 0,
                (struct sockaddr *)&in_sock, sizeof(in_sock));
        if (err == -1)
        {
                time (&atime);
                fprintf (log_file, "%24.24s sendto (mon reply) error:%s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }

}

int	repeater_mon(void)
{
	struct	ModuleTable	*m_pnt;
	int	length;
	time_t	atime;
	struct	timeval		time_21ms;
	struct	timeval		cur_time;

	len_in_sock = sizeof (in_sock);
    	length = recvfrom(rpt_mon_sd, &mon_buff, sizeof(mon_buff), 0, (struct sockaddr *)&in_sock, &len_in_sock);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s Repeater data Reciv. error\n", ctime(&atime));
        	return FALSE;			// end
    	}

	if (!memcmp(mon_buff.d_packet.id, "DSTR", 4) && (mon_buff.d_packet.sr == 's')) 
		//&& (mon_buff.d_packet.c == 0x12) && (mon_buff.d_packet.trunk.FrameType == 0x20) 
		//&& ((mon_buff.d_packet.trunk.FrameSeq & 0x3f) < 21))		// check D-STAR packet (DSTR)
	{
		mon_reply((char *)&mon_buff);
		
		if (length == 58)
		{
			m_pnt = module_check(mon_buff.d_packet.body.header.rpt1);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &mon_buff, 58);
				m_pnt->rpt_save_length = 58;
				rep_send (m_pnt);
				m_pnt->FrameID[0] = mon_buff.d_packet.trunk.FrameID[0];
				m_pnt->FrameID[1] = mon_buff.d_packet.trunk.FrameID[1];
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
			if ((mon_buff.d_packet.body.header.rpt2[7] != 'G')) 
					memcpy (mon_frame_id, mon_buff.d_packet.trunk.FrameID, 2);
		}
		else if (length == 29) // voice packet ICOM
		{
			m_pnt = module_check_ex (mon_buff.d_packet.trunk.FrameID);
			if (m_pnt)
			{
				memcpy (&m_pnt->rpt_save, &mon_buff, 29);
				m_pnt->rpt_save_length = 29;
				rep_send (m_pnt);
				gettimeofday (&cur_time, NULL);
				time_21ms.tv_sec = 0;
				time_21ms.tv_usec = 21000;
				timeradd (&cur_time, &time_21ms, &m_pnt->recv_time);
				m_pnt->lost_cnt = 0;
			}
		}
		else if (length == 32) // Last Frame ICOM
		{
			m_pnt = module_check_ex (mon_buff.d_packet.trunk.FrameID); 
			if (m_pnt)
			{
                        	memcpy (&m_pnt->rpt_save, &mon_buff, 32);
                        	m_pnt->rpt_save_length = 32;
				rep_send (m_pnt);
				//module_delete (m_pnt);
			}
		}
	}
	return TRUE;
}

int	repeater_init(void)
{
	time_t	atime;

	if (mon_port > 0)
	{
    		// IPv4 UDP socket
		// monitor port
    		if((rpt_mon_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		{
                	time(&atime);
                	fprintf (log_file, "%24.24s Zone Repeater socket(Monitor) not open\n", ctime(&atime));
        		return FALSE;	
    		}

        	// 待ち受けるIPとポート番号を設定
        	rpt_mon_addr.sin_family = PF_UNSPEC;
        	rpt_mon_addr.sin_port = htons(mon_port);
        	rpt_mon_addr.sin_addr.s_addr = INADDR_ANY;

		FD_SET (rpt_mon_sd, &fd_save);

    		// Bind
    		if(bind(rpt_mon_sd, (struct sockaddr *)&rpt_mon_addr, sizeof(rpt_mon_addr)) < 0) {
			time(&atime);
			fprintf (log_file, "%24.24s Zone Repeater Monitor socket not bind %s\n", 
				ctime(&atime), strerror(errno));
        		return FALSE;
    		}
	}

	return TRUE;
}
