﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace SST.Viewer
{
	/// <summary>
	///		ビュアーメへのッセージ（<see cref="ViewerMessage"/>）を管理するキュー。
	/// </summary>
	class ViewerMessageQueue
	{
		public void 格納する( ViewerMessage msg )
		{
			this._メッセージキュー.Enqueue( msg );
		}

		/// <summary>
		///		ビュアーメッセージキューから<see cref="ViewerMessage">メッセージ</see>を取り出す。
		/// </summary>
		/// <returns>
		///		取り出された<see cref="ViewerMessage">メッセージ</see>。
		///		キューにメッセージがなかった場合は null 。
		///	</returns>
		public ViewerMessage 取得する()
		{
			if( this._メッセージキュー.TryDequeue( out ViewerMessage msg ) )	// 空なら false 。
			{
				FDK.Log.Info( "ビュアーメッセージを取得しました。" );
				return msg;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		///		ビュアーメッセージキューの実体。
		/// </summary>
		private ConcurrentQueue<ViewerMessage> _メッセージキュー = new ConcurrentQueue<ViewerMessage>();
	}
}
