﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using SharpDX;
using FDK;
using FDK.メディア;
using FDK.カウンタ;
using SST.設定;
using SST.入力;

namespace SST.ステージ
{
	/// <summary>
	///		ドラムセットを描画する。
	/// </summary>
	class ドラムセット : FDK.Activity
	{
		/// <summary>
		///		0.0:閉じてる ～ 1.0:開いてる
		/// </summary>
		public float ハイハットの開度
		{
			get
				=> this._ハイハットの開度;

			set
				=> this._ハイハットの開度 =
					( 1.0f < value ) ? throw new ArgumentOutOfRangeException( "1.0 を超える値は設定できません。" ) :
					( 0.0f > value ) ? throw new ArgumentOutOfRangeException( "0.0 未満の値は設定できません。" ) :
					value;
		}

		/// <summary>
		///		ベロシティ（開:0～80:閉）に応じたハイハット開度を設定する。
		///		80超えの指定も可能。
		/// </summary>
		public int ハイハットのベロシティ
		{
			set
				=> this.ハイハットの開度 = 1f - ( Math.Min( value, 80 ) / 80f );  //  ベロシティ80超えはすべて1.0（完全閉じ）とする。
		}

		public ドラムセット()
		{
			this.子リスト.Add( this._HiHatTop = new 画像( @"$(System)images\DrumKit HiHat Top.png" ) );
			this.子リスト.Add( this._HiHatBottom = new 画像( @"$(System)images\DrumKit HiHat Bottom.png" ) );
			this.子リスト.Add( this._Snare = new 画像( @"$(System)images\DrumKit Snare.png" ) );
			this.子リスト.Add( this._Bass = new 画像( @"$(System)images\DrumKit Bass.png" ) );
			this.子リスト.Add( this._HiTom = new 画像( @"$(System)images\DrumKit HiTom.png" ) );
			this.子リスト.Add( this._LowTom = new 画像( @"$(System)images\DrumKit LowTom.png" ) );
			this.子リスト.Add( this._FloorTom = new 画像( @"$(System)images\DrumKit FloorTom.png" ) );
			this.子リスト.Add( this._LCymbal = new 画像( @"$(System)images\DrumKit LCymbal.png" ) );
			this.子リスト.Add( this._LCymbalStand = new 画像( @"$(System)images\DrumKit LCymbal Stand.png" ) );
			this.子リスト.Add( this._LCymbalTop = new 画像( @"$(System)images\DrumKit LCymbal Top.png" ) );
			this.子リスト.Add( this._RCymbal = new 画像( @"$(System)images\DrumKit RCymbal.png" ) );
			this.子リスト.Add( this._RCymbalStand = new 画像( @"$(System)images\DrumKit RCymbal Stand.png" ) );
			this.子リスト.Add( this._RCymbalTop = new 画像( @"$(System)images\DrumKit RCymbal Top.png" ) );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			this._HiHat振動用カウンタ = null;
			this._Snare振動用カウンタ = null;
			this._Bass振動用カウンタ = null;
			this._HiTom振動用カウンタ = null;
			this._LowTom振動用カウンタ = null;
			this._FloorTom振動用カウンタ = null;
			this._LCymbal振動用カウンタ = null;
			this._RCymbal振動用カウンタ = null;
		}

		public void ヒットアニメ開始( ドラム入力種別 drumsType, 表示レーンの左右 LR )
		{
			const int 最初の値 = 0;
			const int 最後の値 = 100;
			const int 値をひとつ増加させるのにかける時間ms = 3;

			switch( drumsType )
			{
				case ドラム入力種別.Unknown:
					break;

				case ドラム入力種別.China:
					if( LR.Chinaは左 )
						this._LCymbal振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					else
						this._RCymbal振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.Ride:
					if( LR.Rideは左 )
						this._LCymbal振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					else
						this._RCymbal振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.Splash:
					if( LR.Splashは左 )
						this._LCymbal振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					else
						this._RCymbal振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.LeftCrash:
					this._LCymbal振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.RightCrash:
					this._RCymbal振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.HiHat_Close:
				case ドラム入力種別.HiHat_Control:
				case ドラム入力種別.HiHat_Open:
					this._HiHat振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.Snare:
				case ドラム入力種別.Snare_ClosedRim:
				case ドラム入力種別.Snare_OpenRim:
					this._Snare振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.Bass:
					this._Bass振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.Tom1:
				case ドラム入力種別.Tom1_Rim:
					this._HiTom振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.Tom2:
				case ドラム入力種別.Tom2_Rim:
					this._LowTom振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;

				case ドラム入力種別.Tom3:
				case ドラム入力種別.Tom3_Rim:
					this._FloorTom振動用カウンタ = new Counter( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
					break;
			}
		}

		public void 進行描画する( グラフィックデバイス gd )
		{
			Debug.Assert( this.活性化している );

			#region " Bass "
			//----------------
			if( this._Bass振動用カウンタ?.終了値に達していない ?? false )
			{
				float 最大振幅 = (float) ( 2.0 * Math.Cos( ( Math.PI / 2.0 ) * this._Bass振動用カウンタ.現在値の割合 ) );   // 2 → 0
				this._Bassの振動幅 = (float) ( 最大振幅 * Math.Sin( 10.0 * Math.PI * this._Bass振動用カウンタ.現在値の割合 ) ); // 10周
			}
			this._Bass.描画する( gd, 881f, 891f + this._Bassの振動幅 );
			//----------------
			#endregion

			#region " LowTom "
			//----------------
			this._LowTomの振動幅 = 0f;
			if( this._LowTom振動用カウンタ?.終了値に達していない ?? false )
			{
				float 最大振幅 = (float) ( 2.0 * Math.Cos( ( Math.PI / 2.0 ) * this._LowTom振動用カウンタ.現在値の割合 ) );  // 2 → 0
				this._LowTomの振動幅 = (float) ( 最大振幅 * Math.Sin( 15.0 * Math.PI * this._LowTom振動用カウンタ.現在値の割合 ) );  // 15周
			}
			this._LowTom.描画する( gd, 999f, 901f + this._LowTomの振動幅 + this._Bassの振動幅 );
			//----------------
			#endregion

			#region " HiTom "
			//----------------
			this._HiTomの振動幅 = 0f;
			if( this._HiTom振動用カウンタ?.終了値に達していない ?? false )
			{
				float 最大振幅 = (float) ( 2.0 * Math.Cos( ( Math.PI / 2.0 ) * this._HiTom振動用カウンタ.現在値の割合 ) );   // 2 → 0
				this._HiTomの振動幅 = (float) ( 最大振幅 * Math.Sin( 15.0 * Math.PI * this._HiTom振動用カウンタ.現在値の割合 ) ); // 15周
			}
			this._HiTom.描画する( gd, 850f, 901f + this._HiTomの振動幅 + this._Bassの振動幅 );
			//----------------
			#endregion

			#region " FloorTom "
			//----------------
			this._FloorTomの振動幅 = 0f;
			if( this._FloorTom振動用カウンタ?.終了値に達していない ?? false )
			{
				float 最大振幅 = (float) ( 2.0 * Math.Cos( ( Math.PI / 2.0 ) * this._FloorTom振動用カウンタ.現在値の割合 ) );   // 2 → 0
				this._FloorTomの振動幅 = (float) ( 最大振幅 * Math.Sin( 10.0 * Math.PI * this._FloorTom振動用カウンタ.現在値の割合 ) ); // 10周
			}
			this._FloorTom.描画する( gd, 1050f, 981f + this._FloorTomの振動幅 );
			//----------------
			#endregion

			#region " Snare "
			//----------------
			this._Snareの振動幅 = 0f;
			if( this._Snare振動用カウンタ?.終了値に達していない ?? false )
			{
				float 最大振幅 = (float) ( 2.0 * Math.Cos( ( Math.PI / 2.0 ) * this._Snare振動用カウンタ.現在値の割合 ) );   // 2 → 0
				this._Snareの振動幅 = (float) ( 最大振幅 * Math.Sin( 17.0 * Math.PI * this._Snare振動用カウンタ.現在値の割合 ) ); // 17周
			}
			this._Snare.描画する( gd, 741f, 988f + this._Snareの振動幅 );
			//----------------
			#endregion

			#region " HiHat "
			//----------------
			this._HiHatの振動幅 = 0f;
			if( this._HiHat振動用カウンタ?.終了値に達していない ?? false )
			{
				float 最大振幅 = ( this.ハイハットの開度 < 0.2f ) ? 1f : (float) ( 2.0 * Math.Cos( ( Math.PI / 2.0 ) * this._HiHat振動用カウンタ.現在値の割合 ) );   // 2 → 0, 開度が小さい場合は 1。
				this._HiHatの振動幅 = (float) ( 最大振幅 * Math.Sin( 20.0 * Math.PI * this._HiHat振動用カウンタ.現在値の割合 ) ); // 20周
			}
			this._HiHatBottom.描画する( gd, 657f, 935f );       // Bottom は振動しない。
			this._HiHatTop.描画する( gd, 657f, ( 935f - 20f * this.ハイハットの開度 ) + this._HiHatの振動幅 );
			//----------------
			#endregion

			#region " 右シンバル "
			//----------------
			this._RCymbalの振動幅 = 0f;
			if( this._RCymbal振動用カウンタ?.終了値に達していない ?? false )
			{
				float 最大振幅 = (float) ( 1.0 * Math.Cos( ( Math.PI / 2.0 ) * this._RCymbal振動用カウンタ.現在値の割合 ) );   // 1 → 0
				this._RCymbalの振動幅 = (float) ( 最大振幅 * Math.Sin( 20.0 * Math.PI * this._RCymbal振動用カウンタ.現在値の割合 ) ); // 20周
			}
			this._RCymbalStand.描画する( gd, 1229f, 920f ); // スタンドは振動しない。
			this._RCymbal.描画する( gd, ( 1257f - this._RCymbal.サイズ.Width / 2f ), ( 923f - this._RCymbal.サイズ.Height / 2f ) + this._RCymbalの振動幅 );
			this._RCymbalTop.描画する( gd, 1229f, 880f + this._RCymbalの振動幅 );
			//----------------
			#endregion

			#region " 左シンバル "
			//----------------
			this._LCymbalの振動幅 = 0f;
			if( this._LCymbal振動用カウンタ?.終了値に達していない ?? false )
			{
				float 最大振幅 = (float) ( 1.0 * Math.Cos( ( Math.PI / 2.0 ) * this._LCymbal振動用カウンタ.現在値の割合 ) );   // 1 → 0
				this._LCymbalの振動幅 = (float) ( 最大振幅 * Math.Sin( 20.0 * Math.PI * this._LCymbal振動用カウンタ.現在値の割合 ) ); // 20周
			}
			this._LCymbalStand.描画する( gd, 472f, 916f );  // スタンドは振動しない。
			this._LCymbal.描画する( gd, ( 649f - this._LCymbal.サイズ.Width / 2f ), ( 918f - this._LCymbal.サイズ.Height / 2f ) + this._LCymbalの振動幅 );
			this._LCymbalTop.描画する( gd, 633f, 891f + this._LCymbalの振動幅 );
			//----------------
			#endregion
		}


		private float _ハイハットの開度 = 1.0f;

		private 画像 _HiHatTop;

		private 画像 _HiHatBottom;

		private 画像 _Snare;

		private 画像 _Bass;

		private 画像 _HiTom;

		private 画像 _LowTom;

		private 画像 _FloorTom;

		private 画像 _LCymbal;

		private 画像 _LCymbalStand;

		private 画像 _LCymbalTop;

		private 画像 _RCymbal;

		private 画像 _RCymbalStand;

		private 画像 _RCymbalTop;

		private Counter _HiHat振動用カウンタ;

		private Counter _Snare振動用カウンタ;

		private Counter _Bass振動用カウンタ;

		private Counter _HiTom振動用カウンタ;

		private Counter _LowTom振動用カウンタ;

		private Counter _FloorTom振動用カウンタ;

		private Counter _LCymbal振動用カウンタ;

		private Counter _RCymbal振動用カウンタ;

		private float _Bassの振動幅; // Bass を振動させると、HiTom と LowTom も連動する。

		private float _LowTomの振動幅;

		private float _HiTomの振動幅;

		private float _FloorTomの振動幅;

		private float _Snareの振動幅;

		private float _HiHatの振動幅;

		private float _RCymbalの振動幅;

		private float _LCymbalの振動幅;
	}
}
