﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using CSCore;
using SharpDX;
using SharpDX.DirectInput;
using FDK;
using FDK.メディア;
using FDK.メディア.サウンド.WASAPI;
using FDK.カウンタ;
using SSTFormat.v3;
using SST.入力;
using SST.設定;

using FDKUtilities = FDK.FDKUtilities;

namespace SST.ステージ.演奏
{
	class 演奏ステージ : ステージ
	{
		public enum フェーズ
		{
			演奏中,
			Failed,
			クリア時フェードアウト,
			クリア,
			キャンセル,
			ビュアーメッセージ待機,
		}

		public フェーズ 現在のフェーズ
		{
			get;
			set;
		}

		public const float ヒット判定バーの中央Y座標 = 869f + 43f;

		public const float レーンフレームの左端位置 = 619f;

		public ConcurrentDictionary<ヒットランク種別, int> ヒットランク別ヒット回数
		{
			get;
		} = new ConcurrentDictionary<ヒットランク種別, int>();


		public 演奏ステージ()
		{
			this.子リスト.Add( this._ステージ台 = new 画像( @"$(System)images\ステージ台.png" ) );
			this.子リスト.Add( this._レーンフレーム = new レーンフレーム() );
			this.子リスト.Add( this._ドラムセット = new ドラムセット() );
			this.子リスト.Add( this._ヒット判定バー = new 画像( @"$(System)images\判定バー.png" ) );
			this.子リスト.Add( this._チップ画像 = new 画像( @"$(System)images\Chips.png" ) );
			this.子リスト.Add( this._回転羽 = new 回転羽( 最大同時発火数: 32 ) );
			this.子リスト.Add( this._コンソールフォント = new コンソールフォント() );
			this.子リスト.Add( this._ドラムサウンド = new ドラムサウンド() );
			this.子リスト.Add( this._コンボ = new コンボ() );
			this.子リスト.Add( this._ヒットランク = new ヒットランク() );
			this.子リスト.Add( this._クリア時フェードアウト = new フェードアウト( 1.0f ) );
			this.子リスト.Add( this._白パネル = new 画像( @"$(System)images\パネル白64x64.png" ) );
			this.子リスト.Add( this._FPS = new FPS() );
			this.子リスト.Add( this._数字フォント中グレー48x64 = new 画像フォント(
				@"$(System)images\数字フォント中グレー48x64.png", 
				@"$(System)images\数字フォント中グレー48x64矩形リスト.xml",
				文字幅補正dpx: -16f,
				不透明度: 0.3f ) );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this._活性化した直後である = true;
				this._背景動画開始済み = false;
				this._現在進行描画中の譜面スクロール速度の倍率 = App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率;
				this._描画開始チップ番号 = -1;
				this._背景動画 = null;
				this._BGM = null;
				//this._デコード済みWaveSource = null;	--> キャッシュなので消さない。
				this._背景動画開始済み = false;
				this._BGM再生開始済み = false;
				this._チップ画像の矩形リスト = new 矩形リスト( @"$(System)images\Chips Rectangle List.xml" );      // デバイスリソースは持たないので、子Activityではない。

				this.ヒットランク別ヒット回数.Clear();
				foreach( ヒットランク種別 hitRankType in Enum.GetValues( typeof( ヒットランク種別 ) ) )
					this.ヒットランク別ヒット回数[ hitRankType ] = 0;

				#region " 背景動画とBGMを生成する。"
				//----------------
				if( ( null != App.演奏スコア ) && ( App.演奏スコア.背景動画ファイル名.Nullでも空でもない() ) )
				{
					Log.Info( "背景動画とBGMを読み込みます。" );

					// 動画を子リストに追加。
					this.子リスト.Add( this._背景動画 = new 動画( App.演奏スコア.背景動画ファイル名 ) );

					// 動画から音声パートを抽出して BGM を作成。
					if( ( null != this._デコード済みSampleSource ) && this._デコード済みWaveSourcePath.Equals( App.演奏スコア.背景動画ファイル名 ) )
					{
						// (A) 前回生成したBGMとパスが同じなので、前回のデコード済み WaveSource をキャッシュとして再利用する。
						Log.Info( "前回生成したサウンドデータを再利用します。" );
					}
					else
					{
						// (B) 初めての生成か、または前回生成したBGMとパスが違うので、新しくデコード済み WaveSource を生成する。
						this._デコード済みSampleSource?.Dispose();
						this._デコード済みSampleSource = SampleSourceFactory.Create( App.サウンドデバイス, App.演奏スコア.背景動画ファイル名 );
						this._デコード済みWaveSourcePath = App.演奏スコア.背景動画ファイル名;
					}

					this._BGM?.Dispose();
					this._BGM = new Sound( App.サウンドデバイス, this._デコード済みSampleSource );
				}
				else
				{
					Log.Info( "背景動画とBGMはありません。" );
				}
				//----------------
				#endregion

				#region " 最初のフェーズを設定する。"
				//----------------
				if( ( App.ビュアーモードではない ) ||
					( ( null != App.最後に取得したビュアーメッセージ ) &&
					  ( App.最後に取得したビュアーメッセージ.種別 == Viewer.ViewerMessage.指示種別.演奏開始 ) ) )
				{
					this.現在のフェーズ = フェーズ.演奏中;
				}
				else
				{
					this.現在のフェーズ = フェーズ.ビュアーメッセージ待機;
				}
				//----------------
				#endregion
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				// 背景動画を生成した場合は子リストから削除。
				if( null != this._背景動画 )
					this.子リスト.Remove( this._背景動画 );

				App.ユーザ管理.選択されているユーザ.保存する();

				this._活性化した直後である = false;
			}
		}

		public override void 高速進行する()
		{
			Debug.Assert( this.活性化している );

			switch( this.現在のフェーズ )
			{
				case フェーズ.演奏中:
					#region " *** "
					//----------------
					{
						// 進行。

						#region " 初めての進行描画。"
						//----------------
						if( this._活性化した直後である )
						{
							this._活性化した直後である = false;
							this._描画開始チップ番号 = 0; // -1 → 0; 演奏開始。
							this._チップアニメ.開始する( 最初の値: 0, 最後の値: 48, 値をひとつ増加させるのにかける時間ms: 10 );

							#region " 演奏開始時刻を初期化し、動画とBGMの再生を開始する。"
							//----------------
							double 演奏開始位置の先頭からの時間sec = 0.0;

							// 演奏開始時刻の設定(1)
							App.サウンドタイマ.リセットする( 演奏開始位置の先頭からの時間sec );
							Log.Info( $"演奏開始時刻（背景動画再生チェック前）: {App.サウンドタイマ.現在時刻sec} sec" );

							// 演奏開始時刻の設定(2) ビュアーメッセージがある場合、開始時刻を修正する。
							var msg = App.最後に取得したビュアーメッセージ;
							if( null != msg )
							{
								// 演奏開始位置を設定。
								演奏開始位置の先頭からの時間sec = this._演奏開始小節番号を設定しその時刻secを返す( msg.演奏を開始する小節番号 );
								Log.Info( $"演奏開始の先頭からの時間: {演奏開始位置の先頭からの時間sec} sec" );

								// その他のオプション。
								App.システム設定.Autoチップのドラム音を再生する = msg.ドラムチップのヒット時に発声する;
							}

							// BGMと動画を（必要あれば）再生開始。
							this._再生中の時刻なら動画とBGMを再生開始する( 演奏開始位置の先頭からの時間sec );

							// 演奏開始時刻の設定(3) 動画とBGMが再生された場合、ここに到達するまでに多少の遅延が生じているので、ここで演奏開始時刻を再取得しておく。
							App.サウンドタイマ.リセットする( 演奏開始位置の先頭からの時間sec );
							Log.Info( $"演奏開始時刻（背景動画再生チェック後）: {App.サウンドタイマ.現在時刻sec} sec" );
							//----------------
							#endregion
						}
						//----------------
						#endregion

						this._FPS.FPSをカウントしプロパティを更新する();

						#region " 背景動画が再生されているのにBGMがまだ再生されていないなら、すぐに再生を開始する。"
						//----------------
						if( this._背景動画開始済み && !( this._BGM再生開始済み ) )
						{
							this._BGM?.Play();
							this._BGM再生開始済み = true;
						}
						//----------------
						#endregion

						double 現在の演奏時刻sec = this._演奏開始からの経過時間secを返す();

						// 自動演奏

						#region " 自動ヒット処理。"
						//----------------
						this._描画範囲のチップに処理を適用する( 現在の演奏時刻sec, ( chip, index, ヒット判定バーと描画との時間sec, ヒット判定バーと発声との時間sec, ヒット判定バーとの距離 ) => {

							var オプション設定 = App.ユーザ管理.選択されているユーザ.オプション設定;
							var 対応表 = オプション設定.ドラムとチップと入力の対応表[ chip.チップ種別 ];
							var AutoPlay = オプション設定.AutoPlay[ 対応表.AutoPlay種別 ];

							bool チップはヒット済みである = chip.ヒット済みである;
							bool チップはMISSエリアに達している = ( ヒット判定バーと描画との時間sec > オプション設定.最大ヒット距離sec[ ヒットランク種別.POOR ] );
							bool チップは描画についてヒット判定バーを通過した = ( 0 <= ヒット判定バーと描画との時間sec );
							bool チップは発声についてヒット判定バーを通過した = ( 0 <= ヒット判定バーと発声との時間sec );

							if( チップはヒット済みである )
							{
								// 何もしない。
								return;
							}

							if( チップはMISSエリアに達している )
							{
								// MISS判定。
								if( AutoPlay && 対応表.AutoPlayON.MISS判定 )
								{
									this._チップのヒット処理を行う( chip, ヒットランク種別.MISS, 対応表.AutoPlayON.自動ヒット時処理, ヒット判定バーと発声との時間sec );
									return;
								}
								else if( !AutoPlay && 対応表.AutoPlayOFF.MISS判定 )
								{
									this._チップのヒット処理を行う( chip, ヒットランク種別.MISS, 対応表.AutoPlayOFF.ユーザヒット時処理, ヒット判定バーと発声との時間sec );
									return;
								}
								else
								{
									// 通過。
								}
							}

							if( チップは発声についてヒット判定バーを通過した )
							{
								// 自動ヒット判定。
								if( ( AutoPlay && 対応表.AutoPlayON.自動ヒット && 対応表.AutoPlayON.自動ヒット時処理.再生 ) ||
									( !AutoPlay && 対応表.AutoPlayOFF.自動ヒット && 対応表.AutoPlayOFF.自動ヒット時処理.再生 ) )
								{
									this._チップの発声を行う( chip, ヒット判定バーと発声との時間sec );
								}
							}

							if( チップは描画についてヒット判定バーを通過した )
							{
								// 自動ヒット判定。
								if( AutoPlay && 対応表.AutoPlayON.自動ヒット )
								{
									this._チップのヒット処理を行う( chip, ヒットランク種別.AUTO, 対応表.AutoPlayON.自動ヒット時処理, ヒット判定バーと発声との時間sec );
									return;
								}
								else if( !AutoPlay && 対応表.AutoPlayOFF.自動ヒット )
								{
									this._チップのヒット処理を行う( chip, ヒットランク種別.AUTO, 対応表.AutoPlayOFF.自動ヒット時処理, ヒット判定バーと発声との時間sec );
									return;
								}
								else
								{
									// 通過。
								}
							}

						} );
						//----------------
						#endregion

						// 入力(1) 手動演奏

						App.入力管理.すべての入力デバイスをポーリングする( 入力履歴を記録する: false );

						#region " ユーザヒット処理。"
						//----------------
						{
							var オプション設定 = App.ユーザ管理.選択されているユーザ.オプション設定;

							#region " ヒットしてようがしてまいが起こすアクション（空打ち処理）。 "
							//----------------
							foreach( var 入力 in App.入力管理.ポーリング結果 )
							{
								if( 入力.InputEvent.離された )
									continue;   // 押下イベントじゃないなら無視。

								this._ドラムセット.ヒットアニメ開始( 入力.Type, オプション設定.表示レーンの左右 );

								var カラム = オプション設定.ドラムとチップと入力の対応表.対応表.Where( ( kvp ) => ( kvp.Value.ドラム入力種別 == 入力.Type ) );  // カラムは struct なので FirstOrDefault() は使わない。
								if( 0 < カラム.Count() )
									this._レーンフレーム.フラッシュ開始( カラム.First().Value.表示レーン種別 );
							}
							//----------------
							#endregion

							var 処理済み入力 = new List<ドラム入力イベント>(); // ヒット処理が終わった入力は、二重処理しないよう、この中に追加しておく。

							this._描画範囲のチップに処理を適用する( 現在の演奏時刻sec, ( chip, index, ヒット判定バーと描画との時間sec, ヒット判定バーと発声との時間sec, ヒット判定バーとの距離 ) => {

								#region " ヒット判定 "
								//----------------
								if( chip.ヒット済みである )
									return;

								var チップの対応表 = オプション設定.ドラムとチップと入力の対応表[ chip.チップ種別 ];

								if( オプション設定.AutoPlay[ チップの対応表.AutoPlay種別 ] )
									return; // チップが AutoPlay ON である。

								if( !( チップの対応表.AutoPlayOFF.ユーザヒット ) )
									return; // このチップは、AutoPlay OFF 時でもユーザヒットの対象ではない。

								double ヒット判定バーとの時間の絶対値sec = Math.Abs( ヒット判定バーと描画との時間sec );

								bool チップはMISSエリアに達している = ( ヒット判定バーと描画との時間sec > オプション設定.最大ヒット距離sec[ ヒットランク種別.POOR ] );
								if( !( ヒット判定バーと描画との時間sec >= -( オプション設定.最大ヒット距離sec[ ヒットランク種別.POOR ] ) && !チップはMISSエリアに達している ) )
									return; // チップはヒット可能エリアにある。

								var ヒット入力 = App.入力管理.ポーリング結果.FirstOrDefault( ( 入力 ) => {
									#region " chip にヒットする入力があれば true を返す。"
									//----------------
									if( !( 入力.InputEvent.押された ) )
										return false;   // 押下入力じゃない。

									if( 処理済み入力.Contains( 入力 ) )
										return false;   // すでに今回のターンで処理済み（＝処理済み入力リストに追加済み）。

									// chip がシンバルフリーの対象なら、chip に直接対応する入力の他にも、ヒット判定すべき入力がある。
									if( チップの対応表.シンバルフリーの対象 && オプション設定.シンバルフリー )
									{
										// この入力に対応するカラムのうち、
										var カラムs = オプション設定.ドラムとチップと入力の対応表.対応表.Where( ( kvp ) => ( kvp.Value.ドラム入力種別 == 入力.Type ) );
										foreach( var カラム in カラムs )
										{
											// シンバルフリーなチップがあるなら true。
											if( カラム.Value.シンバルフリーの対象 )
												return true;
										}
										// まったくなかったら false。
										return false;
									}

									// chip に対応する入力なら true。
									return ( チップの対応表.ドラム入力種別 == 入力.Type );
									//----------------
									#endregion
								} );

								if( null == ヒット入力 )
									return;
								//----------------
								#endregion

								処理済み入力.Add( ヒット入力 );

								#region " ヒットランクを判定する。"
								//----------------
								var ヒットランク = ヒットランク種別.POOR;

								if( ヒット判定バーとの時間の絶対値sec <= オプション設定.最大ヒット距離sec[ ヒットランク種別.PERFECT ] )
								{
									ヒットランク = ヒットランク種別.PERFECT;
								}
								else if( ヒット判定バーとの時間の絶対値sec <= オプション設定.最大ヒット距離sec[ ヒットランク種別.GREAT ] )
								{
									ヒットランク = ヒットランク種別.GREAT;
								}
								else if( ヒット判定バーとの時間の絶対値sec <= オプション設定.最大ヒット距離sec[ ヒットランク種別.GOOD ] )
								{
									ヒットランク = ヒットランク種別.GOOD;
								}
								//----------------
								#endregion

								this._チップのヒット処理を行う( chip, ヒットランク, チップの対応表.AutoPlayOFF.ユーザヒット時処理, ヒット判定バーと発声との時間sec );

							} );
						}
						//----------------
						#endregion

						// 入力(2) アプリ操作

						if( App.入力管理.キーボードデバイス.キーが押された( 0, Key.Escape ) )
						{
							#region " ESC → ステージキャンセル "
							//----------------
							if( App.ビュアーモードではない )
							{
								this.BGMを停止する();
								this.現在のフェーズ = フェーズ.キャンセル;
								break;  // このタスクを終了。
							}
							else
							{
								// ビュアーモード時のキャンセルは無効。
							}
							//----------------
							#endregion
						}
						if( App.入力管理.キーボードデバイス.キーが押された( 0, Key.Up ) )
						{
							#region " 上 → 譜面スクロールを加速 "
							//----------------
							const double 最大倍率 = 8.0;
							App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率 =
								Math.Min( App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率 + 0.5, 最大倍率 );
							//----------------
							#endregion
						}
						if( App.入力管理.キーボードデバイス.キーが押された( 0, Key.Down ) )
						{
							#region " 下 → 譜面スクロールを減速 "
							//----------------
							const double 最小倍率 = 0.5;
							App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率 =
								Math.Max( App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率 - 0.5, 最小倍率 );
							//----------------
							#endregion
						}
						foreach( var ev in App.入力管理.MIDI入力デバイス.入力イベントリスト.Where( ( ie ) => ( 255 == ie.Key ) ) )
						{
							#region " ハイハットの開閉 "
							//----------------
							this._ドラムセット.ハイハットのベロシティ = ev.Velocity;
							//----------------
							#endregion
						}
					}
					//----------------
					#endregion
					break;
			}
		}

		public override void 進行描画する( グラフィックデバイス gd )
		{
			Debug.Assert( this.活性化している );
			Debug.Assert( null != gd );

			switch( this.現在のフェーズ )
			{
				case フェーズ.演奏中:
					if( this._活性化した直後である )
						break;  // 進行処理がまだ行われていない。

					#region " 譜面スクロール速度が変化している → 追い付き進行 "
					//----------------
					{
						double 倍率 = this._現在進行描画中の譜面スクロール速度の倍率;

						if( 倍率 < App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率 )
						{
							if( 0 > this._スクロール倍率追い付き用_最後の値 )
							{
								this._スクロール倍率追い付き用カウンタ = new LoopCounter( 0, 1000, 10 );    // 0→100; 全部で10×1000 = 10000ms = 10sec あれば十分だろう
								this._スクロール倍率追い付き用_最後の値 = 0;
							}
							else
							{
								while( this._スクロール倍率追い付き用_最後の値 < this._スクロール倍率追い付き用カウンタ.現在値 )
								{
									倍率 += 0.025;
									this._スクロール倍率追い付き用_最後の値++;
								}

								this._現在進行描画中の譜面スクロール速度の倍率 =
									Math.Min( 倍率, App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率 );
							}
						}
						else if( 倍率 > App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率 )
						{
							if( 0 > this._スクロール倍率追い付き用_最後の値 )
							{
								this._スクロール倍率追い付き用カウンタ = new LoopCounter( 0, 1000, 10 );    // 0→100; 全部で10×1000 = 10000ms = 10sec あれば十分だろう
								this._スクロール倍率追い付き用_最後の値 = 0;
							}
							else
							{
								while( this._スクロール倍率追い付き用_最後の値 < this._スクロール倍率追い付き用カウンタ.現在値 )
								{
									倍率 -= 0.025;
									this._スクロール倍率追い付き用_最後の値++;
								}

								this._現在進行描画中の譜面スクロール速度の倍率 =
									Math.Max( 倍率, App.ユーザ管理.選択されているユーザ.オプション設定.譜面スクロール速度の倍率 );
							}
						}
						else
						{
							this._スクロール倍率追い付き用_最後の値 = -1;
							this._スクロール倍率追い付き用カウンタ = null;
						}
					}
					//----------------
					#endregion

					this._コンボ.進行描画する( gd );
					this._回転羽.進行描画する( gd );

					double 演奏時刻sec = this._演奏開始からの経過時間secを返す() + gd.次のDComp表示までの残り時間sec;

					#region " 背景動画とBGMの進行描画。"
					//----------------
					if( this._背景動画開始済み )
					{
						// 背景動画チップがヒット済みなら、背景動画の進行描画を行う。
						switch( App.ユーザ管理.選択されているユーザ.オプション設定.動画表示パターン種別 )
						{
							case 動画表示パターン種別.中央表示:
								#region " *** "
								//----------------
								{
									float w = gd.設計画面サイズ.Width;
									float h = gd.設計画面サイズ.Height;

									this._背景動画?.描画する( gd, new RectangleF( 0f, 0f, w, h ), 0.2f );  // 全体

									float 拡大縮小率 = 0.75f;
									float 上移動 = 100.0f;

									// 進行描画せず、直前に取得したフレームをそのまま描画する。
									this._背景動画?.前のフレームを描画する( gd, new RectangleF(
										w * ( 1f - 拡大縮小率 ) / 2f,
										h * ( 1f - 拡大縮小率 ) / 2f - 上移動,
										w * 拡大縮小率,
										h * 拡大縮小率 ) );
								}
								//----------------
								#endregion
								break;

							case 動画表示パターン種別.最大表示:
								#region " *** "
								//----------------
								this._背景動画?.描画する( gd, new RectangleF( 0f, 0f, gd.設計画面サイズ.Width, gd.設計画面サイズ.Height ), 1.0f );
								//----------------
								#endregion
								break;
						}

						// 動画が重たいかもしれないので、演奏時刻をここで更新しておく。	---> 重たくても更新禁止！（譜面スクロールがガタつく原因になる）
						//演奏時刻sec = this._演奏開始からの経過時間secを返す();
					}
					//----------------
					#endregion

					this._ステージ台.描画する( gd, 0f, 0f );
					this._レーンフレーム.進行描画する( gd, レーンフレームの左端位置 );
					this._コンボ.進行描画する( gd );
					this._ヒットランク.進行描画する( gd, レーンフレームの左端位置 );
					this._小節線拍線を描画する( gd, 演奏時刻sec );
					this._ヒット判定バー.描画する( gd, 597f, ヒット判定バーの中央Y座標 - 43f );
					this._ドラムセット.進行描画する( gd );
					this._チップを描画する( gd, 演奏時刻sec );
					this._回転羽.進行描画する( gd );
					this._FPS.VPSをカウントする();
					this._FPS.描画する( gd, 0f, 0f );
					break;

				case フェーズ.クリア時フェードアウト:
					if( this._クリア時フェードアウト.開始されていない )
					{
						this._クリア時フェードアウト.開始する();
					}
					else
					{
						if( this._クリア時フェードアウト.完了した )
						{
							this.現在のフェーズ = フェーズ.クリア;
						}
					}
					this._ステージ台.描画する( gd, 0f, 0f );
					this._レーンフレーム.進行描画する( gd, レーンフレームの左端位置 );
					this._ヒット判定バー.描画する( gd, 597f, ヒット判定バーの中央Y座標 - 43f );
					this._ドラムセット.進行描画する( gd );
					this._回転羽.進行描画する( gd );
					this._クリア時フェードアウト.進行描画する( gd, this._白パネル );
					this._FPS.VPSをカウントする();
					this._FPS.描画する( gd, 0f, 0f );
					break;

				case フェーズ.Failed:
				case フェーズ.クリア:
				case フェーズ.キャンセル:
				case フェーズ.ビュアーメッセージ待機:
					break;
			}
		}

		public void 演奏を停止する()
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this._描画開始チップ番号 = -1;   // 演奏停止

				this.BGMを停止する();
				this._背景動画開始済み = false;

				this._コンボ.COMBO値 = 0;
			}
		}

		/// <remarks>
		///		演奏クリア時には、次の結果ステージに入ってもBGMが鳴り続ける。
		///		そのため、後からBGMだけを別個に停止するためのメソッドが必要になる。
		/// </remarks>
		public void BGMを停止する()
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this._BGM?.Stop();
				this._BGM?.Dispose();
				this._BGM = null;

				//this._デコード済みWaveSource?.Dispose();	--> ここではまだ解放しない。
				//this._デコード済みWaveSource = null;
			}
		}

		public void BGMのキャッシュを解放する()
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this.BGMを停止する();
				FDKUtilities.解放する( ref this._デコード済みSampleSource );
			}
		}


		private double _現在進行描画中の譜面スクロール速度の倍率 = 1.0;

		/// <summary>
		///		<see cref="スコア.チップリスト"/> のうち、描画を始めるチップのインデックス番号。
		///		未演奏時・演奏終了時は -1 。
		/// </summary>
		/// <remarks>
		///		演奏開始直後は 0 で始まり、対象番号のチップが描画範囲を流れ去るたびに +1 される。
		///		このメンバの更新は、高頻度進行タスクではなく、進行描画メソッドで行う。（低精度で構わないので）
		/// </remarks>
		private int _描画開始チップ番号 = -1;

		private 動画 _背景動画 = null;

		/// <remarks>
		///		停止と解放は、演奏ステージクラスの非活性化後に、外部から行われる。
		///		<see cref="SST.ステージ.演奏.演奏ステージ.BGMを停止する"/>
		///		<see cref="SST.ステージ.演奏.演奏ステージ.BGMのキャッシュを解放する"/>
		/// </remarks>
		private Sound _BGM = null;

		/// <summary>
		///		BGM の生成もとになるデコード済みサウンドデータ。
		///	</summary>
		///	<remarks>
		///		活性化と非活性化に関係なく、常に最後にデコードしたデータを持つ。（キャッシュ）
		///		演奏ステージインスタンスを破棄する際に、このインスタンスもDisposeすること。
		/// </remarks>
		private ISampleSource _デコード済みSampleSource = null;
		private string _デコード済みWaveSourcePath = null;

		private bool _背景動画開始済み = false;

		private bool _BGM再生開始済み = false;

		private 画像 _ステージ台 = null;

		private レーンフレーム _レーンフレーム = null;

		private ドラムセット _ドラムセット = null;

		private 画像 _ヒット判定バー = null;

		private 画像 _チップ画像 = null;

		private 矩形リスト _チップ画像の矩形リスト = null;

		private LoopCounter _チップアニメ = new LoopCounter();

		private 回転羽 _回転羽 = null;

		private コンソールフォント _コンソールフォント = null;

		private 画像フォント _数字フォント中グレー48x64 = null;

		private ドラムサウンド _ドラムサウンド = null;

		private コンボ _コンボ = null;

		private ヒットランク _ヒットランク = null;

		private FPS _FPS = null;

		private LoopCounter _スクロール倍率追い付き用カウンタ = null;

		private int _スクロール倍率追い付き用_最後の値 = -1;

		private フェードアウト _クリア時フェードアウト = null;

		private 画像 _白パネル = null;

		private bool _活性化した直後である;


		// 譜面描画。

		/// <summary>
		///		指定した小節の先頭を演奏開始位置として設定し、その位置（時刻）を返す。
		/// </summary>
		/// <returns>演奏開始位置sec。（0～）</returns>
		private double _演奏開始小節番号を設定しその時刻secを返す( int 演奏開始小節番号 )
		{
			var score = App.演奏スコア;

			if( null == score )
				return 0.0;

			double 演奏開始時刻sec = 0.0;

			for( int i = 0; i < score.チップリスト.Count; i++ )
			{
				if( score.チップリスト[ i ].小節番号 < 演奏開始小節番号 )
				{
					// 開始チップ以前のチップはヒット済みとする。
					score.チップリスト[ i ].ヒット済みの状態にする();
				}
				else
				{
					// 開始チップを設定。
					this._描画開始チップ番号 = i;

					// 演奏開始時刻は、開始チップの発声時刻から少し早めの値に。
					演奏開始時刻sec = score.チップリスト[ i ].発声時刻sec;
					演奏開始時刻sec -= 0.5;

					// 開始チップ以降のすべてのチップをヒット前の状態にする。
					for( int j = i; j >= 0; j-- )
					{
						if( score.チップリスト[ j ].ヒット済みである )
							score.チップリスト[ j ].ヒット前の状態にする();
					}

					break;
				}
			}

			return 演奏開始時刻sec;
		}

		private void _再生中の時刻なら動画とBGMを再生開始する( double 時刻sec )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				Log.Info( $"指定された時刻: {時刻sec} sec" );

				var 背景動画チップ = App.演奏スコア.チップリスト.FirstOrDefault( ( chip ) => ( chip.チップ種別 == チップ種別.背景動画 ) );

				if( null == 背景動画チップ )
				{
					Log.Info( "背景動画チップは存在しません。" );
					return;
				}

				double 背景動画の長さsec = 0.0;        // 動画のサイズは、映像ではなく音声を優先する。
				if( null != this._BGM )
				{
					背景動画の長さsec = this._BGM.WaveFormat.BytesToMilliseconds( this._BGM.Length * this._BGM.WaveFormat.BytesPerSample ) / 1000.0;
				}

				Log.Info( $"背景動画の発生時刻: {背景動画チップ.発声時刻sec} sec" );
				Log.Info( $"背景動画の長さ: {背景動画の長さsec} sec" );

				// 指定された時刻secは再生期間内？
				if( ( 背景動画チップ.発声時刻sec <= 時刻sec ) && ( 時刻sec < ( 背景動画チップ.発声時刻sec + 背景動画の長さsec ) ) )
				{
					// 背景動画の再生を開始する。
					double 再生開始時刻sec = ( 時刻sec - 背景動画チップ.発声時刻sec );
					this._背景動画?.再生を開始する( 再生開始時刻sec );
					this._背景動画開始済み = true;
					this._BGM?.Play( 再生開始時刻sec - App.サウンドデバイス.再生遅延sec );
					this._BGM再生開始済み = true;
					Log.Info( $"背景動画の再生を開始しました。（再生開始時刻: {再生開始時刻sec} sec）" );
				}
				else
				{
					Log.Info( $"指定された時刻は背景動画の再生期間内ではないので、何もしません。" );
				}
			}
		}

		private double _演奏開始からの経過時間secを返す()
		{
			return App.サウンドタイマ.現在時刻sec;
		}

		// 小節線・拍線 と チップ は描画階層（奥行き）が異なるので、別々のメソッドに分ける。

		private void _小節線拍線を描画する( グラフィックデバイス gd, double 現在の演奏時刻sec )
		{
			if( null == this._チップ画像 )
				return;

			this._チップ画像.加算合成 = false;

			this._描画範囲のチップに処理を適用する( 現在の演奏時刻sec, ( chip, index, ヒット判定バーと描画との時間sec, ヒット判定バーと発声との時間sec, ヒット判定バーとの距離 ) => {

				if( chip.チップ種別 == チップ種別.小節線 )
				{
					#region " 小節線 "
					//----------------
					float 左位置 = レーンフレームの左端位置 + レーンフレーム.レーンto横中央相対位置[ 表示レーン種別.LeftCrash ] - 1f;      // -1f はレーン線の幅の半分。
					float 上位置 = (float)( ヒット判定バーの中央Y座標 + ヒット判定バーとの距離 - 1f );   // -1f は小節線の厚みの半分。
					if( this._チップ画像の矩形リスト[ nameof( チップ種別.小節線 ) ] is RectangleF 画像範囲 )	// 矩形リスト[名前] で RectangleF を取得できる。
					{
						this._チップ画像.描画する( gd, 左位置, 上位置, 転送元矩形: 画像範囲, 描画先矩形を整数境界に合わせる: true );	// false にすると、
						this._チップ画像.描画する( gd, 左位置 + 画像範囲.Width, 上位置, 転送元矩形: 画像範囲, 描画先矩形を整数境界に合わせる: true );	// チカチカする。
					}
					//----------------
					#endregion
					#region " 小節番号 "
					//----------------
					float 右位置 = レーンフレームの左端位置 + this._レーンフレーム.幅 - 64f;	// -48f は適当なマージン。
					this._数字フォント中グレー48x64.描画する( gd, 右位置, 上位置 - 84f, chip.小節番号.ToString(), 右揃え: true );	// -74f は適当なマージン。
					//----------------
					#endregion
				}
				else if( chip.チップ種別 == チップ種別.拍線 )
				{
					#region " 拍線 "
					//----------------
					float 左位置 = レーンフレームの左端位置 + レーンフレーム.レーンto横中央相対位置 [ 表示レーン種別.LeftCrash ] - 1f;	 // -1f はレーン線の幅の半分。
					float 上位置 = (float)( ヒット判定バーの中央Y座標 + ヒット判定バーとの距離 - 1f );   // -1f は拍線の厚みの半分。
					if( this._チップ画像の矩形リスト[ nameof( チップ種別.拍線 ) ] is RectangleF 画像範囲 )
					{
						this._チップ画像.描画する( gd, 左位置: 左位置, 上位置: 上位置, 転送元矩形: 画像範囲, 描画先矩形を整数境界に合わせる: true );	// false にすると、
						this._チップ画像.描画する( gd, 左位置: 左位置 + 画像範囲.Width, 上位置: 上位置, 転送元矩形: 画像範囲, 描画先矩形を整数境界に合わせる: true );	// チカチカする。
					}
					//----------------
					#endregion
				}

			} );
		}

		private void _チップを描画する( グラフィックデバイス gd, double 現在の演奏時刻sec )
		{
			if( null == this._チップ画像 )
				return;

			this._チップ画像.加算合成 = false;

			this._描画範囲のチップに処理を適用する( 現在の演奏時刻sec, ( chip, index, ヒット判定バーと描画との時間sec, ヒット判定バーと発声との時間sec, ヒット判定バーとの距離 ) => {

				float 縦中央位置 = (float)( ヒット判定バーの中央Y座標 + ヒット判定バーとの距離 );

				#region " チップが描画開始チップであり、かつ、そのY座標が画面下端を超えたなら、描画開始チップ番号を更新する。"
				//----------------
				if( ( index == this._描画開始チップ番号 ) &&
					( gd.設計画面サイズ.Height + 40.0 < 縦中央位置 ) )   // +40 はチップが隠れるであろう適当なマージン。
				{
					this._描画開始チップ番号++;

					if( App.演奏スコア.チップリスト.Count <= this._描画開始チップ番号 )
					{
						this.現在のフェーズ = フェーズ.クリア時フェードアウト;
						this._描画開始チップ番号 = -1;    // 演奏完了。
						return;
					}
				}
				//----------------
				#endregion

				if( chip.不可視 )
					return;

				#region " チップを個別に描画する。"
				//----------------
				float 音量0to1 = chip.音量 / (float) チップ.最大音量;

				switch( chip.チップ種別 )
				{
					case チップ種別.LeftCrash:
						_単画チップを１つ描画する( 表示レーン種別.LeftCrash, this._チップ画像の矩形リスト[ nameof( チップ種別.LeftCrash ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.HiHat_Close:
						_アニメチップを１つ描画する( 表示レーン種別.HiHat, this._チップ画像の矩形リスト[ nameof( チップ種別.HiHat_Close ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.HiHat_HalfOpen:
						_アニメチップを１つ描画する( 表示レーン種別.HiHat, this._チップ画像の矩形リスト[ nameof( チップ種別.HiHat_Close ) ], 縦中央位置, 音量0to1 );
						_単画チップを１つ描画する( 表示レーン種別.Foot, this._チップ画像の矩形リスト[ nameof( チップ種別.HiHat_HalfOpen ) ], 縦中央位置, 1.0f );
						break;

					case チップ種別.HiHat_Open:
						_アニメチップを１つ描画する( 表示レーン種別.HiHat, this._チップ画像の矩形リスト[ nameof( チップ種別.HiHat_Close ) ], 縦中央位置, 音量0to1 );
						_単画チップを１つ描画する( 表示レーン種別.Foot, this._チップ画像の矩形リスト[ nameof( チップ種別.HiHat_Open ) ], 縦中央位置, 1.0f );
						break;

					case チップ種別.HiHat_Foot:
						_単画チップを１つ描画する( 表示レーン種別.Foot, this._チップ画像の矩形リスト[ nameof( チップ種別.HiHat_Foot ) ], 縦中央位置, 1.0f );
						break;

					case チップ種別.Snare:
						_アニメチップを１つ描画する( 表示レーン種別.Snare, this._チップ画像の矩形リスト[ nameof( チップ種別.Snare ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.Snare_ClosedRim:
						_単画チップを１つ描画する( 表示レーン種別.Snare, this._チップ画像の矩形リスト[ nameof( チップ種別.Snare_ClosedRim ) ], 縦中央位置, 1.0f );
						break;

					case チップ種別.Snare_OpenRim:
						_単画チップを１つ描画する( 表示レーン種別.Snare, this._チップ画像の矩形リスト[ nameof( チップ種別.Snare_OpenRim ) ], 縦中央位置, 音量0to1 );
						// ↓ないほうがいいかも。
						//_単画チップを１つ描画する( 表示レーン種別.Snare, this._チップ画像の矩形リスト[ nameof( チップ種別.Snare ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.Snare_Ghost:
						_単画チップを１つ描画する( 表示レーン種別.Snare, this._チップ画像の矩形リスト[ nameof( チップ種別.Snare_Ghost ) ], 縦中央位置, 1.0f );
						break;

					case チップ種別.Bass:
						_アニメチップを１つ描画する( 表示レーン種別.Bass, this._チップ画像の矩形リスト[ nameof( チップ種別.Bass ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.Tom1:
						_アニメチップを１つ描画する( 表示レーン種別.Tom1, this._チップ画像の矩形リスト[ nameof( チップ種別.Tom1 ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.Tom1_Rim:
						_単画チップを１つ描画する( 表示レーン種別.Tom1, this._チップ画像の矩形リスト[ nameof( チップ種別.Tom1_Rim ) ], 縦中央位置, 1.0f );
						break;

					case チップ種別.Tom2:
						_アニメチップを１つ描画する( 表示レーン種別.Tom2, this._チップ画像の矩形リスト[ nameof( チップ種別.Tom2 ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.Tom2_Rim:
						_単画チップを１つ描画する( 表示レーン種別.Tom2, this._チップ画像の矩形リスト[ nameof( チップ種別.Tom2_Rim ) ], 縦中央位置, 1.0f );
						break;

					case チップ種別.Tom3:
						_アニメチップを１つ描画する( 表示レーン種別.Tom3, this._チップ画像の矩形リスト[ nameof( チップ種別.Tom3 ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.Tom3_Rim:
						_単画チップを１つ描画する( 表示レーン種別.Tom3, this._チップ画像の矩形リスト[ nameof( チップ種別.Tom3_Rim ) ], 縦中央位置, 1.0f );
						break;

					case チップ種別.RightCrash:
						_単画チップを１つ描画する( 表示レーン種別.RightCrash, this._チップ画像の矩形リスト[ nameof( チップ種別.RightCrash ) ], 縦中央位置, 音量0to1 );
						break;

					case チップ種別.China:
						if( App.ユーザ管理.選択されているユーザ.オプション設定.表示レーンの左右.Chinaは左 )
						{
							_単画チップを１つ描画する( 表示レーン種別.LeftCrash, this._チップ画像の矩形リスト[ "LeftChina" ], 縦中央位置, 音量0to1 );
						}
						else
						{
							_単画チップを１つ描画する( 表示レーン種別.RightCrash, this._チップ画像の矩形リスト[ "RightChina" ], 縦中央位置, 音量0to1 );
						}
						break;

					case チップ種別.Ride:
						if( App.ユーザ管理.選択されているユーザ.オプション設定.表示レーンの左右.Rideは左 )
						{
							_単画チップを１つ描画する( 表示レーン種別.LeftCrash, this._チップ画像の矩形リスト[ "LeftRide" ], 縦中央位置, 音量0to1 );
						}
						else
						{
							_単画チップを１つ描画する( 表示レーン種別.RightCrash, this._チップ画像の矩形リスト[ "RightRide" ], 縦中央位置, 音量0to1 );
						}
						break;

					case チップ種別.Ride_Cup:
						if( App.ユーザ管理.選択されているユーザ.オプション設定.表示レーンの左右.Rideは左 )
						{
							_単画チップを１つ描画する( 表示レーン種別.LeftCrash, this._チップ画像の矩形リスト[ "LeftRide_Cup" ], 縦中央位置, 音量0to1 );
						}
						else
						{
							_単画チップを１つ描画する( 表示レーン種別.RightCrash, this._チップ画像の矩形リスト[ "RightRide_Cup" ], 縦中央位置, 音量0to1 );
						}
						break;

					case チップ種別.Splash:
						if( App.ユーザ管理.選択されているユーザ.オプション設定.表示レーンの左右.Splashは左 )
						{
							_単画チップを１つ描画する( 表示レーン種別.LeftCrash, this._チップ画像の矩形リスト[ "LeftSplash" ], 縦中央位置, 音量0to1 );
						}
						else
						{
							_単画チップを１つ描画する( 表示レーン種別.RightCrash, this._チップ画像の矩形リスト[ "RightSplash" ], 縦中央位置, 音量0to1 );
						}
						break;

					case チップ種別.LeftCymbal_Mute:
						_単画チップを１つ描画する( 表示レーン種別.LeftCrash, this._チップ画像の矩形リスト[ "LeftCymbal_Mute" ], 縦中央位置, 1.0f );
						break;

					case チップ種別.RightCymbal_Mute:
						_単画チップを１つ描画する( 表示レーン種別.RightCrash, this._チップ画像の矩形リスト[ "RightCymbal_Mute" ], 縦中央位置, 1.0f );
						break;
				}
				//----------------
				#endregion

			} );

			#region " ローカル関数 "
			//----------------
			void _単画チップを１つ描画する( 表示レーン種別 lane, RectangleF? 元矩形, float 上位置, float 音量0to1 )
			{
				if( null == 元矩形 )
					return;

				var 画像範囲 = (RectangleF) 元矩形;

				this._チップ画像?.描画する(
					gd,
					左位置: レーンフレームの左端位置 + レーンフレーム.レーンto横中央相対位置[ lane ] - ( 画像範囲.Width / 2f ),
					上位置: 上位置 - ( ( 画像範囲.Height / 2f ) * 音量0to1 ),
					転送元矩形: 元矩形,
					Y方向拡大率: 音量0to1 );
			}
			void _アニメチップを１つ描画する( 表示レーン種別 lane, RectangleF? 画像範囲orNull, float Y, float 音量0to1 )
			{
				if( null == 画像範囲orNull )
					return;

				var 画像範囲 = (RectangleF) 画像範囲orNull;

				float チップ1枚の高さ = 18f;
				画像範囲.Offset( 0f, this._チップアニメ.現在値 * 15f );   // 下端3pxは下のチップと共有する前提のデザインなので、18f-3f = 15f。
				画像範囲.Height = チップ1枚の高さ;
				float 左位置 = レーンフレームの左端位置 + レーンフレーム.レーンto横中央相対位置[ lane ] - ( 画像範囲.Width / 2f );
				float 上位置 = Y - ( チップ1枚の高さ / 2f ) * 音量0to1;

				this._チップ画像?.描画する( gd, 左位置, 上位置, 転送元矩形: 画像範囲, Y方向拡大率: 音量0to1 );
			}
			//----------------
			#endregion
		}

		/// <summary>
		///		<see cref="_描画開始チップ番号"/> から画面上端にはみ出すまでの間の各チップに対して、指定された処理を適用する。
		/// </summary>
		/// <param name="適用する処理">引数は、順に、対象のチップ、チップ番号、ヒット判定バーとの時間sec、ヒット判定バーとの距離</param>
		private void _描画範囲のチップに処理を適用する( double 現在の演奏時刻sec, Action<チップ, int, double, double, double> 適用する処理 )
		{
			var スコア = App.演奏スコア;
			if( null == スコア )
				return;

			for( int i = this._描画開始チップ番号; ( 0 <= i ) && ( i < スコア.チップリスト.Count ); i++ )
			{
				var チップ = スコア.チップリスト[ i ];

				// ヒット判定バーとチップの間の、時間 と 距離 を算出。→ いずれも、負数ならバー未達、0でバー直上、正数でバー通過。
				double ヒット判定バーと描画との時間sec = 現在の演奏時刻sec - チップ.描画時刻sec;
				double ヒット判定バーと発声との時間sec = 現在の演奏時刻sec - チップ.発声時刻sec;
				double ヒット判定バーとの距離 = スコア.指定された時間secに対応する符号付きピクセル数を返す( this._現在進行描画中の譜面スクロール速度の倍率, ヒット判定バーと描画との時間sec );

				// 終了判定。
				bool チップは画面上端より上に出ている = ( ( ヒット判定バーの中央Y座標 + ヒット判定バーとの距離 ) < -40.0 );   // -40 はチップが隠れるであろう適当なマージン。
				if( チップは画面上端より上に出ている )
					break;

				// 処理実行。開始判定（描画開始チップ番号の更新）もこの中で。
				適用する処理( チップ, i, ヒット判定バーと描画との時間sec, ヒット判定バーと発声との時間sec, ヒット判定バーとの距離 );
			}
		}

		private void _チップのヒット処理を行う( チップ chip, ヒットランク種別 hitRankType, ドラムとチップと入力の対応表.Column.Columnヒット処理 ヒット処理表, double ヒット判定バーと発声との時間sec )
		{
			chip.ヒット済みである = true;

			if( ヒット処理表.再生 )
			{
				#region " チップの発声を行う。"
				//----------------
				if( chip.発声されていない )
					this._チップの発声を行う( chip, ヒット判定バーと発声との時間sec );
				//----------------
				#endregion
			}
			if( ヒット処理表.判定 )
			{
				#region " チップの判定処理を行う。"
				//----------------
				if( hitRankType != ヒットランク種別.MISS )
				{
					// (A) PERFECT～POOR

					var 対応表 = App.ユーザ管理.選択されているユーザ.オプション設定.ドラムとチップと入力の対応表[ chip.チップ種別 ];

					this._コンボ.COMBO値++;

					this._回転羽.発火する(
						new Vector2(
							レーンフレームの左端位置 + レーンフレーム.レーンto横中央相対位置[ 対応表.表示レーン種別 ],
							ヒット判定バーの中央Y座標 ) );

					this._ドラムセット.ヒットアニメ開始( 対応表.ドラム入力種別, App.ユーザ管理.選択されているユーザ.オプション設定.表示レーンの左右 );

					if( hitRankType == ヒットランク種別.AUTO )
						this._レーンフレーム.フラッシュ開始( 対応表.表示レーン種別 );	// レーンフラッシュは Auto 時のみ。

					this._ヒットランク.表示開始( chip.チップ種別, hitRankType );
					this.ヒットランク別ヒット回数[ hitRankType ]++;
				}
				else
				{
					// (B) MISS

					this._コンボ.COMBO値 = 0;

					this._ヒットランク.表示開始( chip.チップ種別, ヒットランク種別.MISS );
					this.ヒットランク別ヒット回数[ hitRankType ]++;
				}
				//----------------
				#endregion
			}
			if( ヒット処理表.非表示 )
			{
				#region " チップを非表示にする。"
				//----------------
				if( hitRankType != ヒットランク種別.MISS )
				{
					chip.可視 = false;        // PERFECT～POOR チップは非表示。
				}
				else
				{
					// MISSチップは最後まで表示し続ける。
				}
				//----------------
				#endregion
			}
		}

		private void _チップの発声を行う( チップ chip, double 再生開始位置sec )
		{
			if( chip.発声済みである )
				return;

			chip.発声済みである = true;

			if( chip.チップ種別 == チップ種別.背景動画 )
			{
				App.サウンドタイマ.一時停止する();

				// 背景動画の再生を開始する。
				this._背景動画?.再生を開始する();
				this._背景動画開始済み = true;

				// BGMの再生を開始する。
				this._BGM?.Play( 再生開始位置sec );
				this._BGM再生開始済み = true;

				App.サウンドタイマ.再開する();
			}
			else
			{
				// BGM以外のサウンドについては、再生開始位置sec は反映せず、常に最初から再生する。
				if( App.システム設定.Autoチップのドラム音を再生する )
					this._ドラムサウンド.発声する( chip.チップ種別, ( chip.音量 / (float) チップ.最大音量 ) );
			}
		}
	}
}
