﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading;
using SharpDX;
using FDK;
using FDK.メディア;
using FDK.カウンタ;

namespace SST.ステージ.演奏
{
	class コンボ : FDK.Activity
	{
		public int COMBO値
		{
			get;
			set;
		} = 0;


		public コンボ()
		{
			this.子リスト.Add( this._単位付き数値 = new コンボジャンプ() );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			this._現在のモード = EMode.非表示中;
			this.COMBO値 = 0;
			this._前回のCOMBO値 = 0;
			this._コンボが切れたときのCOMBO値 = 0;
			this._コンボが切れた時刻 = QPCTimer.未使用;
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
		}

		public void 進行描画する( グラフィックデバイス gd )
		{
			#region " 進行 "
			//----------------
			EEvent 今回の状態遷移イベント;

			#region " 前回と今回の COMBO 値から、今回の状態遷移イベントを決定する。"
			//-----------------
			int 前回の値 = this._前回のCOMBO値;
			int 今回の値 = COMBO値;

			if( 今回の値 < _表示可能な最小コンボ数 )
			{
				今回の状態遷移イベント = EEvent.非表示;
			}
			else if( 前回の値 == 今回の値 )
			{
				今回の状態遷移イベント = EEvent.同一数値;
			}
			else if( 前回の値 < 今回の値 )
			{
				今回の状態遷移イベント = EEvent.数値更新;
			}
			else
			{
				今回の状態遷移イベント = EEvent.ミス;
			}
			//-----------------
			#endregion

			this._前回のCOMBO値 = COMBO値;

			Retry:  // モードが変化した場合はここからリトライする。（次のターンに回すと、間にPresentを挟んで表示がチラつくから。）

			switch( this._現在のモード )
			{
				case EMode.非表示中:
					#region " 数値が更新されたら 進行表示中モードへ。"
					//-----------------
					if( 今回の状態遷移イベント == EEvent.数値更新 )
					{
						this._現在のモード = EMode.表示中;
						goto Retry;
					}
					this._単位付き数値.表示する = false;
					//-----------------
					#endregion
					break;

				case EMode.表示中:
					#region " 遷移イベントが非表示・ミスのときは 残像表示中 モードへ。"
					//-----------------
					if( ( 今回の状態遷移イベント == EEvent.非表示 ) ||
						( 今回の状態遷移イベント == EEvent.ミス ) )
					{
						this._現在のモード = EMode.残像表示中;
						this._コンボが切れたときのCOMBO値 = 前回の値;
						this._コンボが切れた時刻 = QPCTimer.生カウント;
						goto Retry;
					}
					this._単位付き数値.数値 = 今回の値;
					this._単位付き数値.表示する = true;
					//-----------------
					#endregion
					break;

				case EMode.残像表示中:
					#region " 数値が更新された場合は 進行表示中 モードへ、残像表示時間が切れたときは 非表示 モードへ。"
					//-----------------
					if( 今回の状態遷移イベント == EEvent.数値更新 )
					{
						this._現在のモード = EMode.表示中;
						goto Retry;
					}
					else if( QPCTimer.生カウント相対値を秒へ変換して返す( QPCTimer.生カウント - this._コンボが切れた時刻 ) > 1.0 )     // 1.0秒経った
					{
						this._現在のモード = EMode.非表示中;
						goto Retry;
					}
					this._単位付き数値.数値 = this._コンボが切れたときのCOMBO値;
					this._単位付き数値.表示する = true;
					//-----------------
					#endregion
					break;
			}
			//----------------
			#endregion

			#region " 描画 "
			//----------------
			float 中央X = 1920f / 2f;
			//switch( Global.Users.Config.ComboPosition )			→ コンボのX位置の調整はあとまわし。
			//{
			//	case Eコンボ表示位置.LEFT: n中央X = 300; break;
			//	case Eコンボ表示位置.CENTER: n中央X = 440; break;
			//	case Eコンボ表示位置.RIGHT: n中央X = 680; break;
			//}
			float 下辺Y = 130f; // Y座標は固定位置

			this._単位付き数値.進行描画する( gd, 中央X, 下辺Y, _ドラムコンボの文字間隔 );
			//----------------
			#endregion
		}


		private enum EEvent
		{
			非表示,
			数値更新,
			同一数値,
			ミス,
		}

		private enum EMode
		{
			非表示中,
			表示中,
			残像表示中,
		}

		private EMode _現在のモード;

		private const float _ドラムコンボの文字間隔 = 2f;

		private const int _表示可能な最小コンボ数 = 11;

		private int _前回のCOMBO値 = 0;

		private long _コンボが切れた時刻 = QPCTimer.未使用;

		private int _コンボが切れたときのCOMBO値 = 0;

		private コンボジャンプ _単位付き数値 = null;


		private class コンボジャンプ : Activity
		{
			/// <summary>
			///		表示する数値。新しい数値をここに上書きしていく。
			/// </summary>
			public int 数値
			{
				get;
				set;
			} = 0;

			/// <summary>
			///		false にすると非表示。
			/// </summary>
			public bool 表示する
			{
				get;
				set;
			} = false;


			public コンボジャンプ()
			{
				this.子リスト.Add( this._数値と単位の画像 = new 画像( @"$(System)images\combo.png" ) );

				// 180度分のジャンプY座標差分を算出。(i:{0 → 90 → 179} で、[i]:{0 → -15 → 0})
				for( int i = 0; i < 180; i++ )
					this._ジャンプ差分値[ i ] = ( int ) ( -15.0 * Math.Sin( MathUtil.DegreesToRadians( i ) ) );
			}

			protected override void On活性化( グラフィックデバイス gd )
			{
				this.数値 = 0;
				this._現在の数値 = 0;
				this.表示する = true;
				this._ジャンプインデックス値 = 99999;
				this._ジャンプインデックス進行 = new 定間隔進行();
			}

			protected override void On非活性化( グラフィックデバイス gd )
			{
			}

			public void 進行描画する( グラフィックデバイス gd, float 中央X, float 下辺Y, float 文字間隔 )
			{
				// 進行。

				#region " ジャンプインデックス値 の進行。"
				//-----------------
				if( 360 > this._ジャンプインデックス値 )
				{
					this._ジャンプインデックス進行.経過時間の分だけ進行する(
						間隔ms: 2,
						定間隔処理: () => {
							if( 2000 > this._ジャンプインデックス値 )
								this._ジャンプインデックス値 += 3;
						} );
				}
				//-----------------
				#endregion

				#region " 数値が増加していればジャンプを開始する。"
				//-----------------
				if( this.数値 > this._現在の数値 )
				{
					this._ジャンプインデックス値 = 0;
					this._ジャンプインデックス進行 = new 定間隔進行();
				}
				//-----------------
				#endregion

				this._現在の数値 = this.数値;

				// 描画。

				if( this.表示する )
				{
					// 数値と単位を表示。
					var 位の数 = new int[ 10 ]; // 10桁もあれば足りるやろ
					int 桁数 = 0;

					#region " 現在の数値 の桁を 逆順に 位の数[] に格納する。（例：現在の数値=125 のとき 位の数 = { 5,2,1,0,0,0,0,0,0,0 }, 桁数 = 3 ） "
					//-----------------
					int n = this._現在の数値;
					while( ( 0 < n ) && ( 10 > 桁数 ) )
					{
						位の数[ 桁数 ] = n % 10;       // 1の位を格納
						n = ( n - ( n % 10 ) ) / 10;  // 右へシフト（例: 12345 → 1234 ）
						桁数++;
					}
					//-----------------
					#endregion

					#region " 単位文字の矩形(COMBO矩形) と 数字と単位を合わせた画像の全幅を算出。"
					//-----------------
					var COMBO矩形 = this._文字矩形[ 10 ];
					float 数字と単位を合わせた画像の全幅 = this._文字矩形[ 10 ].Width;

					for( int i = 0; i < 桁数; i++ )
						数字と単位を合わせた画像の全幅 += this._文字矩形[ 位の数[ i ] ].Width;
					//-----------------
					#endregion

					#region " 位の数[] を、COMBO文字→ 1の位 → 10の位 … の順に、右から左へ向かって順番に表示する。"
					//-----------------
					float x = 中央X + ( 数字と単位を合わせた画像の全幅 / 2f );      // 右端X
					float y = 下辺Y;
					int jump = this._ジャンプインデックス値 - ( 桁数 * _桁ごとのジャンプの遅れ );

					// "COMBO" を表示。
					x -= COMBO矩形.Width;
					this._数値と単位の画像.描画する( gd, x, ( 下辺Y - COMBO矩形.Height ), _不透明度0to1, 転送元矩形: COMBO矩形 );

					// 数値を1の位から順に表示。
					for( int i = 0; i < 桁数; i++ )
					{
						var rc = this._文字矩形[ 位の数[ i ] ];

						x -= rc.Width + 文字間隔;
						y = 下辺Y - rc.Height;

						jump = this._ジャンプインデックス値 - ( ( ( 桁数 - i ) - 1 ) * _桁ごとのジャンプの遅れ );
						if( ( 0 <= jump ) && ( 180 > jump ) )
							y += this._ジャンプ差分値[ jump ];

						this._数値と単位の画像.描画する( gd, x, y, _不透明度0to1, 転送元矩形: rc );
					}
					//-----------------
					#endregion
				}
			}


			private int _現在の数値 = -1;

			private 画像 _数値と単位の画像 = null;

			private readonly List<RectangleF> _文字矩形 = new List<RectangleF>() {
				#region " [0]～[9]: '0'～'9', [10]:'COMBO' "
				//----------------
				new RectangleF( 0, 0, 45, 70 ),
				new RectangleF( 45, 0, 45, 70 ),
				new RectangleF( 90, 0, 45, 70 ),
				new RectangleF( 135, 0, 45, 70 ),
				new RectangleF( 180, 0, 45, 70 ),
				new RectangleF( 0, 70, 45, 70 ),
				new RectangleF( 45, 70, 45, 70 ),
				new RectangleF( 90, 70, 45, 70 ),
				new RectangleF( 135, 70, 45, 70 ),
				new RectangleF( 180, 70, 45, 70 ),
				new RectangleF( 0, 140, 90, 32 ),
				//----------------
				#endregion
			};

			private const int _桁ごとのジャンプの遅れ = 50;   // 1桁につき 50 インデックス遅れる

			private const float _不透明度0to1 = 0.7f;

			private int _ジャンプインデックス値 = 9999;

			private int[] _ジャンプ差分値 = new int[ 180 ];

			private 定間隔進行 _ジャンプインデックス進行 = null;
		}
	}
}
