﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using SharpDX.DirectInput;
using FDK;
using FDK.メディア;
using FDK.カウンタ;

namespace SST.ステージ.選曲
{
	class 選曲ステージ : ステージ
	{
		public enum フェーズ
		{
			開始,
			曲決定アニメ,
			曲決定,
			キャンセル,
		}

		public フェーズ 現在のフェーズ
		{
			get;
			protected set;
		}


		public 選曲ステージ()
		{
			this.子リスト.Add( this._ステージ台 = new 画像( @"$(System)images\ステージ台.png" ) );
			this.子リスト.Add( this._ドラムセット = new ドラムセット() );
			this.子リスト.Add( this._曲パネルビュー = new 曲パネルビュー() );
			this.子リスト.Add( this._背景動画 = new 動画( @"$(System)images\選曲画面BGV.mp4" ) );
			this.子リスト.Add( this._曲決定アニメ = new 曲決定アニメ() );
			this.子リスト.Add( this._FPS = new FPS() );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this._活性化した直後である = true;
				this.現在のフェーズ = フェーズ.開始;
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
			}
		}

		public override void 進行描画する( グラフィックデバイス gd )
		{
			Debug.Assert( this.活性化している );

			if( this._活性化した直後である )
			{
				this._背景動画.再生を開始する( 開始位置sec: 0.0, ループ再生する: true );
				this._活性化した直後である = false;
			}

			switch( this.現在のフェーズ )
			{
				case フェーズ.キャンセル:
				case フェーズ.曲決定:
					return;

				case フェーズ.曲決定アニメ:
					// なんかデザインがマッチしてないので保留。
					this.現在のフェーズ = フェーズ.曲決定;
					break;

				case フェーズ.開始:
					// 描画
					this._背景動画.描画する( gd, new SharpDX.RectangleF( 0f, 0f, gd.設計画面サイズ.Width, gd.設計画面サイズ.Height ) );
					this._曲パネルビュー.進行描画する( gd );
					this._ステージ台.描画する( gd, 0, 0 );
					this._ドラムセット.進行描画する( gd );
					this._FPS.VPSをカウントする();
					this._FPS.FPSをカウントしプロパティを更新する();
					this._FPS.描画する( gd, 0f, 0f );

					// 入力

					App.入力管理.すべての入力デバイスをポーリングする();

					if( App.入力管理.キーボードデバイス.キーが押された( 0, Key.Escape ) )
					{
						#region " ESC → キャンセル "
						//----------------
						this.現在のフェーズ = フェーズ.キャンセル;
						return;
						//----------------
						#endregion
					}
					if( App.入力管理.シンバルが入力された() )
					{
						#region " シンバル → 曲決定アニメ "
						//----------------
						if( null != App.ユーザ管理.選択されているユーザ.曲ツリー.フォーカスノード )
						{
							this.現在のフェーズ = フェーズ.曲決定アニメ;
							Log.Info( $"演奏する曲が決定されました。[{App.ユーザ管理.選択されているユーザ.曲ツリー.フォーカスノード.タイトル}]" );
							return;
						}
						else
						{
							Log.WARNING( "演奏する曲が選択されていません。" );
						}
						//----------------
						#endregion
					}

					if( App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Tom1 ) ||
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Tom1_Rim ) ||
						App.入力管理.キーボードデバイス.キーが押された( 0, Key.Up ) )
					{
						#region " 上 or Tom1 → 曲カーソル上移動 "
						//----------------
						this._曲パネルビュー.カーソルを上に移動する();
						//----------------
						#endregion
					}
					if( App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Tom2 ) ||
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Tom2_Rim ) ||
						App.入力管理.キーボードデバイス.キーが押された( 0, Key.Down ) )
					{
						#region " 下 or Tom2 → 曲カーソル下移動 "
						//----------------
						this._曲パネルビュー.カーソルを下に移動する();
						//----------------
						#endregion
					}
					if( App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Snare ) ||
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Snare_ClosedRim ) ||
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Snare_OpenRim ) ||
						App.入力管理.キーボードデバイス.キーが押された( 0, Key.Left ) )
					{
						#region " 左 or Snare → 曲カーソル左移動 "
						//----------------
						this._曲パネルビュー.カーソルを左に移動する();
						//----------------
						#endregion
					}
					if( App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Tom3 ) ||
						App.入力管理.ドラムが入力された( 入力.ドラム入力種別.Tom3_Rim ) ||
						App.入力管理.キーボードデバイス.キーが押された( 0, Key.Right ) )
					{
						#region " 右, Tom3 → 曲カーソル右移動 "
						//----------------
						this._曲パネルビュー.カーソルを右に移動する();
						//----------------
						#endregion
					}
					foreach( var ev in App.入力管理.MIDI入力デバイス.入力イベントリスト.Where( ( ie ) => ( 255 == ie.Key ) ) )
					{
						#region " ハイハットの開閉 "
						//----------------
						this._ドラムセット.ハイハットのベロシティ = ev.Velocity;
						//----------------
						#endregion
					}
					break;
			}
		}

		private bool _活性化した直後である = false;

		private 画像 _ステージ台 = null;

		private ドラムセット _ドラムセット = null;

		private 曲パネルビュー _曲パネルビュー = null;

		private 動画 _背景動画 = null;

		private 曲決定アニメ _曲決定アニメ = null;

		private FPS _FPS = null;
	}
}