﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK;
using FDK.メディア;

namespace SST.ステージ.クリア
{
	class クリアステージ : ステージ
	{
		public enum フェーズ
		{
			開始,
			表示中,
			完了,
		};

		public フェーズ 現在のフェーズ
		{
			get;
			protected set;
		}


		public クリアステージ()
		{
			this.子リスト.Add( this._背景動画 = new 動画( @"$(System)images\ステージクリア.mp4" ) );
			this.子リスト.Add( this._フェードイン = new フェードイン( 0.5f ) );
			this.子リスト.Add( this._白パネル = new 画像( @"$(System)images\パネル白64x64.png" ) );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this.現在のフェーズ = フェーズ.開始;
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
			}
		}

		public override void 進行描画する( グラフィックデバイス gd )
		{
			retry:

			switch( this.現在のフェーズ )
			{
				case フェーズ.開始:
					this._フェードイン.開始する();
					this._背景動画.再生を開始する();
					this.現在のフェーズ = フェーズ.表示中;
					goto retry;

				case フェーズ.表示中:
					this._背景動画.描画する( gd, new SharpDX.RectangleF( 0f, 0f, gd.設計画面サイズ.Width, gd.設計画面サイズ.Height ) );
					if( this._背景動画.動画がエラーまたは再生を終了した )
						this.現在のフェーズ = フェーズ.完了;
					break;

				case フェーズ.完了:
					break;
			}

			this._フェードイン.進行描画する( gd, this._白パネル );
		}


		private 動画 _背景動画 = null;

		private フェードイン _フェードイン = null;

		private 画像 _白パネル = null;
	}
}
