﻿using System;
using System.Drawing;
using System.Windows.Forms;
using TabTextFinder.Properties;

namespace TabTextFinder
{
    partial class ConfigForm : Form
    {
        public string EditorCommand { get; set; }
        public string EditorArgument { get; set; }
        public bool EnableFileCache { get; set; }
        public long SizeFileCache { get; set; }

        public ConfigForm()
        {
            InitializeComponent();
            Icon = Icon.FromHandle( Resources.Img_wrench_screwdriver.GetHicon() );

            textEditorCommand.DataBindings.Add( "Text", this, "EditorCommand" );
            textEditorArgument.DataBindings.Add( "Text", this, "EditorArgument" );
            chkCacheFile.DataBindings.Add( "Checked", this, "EnableFileCache" );
            textCacheSize.DataBindings.Add( "Text", this, "SizeFileCache" );
        }

        public void LoadSettings( Settings settings )
        {
            EditorCommand = settings.EditorCommand;
            EditorArgument = settings.EditorArgument;
            EnableFileCache = settings.CheckFileCache;
            SizeFileCache = settings.SizeFileCache;
        }

        public void SaveSettings( Settings settings )
        {
            settings.EditorCommand = EditorCommand;
            settings.EditorArgument = EditorArgument;
            settings.CheckFileCache = EnableFileCache;
            settings.SizeFileCache = SizeFileCache;
        }

        public bool SettingsChanged( Settings settings )
        {
            return settings.EditorCommand != EditorCommand
                || settings.EditorArgument != EditorArgument
                || settings.CheckFileCache != EnableFileCache
                || settings.SizeFileCache != SizeFileCache;
        }

        private void ConfigForm_Load( object sender, EventArgs e )
        {
            UpdateControls();
        }

        private void chkCacheFile_CheckedChanged( object sender, EventArgs e )
        {
            UpdateControls();
        }

        private void UpdateControls()
        {
            bool bEnable = chkCacheFile.Checked;
            textCacheSize.Enabled = bEnable;
            labelCacheSize.Enabled = bEnable;
            labelCacheSizeUnit.Enabled = bEnable;
        }

        private void btnBrowse_Click( object sender, EventArgs e )
        {
            using (OpenFileDialog dlg = new OpenFileDialog()) {
                if (dlg.ShowDialog( this ) == DialogResult.OK) {
                    EditorCommand = dlg.FileName;
                    textEditorCommand.DataBindings["Text"].ReadValue();
                }
            }
        }
    }
}
