#include "stdafx.h"

#include "BMFinder.h"
#include "NativeLib/BMUtil.h"

using namespace System;

namespace NTextFinder {
namespace Native {

    int BMFinder::FindInLines( String^ text, String^ content, array<int>^ skip, array<int>^ last_idx_of, array<unsigned char>^ is_word, array<int>^% result )
	{
        using namespace NTextFinder::NativeLib::BMUtil;

        int num_lines = 0;
        std::vector<SFoundLine> FoundLines;
        {
            pin_ptr<const wchar_t> _text = PtrToStringChars( text );
            pin_ptr<const wchar_t> _content = PtrToStringChars( content );
            pin_ptr<const int> _skip = PIN_PTR( skip );
            pin_ptr<const int> _last_idx_of = PIN_PTR( last_idx_of );
            pin_ptr<const unsigned char> _is_word = PIN_PTR( is_word );

            SFindParams params;
            {
                params.text = _text;
                params.content = _content;
                params.text_length = text->Length;
                params.content_length = content->Length;
                params.skip = _skip;
                params.last_idx_of = _last_idx_of;
                params.is_word = _is_word;
            }
            num_lines = FindInLinesNative( params, FoundLines );
        }
		{// copy
			result = gcnew array<int>( FoundLines.size() * 4 );
            pin_ptr<int> _result = PIN_PTR( result );
            ::memcpy( _result, &FoundLines[0], sizeof( SFoundLine ) * FoundLines.size() );
		}
		return num_lines;
	}

}
}
