package net.takemix.testok.activity;

import net.takemix.testok.PFConstants;
import net.takemix.testok.Question;
import net.takemix.testok.R;
import net.takemix.testok.Testok;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.Log;
import android.view.GestureDetector;
import android.view.GestureDetector.OnGestureListener;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.Window;
import android.widget.*;
import android.widget.CompoundButton.OnCheckedChangeListener;

public class AnswerDetailActivity extends Activity implements View.OnClickListener,  OnCheckedChangeListener {
    private static final String TAG = "AnswerDetailActivity";
    private static final int FLING_THRESHOLD = 200;

    private Testok testok;

    private Question question;
    private Integer answerIndex;

    private LinearLayout llBase;
    private ImageView ivResult;

    private ToggleButton tbMark;

    private TextView tvLevel;
	private TextView tvRightCount;
	private TextView tvMisstakeCount;

	private TextView tvQuestion;
    private TextView tvHint;
    private TextView[] tvAnswer;

	private ImageButton ibLeftArrow;
	private ImageButton ibRightArrow;

	private GestureDetector myGestureDetector;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.answerdetail);

        this.testok = (Testok)getApplication();

        this.ivResult = (ImageView)this.findViewById(R.id.answerdetail_resultImageView);

        TextView tvTemp;
        tvTemp = (TextView)this.findViewById(R.id.answerdetail_levelHeaderTextView);
        tvTemp.setText(R.string.answerdetail_level);
        tvTemp = (TextView)this.findViewById(R.id.answerdetail_rightCountHeaderTextView);
        tvTemp.setText(R.string.answerdetail_right);
        tvTemp = (TextView)this.findViewById(R.id.answerdetail_misstakeCountHeaderTextView);
        tvTemp.setText(R.string.answerdetail_misstake);

        this.tvLevel = (TextView)this.findViewById(R.id.answerdetail_levelBodyTextView);
        this.tvRightCount = (TextView)this.findViewById(R.id.answerdetail_rightCountBodyTextView);
        this.tvMisstakeCount = (TextView)this.findViewById(R.id.answerdetail_misstakeCountBodyTextView);

        this.tbMark = (ToggleButton)this.findViewById(R.id.answerdetail_markToggleButton);
        this.tbMark.setOnCheckedChangeListener(this);

        this.tvQuestion = (TextView)this.findViewById(R.id.answerdetail_questionTextView);
        this.tvHint = (TextView)this.findViewById(R.id.answerdetail_hintTextView);
        this.tvAnswer = new TextView[Question.MAX_ANSWER];
        this.tvAnswer[0] = (TextView)this.findViewById(R.id.answerdetail_answer1TextView);
        this.tvAnswer[1] = (TextView)this.findViewById(R.id.answerdetail_answer2TextView);
        this.tvAnswer[2] = (TextView)this.findViewById(R.id.answerdetail_answer3TextView);
        this.tvAnswer[3] = (TextView)this.findViewById(R.id.answerdetail_answer4TextView);

        this.ibLeftArrow = (ImageButton)this.findViewById(R.id.answerdetail_leftArrowImageButton);
        this.ibLeftArrow.setOnClickListener(this);
        this.ibRightArrow = (ImageButton)this.findViewById(R.id.answerdetail_rightArrowImageButton);
        this.ibRightArrow.setOnClickListener(this);


        this.myGestureDetector = new GestureDetector(this, new OnGestureListener() {
            private boolean event = true;
            public boolean onSingleTapUp(MotionEvent e) {
                return false;
            }

            public void onShowPress(MotionEvent e) {
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                return false;
            }

            public void onLongPress(MotionEvent e) {
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (Math.abs(e2.getX() - e1.getX()) > FLING_THRESHOLD) {
                    if (velocityX < 0) {
                        nextAnswer();
                    } else {
                        prevAnswer();
                    }
                    event = true;
                    return true;
                }
                return false;
            }

            public boolean onDown(MotionEvent e) {
                if (event) {
                    event = false;
                    return true;
                } else {
                    return false;
                }
            }
        });
        this.llBase = (LinearLayout)this.findViewById(R.id.baseLinearLayout);
        this.llBase.setOnTouchListener(new OnTouchListener() {
            public boolean onTouch(View v, MotionEvent event) {
                return myGestureDetector.onTouchEvent(event);
            }
        });

        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        this.answerIndex = pref.getInt(PFConstants.getAnswerIndex(), 0);
        this.question = this.testok.questionArray.get(this.answerIndex);
        this.refresh();

        Log.i(TAG, "onCreate - OUT");
    }

    private void refresh() {
        if (this.question.selectedIndex == -1) {
            this.ivResult.setImageResource(R.drawable.non);
        } else if (this.question.rightAnswerIndex == this.question.selectedIndex) {
            this.ivResult.setImageResource(R.drawable.ok);
        } else {
            this.ivResult.setImageResource(R.drawable.ng);
        }

        this.tvLevel.setText(this.question.level.toString());
        Integer count = this.testok.db.getMatchCountFromHistory(this.question.qid, true);
        this.tvRightCount.setText(count.toString());
        count = this.testok.db.getMatchCountFromHistory(this.question.qid, false);
        this.tvMisstakeCount.setText(count.toString());

        Boolean mark = this.testok.db.mark(this.question.qid);
        this.tbMark.setChecked(mark);

        this.tvQuestion.setText(this.question.questionSentence);
        this.tvHint.setText(this.question.hint);
        for (int i = 0; i < Question.MAX_ANSWER; i++) {
            this.tvAnswer[i].setText("・" + this.question.answer[i]);
            this.tvAnswer[i].setTypeface(Typeface.DEFAULT);
            this.tvAnswer[i].setTextColor(Color.BLACK);
            if (i == this.question.selectedIndex) {
                this.tvAnswer[i].setTypeface(Typeface.DEFAULT, Typeface.BOLD);
            }
            if (i == this.question.rightAnswerIndex) {
                this.tvAnswer[i].setTextColor(Color.BLUE);
            }
        }

        if ((this.answerIndex + 1) == this.testok.questionArray.size()) {
            this.ibLeftArrow.setVisibility(View.VISIBLE);
            this.ibRightArrow.setVisibility(View.INVISIBLE);
        } else if (this.answerIndex == 0) {
            this.ibLeftArrow.setVisibility(View.INVISIBLE);
            this.ibRightArrow.setVisibility(View.VISIBLE);
        } else {
            this.ibLeftArrow.setVisibility(View.VISIBLE);
            this.ibRightArrow.setVisibility(View.VISIBLE);
        }
    }

    public void onClick(View v) {
    	if (v == this.ibLeftArrow) {
            Log.i(TAG, "onClick - ibLeftArrow");
            this.prevAnswer();
    	} else if(v == this.ibRightArrow) {
            Log.i(TAG, "onClick - ibRightArrow");
            this.nextAnswer();
    	}
        Log.i(TAG, "onClick - OUT");
    }

    public void onCheckedChanged(CompoundButton button, boolean checked) {
        if (button == this.tbMark) {
            Log.i(TAG, "onClick - tbMark");

            this.testok.db.setMark(this.question.qid, checked);
        }

        Log.i(TAG, "onCheckedChanged - OUT");
    }


    private void nextAnswer() {
        if (this.testok.questionArray.size() > this.answerIndex + 1) {
            this.answerIndex++;
            this.question = this.testok.questionArray.get(this.answerIndex);
            this.refresh();
        }
    }

    private void prevAnswer() {
        if (0 <= this.answerIndex - 1) {
            this.answerIndex--;
            this.question = this.testok.questionArray.get(this.answerIndex);
            this.refresh();
        }
    }
}
