package net.takemix.testok.activity;

import net.takemix.testok.R;
import net.takemix.testok.db.TestokDataBaseHelper;
import net.takemix.testok.db.TestokDataBaseHelper.QuestionType;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.AdapterView.OnItemClickListener;

public class QuestionListActivity extends Activity implements OnItemClickListener {
    private static final String TAG = "QuestionListActivity";

//    private Testok testok;

    private ListView lvQuestionList;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.questionlist);

//        this.testok = (Testok)getApplication();

        this.lvQuestionList = (ListView)findViewById(R.id.questionlist_questionListView);

        QuestionType[] qt = TestokDataBaseHelper.QuestionType.values();
        String[] strArray = new String[qt.length];
        for (int i = 0; i < qt.length; i++) {
            strArray[i] = qt.toString();
        }

        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, strArray);
        this.lvQuestionList.setAdapter(adapter);
        this.lvQuestionList.setOnItemClickListener(this);

        Log.i(TAG, "onCreate - OUT");
    }

    public void onItemClick(AdapterView<?> adapter, View view, int position, long id) {
        Intent intent = new Intent(this, net.takemix.testok.activity.QuestionActivity.class);
        startActivityForResult(intent, 0);
    }
}
