package net.takemix.testok.activity;

import java.io.IOException;

import net.takemix.testok.PFConstants;
import net.takemix.testok.R;
import net.takemix.testok.Testok;
import net.takemix.testok.db.TestokDataBaseHelperInterface;
import net.takemix.testok.db.TestokDataBaseHelper.QuestionType;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.TextView;

public class MainMenuActivity extends Activity implements View.OnClickListener, TestokDataBaseHelperInterface {
    private static final String TAG = "MainMenuActivity";

    private static final int musoScore = 500;

    private static final int SUBMENU_HISTORY = 0;
    private static final int SUBMENU_SETTINGS = 1;
    private static final int SUBMENU_MUSO = 2;

    private Testok testok;

    private ImageButton ibStudy;
    private ImageButton ibMockExam;
    private ImageButton ibSettingStudy;

    private ProgressDialog progress;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.main);

        this.testok = (Testok)getApplication();
        this.testok.db.delegate = this;

        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        WindowManager windowmanager = (WindowManager)getSystemService(WINDOW_SERVICE);
        Display disp = windowmanager.getDefaultDisplay();
        editor.putInt(PFConstants.getWindowWidth(), disp.getWidth());
        editor.putInt(PFConstants.getWindowHeight(), disp.getHeight());
        editor.commit();

        this.ibStudy = (ImageButton)this.findViewById(R.id.main_todayStudyImageButton);
        this.ibStudy.setOnClickListener(this);
        this.ibMockExam = (ImageButton)this.findViewById(R.id.main_mockExamImageButton);
        this.ibMockExam.setOnClickListener(this);
        this.ibSettingStudy = (ImageButton)this.findViewById(R.id.main_settingStudyImageButton);
        this.ibSettingStudy.setOnClickListener(this);

        if (!pref.getBoolean(PFConstants.getInitialized(), false)) {
            Log.d(TAG, "Initialize execute");
            try {
                this.testok.db.copyDataBase();
                this.testok.db.insertDefaultUserProfile();
            } catch (IOException e) {
                Log.e(TAG, e.getLocalizedMessage());
                e.printStackTrace();
            }
        }

        this.refreshView();

        Log.i(TAG, "onCreate - OUT");
    }

    @Override
    public void onResume() {
        super.onResume();

        Log.i(TAG, "onResume - IN");

        this.refreshView();
        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        if (!pref.getBoolean(PFConstants.getInitialized(), false)) {
            this.progress = this.testok.showProgressDialog(this, R.string.main_progress_db, R.string.main_progress_wait);
            this.testok.db.importDataBase();
        }

        Log.i(TAG, "onResume - OUT");
    }

    public void onClick(View v) {
        if(v == this.ibStudy) {
            this.testok.setQuestionPref(
                    QuestionType.QT_READING_INCOMPLETE_SENTENCES,
                    this.testok.level.getMaxLevel(),
                    this.testok.level.getMinLevel(),
                    -1,
                    this.testok.studyTime / 10 + 1);

            Intent intent = new Intent(getApplicationContext(), net.takemix.testok.activity.QuestionActivity.class);
            startActivity(intent);
        } else if(v == this.ibMockExam) {
            Intent intent = new Intent(getApplicationContext(), net.takemix.testok.activity.MockExamActivity.class);
            startActivity(intent);
        } else if(v == this.ibSettingStudy) {
            Intent intent = new Intent(getApplicationContext(), net.takemix.testok.activity.SettingStudyActivity.class);
            startActivity(intent);
        }
    }

    private void refreshView() {
        this.testok.getProfile();

        TextView beforeTextView;
        TextView valTextView;
        TextView afterTextView;

        beforeTextView = (TextView)this.findViewById(R.id.main_untilBeforeTextView);
        valTextView = (TextView)this.findViewById(R.id.main_daysTextView);
        afterTextView = (TextView)this.findViewById(R.id.main_untilAfterTextView);
        if (testok.untilDays >= 0) {
            beforeTextView.setText(R.string.main_until_days_before);
            valTextView.setText(testok.untilDays.toString());
            afterTextView.setText(R.string.main_until_days_after);
        } else {
            beforeTextView.setText("");
            valTextView.setText("");
            afterTextView.setText("");
        }

        beforeTextView = (TextView)this.findViewById(R.id.main_currentBeforeTextView);
        valTextView = (TextView)this.findViewById(R.id.main_scoreTextView);
        afterTextView = (TextView)this.findViewById(R.id.main_currentAfterTextView);
        beforeTextView.setText(R.string.main_current_score_before);
        valTextView.setText(testok.currentScore.toString());
        afterTextView.setText(R.string.main_current_score_after);

        TextView adviceTextView = (TextView)this.findViewById(R.id.main_adviceTextView);
        switch (testok.level) {
        case TL_A:
            adviceTextView.setText(R.string.lv_A_advice);
            break;
        case TL_B:
            adviceTextView.setText(R.string.lv_B_advice);
            break;
        case TL_C:
            adviceTextView.setText(R.string.lv_C_advice);
            break;
        case TL_D:
            adviceTextView.setText(R.string.lv_D_advice);
            break;
        case TL_E:
        default:
            adviceTextView.setText(R.string.lv_E_advice);
            break;
        }
    }

    public void importDataBaseComplete() {
        Log.i(TAG, "importDataBaseComplete - IN");

        this.progress.dismiss();

        Intent intent = new Intent(this, net.takemix.testok.activity.InitialActivity.class);
        startActivity(intent);

        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        editor.putBoolean(PFConstants.getInitialized(), true);
        editor.commit();

        Log.i(TAG, "importDataBaseComplete - OUT");
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        if (this.testok.currentScore >= musoScore) {
            MenuItem menuItem = menu.add(0, SUBMENU_MUSO, 0, R.string.main_submenu_muso);
            menuItem.setIcon(R.drawable.muso_off);
        }
        menu.add(0, SUBMENU_HISTORY, 0, R.string.main_submenu_history);
        menu.add(0, SUBMENU_SETTINGS, 0, R.string.main_submenu_settings);

        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch(item.getItemId()) {
        case SUBMENU_HISTORY: {
            Intent intent = new Intent(getApplicationContext(), net.takemix.testok.activity.HistoryActivity.class);
            startActivity(intent);
            return true;
        }
        case SUBMENU_SETTINGS: {
            Intent intent = new Intent(getApplicationContext(), net.takemix.testok.activity.SettingsActivity.class);
            startActivity(intent);
            return true;
        }
        case SUBMENU_MUSO: {
            Intent intent = new Intent(getApplicationContext(), net.takemix.testok.activity.QuestionActivity.class);
            startActivity(intent);
            return true;
        }
        }

        return true;
    }
}
