package net.takemix.testok.activity;

import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;

import net.takemix.testok.PFConstants;
import net.takemix.testok.R;
import net.takemix.testok.Testok;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.*;

public class SettingsActivity extends Activity implements OnClickListener {
    private static final String TAG = "SettingsActivity";

    private Testok testok;

    private EditText etName;
    private DatePicker dpExam;
    private CheckBox cbExam;
    private Button bInitialize;
    private Button bInitializeDb;
    private CheckBox cbShowInstantAnswer;
    private CheckBox cbAutomaticallyNextQuestion;

    private ProgressDialog progress;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.i(TAG, "onCreate - IN");

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.settings);

        this.testok = (Testok)getApplication();
        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);

        TextView tvTemp;

        tvTemp = (TextView)findViewById(R.id.settings_nameTextView);
        tvTemp.setText(R.string.settings_name);
        this.etName = (EditText)findViewById(R.id.settings_nameEditText);
        this.etName.setText(this.testok.db.userName());

        this.dpExam = (DatePicker)findViewById(R.id.settings_examDatePicker);
        this.cbExam = (CheckBox)findViewById(R.id.settings_examCheckBox);
        this.cbExam.setText(R.string.settings_date);
        if (this.testok.db.examDate() != null) {
            this.cbExam.setChecked(true);
        } else {
            this.cbExam.setChecked(false);
        }

        this.bInitialize = (Button)findViewById(R.id.settings_initializeButton);
        this.bInitialize.setText(R.string.settings_init);
        this.bInitialize.setOnClickListener(this);

        this.bInitializeDb = (Button)findViewById(R.id.settings_initializeDbButton);
        this.bInitializeDb.setText(R.string.settings_initdb);
        this.bInitializeDb.setOnClickListener(this);

        this.cbShowInstantAnswer = (CheckBox)findViewById(R.id.setting_showInstantAnswerCheckBox);
        this.cbShowInstantAnswer.setText(R.string.settings_show_instantanswer);
        boolean showInstantAnswer = pref.getBoolean(PFConstants.getShowInstantAnswer(), true);
        this.cbShowInstantAnswer.setChecked(showInstantAnswer);

        this.cbAutomaticallyNextQuestion = (CheckBox)findViewById(R.id.setting_showInstantAnswerCheckBox);
        this.cbAutomaticallyNextQuestion.setText(R.string.settings_show_instantanswer);
        boolean automaticallyNextQuestion = pref.getBoolean(PFConstants.getAutomaticallyNextQuestion(), false);
        this.cbAutomaticallyNextQuestion.setChecked(automaticallyNextQuestion);

        Log.i(TAG, "onCreate - OUT");
    }

    @Override
    public void onPause() {
        super.onPause();

        Log.i(TAG, "onPause - IN");

        this.testok.db.setUserName(this.etName.getText().toString());

        if (this.cbExam.isChecked()) {
            Calendar cal = Calendar.getInstance(Locale.JAPAN);
            cal.set(Calendar.YEAR, dpExam.getYear());
            cal.set(Calendar.MONTH, dpExam.getMonth());
            cal.set(Calendar.DAY_OF_MONTH, dpExam.getDayOfMonth());
            this.testok.db.setExamDate(cal.getTime());
        } else {
            this.testok.db.setExamDate(null);
        }

        SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = pref.edit();
        editor.putBoolean(PFConstants.getShowInstantAnswer(), this.cbShowInstantAnswer.isChecked());
        editor.putBoolean(PFConstants.getShowInstantAnswer(), this.cbAutomaticallyNextQuestion.isChecked());
        editor.commit();

        Log.i(TAG, "onPause - OUT");
    }

    public void onClick(View v) {
        if (v == this.bInitializeDb) {
            Log.i(TAG, "onClick - [bInitializeDb]");

            try {
                this.progress = this.testok.showProgressDialog(this, R.string.main_progress_db, R.string.main_progress_wait);

                this.testok.db.copyDataBaseForce();
                this.testok.db.importDataBase();
            } catch (IOException e) {
                this.testok.showAlertDialog(this, R.string.error, R.string.settings_initdb_fail, false);
            }
        } else if (v == this.bInitialize) {
            Log.i(TAG, "onClick - [bInitialize]");

            try {
                this.testok.db.copyDataBaseForce();
                this.testok.db.insertDefaultUserProfile();

                SharedPreferences pref = this.getSharedPreferences("testok_pref", Context.MODE_PRIVATE);
                SharedPreferences.Editor editor = pref.edit();
                editor.putBoolean(PFConstants.getInitialized(), false);
                editor.commit();

                finish();
            } catch (IOException e) {
                this.testok.showAlertDialog(this, R.string.error, R.string.settings_initdb_fail, false);
            }
        }

        Log.i(TAG, "onClick - OUT");
    }

    public void importDataBaseComplete() {
        Log.i(TAG, "importDataBaseComplete - IN");

        this.testok.db.insertUserProfile(this.testok.userName, this.testok.currentScore, this.testok.studyTime, this.testok.examDate);
        this.progress.dismiss();

        Log.i(TAG, "importDataBaseComplete - OUT");
    }
}
