
/* Drop Views */

DROP VIEW V_QUESTION;
DROP VIEW V_WORD;



/* Drop Tables */

DROP TABLE T_ANSWER_SENTENCE_ASSIGN;
DROP TABLE T_ANSWER_WORD_ASSIGN;
DROP TABLE T_QUESTION_ANSWER_ASSIGN;
DROP TABLE T_ANSWER;
DROP TABLE T_ANSWERTYPE;
DROP TABLE T_HISTORY;
DROP TABLE T_QUESTION;
DROP TABLE T_QUESTIONTYPE;
DROP TABLE T_WORDTYPE_RELATION;
DROP TABLE T_RELATIONSHIP;
DROP TABLE T_SENTENCE;
DROP TABLE T_USER_PROFILE;
DROP TABLE T_WORD;
DROP TABLE T_WORDTYPE;




/* Create Tables */

CREATE TABLE T_ANSWERTYPE
(
	answer_type integer NOT NULL UNIQUE,
	alias_string text NOT NULL
);


CREATE TABLE T_ANSWER
(
	answer_id integer NOT NULL UNIQUE PRIMARY KEY AUTOINCREMENT,
	answer_type integer NOT NULL,
	-- 0:non group
	-- 1-:grouped answer
	answer_group integer DEFAULT 0,
	FOREIGN KEY (answer_type)
	REFERENCES T_ANSWERTYPE (answer_type)
);


CREATE TABLE T_SENTENCE
(
	sentence_id integer NOT NULL UNIQUE PRIMARY KEY AUTOINCREMENT,
	sentence text NOT NULL
);


CREATE TABLE T_ANSWER_SENTENCE_ASSIGN
(
	answer_id integer NOT NULL UNIQUE,
	right_id integer NOT NULL,
	misstake_id_1 integer,
	misstake_id_2 integer,
	misstake_id_3 integer,
	FOREIGN KEY (answer_id)
	REFERENCES T_ANSWER (answer_id),
	FOREIGN KEY (right_id)
	REFERENCES T_SENTENCE (sentence_id)
);


CREATE TABLE T_WORD
(
	word_id integer NOT NULL UNIQUE PRIMARY KEY AUTOINCREMENT,
	word text NOT NULL,
	translate text
);


CREATE TABLE T_ANSWER_WORD_ASSIGN
(
	answer_id integer NOT NULL UNIQUE,
	right_id integer NOT NULL,
	misstake_id_1 integer,
	misstake_id_2 integer,
	misstake_id_3 integer,
	FOREIGN KEY (answer_id)
	REFERENCES T_ANSWER (answer_id),
	FOREIGN KEY (right_id)
	REFERENCES T_WORD (word_id)
);


CREATE TABLE T_QUESTIONTYPE
(
	question_type integer NOT NULL UNIQUE,
	alias_string text NOT NULL,
	-- Photos 10
	-- Question-Response 30
	-- Conversations 30
	-- Short Talks 30
	-- Incomplete Sentences 40
	-- Cloze Passages 12
	-- Reading Comprehension 48
	questions integer NOT NULL
);


CREATE TABLE T_QUESTION
(
	question_id integer NOT NULL UNIQUE PRIMARY KEY AUTOINCREMENT,
	question_type integer NOT NULL,
	-- WordType(Class)の値を入れるなどして任意に使用すること
	question_subtype integer,
	text text NOT NULL UNIQUE,
	lv integer DEFAULT 1,
	speech none DEFAULT 'NULL',
	picture none DEFAULT 'NULL',
	-- 問題文の日本語訳
	hint text,
	-- 問題の解説
	explanation text,
	-- 0:false
	-- 1:true
	mark integer DEFAULT 0,
	FOREIGN KEY (question_type)
	REFERENCES T_QUESTIONTYPE (question_type)
);


CREATE TABLE T_HISTORY
(
	history_id integer NOT NULL UNIQUE PRIMARY KEY AUTOINCREMENT,
	sequence_id integer NOT NULL,
	question_id integer NOT NULL,
	date text NOT NULL,
	-- 0:non group
	-- 1-:grouped answer
	answer_group integer,
	selected_num integer NOT NULL,
	right_num integer NOT NULL,
	question_text text,
	choice_text_1 text,
	choice_text_2 text,
	choice_text_3 text,
	choice_text_4 text,
	-- -1:not selected
	-- 0:misstake
	-- 1:right
	match integer NOT NULL,
	time integer,
	FOREIGN KEY (question_id)
	REFERENCES T_QUESTION (question_id)
);


CREATE TABLE T_QUESTION_ANSWER_ASSIGN
(
	question_id integer NOT NULL UNIQUE,
	answer_id integer NOT NULL,
	FOREIGN KEY (answer_id)
	REFERENCES T_ANSWER (answer_id),
	FOREIGN KEY (question_id)
	REFERENCES T_QUESTION (question_id)
);


CREATE TABLE T_RELATIONSHIP
(
	relationship integer NOT NULL UNIQUE,
	alias_string text
);


CREATE TABLE T_USER_PROFILE
(
	name text NOT NULL,
	last_score integer,
	mock_score integer,
	study_time integer,
	exam_date text
);


CREATE TABLE T_WORDTYPE
(
	word_type integer NOT NULL UNIQUE,
	alias_string text
);


CREATE TABLE T_WORDTYPE_RELATION
(
	word_id integer NOT NULL,
	word_type integer NOT NULL,
	relationship integer NOT NULL,
	FOREIGN KEY (relationship)
	REFERENCES T_RELATIONSHIP (relationship),
	FOREIGN KEY (word_id)
	REFERENCES T_WORD (word_id),
	FOREIGN KEY (word_type)
	REFERENCES T_WORDTYPE (word_type)
);



/* Create Views */

CREATE VIEW V_QUESTION AS SELECT
                T_QUESTION.question_id AS question_id
                ,T_QUESTIONTYPE.question_type AS question_type
                ,T_QUESTION.text AS text
                ,T_QUESTION.lv AS lv
                ,T_QUESTION.hint AS hint
                ,T_ANSWER.answer_id AS answer_id
                ,T_ANSWERTYPE.answer_type AS answer_type
                ,T_ANSWERTYPE.alias_string AS answer_type_alias_string
            FROM
                T_QUESTION
                ,T_QUESTIONTYPE
                ,T_QUESTION_ANSWER_ASSIGN
                ,T_ANSWER
                ,T_ANSWERTYPE
            WHERE
                T_QUESTION.question_type = T_QUESTIONTYPE.question_type
                AND T_QUESTION.question_id = T_QUESTION_ANSWER_ASSIGN.question_id
                AND T_QUESTION_ANSWER_ASSIGN.answer_id = T_ANSWER.answer_id
                AND T_ANSWER.answer_type = T_ANSWERTYPE.answer_type;
CREATE VIEW V_WORD AS SELECT
                T_WORD.word_id AS word_id
                ,T_WORD.word AS word
                ,T_WORD.translate AS translate
                ,T_WORDTYPE.word_type AS type
                ,T_WORDTYPE.alias_string AS type_alias_string
                ,T_RELATIONSHIP.relationship AS type_relationship
                ,T_RELATIONSHIP.alias_string AS type_relationship_alias_string
            FROM
                T_WORD
                ,T_WORDTYPE
                ,T_RELATIONSHIP
                ,T_WORDTYPE_RELATION
            WHERE
                T_WORD.word_id = T_WORDTYPE_RELATION.word_id
                AND T_WORDTYPE.word_type = T_WORDTYPE_RELATION.word_type
                AND T_RELATIONSHIP.relationship = T_WORDTYPE_RELATION.relationship;



