# encoding: utf-8
require 'kml'

class ApiController < ApplicationController
  before_filter :authenticate_user!
  respond_to :json, :xml

  # /api/bloglist/:page/:per
  # 最新ブログのリスト
  def bloglist
    limit = Settings.max_list
    if params[:per]
      limit = params[:per].to_i
      limit = Settings.max_list if limit > Settings.max_list || limit < 1
    end

    page = 1
    if params[:page]
      page = params[:page].to_i
      page = 1 if page == 0
    end

    posts = Post.page(page).per(limit)
    respond_with(posts, {:include => {:user => {:only => [:id, :nickname, :icon]}}, :only => [:title, :posted_at]})
  end

  # /api/bloglist/:id/:page/:per
  # 指定ユーザーの最新ブログのリスト
  def user_bloglist
    limit = Settings.max_list
    if params[:per]
      limit = params[:per].to_i
      limit = Settings.max_list if limit > Settings.max_list || limit < 1
    end

    page = 1
    if params[:page]
      page = params[:page].to_i
      page = 1 if page == 0
    end

    posts = Post.where([ "user_id = ?", params[:id] ]).page(page).per(limit)
    respond_with(posts, {:include => {:user => {:only => [:id, :nickname, :icon]}}, :only => [:title, :posted_at]})
  end

  # /api/userlist/:page/:per
  # ユーザーのリスト
  def userlist
    limit = Settings.max_list
    if params[:per]
      limit = params[:per].to_i
      limit = Settings.max_list if limit > Settings.max_list || limit < 1
    end

    page = 1
    if params[:page]
      page = params[:page].to_i
      page = 1 if page == 0
    end

    users = User.page(page).per(limit)
    respond_with(users, {:only => [:id, :nickname, :icon, :location, :comment]})
  end

  # /api/categorylist/:per
  # カテゴリのリスト
  def categorylist
    limit = Settings.max_list
    if params[:per]
      limit = params[:per].to_i
      limit = Settings.max_list if limit > Settings.max_list || limit < 1
    end

    categories = Post.tag_counts_on(:categories, {:limit => limit, :order => 'taggings.tags_count desc'})
    render :json => categories
  end

  # /api/kml/:id
  # 指定ブログに添付されている写真のGPS情報から取得したKMLデータ
  def render_kml

    kml = KMLFile.new
    doc = KML::Document.new()

    post = Post.find(params[:id])
    if post
      folder = KML::Folder.new(:name => post.title)
      galleries = Gallery.find(:all, :conditions => ["post_id = ?", post])
      if galleries
        galleries.each do |gallery|
          if gallery.exif && gallery.exif.gps_latitude_ref && gallery.exif.gps_longitude_ref
            folder.features << KML::Placemark.new(
              :name => gallery.name,
              :geometry => KML::Point.new(:coordinates => {:lat => gallery.exif.gps_latitude, :lng => gallery.exif.gps_longitude})
            )
          end
        end
      end
      doc.features << folder
      kml.objects << doc
    end

    render :xml => kml.render

  end

end
