# encoding: utf-8
require 'mime/types'

class GalleriesController < ApplicationController
  include GalleriesHelper

  before_filter :authenticate_user!
  respond_to :json, :html, :js

  # GET /posts/1/galleries
  # GET /posts/1/galleries.json
  def index
    respond_with
  end

  # GET /posts/1/galleries/1
  # GET /posts/1/galleries/1.json
  def show
    @post = Post.find(params[:post_id])
    @gallery = Gallery.find(params[:id])
  end

  # GET /posts/1/galleries/new
  # GET /posts/1/galleries/new.json
  def new
    @gallery = Gallery.new
    @post = Post.find(params[:post_id])
    @galleries = Gallery.where(:post_id => @post)
    @gallery.post_id = @post
    respond_with(@post)
  end

  # GET /posts/1/galleries/1/edit
  def edit
    @post = Post.find(params[:post_id])
    @gallery = Gallery.find(params[:id])

    unless @gallery.exif
      @gallery.exif = Exif.new
      @gallery.exif.gallery_id = @gallery.id
    end

    if !@post || !@gallery
      render_404
    end
    respond_with(@post, @gallery)
  end

  # PUT /posts/1/galleries/1
  # PUT /posts/1/galleries/1.json
  def update
    @post = Post.find(params[:post_id])
    @gallery = Gallery.find(params[:id])

    if !@post || !@gallery
      render_404
    else
      @gallery.snoop(request)

      if @gallery.update_attributes(params[:gallery])
        flash[:notice] = I18n.t('flash.messages.update', :model => Gallery.model_name.human)
      end
      respond_with(@post, @gallery)
    end
  end

  # DELETE /posts/1/galleries/1
  # DELETE /posts/1/galleries/1.json
  def destroy
    @post = Post.find(params[:post_id])
    @gallery = Gallery.find(params[:id])
    if !@post || !@gallery
      #render_404
    else
      title = @gallery.name
      @gallery.destroy

      galleries = Gallery.where(:post_id => @post)

      msg = I18n.t('flash.messages.delete', :model => Gallery.model_name.human)
      respond_with(@post, @gallery) do | format |
        format.html { redirect_to post_galleries_path, :notice => msg }
        format.js { render 'uploader/destory_callback', :location => new_post_gallery_path(@post), :locals => { :msg => msg, :galleries => galleries } }
      end

    end
  end
end
