# encoding: utf-8
class PublishController < ApplicationController
  respond_to :json, :html

  def index
    @q = Q.new(params[:q])
    cond = {}

    where = ''
    where << "publish = :publish "
    cond[:publish] = true

    if @q.word && @q.word.length > 0
      where << 'AND rawdata like :rawdata '
      cond[:rawdata] = "%#{@q.word}%"
    end

    if @q.from && @q.from.length > 0
      where << 'AND posted_at >= :from '
      dt = @q.from.split(/\//)
      cond[:from] = Date::new(dt[0].to_i, dt[1].to_i, dt[2].to_i)
    end

    if @q.to && @q.to.length > 0
      where << 'AND posted_at <= :to '
      dt = @q.to.split(/\//)
      cond[:to] = Date::new(dt[0].to_i, dt[1].to_i, dt[2].to_i)
    end

    if @q.auther && @q.auther.length > 0
      where << 'AND user_id = :user_id '
      cond[:user_id] = @q.auther
    end

    if params[:tag]
      @q[:word] = params[:tag]
      @posts = Post.tagged_with(params[:tag], :any => true).page(params[:page])
      @posts.reject! { |post| post.publish == false }
    else
      @posts = Post.where(where, cond).page(params[:page])
    end

    @categories = Post.tag_counts_on(:categories, {:limit => Settings.max_categories, :order => 'taggings.tags_count desc'})
    @tags = Post.tag_counts_on(:tags, {:limit => Settings.max_tags, :order => 'tags.created_at desc, taggings.tags_count desc'})
    @post_months = @posts.group_by { |t| t.posted_at.beginning_of_day if t.posted_at }
  end

  def show
    @post = Post.find(:first, :conditions => ["id = ? and publish = ?", params[:id], true])
    if !@post
      render_404
    else
      @galleries = Gallery.find(:all, :conditions => ["post_id = ?", @post])

      @comment = @post.comments.build
      @comment.user = current_user
      @post.comments.pop
    end
  end

end
