# encoding: utf-8
class UploaderController < ApplicationController
  include GalleriesHelper

  before_filter :authenticate_user!
  respond_to :js

  def index
    @post = Post.find(params[:post_id])
    @galleries = Gallery.where(:post_id => @post)
    respond_with(@post, @galleries) do | format |
      format.js { render 'uploader/index_callback', :location => new_post_gallery_path(@post) }
    end
  end

  def create
    @post = Post.find(params[:post_id])
    count = Gallery.where(:post_id => params[:post_id]).count
    if count < Settings.max_page_images

      #uploadifyの場合
      if params[:Filename]
        image = params[:Filedata]
        @gallery = Gallery.new do |g|
          g.post_id = params[:post_id]
          g.image = image
          g.name = params[:Filename]
          g.comment = @post.title
          g.content_type = MIME::Types.type_for(params[:Filename])[0].to_s
          g.user = current_user
        end
      #flashがない場合
      else
        @gallery = Gallery.new do |g|
          image = params[:post][:Filedata]
          g.post_id = params[:post_id]
          g.image = image
          g.name = image.original_filename
          g.comment = @post.title
          g.content_type = MIME::Types.type_for(image.original_filename)[0].to_s
          g.user = current_user
        end
      end

      @gallery.snoop(request)

      msg = nil

      exif = Exif.new
      #jpeg以外はexif情報の取得を行わない
      if current_user.exifable && @gallery.content_type =~ /(jpg|jpeg)$/i
        exif = exifFactory(image.path)
      end

      @gallery.exif = exif
      
      # tag
      @gallery.model_list = exif.model if exif.model
      @gallery.month_list = exif.date_time_original.strftime('%m') if exif.date_time_original
    
      if @gallery.save
        respond_with(@post, @gallery) do |format|
          format.js { render 'uploader/create_callback', :location => new_post_gallery_path(@post), :locals => { :msg => msg } }
        end
      else
        msg = I18n.t('flash.errors.format_error')
        logger.warn(msg + "\n" + image.pretty_inspect)
        respond_with(@post, @gallery) do |format|
          format.js { render 'uploader/create_callback', :location => new_post_gallery_path(@post), :locals => { :msg => msg } }
        end
      end  
    else
      msg = I18n.t('flash.errors.limit_error')
      logger.warn(msg + "\n" + image.pretty_inspect)
      respond_with(@post, @gallery) do |format|
        format.js { render 'uploader/create_callback', :location => new_post_gallery_path(@post), :locals => { :msg => msg } }
      end
    end

  end

end
