# encoding: utf-8
require 'exifr'

TYPE1 = 'locality'
TYPE2 = 'sublocality_level_1'

class Point
  def initialize(ref="")
    @r = ref
    @dd = 0.0
    @mm = 0.0
    @ss = 0.0
  end

  def per
    d = @dd + (@mm / 60.0) + (@ss / 3600.0)
    if @r == "N" || @r == "E"
      return d
      return d * -1
    end
  end

  attr_accessor :r
  attr_accessor :dd
  attr_accessor :mm
  attr_accessor :ss
end

module GalleriesHelper

  def toPoint(ref, arr)
    point = Point.new(ref)
    point.dd = arr[0].to_f

    if arr[1].denominator == 1
      # DMS
      point.mm = arr[1].to_f
      point.ss = arr[2].to_f
    else
      # DMM
      point.mm = arr[1].to_i
      mmmm = arr[1].to_f
      point.ss = (mmmm % 1) * 60
    end

    return point
  end

  def getTimestamp(val)
    if val && val.length == 3
      hh = val[0].to_i
      mm = val[1].to_i
      if val[2].denominator == 1
        #hhmmmmssss
        mmmm = val[2].to_f
        mm += (mmmm / 60).to_i
        hh += (mm / 60).to_i
        mm = mm % 60
        ss = val[2].to_f % 60
        ggg = 0
      else
        #hhmmssggg
        ss = val[2].to_i
        ggg = (val[2].to_f % 1) * 100
      end
      return "#{hh.to_i}:#{mm.to_i}:#{ss.to_i}.#{ggg.to_i}"
    else
      return ""
    end
  end

  #
  # イメージのexifタグ情報を取得する
  #
  def exifFactory(path)
    exif = Exif.new
    
    begin
      e = EXIFR::JPEG::new(path)
      return exif unless e.exif?
    rescue => err
      logger.warn(err)
      return exif
    end

    exif = Exif.new
    e.to_hash.each_pair {|key, val|
      setval = nil

      #for debug
      #p key
      #p val.class

      case key
        when :orientation
          setval = val.to_i
        when :gps_latitude
          setval = toPoint(e.gps_latitude_ref, val).per
        when :gps_longitude
          setval = toPoint(e.gps_longitude_ref, val).per
        when :gps_dest_latitude
          setval = toPoint(e.gps_dest_latitude_ref, val).per
        when :gps_dest_longitude
          setval = toPoint(e.gps_dest_longitude_ref, val).per
        when :gps_time_stamp
          setval = getTimestamp(val)
        when :locality
        when :sublocality
        else
          if val.kind_of?(Rational)
            setval = val.to_f
          else
            setval = val
          end
      end

      exif.[]=(key, setval) if setval
    }

    return exif
  end

end
