# encoding: utf-8
module UsericonHelper
  def icon_uploadify
    session_key_name = Rails.application.config.session_options[:key]
    lang = "uploadify/uploadifyLang_#{I18n.locale.to_s.gsub(/:/, '')}.js"

    %Q{

    <script type='text/javascript'>
      $(document).ready(function() {
        if (!FlashDetect.versionAtLeast(9)) {
          $("#uploadify").html('You do not have Flash Player installed or your Flash Player is too old!<br>Please install Flash Player 9 or higher.');
        }
        else {
          $("#uploadify").uploadify({
            // Required Settings
            langFile : "#{asset_path(lang)}",
            swf : "#{asset_path('uploadify/uploadify.swf')}",
            uploader : "#{users_edit_icon_path}",
            'checkExisting'   : false,
            'folder'          : '/uploads',
            'createFolder'    : false,
            'debug'           : false,
            'auto'            : true,
            'width'           : 150,
            'height'          : 30,
            'cancelImage'     : "#{asset_path('uploadify/uploadify-cancel.png')}",
            'fileSizeLimit'   : 280, //KB
            'fileTypeExts'    : '*.jpg;*.jpeg;*.gif;*.png;*.JPG;*.JPEG;*.GIF;*.PNG',
            'fileTypeDesc'    : 'Image Files (.JPG, .GIF, .PNG)',
            'method'          : 'post',
            'multi'           : false,
            'requeueErrors'   : false,
            'queueID'         : 'file_queue',
            'queueSizeLimit'  : 1,
            'removeCompleted' : true,
            'postData'        : {
              '_http_accept': 'application/javascript',
              '#{session_key_name}' : '#{u(cookies[session_key_name])}',
              'authenticity_token'  : '#{form_authenticity_token}'
            },
            'progressData'    : 'all',

            onSelect : function(file) {
            },
            onUploadSuccess : function(file, data, response) {
              eval(data);
            },
            onUploadComplete : function(file, queue) {
            
            },
            onQueueComplete : function (stats) {
            },
            onUploadError : function (file, errorCode, errorMsg, errorString, queue) {
              $('#uploadify').uploadifyStop();
              alert('ファイルアップロードでエラーが発生しました。' + errorMsg);
            }
          });
        }
      });
    </script>

    }.html_safe
    #}.gsub(/[\n ]+/, ' ').strip.html_safe
  end

end
