# encoding: utf-8
require 'tiempo'

class Gallery < ActiveRecord::Base
  attr_accessible :image, :name, :comment, :content_type, :exif
  attr_protected :id
  belongs_to :post
  belongs_to :user
  mount_uploader :image, ImageUploader

  default_scope :include => 'exif', :order => 'exifs.date_time_original desc'
  paginates_per 32

  acts_as_taggable_on :locations, :months, :models
  
  has_one :exif, :dependent => :destroy, :autosave => true
  accepts_nested_attributes_for :exif, :allow_destroy => true

  def snoop(request)
    self.user_ip = request.remote_ip
    self.user_agent = request.user_agent
    self.referrer = request.referrer
  end

  def remove_exif
    if self.image
      unless self.user.exifable
        util = Tiempo::ImageUtil.new
        util.remove_exif("#{Rails.root}/public#{self.image}")
      end
    end
  end
  before_save :remove_exif

end
