# encoding: utf-8
require 'uri'

class ImageUploader < CarrierWave::Uploader::Base

  # Include RMagick or ImageScience support:
  include CarrierWave::RMagick
  # include CarrierWave::MiniMagick
  # include CarrierWave::ImageScience

  #include CarrierWave::MimeTypes
  #process :set_content_type

  # Choose what kind of storage to use for this uploader:
  storage :file
  # storage :fog

  # Override the directory where uploaded files will be stored.
  # This is a sensible default for uploaders that are meant to be mounted:
  def store_dir
    "uploads/#{model.class.to_s.underscore}/#{mounted_as}/#{model.id}"
  end

  # Provide a default URL as a default if there hasn't been a file uploaded:
  # def default_url
  #   "/images/fallback/" + [version_name, "default.png"].compact.join('_')
  # end

  # Process files as they are uploaded:
  # process :scale => [200, 300]
  #
  # def scale(width, height)
  #   # do something
  # end

  def rotate
    manipulate! do |img|
      img = img.auto_orient
    end
  end

  def remove_exif
    manipulate! do |img|
      img = img.strip!
    end
  end

  process :rotate

  # Create different versions of your uploaded files:
  version :thumb do
    process :remove_exif
    process :resize_to_fill => [64, 64]
  end

  version :home do
    process :remove_exif
    process :resize_to_fill => [256, 256]
  end

  version :preview do
    process :remove_exif
    process :resize_to_limit => [512, 512]
  end

  # Add a white list of extensions which are allowed to be uploaded.
  # For images you might use something like this:
  def extension_white_list
    %w(jpg jpeg gif png)
  end

  # Override the filename of the uploaded files:
  # Avoid using model.id or version_name here, see uploader/store.rb for details.
  def filename
    URI.encode(original_filename) if original_filename
  end

end
