# encoding: UTF-8
# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended to check this file into your version control system.

ActiveRecord::Schema.define(:version => 20111123103711) do

  create_table "comments", :force => true do |t|
    t.string   "title",            :limit => 50, :default => ""
    t.text     "comment"
    t.integer  "commentable_id"
    t.string   "commentable_type"
    t.integer  "user_id"
    t.string   "user_ip"
    t.string   "user_agent"
    t.string   "referrer"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "comments", ["commentable_id"], :name => "index_comments_on_commentable_id"
  add_index "comments", ["commentable_type"], :name => "index_comments_on_commentable_type"
  add_index "comments", ["user_id"], :name => "index_comments_on_user_id"

  create_table "delayed_jobs", :force => true do |t|
    t.integer  "priority",   :default => 0
    t.integer  "attempts",   :default => 0
    t.text     "handler"
    t.text     "last_error"
    t.datetime "run_at"
    t.datetime "locked_at"
    t.datetime "failed_at"
    t.string   "locked_by"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "delayed_jobs", ["priority", "run_at"], :name => "delayed_jobs_priority"

  create_table "exifs", :force => true do |t|
    t.integer  "width"
    t.integer  "height"
    t.integer  "bits"
    t.string   "comment"
    t.string   "make"
    t.string   "model"
    t.integer  "orientation"
    t.decimal  "x_resolution"
    t.decimal  "y_resolution"
    t.integer  "resolution_unit"
    t.string   "software"
    t.datetime "date_time"
    t.integer  "ycb_cr_positioning"
    t.decimal  "exposure_time"
    t.decimal  "f_number"
    t.integer  "exposure_program"
    t.integer  "iso_speed_ratings"
    t.datetime "date_time_original"
    t.datetime "date_time_digitized"
    t.decimal  "shutter_speed_value"
    t.decimal  "aperture_value"
    t.integer  "metering_mode"
    t.integer  "flash"
    t.decimal  "focal_length"
    t.integer  "color_space"
    t.integer  "pixel_x_dimension"
    t.integer  "pixel_y_dimension"
    t.integer  "sensing_method"
    t.integer  "exposure_mode"
    t.integer  "white_balance"
    t.integer  "scene_capture_type"
    t.integer  "sharpness"
    t.string   "gps_version_id"
    t.string   "gps_latitude_ref"
    t.decimal  "gps_latitude"
    t.string   "gps_longitude_ref"
    t.decimal  "gps_longitude"
    t.string   "gps_altitude_ref",       :default => "0"
    t.decimal  "gps_altitude"
    t.string   "gps_time_stamp"
    t.string   "gps_satellites"
    t.string   "gps_status"
    t.string   "gps_measure_mode"
    t.decimal  "gps_dop"
    t.string   "gps_speed_ref"
    t.decimal  "gps_speed"
    t.string   "gps_track_ref"
    t.decimal  "gps_track"
    t.string   "gps_img_direction_ref"
    t.decimal  "gps_img_direction"
    t.string   "gps_map_datum"
    t.string   "gps_dest_latitude_ref"
    t.decimal  "gps_dest_latitude"
    t.string   "gps_dest_longitude_ref"
    t.decimal  "gps_dest_longitude"
    t.string   "gps_dest_bearing_ref"
    t.decimal  "gps_dest_bearing"
    t.string   "gps_dest_distance_ref"
    t.decimal  "gps_dest_distance"
    t.string   "gps_processing_method"
    t.string   "gps_area_information"
    t.string   "gps_date_stamp"
    t.integer  "gps_differential"
    t.string   "locality"
    t.string   "sublocality"
    t.integer  "gallery_id"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "exifs", ["date_time_original"], :name => "index_exifs_on_date_time_original"
  add_index "exifs", ["gallery_id"], :name => "index_exifs_on_gallery_id"

  create_table "galleries", :force => true do |t|
    t.string   "name"
    t.string   "comment"
    t.string   "content_type"
    t.integer  "user_id"
    t.string   "user_ip"
    t.string   "user_agent"
    t.string   "referrer"
    t.integer  "post_id"
    t.string   "image"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "galleries", ["post_id"], :name => "index_galleries_on_post_id"
  add_index "galleries", ["user_id"], :name => "index_galleries_on_user_id"

  create_table "posts", :force => true do |t|
    t.string   "title"
    t.text     "content"
    t.text     "markdown"
    t.text     "rawdata"
    t.integer  "editor_type", :default => 0
    t.boolean  "commentable"
    t.boolean  "publish"
    t.datetime "posted_at"
    t.integer  "user_id"
    t.string   "user_ip"
    t.string   "user_agent"
    t.string   "referrer"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.boolean  "tweeted"
  end

  add_index "posts", ["posted_at"], :name => "index_posts_on_posted_at"
  add_index "posts", ["user_id"], :name => "index_posts_on_user_id"

  create_table "taggings", :force => true do |t|
    t.integer  "tag_id"
    t.integer  "taggable_id"
    t.string   "taggable_type"
    t.integer  "tagger_id"
    t.string   "tagger_type"
    t.string   "context"
    t.datetime "created_at"
  end

  add_index "taggings", ["tag_id"], :name => "index_taggings_on_tag_id"
  add_index "taggings", ["taggable_id", "taggable_type", "context"], :name => "index_taggings_on_taggable_id_and_taggable_type_and_context"

  create_table "tags", :force => true do |t|
    t.string   "name"
    t.datetime "created_at"
  end

  create_table "user_settings", :force => true do |t|
    t.boolean  "exifable"
    t.boolean  "commentable"
    t.boolean  "publish"
    t.integer  "style"
    t.integer  "users_id"
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "user_settings", ["users_id"], :name => "index_user_settings_on_users_id"

  create_table "users", :force => true do |t|
    t.string   "email",                                 :default => "",    :null => false
    t.string   "encrypted_password",     :limit => 128, :default => "",    :null => false
    t.string   "reset_password_token"
    t.datetime "reset_password_sent_at"
    t.datetime "remember_created_at"
    t.integer  "sign_in_count",                         :default => 0
    t.datetime "current_sign_in_at"
    t.datetime "last_sign_in_at"
    t.string   "current_sign_in_ip"
    t.string   "last_sign_in_ip"
    t.string   "password_salt"
    t.string   "confirmation_token"
    t.datetime "confirmed_at"
    t.datetime "confirmation_sent_at"
    t.integer  "failed_attempts",                       :default => 0
    t.string   "unlock_token"
    t.datetime "locked_at"
    t.string   "nickname"
    t.string   "location"
    t.string   "comment"
    t.boolean  "exifable",                              :default => true
    t.boolean  "commentable",                           :default => true
    t.boolean  "publish",                               :default => false
    t.integer  "style",                                 :default => 0
    t.string   "icon"
    t.datetime "created_at"
    t.datetime "updated_at"
    t.integer  "uid"
    t.string   "access_token"
    t.string   "access_secret"
    t.boolean  "tweetable"
  end

  add_index "users", ["email"], :name => "index_users_on_email", :unique => true
  add_index "users", ["reset_password_token"], :name => "index_users_on_reset_password_token", :unique => true

end
