// ----------------------------------------------------------------------------
// markItUp!
// ----------------------------------------------------------------------------
// Copyright (C) 2011 Jay Salvat
// http://markitup.jaysalvat.com/
// ----------------------------------------------------------------------------
// markdown tags
// http://en.wikipedia.org/wiki/markdown
// ----------------------------------------------------------------------------
// Basic set. Feel free to add more tags
// ----------------------------------------------------------------------------
myMarkdownSettings = {

    nameSpace: 'markdown', // Useful to prevent multi-instances CSS conflict
    previewTemplatePath: $Tiempo.PreviewTemplate,
    //previewInWindow: 'width=800, height=600, resizable=yes, scrollbars=yes',
    previewAutoRefresh: true,
    previewPosition: 'before',
    previewParser: function(content) {
        var converter = new Attacklab.showdown.converter();
        return converter.makeHtml(content);
    },
    previewRunWithStart: true,
    //onEnter: {keepDefault:false, replaceWith:'<br />\n'},
    onShiftEnter:       {keepDefault:false, replaceWith:'\n\n'},
    markupSet: [
        {name:'First Level Heading', key:"1", placeHolder:'Your title here...', closeWith:function(markItUp) { return miu.markdownTitle(markItUp, '=') } },
        {name:'Second Level Heading', key:"2", placeHolder:'Your title here...', closeWith:function(markItUp) { return miu.markdownTitle(markItUp, '-') } },
        {name:'Heading 3', key:"3", openWith:'### ', placeHolder:'Your title here...' },
        {name:'Heading 4', key:"4", openWith:'#### ', placeHolder:'Your title here...' },
        {name:'Heading 5', key:"5", openWith:'##### ', placeHolder:'Your title here...' },
        {name:'Heading 6', key:"6", openWith:'###### ', placeHolder:'Your title here...' },
        {separator:'---------------' },
        {name:'Horizontal', key:"H", openWith:'----------' },
        {separator:'---------------' },
        {name:'Bold', key:"B", openWith:'**', closeWith:'**'},
        {name:'Italic', key:"I", openWith:'_', closeWith:'_'},
        {separator:'---------------' },
        {name:'Bulleted List', key:"U", openWith:'- ' },
        {name:'Numeric List', key:"O", openWith:function(markItUp) {
            return markItUp.line+'. ';
        }},
        {separator:'---------------' },
        {name:'Picture', key:"P", replaceWith:'![[![Alternative text]!]]([![Url:!:http://]!] "[![Title]!]")'},
        {name:'Link', key:"L", openWith:'[', closeWith:']([![Url:!:http://]!] "[![Title]!]")', placeHolder:'Your text to link here...' },
        {separator:'---------------'},
        {name:'Quotes', key:"Q", openWith:'> '},
        {name:'Code Block / Code', key:"K", openWith:'(!(\t|!|`)!)', closeWith:'(!(`)!)'},
        {separator:'---------------'},
        //{name:'Preview', key:"S", className:'preview',  call:'preview'}
    ]
}

// mIu nameSpace to avoid conflict.
miu = {
  markdownTitle: function(markItUp, char) {
    heading = '';
    n = $.trim(markItUp.selection||markItUp.placeHolder).length;
    for(i = 0; i < n; i++) {
      heading += char;
    }
    return '\n'+heading+'\n';
  }
}
