require 'test_helper'

class UsericonsControllerTest < ActionController::TestCase
  setup do
    @usericon = usericons(:one)
  end

  test "should get index" do
    get :index
    assert_response :success
    assert_not_nil assigns(:usericons)
  end

  test "should get new" do
    get :new
    assert_response :success
  end

  test "should create usericon" do
    assert_difference('Usericon.count') do
      post :create, usericon: @usericon.attributes
    end

    assert_redirected_to usericon_path(assigns(:usericon))
  end

  test "should show usericon" do
    get :show, id: @usericon.to_param
    assert_response :success
  end

  test "should get edit" do
    get :edit, id: @usericon.to_param
    assert_response :success
  end

  test "should update usericon" do
    put :update, id: @usericon.to_param, usericon: @usericon.attributes
    assert_redirected_to usericon_path(assigns(:usericon))
  end

  test "should destroy usericon" do
    assert_difference('Usericon.count', -1) do
      delete :destroy, id: @usericon.to_param
    end

    assert_redirected_to usericons_path
  end
end
